/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.xml.ui.wizards;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.xml.XmlFragment;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.ResourceFinder;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.types.EnterpriseDatatypeInfo;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.xml.factory.IDocumentsAndFragmentsPopulator;
import com.metamatrix.modeler.internal.xml.factory.VirtualDocumentModelPopulator;
import com.metamatrix.modeler.internal.xml.ui.wizards.NewDocumentWizardModel;
import com.metamatrix.modeler.internal.xml.ui.wizards.NewVirtualDocumentWizardPage;
import com.metamatrix.modeler.internal.xml.ui.wizards.PreviewVirtualDocumentWizardPage;
import com.metamatrix.modeler.internal.xml.ui.wizards.VirtualDocumentStatisticsWizardPage;
import com.metamatrix.modeler.ui.wizards.INewModelObjectWizard;
import com.metamatrix.modeler.xml.IVirtualDocumentFragmentSource;
import com.metamatrix.modeler.xml.ModelerXmlPlugin;
import com.metamatrix.modeler.xml.ui.ModelerXmlUiConstants;
import com.metamatrix.modeler.xml.ui.ModelerXmlUiPlugin;
import com.metamatrix.modeler.xml.ui.dialogs.ConvertSimpleTypesToEnteriseTypesDialog;
import com.metamatrix.ui.internal.wizard.AbstractWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;

public class XMLDocumentWizard
extends AbstractWizard
implements INewModelObjectWizard,
ModelerXmlUiConstants {
    private static final String DOC_ERROR_MSG = ModelerXmlUiConstants.Util.getString("XMLDocumentWizard.documentErrorMessage");
    private ModelResource modelResource;
    private NewVirtualDocumentWizardPage docPage;
    private VirtualDocumentStatisticsWizardPage statsPage;
    private PreviewVirtualDocumentWizardPage previewPage;
    private IWizardPage priorPage;
    private boolean completedOperation = false;
    private NewDocumentWizardModel model;
    boolean txnStarted = false;
    boolean txnSucceeded = false;
    boolean txnCancelled = false;

    public XMLDocumentWizard() {
        super((AbstractUIPlugin)ModelerXmlUiPlugin.getDefault(), ModelerXmlUiConstants.Util.getString("XMLDocumentWizard.title"), null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.model = new NewDocumentWizardModel();
        this.startTransaction();
    }

    private void startTransaction() {
        this.txnStarted = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Build XML Document", (Object)((Object)this));
        this.txnSucceeded = false;
        this.txnCancelled = false;
    }

    private void commitTransaction() {
        if (this.txnStarted) {
            if (this.txnSucceeded) {
                ModelerCore.commitTxn();
            } else {
                ModelerCore.rollbackTxn();
            }
        }
    }

    private void cancelTransaction() {
        if (this.txnStarted) {
            ModelerCore.rollbackTxn();
        }
    }

    public void setModel(ModelResource model) {
        this.modelResource = model;
    }

    public void addPages() {
        this.docPage = new NewVirtualDocumentWizardPage(this.model, null);
        this.addPage((IWizardPage)this.docPage);
        this.model.setSource((IVirtualDocumentFragmentSource)this.docPage);
        this.statsPage = new VirtualDocumentStatisticsWizardPage(this.model);
        this.addPage((IWizardPage)this.statsPage);
        this.previewPage = new PreviewVirtualDocumentWizardPage(this.model);
        this.addPage((IWizardPage)this.previewPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage currP = this.getContainer().getCurrentPage();
        try {
            DocSrcUpdater dsi = null;
            dsi = this.priorPage == this.docPage && currP == this.statsPage ? new DocSrcUpdater((IVirtualDocumentFragmentSource)this.statsPage, true, this.model.getSelectedFragmentCount()) : (currP == this.previewPage ? new DocSrcUpdater((IVirtualDocumentFragmentSource)this.previewPage, true, this.model.getEstimatedNodeCount()) : null);
            if (dsi != null) {
                this.getContainer().run(false, true, (IRunnableWithProgress)dsi);
            }
        }
        catch (Exception ex) {
            ModelerXmlUiConstants.Util.log((Throwable)ex);
        }
        this.priorPage = currP;
        return super.getNextPage(page);
    }

    public boolean finish() {
        this.completedOperation = XMLDocumentWizard.finishWizard(this.docPage, this.previewPage, this.modelResource, this.getContainer(), this.model);
        if (this.completedOperation) {
            this.txnSucceeded = true;
            this.commitTransaction();
        }
        return this.completedOperation;
    }

    public static boolean finishWizard(final NewVirtualDocumentWizardPage docPage, final PreviewVirtualDocumentWizardPage previewPage, final ModelResource modelResource, final IWizardContainer container, final NewDocumentWizardModel wizModel) {
        final boolean useXsdTypes = wizModel.getUseSchemaTypes();
        ModelerXmlPlugin.getDefault().getPluginPreferences().setValue("mappingTypeFromXsd", useXsdTypes);
        ModelerXmlPlugin.getDefault().savePluginPreferences();
        final DatatypeManager dtMgr = ModelerCore.getWorkspaceDatatypeManager();
        final boolean[] completedOperation = new boolean[1];
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                try {
                    IDocumentsAndFragmentsPopulator populator = docPage.getPopulator();
                    IWizardPage currentPage = container.getCurrentPage();
                    boolean buildMappingClasses = wizModel.getBuildMappingClasses();
                    Collection<Object> fragments = new ArrayList();
                    if (currentPage != previewPage) {
                        fragments = previewPage.getRoots(monitor);
                        Resource res = modelResource.getEmfResource();
                        if (res instanceof MtkXmiResourceImpl && !buildMappingClasses) {
                            ((MtkXmiResourceImpl)res).addMany(fragments);
                        } else {
                            EList contents = modelResource.getEmfResource().getContents();
                            ModelerCore.getModelEditor().addValue((Object)res, fragments, contents);
                        }
                    } else {
                        XmlFragment[] xfs = previewPage.getFragments(monitor);
                        fragments = Arrays.asList(xfs);
                        Resource res = modelResource.getEmfResource();
                        EList contents = modelResource.getEmfResource().getContents();
                        ModelerCore.getModelEditor().addValue((Object)res, fragments, contents);
                    }
                    if (buildMappingClasses && populator != null) {
                        Iterator<Object> roots = fragments.iterator();
                        while (roots.hasNext()) {
                            XmlFragment fragment = (XmlFragment)roots.next();
                            populator.buildMappingClasses(fragment, wizModel.getMappingClassBuilderStrategy());
                        }
                    }
                    System.gc();
                    Thread.yield();
                    ModelEditor me = ModelerCore.getModelEditor();
                    Iterator refs = wizModel.getUnhandledModelImports().iterator();
                    while (refs.hasNext()) {
                        Resource next = (Resource)refs.next();
                        me.addModelImport((EmfResource)modelResource.getEmfResource(), next);
                    }
                    if (useXsdTypes && populator != null) {
                        HashMap<String, XSDSchema> simpleTypeMap = new HashMap<String, XSDSchema>();
                        Iterator accumulatedDatatypes = ((VirtualDocumentModelPopulator)populator).getAccumulatedDatatypes().iterator();
                        while (accumulatedDatatypes.hasNext()) {
                            Object type = accumulatedDatatypes.next();
                            if (!(type instanceof XSDSimpleTypeDefinition) || dtMgr.isEnterpriseDatatype((EObject)type)) continue;
                            simpleTypeMap.put(((XSDSimpleTypeDefinition)type).getName(), ((XSDSimpleTypeDefinition)type).getSchema());
                        }
                        if (simpleTypeMap.size() > 0) {
                            HashSet<Resource> resources = new HashSet<Resource>();
                            ModelResource modelResrc = ModelUtilities.getModelResource((IFile)((IFile)populator.getItem()), (boolean)true);
                            if (modelResrc != null) {
                                Resource xsdResource = modelResrc.getEmfResource();
                                resources.add(xsdResource);
                                this.loadReferencedXsdResources(xsdResource, resources, xsdResource.getResourceSet());
                                Set affectedSchemas = this.getAffectedSchemas(resources, simpleTypeMap);
                                this.removeExternalSchemas(affectedSchemas);
                                if (!affectedSchemas.isEmpty() && this.displayDialog(affectedSchemas)) {
                                    Resource resource;
                                    HashSet<Resource> readOnlySchemas = new HashSet<Resource>();
                                    Iterator iter = affectedSchemas.iterator();
                                    while (iter.hasNext()) {
                                        resource = (Resource)iter.next();
                                        if (!ModelUtilities.getModelResource((Resource)resource, (boolean)false).isReadOnly()) continue;
                                        readOnlySchemas.add(resource);
                                    }
                                    if (!readOnlySchemas.isEmpty()) {
                                        iter = readOnlySchemas.iterator();
                                        while (iter.hasNext()) {
                                            resource = (Resource)iter.next();
                                            String file = resource.getURI().toFileString();
                                            CoreFileSystemLibrary.setReadOnly((String)file, (boolean)false);
                                        }
                                    }
                                    this.convertToEnterpriseType(affectedSchemas, simpleTypeMap, monitor);
                                }
                            }
                        }
                    }
                    System.gc();
                    Thread.yield();
                    modelResource.save(monitor, true);
                    modelResource.getEmfResource().setModified(false);
                    completedOperation[0] = true;
                }
                catch (ModelWorkspaceException ex) {
                    ModelerXmlUiConstants.Util.log(4, (Throwable)ex, DOC_ERROR_MSG);
                }
                catch (ModelerCoreException ex) {
                    ModelerXmlUiConstants.Util.log(4, (Throwable)ex, DOC_ERROR_MSG);
                }
                catch (Exception ex) {
                    ModelerXmlUiConstants.Util.log(4, (Throwable)ex, DOC_ERROR_MSG);
                }
                finally {
                    monitor.done();
                }
            }

            private boolean displayDialog(Set resources) {
                ConvertSimpleTypesToEnteriseTypesDialog dialog = null;
                dialog = new ConvertSimpleTypesToEnteriseTypesDialog(null, resources);
                dialog.open();
                return dialog.getReturnCode() == 0;
            }

            private void removeExternalSchemas(Set schemas) {
                Iterator iter = schemas.iterator();
                while (iter.hasNext()) {
                    Resource resource = (Resource)iter.next();
                    ModelResource modelRsrc = null;
                    try {
                        modelRsrc = ModelUtilities.getModelResource((Resource)resource, (boolean)false);
                    }
                    catch (ModelWorkspaceException e) {
                        // empty catch block
                    }
                    if (modelRsrc != null) continue;
                    iter.remove();
                }
            }

            private void convertToEnterpriseType(Set resources, HashMap simpleTypeMap, IProgressMonitor monitor) throws ModelWorkspaceException, Exception {
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(this, resources, simpleTypeMap){
                    private final /* synthetic */ Set val$resources;
                    private final /* synthetic */ HashMap val$simpleTypeMap;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$resources = val$resources;
                        this.val$simpleTypeMap = val$simpleTypeMap;
                    }

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        XSDSchema schema = null;
                        ModelEditor me = ModelerCore.getModelEditor();
                        Iterator<E> xsdIter = this.val$resources.iterator();
                        while (xsdIter.hasNext()) {
                            boolean updated = false;
                            XSDResourceImpl xsdResource = (XSDResourceImpl)xsdIter.next();
                            Iterator eObjects = xsdResource.getContents().iterator();
                            while (eObjects.hasNext()) {
                                E next = eObjects.next();
                                if (!(next instanceof XSDSchema)) continue;
                                schema = (XSDSchema)next;
                                schema.setIncrementalUpdate(false);
                                Iterator children = ((XSDSchema)next).eContents().iterator();
                                while (children.hasNext()) {
                                    V value;
                                    E child = children.next();
                                    if (!(child instanceof XSDSimpleTypeDefinition) || (value = this.val$simpleTypeMap.get(((XSDSimpleTypeDefinition)child).getName())) == null || !((XSDSchema)value).getSchemaLocation().equals(((XSDSchema)next).getSchemaLocation())) continue;
                                    EnterpriseDatatypeInfo edi = 1.access$100(this.this$0, (XSDSimpleTypeDefinition)child);
                                    me.setEnterpriseDatatypePropertyValue((EObject)((XSDSimpleTypeDefinition)child), (Object)edi);
                                    updated = true;
                                }
                            }
                            try {
                                if (!updated) continue;
                                xsdResource.save(new HashMap<K, V>());
                                IResource iResource = ModelUtilities.getModelResource((Resource)xsdResource, (boolean)true).getResource();
                                iResource.refreshLocal(0, null);
                            }
                            catch (Exception err) {
                                String msg = ModelerXmlUiConstants.Util.getString("XMLDocumentWizard.convertToEnterpriseTypesSaveError");
                                ModelerXmlUiConstants.Util.log(4, (Throwable)err, msg);
                            }
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(null).run(false, false, (IRunnableWithProgress)operation);
                }
                catch (InterruptedException e) {
                    ModelerXmlUiConstants.Util.log(4, (Throwable)e, DOC_ERROR_MSG);
                }
                catch (InvocationTargetException e) {
                    ModelerXmlUiConstants.Util.log(4, (Throwable)e, DOC_ERROR_MSG);
                }
            }

            private Set getAffectedSchemas(Set resources, HashMap simpleTypeMap) {
                HashSet<XSDResourceImpl> affectedSchemas = new HashSet<XSDResourceImpl>();
                Iterator xsdIter = resources.iterator();
                while (xsdIter.hasNext()) {
                    XSDResourceImpl xsdResource = (XSDResourceImpl)xsdIter.next();
                    Iterator eObjects = xsdResource.getContents().iterator();
                    while (eObjects.hasNext()) {
                        Object next = eObjects.next();
                        Iterator children = ((XSDSchema)next).eContents().iterator();
                        while (children.hasNext()) {
                            Object value;
                            Object child = children.next();
                            if (!(child instanceof XSDSimpleTypeDefinition) || (value = simpleTypeMap.get(((XSDSimpleTypeDefinition)child).getName())) == null || !((XSDSchema)value).getSchemaLocation().equals(((XSDSchema)next).getSchemaLocation())) continue;
                            affectedSchemas.add(xsdResource);
                        }
                    }
                }
                return affectedSchemas;
            }

            private void loadReferencedXsdResources(Resource xsdSource, Set resources, ResourceSet container2) throws Exception {
                Assertion.isNotNull((Object)ModelerCore.getContainer((Resource)xsdSource));
                ResourceFinder finder = ModelerCore.getContainer((Resource)xsdSource).getResourceFinder();
                if (!xsdSource.isLoaded()) {
                    ResourceSet ctnr = xsdSource.getResourceSet();
                    if (ctnr == null) {
                        ctnr = ModelerCore.getModelContainer();
                    }
                    Map options = ctnr == null ? null : ctnr.getLoadOptions();
                    xsdSource.load(options);
                }
                XSDSchema schema = ((XSDResourceImpl)xsdSource).getSchema();
                Iterator contents = schema.getContents().iterator();
                while (contents.hasNext()) {
                    Object obj = contents.next();
                    if (!(obj instanceof XSDSchemaDirective) || (xsdSource = finder.findByImport((XSDSchemaDirective)obj, false)) == null || xsdSource.getResourceSet() != container2 || !resources.add(xsdSource)) continue;
                    this.loadReferencedXsdResources(xsdSource, resources, container2);
                }
            }

            private EnterpriseDatatypeInfo getEDIForType(XSDSimpleTypeDefinition type) {
                EnterpriseDatatypeInfo edi = new EnterpriseDatatypeInfo();
                XSDSimpleTypeDefinition superType = type;
                XSDSimpleTypeDefinition enterpriseParent = null;
                while (superType != null && enterpriseParent == null) {
                    if (dtMgr.isEnterpriseDatatype((EObject)superType)) {
                        enterpriseParent = superType;
                        continue;
                    }
                    XSDSimpleTypeDefinition tmp = superType.getBaseTypeDefinition();
                    if (tmp != superType) {
                        superType = superType.getBaseTypeDefinition();
                        continue;
                    }
                    superType = null;
                }
                if (enterpriseParent != null) {
                    edi.setRuntimeTypeFixed(dtMgr.getRuntimeTypeFixed(enterpriseParent));
                    edi.setRuntimeType(dtMgr.getRuntimeTypeName((EObject)enterpriseParent));
                }
                edi.fillWithDefaultValues(type);
                return edi;
            }

            static /* synthetic */ EnterpriseDatatypeInfo access$100(1 x0, XSDSimpleTypeDefinition x1) {
                return x0.getEDIForType(x1);
            }
        };
        try {
            container.run(false, true, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            String message = realException.getMessage();
            if (message == null) {
                message = realException.getClass().getName();
            }
            MessageDialog.openError((Shell)container.getShell(), (String)ModelerXmlUiConstants.Util.getString("XMLDocumentWizard.error"), (String)message);
            ModelerXmlUiConstants.Util.log(realException);
            return false;
        }
        return completedOperation[0];
    }

    public boolean completedOperation() {
        return this.completedOperation;
    }

    public boolean performCancel() {
        this.cancelTransaction();
        return super.performCancel();
    }

    public void setCommand(Command descriptor) {
    }

    public static class DocSrcUpdater
    implements IRunnableWithProgress {
        private int units;
        private IVirtualDocumentFragmentSource srcToUpdate;
        private boolean isVis;

        public DocSrcUpdater(IVirtualDocumentFragmentSource thingToUpdate, boolean isVisible, int nodes) {
            this.srcToUpdate = thingToUpdate;
            this.isVis = isVisible;
            this.units = nodes * 2;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(ModelerXmlUiConstants.Util.getString("XMLDocumentWizard.taskGathering"), this.units);
            this.srcToUpdate.updateSourceFragments(this.isVis, monitor);
            monitor.done();
        }
    }
}

