/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BlockedOnMemoryException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.lob.ValueID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.data.basic.BasicValueChunk;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.CacheResults;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.process.DQPProcessorContext;
import com.metamatrix.dqp.internal.process.DataTierManager;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.ParameterInfo;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.query.e.f;
import com.metamatrix.query.e.j.d;
import com.metamatrix.query.k.a;
import com.metamatrix.query.k.b;
import com.metamatrix.query.o.j.ao;
import com.metamatrix.query.o.j.l;
import com.metamatrix.query.o.j.x;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ProcessWorker
extends QueueWorker {
    public static final String LOB_MESSAGE_KEY_PREFIX = "LOB_";
    private RequestManager requestMgr;
    private BufferManager bufferMgr;
    private int processorTimeslice;
    private DataTierManager dataTierMgr;
    private TrackingService tracker;
    private ResultSetCache rsCache;
    private boolean isLobRequest;

    public ProcessWorker(RequestManager requestMgr, BufferManager bufferMgr, WorkerPool processPool, int processorTimeslice, DataTierManager dataTierMgr, TrackingService tracker, ResultSetCache rsCache) {
        this.dataTierMgr = dataTierMgr;
        this.requestMgr = requestMgr;
        this.bufferMgr = bufferMgr;
        this.processorTimeslice = processorTimeslice;
        this.tracker = tracker;
        this.rsCache = rsCache;
    }

    public void initialize() throws QueueWorkerException {
    }

    public void cleanup() throws QueueWorkerException {
        this.requestMgr = null;
    }

    public void process(Object o2) throws QueueWorkerException {
        WorkItem workItem = (WorkItem)o2;
        RequestID requestID = workItem.getRequestID();
        RequestMessage request = this.requestMgr.getRequest(requestID);
        this.isLobRequest = workItem.getType() == 1 || workItem.getType() == 2;
        try {
            if (request != null) {
                this.processDirect(o2, workItem, requestID, request);
            }
        }
        catch (Throwable e2) {
            LogManager.logError("DQP", e2, "############# PW PROCESSING ERROR OCCURRED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processDirect(Object o, WorkItem workItem, RequestID requestID, RequestMessage request) {
        if (LogManager.isMessageToBeRecorded("DQP", 5)) {
            LogManager.logDetail("DQP", "############# PW PROCESSING on " + requestID + " workItem.getType(): " + workItem.getType() + " ###########");
        }
        if (!this.shouldContinue(processor = this.requestMgr.getProcessor(requestID), workItem, request)) {
            LogManager.logDetail("DQP", "############# PW EXITING on " + requestID + " - no processor found ###########");
            return;
        }
        switch (workItem.getType()) {
            case 3: {
                try {
                    this.requestMgr.startProcessing(requestID);
                    this.requestMgr.markResultsSent(requestID);
                    this.sendResultsFromCache(requestID, request, workItem.getResultSetCache(), null, null, false);
                    var7_6 = null;
                }
                catch (Throwable var6_22) {
                    var7_7 = null;
                    try {
                        this.requestMgr.markDoneProcessing(requestID, (WorkItem)o);
                    }
                    catch (Throwable e2) {
                        this.sendError(request, e2);
                    }
                    throw var6_22;
                }
                try {
                    this.requestMgr.markDoneProcessing(requestID, (WorkItem)o);
                }
                catch (Throwable e2) {
                    this.sendError(request, e2);
                }
                break;
            }
            case 1: {
                mainErr = this.requestMgr.getProcessingException(requestID);
                if (mainErr != null) {
                    this.sendError(request, mainErr);
                }
                if ((valueID = workItem.getValueID()) instanceof d) {
                    try {
                        startPosition = workItem.getStartPos();
                        isLengthOnly = workItem.getStartPos() == 0L && workItem.getValueChunkSize() == 0;
                        batchFirst = 1;
                        if (!isLengthOnly) {
                            batchFirst = this.requestMgr.getNextChunkPosition(requestID, valueID, startPosition);
                        }
                        if (this.hasResultsInCache(request)) {
                            this.sendResultsFromCache(requestID, request, this.rsCache, new int[]{batchFirst, batchFirst}, valueID, isLengthOnly);
                            break;
                        }
                        this.sendResults(requestID, request, valueID, new int[]{batchFirst, batchFirst}, workItem, isLengthOnly);
                    }
                    catch (BlockedOnMemoryException e) {
                        try {
                            this.requestMgr.markHasData(requestID, workItem);
                            LogManager.logDetail("DQP", "############# PW EXITING on " + requestID + " - reenqueueing for more processing due to lack of available memory ###########");
                        }
                        catch (QueueSuspendedException qse) {
                        }
                    }
                    catch (BlockedException e) {
                        if (!LogManager.isMessageToBeRecorded("DQP", 5)) break;
                        LogManager.logDetail("DQP", "############# PW EXITING on " + requestID + " - processor blocked ###########");
                    }
                    catch (Throwable e) {
                        LogManager.logError("DQP", e, "############# PW EXITING on " + requestID + " - error occurred ###########");
                        try {
                            processor.p().f5();
                        }
                        catch (Throwable me) {
                            LogManager.logWarning("DQP", me, "Failed to close the processor plan after an error occurred.");
                        }
                        this.sendError(request, e);
                    }
                    break;
                }
                context = (DQPProcessorContext)processor.g();
                clientConn = context.getClientConnection();
                chunkRequest = new AtomicRequestMessage(request);
                chunkRequest.setType(4);
                chunkRequest.assignToClientConnection(clientConn);
                chunkRequest.setUserParameters(clientConn);
                chunkRequest.setConnectorID(new ConnectorID(workItem.getValueID().getConnectorID()));
                chunkRequest.setValueID(workItem.getValueID());
                chunkRequest.setStartPosition(workItem.getStartPos());
                chunkRequest.setChunkSize(workItem.getValueChunkSize());
                try {
                    this.dataTierMgr.registerRequest(chunkRequest);
                }
                catch (MetaMatrixComponentException me) {
                    LogManager.logDetail("DQP", "############# PW EXITING on " + requestID + " - error occurred ###########");
                    this.sendError(request, me);
                }
                break;
            }
            case 2: {
                this.sendResponse(request, workItem.getResponse(), false);
                break;
            }
            case 0: {
                doneProducingBatches = false;
                processSucceeded = false;
                this.requestMgr.startProcessing(requestID);
                try {
                    try {
                        if (this.requestMgr.isPlanOnly(requestID)) {
                            this.bufferMgr.setStatus(processor.r(), 2);
                            doneProducingBatches = true;
                        } else {
                            doneProducingBatches = this.bufferMgr.getFinalRowCount(processor.r()) < 0 ? processor.m(this.processorTimeslice, this.requestMgr.needsResults(requestID)) : true;
                        }
                        processSucceeded = true;
                    }
                    catch (BlockedOnMemoryException e) {
                        try {
                            this.requestMgr.markHasData(requestID, workItem);
                            LogManager.logDetail("DQP", "############# PW EXITING on " + requestID + " - reenqueueing for more processing due to lack of available memory ###########");
                        }
                        catch (QueueSuspendedException qse) {}
                    }
                    catch (BlockedException e) {
                        if (LogManager.isMessageToBeRecorded("DQP", 5)) {
                            LogManager.logDetail("DQP", "############# PW EXITING on " + requestID + " - processor blocked ###########");
                        }
                    }
                    catch (TupleSourceNotFoundException e) {
                    }
                    catch (Throwable e) {
                        LogManager.logDetail("DQP", e, "##### [ProcessWorker.processDirect] ##### CASE: WorkItem.PROCESSING threw: " + e.toString());
                        if (this.requestMgr.isRequestCancelled(requestID)) {
                            LogManager.logDetail("DQP", e, "############# PW EXITING on " + requestID + " - error occurred ###########");
                        } else {
                            LogManager.logError("DQP", e, "############# PW EXITING on " + requestID + " - error occurred ###########");
                        }
                        try {
                            processor.p().f5();
                        }
                        catch (Throwable me) {
                            LogManager.logWarning("DQP", me, "Failed to close the processor plan after an error occurred.");
                        }
                        this.requestMgr.setProcessingException(requestID, e);
                        if (!this.requestMgr.needsResults(requestID)) ** GOTO lbl126
                        this.requestMgr.markResultsSent(requestID);
                        this.sendError(request, e);
                    }
lbl126:
                    // 7 sources

                    if (processSucceeded && this.requestMgr.needsResults(requestID)) {
                        processingException = this.requestMgr.getProcessingException(requestID);
                        if (processingException != null) {
                            this.requestMgr.markResultsSent(requestID);
                            this.sendError(request, processingException);
                        } else {
                            warnings = processor.c();
                            if (warnings != null && !warnings.isEmpty()) {
                                warningIter = warnings.iterator();
                                while (warningIter.hasNext()) {
                                    this.requestMgr.addWarning((MetaMatrixException)warningIter.next(), requestID);
                                }
                            }
                            if ((analysisRecord = this.requestMgr.getAnalysisRecord(requestID)).d()) {
                                analysisRecord.g(processor.p().a());
                            }
                            this.requestMgr.markResultsSent(requestID);
                            try {
                                this.sendResults(requestID, request, processor.r(), processor.p().f6(), doneProducingBatches, workItem);
                            }
                            catch (BlockedOnMemoryException err) {
                                range = this.requestMgr.getBatchInterval(requestID);
                                try {
                                    this.requestMgr.markNeedsResults(requestID, workItem, range[0], range[1]);
                                    LogManager.logDetail("DQP", "############# PW EXITING on " + requestID + " - reenqueueing for more processing due to lack of available memory ###########");
                                }
                                catch (QueueSuspendedException err1) {
                                    this.sendError(request, err1);
                                }
                            }
                            catch (Throwable e) {
                                this.sendError(request, e);
                            }
                        }
                    }
                    var15_40 = null;
                }
                catch (Throwable var14_44) {
                    var15_41 = null;
                    try {
                        if (processSucceeded && !doneProducingBatches) {
                            this.requestMgr.markHasData(requestID, workItem);
                            LogManager.logDetail("DQP", "############# PW EXITING on " + requestID + " - reenqueueing for more processing ###########");
                        }
                        if (doneProducingBatches) {
                            this.requestMgr.markDoneProcessing(requestID, workItem);
                        } else {
                            this.requestMgr.markEndProcessing(requestID, workItem);
                        }
                    }
                    catch (Throwable e2) {
                        this.sendError(request, e2);
                    }
                    throw var14_44;
                }
                try {
                    if (processSucceeded && !doneProducingBatches) {
                        this.requestMgr.markHasData(requestID, workItem);
                        LogManager.logDetail("DQP", "############# PW EXITING on " + requestID + " - reenqueueing for more processing ###########");
                    }
                    if (doneProducingBatches) {
                        this.requestMgr.markDoneProcessing(requestID, workItem);
                        break;
                    }
                    this.requestMgr.markEndProcessing(requestID, workItem);
                }
                catch (Throwable e2) {
                    this.sendError(request, e2);
                }
                break;
            }
        }
    }

    private boolean shouldContinue(f processor, WorkItem workItem, RequestMessage request) {
        if (processor != null) {
            return true;
        }
        return workItem.getType() == 3 || this.hasResultsInCache(request);
    }

    private boolean checkRequest(RequestMessage request) {
        if (request == null) {
            String msg = DQPPlugin.Util.getString("ProcessWorker.Could_not_deliver_response_as_request_has_been_removed.");
            LogManager.logDetail("DQP", msg);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void sendResults(RequestID requestID, RequestMessage request, TupleSourceID resultsID, List elements, boolean done, WorkItem work) throws BlockedOnMemoryException, QueueSuspendedException, MetaMatrixComponentException, RemoteException {
        block17: {
            TupleBatch batch;
            block16: {
                CacheID cid;
                LogManager.logDetail("DQP", "[ProcessWorker.sendResults] requestID: " + requestID + " resultsID: " + resultsID + " done: " + done);
                batch = null;
                int[] range = null;
                range = this.requestMgr.getBatchInterval(requestID);
                range[1] = Math.min(range[1], this.bufferMgr.getRowCount(resultsID));
                batch = this.bufferMgr.pinTupleBatch(resultsID, range[0], range[1]);
                if (!done && batch.getRowCount() == 0) {
                    throw BlockedOnMemoryException.INSTANCE;
                }
                ResultsMessage response = null;
                response = new ResultsMessage(request, batch.getAllTuples(), elements, false);
                response.setFirstRow(batch.getBeginRow());
                response.setLastRow(batch.getEndRow());
                int finalRowCount = this.bufferMgr.getFinalRowCount(resultsID);
                LogManager.logDetail("DQP", "[ProcessWorker.sendResults] finalRowCount: " + finalRowCount);
                response.setFinalRow(finalRowCount);
                boolean isPartialResultSet = finalRowCount < 0 || batch.getEndRow() < finalRowCount;
                response.setPartialResults(isPartialResultSet);
                response.setSchemas(this.requestMgr.getSchemas(requestID));
                response.setWarnings(this.requestMgr.getAndClearWarnings(requestID));
                b analysisRecord = this.requestMgr.getAnalysisRecord(requestID);
                this.setAnalysisRecords(response, analysisRecord);
                l command = request.getCommand();
                if (command instanceof x) {
                    response.setParameters(this.getParameterInfo((x)command));
                }
                this.sendResponse(request, response, false);
                if (this.rsCache == null || !request.useResultSetCache() || !request.getCommand().f9() || this.rsCache.hasResults(cid = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache))) break block16;
                CacheResults cr = new CacheResults(response.getResults(), elements, response.getFirstRow(), !response.isPartialResults());
                cr.setCommand(this.requestMgr.getOriginalCommand(requestID));
                if (batch.getSize() != -1L) {
                    cr.setSize(batch.getSize());
                }
                if (analysisRecord != null) {
                    cr.setAnalysisRecord(analysisRecord);
                }
                this.rsCache.setResults(cid, cr, (Object)requestID);
            }
            Object var17_18 = null;
            try {
                if (batch != null) {
                    this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                }
                break block17;
            }
            catch (Exception e2) {}
            break block17;
            {
                catch (MemoryNotAvailableException e3) {
                    throw BlockedOnMemoryException.INSTANCE;
                }
                catch (TupleSourceNotFoundException e4) {
                    Object var17_19 = null;
                    try {
                        if (batch != null) {
                            this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                        }
                        break block17;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                try {
                    if (batch != null) {
                        this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendResults(RequestID requestID, RequestMessage request, ValueID valueID, int[] range, WorkItem work, boolean isLengthOnly) throws BlockedOnMemoryException, QueueSuspendedException, MetaMatrixComponentException, RemoteException {
        block28: {
            block27: {
                block26: {
                    block25: {
                        if (!this.checkRequest(request)) {
                            return;
                        }
                        resultsID = ((d)valueID).a();
                        batch = null;
                        try {
                            try {
                                response = new ResultsMessage(request, true);
                                finalRowCount = this.bufferMgr.getFinalRowCount(resultsID);
                                if (isLengthOnly) {
                                    if (finalRowCount < 0) {
                                        this.requestMgr.getWorkQueue().add(work);
                                        var19_15 = null;
                                        break block25;
                                    }
                                    docSize = this.requestMgr.getLobLength(requestID, valueID);
                                    if (docSize == 0L) {
                                        for (i = 1; i <= finalRowCount; ++i) {
                                            batch = this.bufferMgr.pinTupleBatch(resultsID, i, i);
                                            chars = (char[])batch.getAllTuples()[0].get(0);
                                            if (chars != null) {
                                                docSize += (long)chars.length;
                                            }
                                            this.bufferMgr.unpinTupleBatch(resultsID, i, i);
                                        }
                                        this.requestMgr.setLobLength(requestID, valueID, docSize);
                                    }
                                    response.setStreamLength(docSize);
                                    this.sendResponse(request, response, false);
                                    break block26;
                                }
                                batch = this.bufferMgr.pinTupleBatch(resultsID, range[0], range[1]);
                                v0 = isPartialResultSet = finalRowCount < 0 || batch.getEndRow() < finalRowCount;
                                if (batch.getRowCount() == 0 && isPartialResultSet) {
                                    this.requestMgr.getWorkQueue().add(work);
                                    break block27;
                                }
                                allTuples = batch.getAllTuples();
                                chunk = null;
                                if (allTuples != null && allTuples.length > 0) {
                                    chunk = (char[])batch.getAllTuples()[0].get(0);
                                    isPartialResultSet = true;
                                }
                                valueChunk = new BasicValueChunk(chunk, false, batch.getTerminationFlag());
                                response.setValueChunk((ValueChunk)valueChunk);
                                this.sendResponse(request, response, false);
                                if (this.rsCache != null && request.useResultSetCache() && request.getCommand().f9() && !this.rsCache.hasResults(cid = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache))) {
                                    results = new List[]{new ArrayList<E>()};
                                    results[0].add(valueChunk);
                                    cr = new CacheResults(results, batch.getBeginRow(), isPartialResultSet == false);
                                    if (batch.getSize() != -1L) {
                                        cr.setSize(batch.getSize());
                                    }
                                    this.rsCache.setResults(cid, cr, (Object)requestID, (Object)work.getValueID());
                                }
                                break block28;
                            }
                            catch (MemoryNotAvailableException e) {
                                throw BlockedOnMemoryException.INSTANCE;
                            }
                            catch (TupleSourceNotFoundException e) {
                                var19_19 = null;
                                try {
                                    if (batch == null) return;
                                    this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                                    return;
                                }
                                catch (Exception e) {
                                    return;
                                }
                            }
                            catch (MetaMatrixComponentException e) {
                                params = new Object[]{requestID};
                                msg = DQPPlugin.Util.getString("ProcessWorker.Failed_getting_first_batch_for_{0}.", (Object)params);
                                LogManager.logWarning("DQP", (Throwable)e, msg);
                                this.sendError(request, e);
                                var19_20 = null;
                                try {}
                                catch (Exception e) {
                                    return;
                                }
                                if (batch == null) return;
                                this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                                return;
                            }
                        }
                        catch (Throwable var18_40) {
                            var19_21 = null;
                            ** try [egrp 2[TRYBLOCK] [19 : 566->595)] { 
lbl80:
                            // 1 sources

                            if (batch == null) throw var18_40;
                            this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                            throw var18_40;
lbl83:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                            throw var18_40;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [19 : 566->595)] { 
lbl88:
                    // 1 sources

                    if (batch == null) return;
                    this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                    return;
lbl91:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                var19_16 = null;
                ** try [egrp 2[TRYBLOCK] [19 : 566->595)] { 
lbl97:
                // 1 sources

                if (batch == null) return;
                this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                return;
lbl100:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            var19_17 = null;
            ** try [egrp 2[TRYBLOCK] [19 : 566->595)] { 
lbl106:
            // 1 sources

            if (batch == null) return;
            this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
            return;
lbl109:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        var19_18 = null;
        try {}
        catch (Exception e) {}
        if (batch == null) return;
        this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
        return;
    }

    private void setAnalysisRecords(ResultsMessage response, b analysisRecord) {
        if (analysisRecord != null) {
            response.setPlanDescription(analysisRecord.a());
            response.setDebugLog(analysisRecord.c());
            Collection anns = analysisRecord.h();
            ArrayList<String[]> converted = null;
            if (anns != null) {
                converted = new ArrayList<String[]>(anns.size());
                Iterator annIter = anns.iterator();
                while (annIter.hasNext()) {
                    a ann = (a)annIter.next();
                    String[] jdbcAnn = new String[]{ann.a(), ann.d(), ann.c(), "" + ann.b()};
                    converted.add(jdbcAnn);
                }
                response.setAnnotations(converted);
            }
        }
    }

    private void sendResultsFromCache(RequestID requestID, RequestMessage request, ResultSetCache resultSetCache, int[] interval, Object valueID, boolean isDocLengthOnly) {
        if (!this.checkRequest(request)) {
            return;
        }
        if (interval == null) {
            interval = this.requestMgr.getBatchInterval(requestID);
        }
        if (interval == null || interval[0] == 0) {
            return;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache);
        CacheResults cResult = resultSetCache.getResults(cID, interval, valueID);
        List[] results = cResult.getResults();
        int firstRow = cResult.getFirstRow();
        ResultsMessage response = null;
        if (valueID != null) {
            response = new ResultsMessage(request, true);
            if (isDocLengthOnly) {
                response.setStreamLength(cResult.getLength());
            } else {
                response.setValueChunk((ValueChunk)results[0].get(0));
            }
        } else {
            response = new ResultsMessage(request, results, cResult.getElements(), false);
        }
        response.setFirstRow(firstRow);
        response.setLastRow(firstRow + results.length - 1);
        boolean isFinal = cResult.isFinal();
        if (isFinal) {
            response.setFinalRow(cResult.getFinalRow());
        }
        response.setPartialResults(!isFinal);
        b analysisRecord = cResult.getAnalysisRecord();
        this.setAnalysisRecords(response, analysisRecord);
        try {
            request.getClientConnection().send((Message)response, request.getMessageKey());
        }
        catch (CommunicationException e2) {
            Object[] params = new Object[]{requestID};
            String msg = DQPPlugin.Util.getString("ProcessWorker.Failed_to_deliver_response_for_{0}", (Object)params);
            LogManager.logError("DQP", (Throwable)e2, msg);
        }
    }

    private void sendError(RequestMessage request, Throwable error) {
        if (!this.checkRequest(request)) {
            return;
        }
        Object[] params = new Object[]{request.getRequestID()};
        String msg = DQPPlugin.Util.getString("ProcessWorker.send_error", (Object)params);
        LogManager.logWarning("DQP", error, msg);
        ResultsMessage response = new ResultsMessage(request, false);
        response.setException(error);
        b analysisRecord = this.requestMgr.getAnalysisRecord(request.getRequestID());
        this.setAnalysisRecords(response, analysisRecord);
        this.sendResponse(request, response, !this.requestMgr.isRequestCancelled(request.getRequestID()));
        if (this.rsCache != null) {
            CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache);
            this.rsCache.removeTempResults(cID);
        }
    }

    private void sendResponse(RequestMessage request, ResultsMessage response, boolean error) {
        RequestID requestID = request.getRequestID();
        f processor = this.requestMgr.getProcessor(requestID);
        if (processor == null) {
            return;
        }
        DQPProcessorContext context = (DQPProcessorContext)processor.g();
        ClientConnection clientConn = context.getClientConnection();
        if (error) {
            this.logCommandError(request);
        }
        String messageKey = context.getMessageKey();
        if (this.isLobRequest) {
            messageKey = LOB_MESSAGE_KEY_PREFIX + messageKey;
        }
        try {
            clientConn.send((Message)response, messageKey);
        }
        catch (CommunicationException e2) {
            Object[] params = new Object[]{requestID};
            String msg = DQPPlugin.Util.getString("ProcessWorker.Failed_to_deliver_response_for_{0}", (Object)params);
            LogManager.logError("DQP", (Throwable)e2, msg);
        }
    }

    private void logCommandError(RequestMessage request) {
        if (this.tracker == null || !this.tracker.willRecordMMCmd()) {
            return;
        }
        RequestID rID = request.getRequestID();
        TransactionID transactionID = null;
        l command = request.getCommand();
        if (request.isTransactional()) {
            transactionID = request.getTransactionContext().getTopLevelTxnID();
        }
        this.tracker.log(rID.toString(), transactionID == null ? null : transactionID.asString(), (short)2, (short)4, request.getRequestID().getConnectionID(), (String)request.getClientConnection().getConnectionProperty("ApplicationName"), request.getUserName(), request.getVdbName(), request.getVdbVersion(), command, -1);
    }

    private List getParameterInfo(x procedure) {
        List params = procedure.in();
        ArrayList<ParameterInfo> paramInfos = new ArrayList<ParameterInfo>(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            ao param = (ao)iter.next();
            ParameterInfo info = new ParameterInfo(param.u(), param.p().size());
            paramInfos.add(info);
        }
        return paramInfos;
    }

    private boolean hasResultsInCache(RequestMessage requestMsg) {
        if (this.rsCache == null) {
            return false;
        }
        if (!requestMsg.useResultSetCache()) {
            return false;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)requestMsg, (ResultSetCache)this.rsCache);
        return this.rsCache.hasResults(cID);
    }
}

