/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.common.types.ClobType;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.Executor;
import com.metamatrix.connector.xml.base.IQueryPreprocessor;
import com.metamatrix.connector.xml.base.LargeOrSmallString;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.connector.xml.base.OutputXPathDesc;
import com.metamatrix.connector.xml.base.QueryAnalyzer;
import com.metamatrix.connector.xml.base.XMLConnection;
import com.metamatrix.connector.xml.base.XMLConnectorState;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.api.ValueReference;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class XMLExecution
implements SynchQueryExecution {
    private XMLConnection m_conn;
    private ConnectorLogger m_logger;
    private ExecutionContext exeContext;
    private ConnectorEnvironment connectorEnv;
    private RuntimeMetadata m_metadata;
    private int m_maxBatch;
    private ExecutionInfo m_info;
    private ArrayList m_resultList;
    private int returnIndex;

    public XMLExecution(XMLConnection conn, RuntimeMetadata metadata, ExecutionContext exeContext, ConnectorEnvironment connectorEnv) {
        this.setConnection(conn);
        this.m_metadata = metadata;
        this.m_logger = this.getConnection().getConnector().getLogger();
        this.m_resultList = null;
        this.exeContext = exeContext;
        this.connectorEnv = connectorEnv;
    }

    public void execute(IQuery query, int maxBatchSize) throws ConnectorException {
        try {
            XMLConnectorState state = this.m_conn.getState();
            IQueryPreprocessor preprocessor = this.loadPreprocessor(state.getQueryPreprocessorClass());
            IQuery newQuery = preprocessor.preprocessQuery(query, this.m_metadata, this.exeContext, this.connectorEnv, this.m_logger);
            this.m_maxBatch = maxBatchSize;
            this.m_logger.logTrace("XML Connector Framework: executing command: " + newQuery);
            QueryAnalyzer analyzer = new QueryAnalyzer(newQuery, this.m_metadata);
            analyzer.analyze();
            this.m_info = analyzer.getExecutionInfo();
            ArrayList fullParams = this.m_info.getParameters();
            ArrayList requestPerms = XMLExecution.getRequestPerms(fullParams);
            this.m_resultList = new ArrayList();
            Iterator iter = requestPerms.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                CriteriaDesc[] criteriaArrayForOnePerm = (CriteriaDesc[])o;
                ArrayList<CriteriaDesc> criteriaListForOnePerm = new ArrayList<CriteriaDesc>(Arrays.asList(criteriaArrayForOnePerm));
                this.m_info.setParameters(criteriaListForOnePerm);
                Executor executioner = state.makeExecutor(this);
                executioner.validate();
                ArrayList resultList = executioner.getResult();
                if (this.m_resultList.size() == 0) {
                    this.m_resultList = resultList;
                    continue;
                }
                for (int i = 0; i < this.m_resultList.size(); ++i) {
                    Object oResultList = this.m_resultList.get(i);
                    List allResultsField = (List)oResultList;
                    oResultList = resultList.get(i);
                    List loopResultsField = (List)oResultList;
                    allResultsField.addAll(loopResultsField);
                }
            }
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private IQueryPreprocessor loadPreprocessor(String queryPreprocessorClass) throws ConnectorException {
        IQueryPreprocessor pre = null;
        try {
            pre = (IQueryPreprocessor)Class.forName(queryPreprocessorClass).newInstance();
        }
        catch (Exception e) {
            this.m_logger.logError(e.getMessage(), (Throwable)e);
            throw new ConnectorException((Throwable)e);
        }
        return pre;
    }

    public Batch nextBatch() throws ConnectorException {
        try {
            BasicBatch batch = new BasicBatch();
            if (this.m_resultList == null) {
                return batch;
            }
            ArrayList firstColumn = (ArrayList)this.m_resultList.get(0);
            while (this.returnIndex < firstColumn.size() && batch.getRowCount() < this.m_maxBatch) {
                ArrayList row = new ArrayList();
                boolean addRowToCollector = true;
                for (int colNum = 0; colNum < this.m_resultList.size(); ++colNum) {
                    Object resultObj = this.m_resultList.get(colNum);
                    ArrayList result = (ArrayList)resultObj;
                    Object valueObj = result.get(this.returnIndex);
                    LargeOrSmallString value = (LargeOrSmallString)valueObj;
                    addRowToCollector = this.passesCriteriaCheck(this.m_info.getCriteria(), value, colNum);
                    if (!addRowToCollector) break;
                    this.setColumnValue(colNum, value, row);
                }
                if (addRowToCollector) {
                    batch.addRow(row);
                }
                ++this.returnIndex;
            }
            this.testBatchForLast(this.returnIndex, firstColumn.size(), (Batch)batch);
            return batch;
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private void testBatchForLast(int currentSize, int totalSize, Batch testBatch) {
        if (currentSize >= totalSize) {
            testBatch.setLast();
        }
    }

    public void close() throws ConnectorException {
    }

    public void cancel() throws ConnectorException {
    }

    private Object convertString(String value, Class type) throws ConnectorException {
        String newValue = value;
        if (newValue == null) {
            return null;
        }
        if (type == String.class) {
            return newValue;
        }
        if (type == ClobType.class) {
            LargeOrSmallString los = LargeOrSmallString.createSmallString(value);
            ValueReference valueReference = los.getAsValueReference();
            Object retval = this.connectorEnv.createValueReferenceReplacement(valueReference, this.exeContext);
            return retval;
        }
        if (type != Character.class) {
            newValue = newValue.replaceAll(",", "");
        }
        return this.attemptTransformation(newValue, type);
    }

    private Object convertLargeOrSmallString(LargeOrSmallString value, Class type) throws ConnectorException {
        if (value == null) {
            return null;
        }
        if (value.isSmall()) {
            return this.convertString(value.getAsString(), type);
        }
        if (type == ClobType.class) {
            Object retval = this.connectorEnv.createValueReferenceReplacement(value.getAsValueReference(), this.exeContext);
            return retval;
        }
        return this.convertString(value.getAsString(), type);
    }

    private Object attemptTransformation(String value, Class type) throws ConnectorException {
        String newValue = value;
        if (DataTypeManager.isTransformable((Class)String.class, (Class)type)) {
            try {
                Transform transform = DataTypeManager.getTransform((Class)String.class, (Class)type);
                return transform.transform((Object)newValue);
            }
            catch (TransformationException tex) {
                String msgRaw = Messages.getString("XMLExecution.type.conversion.failure");
                String msg = MessageFormat.format(msgRaw, newValue, type);
                throw new ConnectorException(msg);
            }
        }
        String msgRaw = Messages.getString("XMLExecution.type.conversion.failure");
        String msg = MessageFormat.format(msgRaw, newValue, type);
        throw new ConnectorException(msg);
    }

    private boolean passesCriteriaCheck(ArrayList criteriaPairs, LargeOrSmallString value, int colNum) throws ConnectorException {
        for (int x = 0; x < criteriaPairs.size(); ++x) {
            CriteriaDesc criteria = (CriteriaDesc)criteriaPairs.get(x);
            if (colNum != criteria.getColumnNumber()) continue;
            return this.evaluate(value, criteria);
        }
        return true;
    }

    private boolean evaluate(LargeOrSmallString currentValue, CriteriaDesc criteria) throws ConnectorException {
        ArrayList values = criteria.getValues();
        Element element = criteria.getElement();
        for (int y = 0; y < values.size(); ++y) {
            if (!this.compareData(currentValue, (String)values.get(y), element)) continue;
            return true;
        }
        return false;
    }

    private boolean compareData(LargeOrSmallString dataStr, String compareStr, Element elementMetadata) throws ConnectorException {
        if (dataStr == null) {
            return false;
        }
        String dataValueStr = dataStr.getAsString();
        String compareValueStr = new String(compareStr);
        if (!elementMetadata.isCaseSensitive()) {
            dataValueStr = dataValueStr.toUpperCase();
            compareValueStr = compareValueStr.toUpperCase();
        }
        Class dataValueType = elementMetadata.getJavaType();
        Object value = this.convertString(dataValueStr, dataValueType);
        Object compareValue = this.convertString(compareValueStr, dataValueType);
        int comparison = 0;
        Comparable comparable = (Comparable)value;
        comparison = comparable.compareTo(compareValue);
        return comparison == 0;
    }

    public XMLConnection getConnection() {
        return this.m_conn;
    }

    void setConnection(XMLConnection conn) {
        this.m_conn = conn;
    }

    public ExecutionInfo getInfo() {
        return this.m_info;
    }

    private void setColumnValue(int colNum, LargeOrSmallString value, ArrayList row) throws ConnectorException {
        if (colNum < this.m_info.getColumnCount()) {
            OutputXPathDesc xpath = (OutputXPathDesc)this.m_info.getRequestedColumns().get(colNum);
            Class dataValueType = xpath.getDataType();
            Object valueObj = this.convertLargeOrSmallString(value, dataValueType);
            row.add(valueObj);
        }
    }

    public ConnectorLogger getLogger() {
        return this.m_logger;
    }

    public static ArrayList getRequestPerms(ArrayList params) {
        ArrayList soFar = new ArrayList();
        soFar.add(new CriteriaDesc[0]);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            ArrayList nextGeneration;
            Object o = iter.next();
            CriteriaDesc desc = (CriteriaDesc)o;
            soFar = nextGeneration = XMLExecution.createCartesionProduct(soFar, desc);
        }
        return soFar;
    }

    private static ArrayList createCartesionProduct(List permsSoFar, CriteriaDesc desc) {
        ArrayList<CriteriaDesc[]> retval = new ArrayList<CriteriaDesc[]>();
        List rows = XMLExecution.createCartesionProduct(permsSoFar, desc.getValues(), desc.isUnlimited());
        Iterator iter = rows.iterator();
        while (iter.hasNext()) {
            Object oRow = iter.next();
            ArrayList row = (ArrayList)oRow;
            Object oOperand1 = row.get(0);
            CriteriaDesc[] previousCriteriaDescs = (CriteriaDesc[])oOperand1;
            CriteriaDesc[] newRow = new CriteriaDesc[previousCriteriaDescs.length + 1];
            System.arraycopy(previousCriteriaDescs, 0, newRow, 0, previousCriteriaDescs.length);
            CriteriaDesc singleValueCriteriaDesc = desc.cloneWithoutValues();
            for (int i = 1; i < row.size(); ++i) {
                Object value = row.get(i);
                singleValueCriteriaDesc.setValue(i - 1, value);
            }
            newRow[newRow.length - 1] = singleValueCriteriaDesc;
            retval.add(newRow);
        }
        return retval;
    }

    private static List createCartesionProduct(List operand1, List operand2, boolean multiElem) {
        if (operand1.size() == 0) {
            operand1 = new ArrayList();
            operand1.add(null);
        }
        if (operand2.size() == 0) {
            operand2 = new ArrayList();
            operand2.add(null);
        }
        ArrayList cartesianProduct = new ArrayList();
        Iterator operand1iter = operand1.iterator();
        while (operand1iter.hasNext()) {
            Object operand1item = operand1iter.next();
            if (!multiElem) {
                Iterator operand2iter = operand2.iterator();
                while (operand2iter.hasNext()) {
                    Object operand2item = operand2iter.next();
                    ArrayList newRow = new ArrayList();
                    newRow.add(operand1item);
                    newRow.add(operand2item);
                    cartesianProduct.add(newRow);
                }
                continue;
            }
            ArrayList newRow = new ArrayList();
            newRow.add(operand1item);
            Iterator operand2iter = operand2.iterator();
            while (operand2iter.hasNext()) {
                Object operand2item = operand2iter.next();
                newRow.add(operand2item);
            }
            cartesianProduct.add(newRow);
        }
        return cartesianProduct;
    }

    public String getSystemName() {
        return this.connectorEnv.getConnectorName();
    }
}

