/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.soap;

import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.DocumentBuilder;
import com.metamatrix.connector.xml.base.Executor;
import com.metamatrix.connector.xml.base.XMLConnectorState;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.base.XMLExecution;
import com.metamatrix.connector.xml.http.HTTPExecutor;
import com.metamatrix.connector.xml.soap.SOAPConnectorState;
import com.metamatrix.data.exception.ConnectorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

public class SOAPExecutor
extends HTTPExecutor {
    private static final String soapEnvelope = "Envelope";
    private static final String soapBody = "Body";
    static final String soapHeader = "Header";
    private static final String soapNSLabel = "SOAP-ENV";
    private static final String soapNS = "http://schemas.xmlsoap.org/soap/envelope/";
    static final Namespace soapNSObj = Namespace.getNamespace((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final String DUMMY_NS_PREFIX = "mm-dummy";
    private static final String DUMMY_NS_NAME = "http://www.metamatrix.com/dummy";

    public SOAPExecutor(XMLConnectorState state, XMLExecution execution) {
        super(state, execution);
    }

    public void validate() throws ConnectorException {
        super.validate();
    }

    protected void modifyRequest(HttpClient client, HttpMethod method) {
        String soapActionHeader = "SOAPAction";
        SOAPConnectorState state = (SOAPConnectorState)this.getState();
        String schemaAction = this.getExecution().getInfo().getOtherProperties().getProperty("SOAPAction");
        Header soapAction = new Header("SOAPAction", state.getSoapAction());
        if (schemaAction != null && schemaAction.trim().length() > 0) {
            soapAction = new Header("SOAPAction", schemaAction);
        }
        method.addRequestHeader(soapAction);
    }

    public Executor.Response getXMLResponse() throws ConnectorException {
        Executor.Response response = super.getXMLResponse();
        XMLDocument[] retDocs = response.getDocuments();
        XMLDocument xmlDoc = retDocs[0];
        Object contextRoot = xmlDoc.getContextRoot();
        if (contextRoot instanceof Document) {
            Document doc = (Document)contextRoot;
            Element env = doc.getRootElement();
            Element bod = env.getChild(soapBody, soapNSObj);
            if (bod != null) {
                xmlDoc.setContextRoot(bod);
            } else {
                xmlDoc.setContextRoot(env);
            }
        }
        retDocs[0] = xmlDoc;
        return response;
    }

    private void handleSoapFault(Element soapFault) throws ConnectorException {
        String strMessage = soapFault.getChildTextTrim("faultstring");
        Element detail = soapFault.getChild("detail");
        Document detailDoc = new Document(detail);
        String strDetail = DocumentBuilder.outputDocToString(detailDoc);
        this.getLogger().logError(strMessage + " : \n" + strDetail);
        throw new ConnectorException(strMessage);
    }

    protected void setRequests(ArrayList params, String uriString) throws ConnectorException {
        SOAPConnectorState state = (SOAPConnectorState)this.getState();
        String encodingStyle = "encoding-style";
        String encodingStyleUrl = "http://schemas.xmlsoap.org/soap/encoding/";
        String xsiLabel = "xsi";
        String xsiNS = "http://www.w3.org/1999/XMLSchema-instance";
        String xsdLabel = "xsd";
        String xsLabel = "xs";
        String xsNS = "http://www.w3.org/2001/XMLSchema";
        String xsdNS = "http://www.w3.org/1999/XMLSchema";
        Namespace soapNSObj = Namespace.getNamespace((String)soapNSLabel, (String)soapNS);
        Namespace xsiNSObj = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/1999/XMLSchema-instance");
        Namespace xsdNSObj = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/1999/XMLSchema");
        Namespace xsNSObj = Namespace.getNamespace((String)"xs", (String)"http://www.w3.org/2001/XMLSchema");
        ArrayList requestPerms = XMLExecution.getRequestPerms(params);
        int requestNumber = requestPerms.size();
        this.m_requests = new HttpMethod[requestNumber];
        for (int i = 0; i < requestPerms.size(); ++i) {
            PostMethod method = new PostMethod(uriString);
            method.setFollowRedirects(false);
            method.getParams().makeLenient();
            this.setStdRequestHeaders((HttpMethod)method);
            CriteriaDesc[] queryParameters = (CriteriaDesc[])requestPerms.get(i);
            List<CriteriaDesc> newList = Arrays.asList(queryParameters);
            ArrayList<CriteriaDesc> queryList = new ArrayList<CriteriaDesc>(newList);
            Element body = new Element(soapBody, soapNSObj);
            Element envelope = new Element(soapEnvelope, soapNSObj);
            envelope.addNamespaceDeclaration(xsiNSObj);
            envelope.addNamespaceDeclaration(xsdNSObj);
            envelope.addNamespaceDeclaration(xsNSObj);
            Element header = new Element(soapHeader, soapNSObj);
            ArrayList headerParams = new ArrayList();
            ArrayList bodyParams = new ArrayList();
            this.sortParams(queryList, headerParams, bodyParams);
            if (headerParams.size() > 0) {
                Document headerDoc = this.createSOAPHeaderDoc(headerParams);
                Element headerRoot = headerDoc.getRootElement();
                Element headerHolder = (Element)headerRoot.getChild(soapHeader).detach();
                List headerChilds = headerHolder.getChildren();
                Iterator childIter = headerChilds.iterator();
                while (childIter.hasNext()) {
                    Element child = (Element)childIter.next();
                    child.detach();
                    header.addContent((Content)child);
                }
            }
            envelope.addContent((Content)header);
            Document doc = this.createXMLRequestDoc(bodyParams);
            Element docRoot = doc.getRootElement();
            docRoot = (Element)docRoot.detach();
            List addNamespaces = docRoot.getAdditionalNamespaces();
            Iterator nsIter = addNamespaces.iterator();
            while (nsIter.hasNext()) {
                Namespace ns = (Namespace)nsIter.next();
                if (ns.getPrefix().equals(xsiNSObj.getPrefix()) && ns.getURI().equals(xsiNSObj.getURI()) || ns.getPrefix().equals(xsdNSObj.getPrefix()) || !ns.getURI().equals(xsdNSObj.getURI())) continue;
                envelope.addNamespaceDeclaration((Namespace)nsIter.next());
            }
            if (docRoot.getNamespaceURI().equals(DUMMY_NS_NAME)) {
                List children = docRoot.getChildren();
                Object[] childarray = children.toArray();
                for (int j = 0; j < childarray.length; ++j) {
                    Element elem = (Element)childarray[j];
                    elem.detach();
                    body.addContent((Content)elem);
                }
                docRoot = body;
            } else {
                body.addContent((Content)docRoot);
            }
            if (state.isEncoded()) {
                Attribute encStyle = new Attribute("encoding-style", "http://schemas.xmlsoap.org/soap/encoding/", xsiNSObj);
                docRoot.setAttribute(encStyle);
            }
            if (state.isUseBasicAuth()) {
                SOAPExecutor.addSoapBasicAuth(header, state.getAuthUser(), state.getAuthPassword());
            }
            envelope.addContent((Content)body);
            doc.setRootElement(envelope);
            String xmlDoc = DocumentBuilder.outputDocToString(doc);
            method.setRequestEntity((RequestEntity)new StringRequestEntity(xmlDoc));
            method.getParams().setVersion(new HttpVersion(1, 0));
            this.m_requests[i] = method;
            this.attemptConditionalLog("XML Connector Framework: request body set to: " + xmlDoc);
            this.getLogger().logDetail("XML Connector Framework: request created");
        }
    }

    private void sortParams(ArrayList allParams, ArrayList headerParams, ArrayList bodyParams) throws ConnectorException {
        Iterator paramIter = allParams.iterator();
        while (paramIter.hasNext()) {
            CriteriaDesc desc = (CriteriaDesc)paramIter.next();
            if (desc.getInputXpath().startsWith("SOAP-ENV:Header")) {
                headerParams.add(desc);
                continue;
            }
            bodyParams.add(desc);
        }
    }

    protected Document createXMLRequestDoc(ArrayList params) throws ConnectorException {
        SOAPConnectorState state = (SOAPConnectorState)this.getState();
        Properties props = this.getExecutionInfo().getOtherProperties();
        String inputParmsXPath = props.getProperty("XPathRootForInput");
        String namespacePrefixes = this.getExecutionInfo().getOtherProperties().getProperty("NamespacePrefixes");
        DocumentBuilder builder = new DocumentBuilder();
        builder.setUseTypeAttributes(state.isEncoded());
        String slash = "/";
        String dotSlash = "./";
        if (inputParmsXPath.equals("./") || inputParmsXPath.equals("/") || inputParmsXPath.equals("")) {
            inputParmsXPath = "mm-dummy:dummy";
            namespacePrefixes = namespacePrefixes + " xmlns:" + DUMMY_NS_PREFIX + "=\"" + DUMMY_NS_NAME + "\"";
        }
        return builder.buildDocument(params, inputParmsXPath, namespacePrefixes);
    }

    protected Document createSOAPHeaderDoc(ArrayList params) throws ConnectorException {
        SOAPConnectorState state = (SOAPConnectorState)this.getState();
        String namespacePrefixes = this.getExecutionInfo().getOtherProperties().getProperty("NamespacePrefixes");
        DocumentBuilder builder = new DocumentBuilder();
        builder.setUseTypeAttributes(state.isEncoded());
        return builder.buildDocument(params, "SOAP-ENV:Header", namespacePrefixes);
    }

    static void addSoapBasicAuth(Element header, String user, String password) {
        String soapBasicAuth = "BasicAuth";
        String authLabel = "auth";
        String authNS = "http://soap-authentication.org/2001/10/";
        String attrMustUnderstand = "mustUnderstand";
        String nameLabel = "Name";
        String passwordLabel = "Password";
        Namespace authNSObj = Namespace.getNamespace((String)"auth", (String)"http://soap-authentication.org/2001/10/");
        Element basicAuth = new Element("BasicAuth", authNSObj);
        Attribute mustUnderstand = new Attribute("mustUnderstand", "1", soapNSObj);
        basicAuth.setAttribute(mustUnderstand);
        header.addContent((Content)basicAuth);
        Element name = new Element("Name");
        name.addContent(user);
        basicAuth.addContent((Content)name);
        Element pwd = new Element("Password");
        pwd.addContent(password);
        basicAuth.addContent((Content)pwd);
    }
}

