/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.webservice.ui.util;

import com.metamatrix.core.io.FileUrl;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.webservice.Input;
import com.metamatrix.metamodels.webservice.Interface;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.metamodels.webservice.Output;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.internal.webservice.ui.IInternalUiConstants;
import com.metamatrix.modeler.webservice.IWebServiceResource;
import com.metamatrix.modeler.webservice.WebServicePlugin;
import com.metamatrix.modeler.webservice.procedure.XsdInstanceNode;
import com.metamatrix.modeler.webservice.ui.WebServiceUiPlugin;
import com.metamatrix.modeler.webservice.util.WebServiceUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import com.metamatrix.ui.internal.util.SystemClipboardUtilities;
import com.metamatrix.ui.internal.util.UiUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xsd.XSDElementDeclaration;

public class WebServiceUiUtil
implements FileUtils.Constants,
IInternalUiConstants {
    public static final String[] FILE_DIALOG_WSDL_EXTENSIONS;
    public static final String[] FILE_DIALOG_XSD_EXTENSIONS;
    private static final String PREFIX;
    public static final String THIS_CLASS = "WebServiceUiUtil";
    static /* synthetic */ Class class$com$metamatrix$modeler$webservice$ui$util$WebServiceUiUtil;

    private static void addVariableStatements(XsdInstanceNode node, Block block, Input input, List nodes, List variables) {
        if (node.isSelectable()) {
            nodes.add(node);
            DeclareStatement declaration = WebServiceUiUtil.createDeclareStatement(node, input);
            variables.add(declaration.getVariable());
            block.getStatements().add(0, declaration);
        }
        XsdInstanceNode[] children = node.getChildren();
        int ndx = children.length;
        while (--ndx >= 0) {
            WebServiceUiUtil.addVariableStatements(children[ndx], block, input, nodes, variables);
        }
    }

    public static void copyToClipboard(ISelection theSelection) {
        ArrayList<String> objects = new ArrayList<String>(SelectionUtilities.getSelectedObjects((ISelection)theSelection));
        if (!objects.isEmpty()) {
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                objects.set(i, WebServiceUiUtil.getText(objects.get(i)));
            }
            SystemClipboardUtilities.copyToClipboard((ISelection)new StructuredSelection(objects));
        }
    }

    public static DeclareStatement createDeclareStatement(XsdInstanceNode node, Input input) {
        String name = AspectManager.getSqlAspect((EObject)input).getFullName((EObject)input);
        DeclareStatement statement = new DeclareStatement(new ElementSymbol(WebServiceUiUtil.getQualifiedInputVariableName(node.getName())), "string");
        statement.setValue((LanguageObject)new Function("xpathvalue", new Expression[]{new ElementSymbol(name), new Constant((Object)WebServiceUtil.createXPath((XsdInstanceNode)node))}));
        return statement;
    }

    public static String createFileDialogExtension(String theExtension) {
        return FileUtils.Constants.FILE_NAME_WILDCARD + '.' + theExtension;
    }

    public static void ensureVariablesUnique(Map nodesToDeclarations) {
        XsdInstanceNode[] nodes = new XsdInstanceNode[nodesToDeclarations.size()];
        ElementSymbol[] vars = new ElementSymbol[nodes.length];
        Iterator iter = nodesToDeclarations.entrySet().iterator();
        int ndx = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            nodes[ndx] = (XsdInstanceNode)entry.getKey();
            vars[ndx] = ((DeclareStatement)entry.getValue()).getVariable();
            ++ndx;
        }
        WebServiceUiUtil.ensureVariablesUnique(nodes, vars);
    }

    public static void ensureVariablesUnique(XsdInstanceNode[] nodes, ElementSymbol[] variables) {
        int ndx1 = variables.length;
        while (--ndx1 > 0) {
            ElementSymbol var1 = variables[ndx1];
            String name1 = var1.getShortName();
            int ndx2 = ndx1;
            while (--ndx2 >= 0) {
                ElementSymbol var2 = variables[ndx2];
                if (!name1.equalsIgnoreCase(var2.getShortName())) continue;
                XsdInstanceNode node1 = nodes[ndx1];
                XsdInstanceNode node2 = nodes[ndx2];
                if (!WebServiceUiUtil.prefixAncestorNamesUntilUnique(var1, var2, node1.getParent(), node2.getParent())) {
                    WebServiceUiUtil.prefixNamespaceSegmentsUntilUnique(var1, var2, node1.getTargetNamespace(), node2.getTargetNamespace());
                }
                WebServiceUiUtil.ensureVariablesUnique(nodes, variables);
                return;
            }
        }
    }

    public static Image getImage(String theImageName) {
        return WebServiceUiPlugin.getDefault().getImage(theImageName);
    }

    public static ImageDescriptor getImageDescriptor(String theImageName) {
        return WebServiceUiPlugin.getDefault().getImageDescriptor(theImageName);
    }

    public static Operation getOperation(Object object) {
        if (object instanceof SqlTransformationMappingRoot) {
            object = ((SqlTransformationMappingRoot)object).getTarget();
        } else if (object instanceof Diagram) {
            object = ((Diagram)object).getTarget();
        }
        if (object instanceof Interface) {
            EList ops = ((Interface)object).getOperations();
            return ops.isEmpty() ? null : (Operation)ops.get(0);
        }
        if (object instanceof EObject) {
            for (EObject eObj = (EObject)object; eObj != null; eObj = eObj.eContainer()) {
                if (eObj instanceof Operation) {
                    return (Operation)eObj;
                }
                if (!(object instanceof ModelAnnotation)) continue;
                ModelAnnotation annot = (ModelAnnotation)object;
                EList eObjs = annot.eResource().getContents();
                Iterator iter = eObjs.iterator();
                while (iter.hasNext()) {
                    Object nextObj = iter.next();
                    if (!(nextObj instanceof Interface)) continue;
                    EList ops = ((Interface)nextObj).getOperations();
                    return ops.isEmpty() ? null : (Operation)ops.get(0);
                }
            }
        }
        return null;
    }

    private static String getQualifiedInputVariableName(String name) {
        return "VARIABLES.IN_" + name;
    }

    public static Image getSharedImage(String theImageName) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(theImageName);
    }

    public static ImageDescriptor getSharedImageDescriptor(String theImageName) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(theImageName);
    }

    public static Image getStatusImage(IStatus theStatus) {
        Image result = null;
        switch (theStatus.getSeverity()) {
            case 4: {
                result = WebServiceUiUtil.getSharedImage("IMG_OBJS_ERROR_TSK");
                break;
            }
            case 2: {
                result = WebServiceUiUtil.getSharedImage("IMG_OBJS_WARN_TSK");
                break;
            }
            case 1: {
                result = WebServiceUiUtil.getSharedImage("IMG_OBJS_INFO_TSK");
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static String getString(String theKey) {
        return IInternalUiConstants.UTIL.getString(PREFIX + theKey);
    }

    public static String getText(Object theObject) {
        String result = "";
        if (theObject != null) {
            if (theObject instanceof IWebServiceResource) {
                IWebServiceResource resource = (IWebServiceResource)theObject;
                result = WebServiceUiUtil.getString("property.namespace") + '=' + resource.getNamespace() + ", " + WebServiceUiUtil.getString("property.resolvedPath") + '=' + resource.getFullPath();
            } else {
                result = theObject instanceof IFile ? ((IFile)theObject).getFullPath().toOSString() : (theObject instanceof FileUrl ? ((FileUrl)theObject).getOriginalUrlString() : (theObject instanceof File ? theObject.toString() : theObject.toString()));
            }
        }
        return result;
    }

    public static void initializeProcedure(Operation operation, Object transactionSource, boolean replace) {
        XmlDocument doc;
        Output output;
        XSDElementDeclaration elem;
        Input input;
        SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)operation);
        CreateUpdateProcedureCommand proc = null;
        if (!TransformationHelper.isEmptySelect((Object)root)) {
            proc = (CreateUpdateProcedureCommand)TransformationHelper.getCommand((Object)root, (int)0);
        }
        boolean initVar = true;
        boolean initSelect = true;
        if (proc == null) {
            String sqlString = TransformationHelper.getSelectSqlString((Object)root);
            if (sqlString != null && sqlString.length() > 0) {
                initVar = false;
                initSelect = false;
            } else {
                proc = new CreateUpdateProcedureCommand(new Block());
                proc.setUpdateProcedure(false);
            }
        } else {
            Block block = proc.getBlock();
            if (block == null) {
                proc.setBlock(new Block());
            } else {
                Iterator statementIter = block.getStatements().iterator();
                while (statementIter.hasNext()) {
                    Object statement = statementIter.next();
                    if (statement instanceof DeclareStatement) {
                        if (replace && ((DeclareStatement)statement).getVariable().getName().startsWith("VARIABLES.IN_")) {
                            statementIter.remove();
                            continue;
                        }
                        initVar = false;
                        continue;
                    }
                    if (statement instanceof AssignmentStatement) {
                        if (replace && ((AssignmentStatement)statement).getVariable().getName().startsWith("VARIABLES.IN_")) {
                            statementIter.remove();
                            continue;
                        }
                        initVar = false;
                        continue;
                    }
                    if (replace) {
                        statementIter.remove();
                        continue;
                    }
                    initSelect = false;
                }
            }
        }
        if (initVar && (input = operation.getInput()) != null && (elem = input.getContentElement()) != null) {
            ArrayList nodes = new ArrayList();
            ArrayList vars = new ArrayList();
            WebServiceUiUtil.addVariableStatements(new XsdInstanceNode(elem), proc.getBlock(), input, nodes, vars);
            WebServiceUiUtil.ensureVariablesUnique(nodes.toArray(new XsdInstanceNode[nodes.size()]), vars.toArray(new ElementSymbol[vars.size()]));
        }
        if (initSelect && (output = operation.getOutput()) != null && (doc = output.getXmlDocument()) != null) {
            proc.getBlock().addStatement((Statement)new CommandStatement((Command)TransformationSqlHelper.createDefaultQuery((EObject)doc)));
        }
        if (initVar || initSelect) {
            TransformationHelper.setSelectSqlString((Object)root, (String)proc.toString(), (boolean)true, (Object)transactionSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addXmlDocumentAsSource(SqlTransformationMappingRoot transformation, XmlDocument xmlDocument, Object txnSource) {
        EObject target = transformation.getTarget();
        if (!(target instanceof Operation)) {
            return;
        }
        Operation operation = (Operation)target;
        if (xmlDocument != null && operation.getOutput() != null) {
            boolean requiredStart = false;
            boolean succeeded = false;
            try {
                requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Output Property Values", (Object)txnSource);
                if (xmlDocument != null) {
                    if (operation.getOutput().getXmlDocument() == null) {
                        operation.getOutput().setXmlDocument(xmlDocument);
                    } else if (operation.getOutput().getXmlDocument() != xmlDocument) {
                        operation.getOutput().setXmlDocument(xmlDocument);
                    }
                    XSDElementDeclaration xsdElementDec = (XSDElementDeclaration)xmlDocument.getRoot().getXsdComponent();
                    if (xsdElementDec != null && (operation.getOutput().getContentElement() == null || operation.getOutput().getContentElement() != xsdElementDec)) {
                        operation.getOutput().setContentElement(xsdElementDec);
                    }
                }
                succeeded = true;
            }
            catch (Exception ex) {
                IInternalUiConstants.UTIL.log(4, (Throwable)ex, ex.getClass().getName() + ":" + THIS_CLASS + ".addXmlDocumentAsSource()");
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void clearXmlDocumentAsSource(SqlTransformationMappingRoot transformation, boolean forceClearContentViaElement, Object txnSource) {
        TransformationHelper.clearXmlDocumentAsSource((SqlTransformationMappingRoot)transformation, (boolean)forceClearContentViaElement, (Object)txnSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setXmlDocumentAsSource(SqlTransformationMappingRoot transformation, XmlDocument xmlDocument, Object txnSource) {
        EObject target = transformation.getTarget();
        if (!(target instanceof Operation)) {
            return;
        }
        Operation operation = (Operation)target;
        if (xmlDocument != null && operation.getOutput() != null) {
            boolean requiredStart = false;
            boolean succeeded = false;
            try {
                requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Operation Output Xml Document", (Object)txnSource);
                if (xmlDocument != null) {
                    operation.getOutput().setXmlDocument(xmlDocument);
                }
                succeeded = true;
            }
            catch (Exception ex) {
                IInternalUiConstants.UTIL.log(4, (Throwable)ex, ex.getClass().getName() + ":" + THIS_CLASS + ".addXmlDocumentAsSource()");
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static boolean isWsdlFile(File theFile) {
        return WebServicePlugin.isWsdlFile((File)theFile);
    }

    public static boolean isWsdlFile(IFile theFile) {
        return WebServicePlugin.isWsdlFile((IFile)theFile);
    }

    public static boolean isXsdFile(File theFile) {
        return ModelUtil.isXsdFile((File)theFile);
    }

    public static boolean isXsdFile(IFile theFile) {
        return ModelUtil.isXsdFile((IResource)theFile);
    }

    private static boolean prefixAncestorNamesUntilUnique(ElementSymbol var1, ElementSymbol var2, XsdInstanceNode node1, XsdInstanceNode node2) {
        String name1 = var1.getShortName();
        if (node1 != null) {
            name1 = node1.getName() + '_' + name1;
            var1.setName(WebServiceUiUtil.getQualifiedInputVariableName(name1));
            node1 = node1.getParent();
        }
        String name2 = var2.getShortName();
        if (node2 != null) {
            name2 = node2.getName() + '_' + name2;
            var2.setName(WebServiceUiUtil.getQualifiedInputVariableName(name2));
            node2 = node2.getParent();
        }
        if (!name1.equalsIgnoreCase(name2)) {
            return true;
        }
        if (node1 != null || node2 != null) {
            return WebServiceUiUtil.prefixAncestorNamesUntilUnique(var1, var2, node1, node2);
        }
        return false;
    }

    private static void prefixNamespaceSegmentsUntilUnique(ElementSymbol var1, ElementSymbol var2, String namespace1, String namespace2) {
        String name1 = var1.getShortName();
        if (namespace1 != null) {
            int ndx = namespace1.lastIndexOf(46);
            name1 = namespace1.substring(ndx + 1) + '_' + name1;
            var1.setName(WebServiceUiUtil.getQualifiedInputVariableName(name1));
            namespace1 = ndx >= 0 ? namespace1.substring(0, ndx) : null;
        }
        String name2 = var2.getShortName();
        if (namespace2 != null) {
            int ndx = namespace2.lastIndexOf(46);
            name2 = namespace2.substring(ndx + 1) + '_' + name2;
            var2.setName(WebServiceUiUtil.getQualifiedInputVariableName(name2));
            String string = namespace2 = ndx >= 0 ? namespace2.substring(0, ndx) : null;
        }
        if (!name1.equalsIgnoreCase(name2)) {
            return;
        }
        WebServiceUiUtil.prefixNamespaceSegmentsUntilUnique(var1, var2, namespace1, namespace2);
    }

    public static void viewFile(Shell theShell, ISelection theSelection) {
        boolean result = false;
        Object file = "null";
        if (theSelection != null && !theSelection.isEmpty() && (file = SelectionUtilities.getSelectedObject((ISelection)theSelection)) != null) {
            if (file instanceof IFile) {
                result = UiUtil.openSystemEditor((IFile)((IFile)file));
            } else if (file instanceof File) {
                result = UiUtil.openSystemEditor((File)((File)file));
            } else if (file instanceof IWebServiceResource) {
                WebServiceUiUtil.viewFile(theShell, (ISelection)new StructuredSelection((Object)((IWebServiceResource)file).getFile()));
            }
        }
        if (!result) {
            String txt = file instanceof IFile ? ((IFile)file).getFullPath().toString() : file.toString();
            MessageDialog.openError((Shell)theShell, (String)IInternalUiConstants.UTIL.getString(PREFIX + "dialog.viewFile.title", new Object[]{txt}), (String)WebServiceUiUtil.getString("dialog.viewFile.msg"));
        }
    }

    private WebServiceUiUtil() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$webservice$ui$util$WebServiceUiUtil == null ? (class$com$metamatrix$modeler$webservice$ui$util$WebServiceUiUtil = WebServiceUiUtil.class$("com.metamatrix.modeler.webservice.ui.util.WebServiceUiUtil")) : class$com$metamatrix$modeler$webservice$ui$util$WebServiceUiUtil));
        FILE_DIALOG_WSDL_EXTENSIONS = new String[WebServicePlugin.WSDL_FILE_EXTENSIONS.length];
        for (int i = 0; i < WebServicePlugin.WSDL_FILE_EXTENSIONS.length; ++i) {
            WebServiceUiUtil.FILE_DIALOG_WSDL_EXTENSIONS[i] = WebServiceUiUtil.createFileDialogExtension(WebServicePlugin.WSDL_FILE_EXTENSIONS[i]);
        }
        FILE_DIALOG_XSD_EXTENSIONS = new String[]{WebServiceUiUtil.createFileDialogExtension("xsd")};
    }
}

