/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class EvaluatableVisitor
extends LanguageVisitor {
    protected boolean evaluationPossible = true;
    private boolean duringPlanning = false;
    private boolean fullyEvaluatable = false;
    private boolean deterministic = false;
    private static Set PROC_VAR_GROUPS = new HashSet<String>(Arrays.asList("VARIABLES", "INPUT", "CHANGING"));

    public EvaluatableVisitor(boolean duringPlanning, boolean fullyEvaluatable) {
        this.duringPlanning = duringPlanning;
        this.fullyEvaluatable = fullyEvaluatable;
    }

    public void visit(Function obj) {
        if (obj.getFunctionDescriptor().getPushdown() == 2) {
            this.evaluationNotPossible();
        } else if (this.duringPlanning) {
            if (obj.getName().equalsIgnoreCase("lookup")) {
                this.evaluationNotPossible();
            } else if (obj.getFunctionDescriptor().getDeterministic() >= 3) {
                this.evaluationNotPossible();
            }
        } else if (this.deterministic && obj.getFunctionDescriptor().getDeterministic() == 4) {
            this.evaluationNotPossible();
        }
    }

    private boolean evaluationNotPossible() {
        this.evaluationPossible = false;
        this.setAbort(true);
        return this.evaluationPossible;
    }

    public void visit(ElementSymbol obj) {
        if (this.duringPlanning || this.fullyEvaluatable || !PROC_VAR_GROUPS.contains(obj.getGroupSymbol().getCanonicalName())) {
            this.evaluationNotPossible();
        }
    }

    public void visit(ExpressionSymbol obj) {
        this.evaluationNotPossible();
    }

    public void visit(AggregateSymbol obj) {
        this.evaluationNotPossible();
    }

    public void visit(Reference obj) {
        if (this.duringPlanning) {
            this.evaluationNotPossible();
        } else if (this.fullyEvaluatable) {
            if (obj.getExpression() instanceof ElementSymbol) {
                if (obj.getTuple() == null) {
                    this.evaluationNotPossible();
                }
            } else if (obj.getExpression() != null) {
                obj.getExpression().acceptVisitor((LanguageVisitor)this);
            }
        } else if (obj.isCorrelated()) {
            this.evaluationNotPossible();
        }
    }

    public void visit(StoredProcedure proc) {
        this.evaluationNotPossible();
    }

    public void visit(ScalarSubquery obj) {
        this.evaluationNotPossible();
    }

    public void visit(DependentSetCriteria obj) {
        this.evaluationNotPossible();
    }

    public void visit(ExistsCriteria obj) {
        this.evaluationNotPossible();
    }

    public void visit(SubquerySetCriteria obj) {
        this.evaluationNotPossible();
    }

    public void visit(SubqueryCompareCriteria obj) {
        this.evaluationNotPossible();
    }

    public boolean isEvaluationPossible() {
        return this.evaluationPossible;
    }

    static final boolean isEvaluatable(LanguageObject obj, boolean duringPlanning, boolean fullyEvaluatable, boolean deterministic) {
        EvaluatableVisitor visitor = new EvaluatableVisitor(duringPlanning, fullyEvaluatable);
        visitor.deterministic = deterministic;
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        return visitor.isEvaluationPossible();
    }
}

