/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.query.processor.xml.Condition;
import com.metamatrix.query.processor.xml.DefaultCondition;
import com.metamatrix.query.processor.xml.ProcessorEnvironment;
import com.metamatrix.query.processor.xml.ProcessorInstruction;
import com.metamatrix.query.processor.xml.Program;
import com.metamatrix.query.processor.xml.RecurseProgramCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IfInstruction
extends ProcessorInstruction {
    private List thenBlocks = new ArrayList();
    private DefaultCondition defaultCondition;
    private boolean blockedOnCondition = false;
    private int blockedConditionIndex = 0;

    public void addCondition(Condition condition) {
        this.thenBlocks.add(condition);
    }

    public void setDefaultCondition(DefaultCondition defaultCondition) {
        this.defaultCondition = defaultCondition;
    }

    int getThenCount() {
        return this.thenBlocks.size();
    }

    Condition getThenCondition(int thenCount) {
        if (thenCount >= 0 && thenCount < this.thenBlocks.size()) {
            return (Condition)this.thenBlocks.get(thenCount);
        }
        return null;
    }

    Program getThenProgram(int thenCount) {
        if (thenCount >= 0 && thenCount < this.thenBlocks.size()) {
            Condition condition = (Condition)this.thenBlocks.get(thenCount);
            return condition.getThenProgram();
        }
        return null;
    }

    Program getElseProgram() {
        return this.defaultCondition.getThenProgram();
    }

    public void process(ProcessorEnvironment env) throws BlockedException, MetaMatrixComponentException {
        ArrayList<DefaultCondition> thens = this.thenBlocks;
        if (this.defaultCondition != null) {
            thens = new ArrayList<DefaultCondition>(this.thenBlocks);
            thens.add(this.defaultCondition);
        }
        int conditionIndex = this.blockedConditionIndex;
        if (this.blockedOnCondition) {
            this.blockedOnCondition = false;
            this.blockedConditionIndex = 0;
        } else {
            conditionIndex = 0;
        }
        Condition condition = null;
        boolean foundTrueCondition = false;
        while (conditionIndex < thens.size()) {
            condition = (Condition)thens.get(conditionIndex);
            try {
                if (condition.evaluate(env)) {
                    foundTrueCondition = true;
                    break;
                }
            }
            catch (BlockedException e) {
                this.blockedOnCondition = true;
                this.blockedConditionIndex = conditionIndex;
                throw e;
            }
            ++conditionIndex;
        }
        env.incrementCurrentProgramCounter();
        if (foundTrueCondition) {
            Program thenProgram = condition.getThenProgram();
            env.pushProgram(thenProgram, condition.isProgramRecursive());
            LogManager.logTrace("XML_PLAN", new Object[]{"IF: true condition", condition, "- then program:", thenProgram});
        }
    }

    public String toString() {
        return "IF BLOCK:";
    }

    public Map getDescriptionProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("type", "CHOICE");
        ArrayList<String> conditions = new ArrayList<String>(this.thenBlocks.size());
        ArrayList<Map> programs = new ArrayList<Map>(this.thenBlocks.size());
        Iterator iter = this.thenBlocks.iterator();
        while (iter.hasNext()) {
            Condition condition = (Condition)iter.next();
            conditions.add(condition.toString());
            if (condition instanceof RecurseProgramCondition) {
                programs.add(new HashMap());
                continue;
            }
            programs.add(condition.getThenProgram().getDescriptionProperties());
        }
        props.put("conditions", conditions);
        props.put("programs", programs);
        if (this.defaultCondition.getThenProgram() != null) {
            props.put("defaultProgram", this.defaultCondition.getThenProgram().getDescriptionProperties());
        }
        return props;
    }
}

