/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function.metadata;

import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.function.metadata.FunctionParameter;
import java.io.Serializable;

public class FunctionMethod
implements Serializable {
    public static final int CAN_PUSHDOWN = 0;
    public static final int CANNOT_PUSHDOWN = 1;
    public static final int MUST_PUSHDOWN = 2;
    public static final int DETERMINISTIC = 0;
    public static final int SERVER_DETERMINISTIC = 1;
    public static final int SESSION_DETERMINISTIC = 2;
    public static final int COMMAND_DETERMINISTIC = 3;
    public static final int NONDETERMINISTIC = 4;
    private String name;
    private String description;
    private String category;
    private int pushdown = 0;
    private String invocationClass;
    private String invocationMethod;
    private boolean nullDependent;
    private int deterministic = 0;
    private FunctionParameter[] inputParameters;
    private FunctionParameter outputParameter;

    public FunctionMethod() {
    }

    public FunctionMethod(String name, String description, String category, String invocationClass, String invocationMethod, FunctionParameter[] inputParams, FunctionParameter outputParam) {
        this(name, description, category, invocationClass, invocationMethod, inputParams, outputParam, 0);
    }

    public FunctionMethod(String name, String description, String category, String invocationClass, String invocationMethod, FunctionParameter[] inputParams, FunctionParameter outputParam, int deterministic) {
        this(name, description, category, 0, invocationClass, invocationMethod, inputParams, outputParam, false, deterministic);
    }

    public FunctionMethod(String name, String description, String category, int pushdown, String invocationClass, String invocationMethod, FunctionParameter[] inputParams, FunctionParameter outputParam) {
        this(name, description, category, pushdown, invocationClass, invocationMethod, inputParams, outputParam, true, 4);
    }

    public FunctionMethod(String name, String description, String category, int pushdown, String invocationClass, String invocationMethod, FunctionParameter[] inputParams, FunctionParameter outputParam, boolean nullDependent, int deterministic) {
        this.setName(name);
        this.setDescription(description);
        this.setCategory(category);
        this.setPushdown(pushdown);
        this.setInvocationClass(invocationClass);
        this.setInvocationMethod(invocationMethod);
        this.setInputParameters(inputParams);
        this.setOutputParameter(outputParam);
        this.setNullDependent(nullDependent);
        this.setDeterministic(deterministic);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public int getPushdown() {
        return this.pushdown;
    }

    public void setPushdown(int pushdown) {
        this.pushdown = pushdown;
    }

    public String getInvocationClass() {
        return this.invocationClass;
    }

    public void setInvocationClass(String invocationClass) {
        this.invocationClass = invocationClass;
    }

    public String getInvocationMethod() {
        return this.invocationMethod;
    }

    public void setInvocationMethod(String invocationMethod) {
        this.invocationMethod = invocationMethod;
    }

    public int getInputParameterCount() {
        if (this.inputParameters == null) {
            return 0;
        }
        return this.inputParameters.length;
    }

    public FunctionParameter[] getInputParameters() {
        return this.inputParameters;
    }

    public void setInputParameters(FunctionParameter[] params) {
        this.inputParameters = params;
    }

    public FunctionParameter getOutputParameter() {
        return this.outputParameter;
    }

    public void setOutputParameter(FunctionParameter param) {
        this.outputParameter = param;
    }

    public int hashCode() {
        int hash = HashCodeUtil.hashCode((int)0, (Object)this.name);
        if (this.inputParameters != null) {
            hash = HashCodeUtil.hashCode((int)hash, (int)this.inputParameters.length);
            if (this.inputParameters.length > 0 && this.inputParameters[0] != null) {
                hash = HashCodeUtil.hashCode((int)hash, (Object)this.inputParameters[0].getType());
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof FunctionMethod) {
            FunctionMethod other = (FunctionMethod)obj;
            if (this.getInputParameterCount() != other.getInputParameterCount()) {
                return false;
            }
            if (other.getName() == null || this.getName() == null) {
                return false;
            }
            if (!other.getName().equalsIgnoreCase(this.getName())) {
                return false;
            }
            FunctionParameter[] thisInputs = this.getInputParameters();
            if (thisInputs != null && thisInputs.length > 0) {
                FunctionParameter[] otherInputs = other.getInputParameters();
                for (int i = 0; i < thisInputs.length; ++i) {
                    boolean paramMatch = this.compareWithNull(thisInputs[i], otherInputs[i]);
                    if (paramMatch) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean compareWithNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.name != null) {
            str.append(this.name);
        } else {
            str.append("<unknown>");
        }
        str.append("(");
        if (this.inputParameters != null) {
            for (int i = 0; i < this.inputParameters.length; ++i) {
                if (this.inputParameters[i] != null) {
                    str.append(this.inputParameters[i].toString());
                } else {
                    str.append("<unknown>");
                }
                if (i >= this.inputParameters.length - 1) continue;
                str.append(", ");
            }
        }
        str.append(") : ");
        if (this.outputParameter != null) {
            str.append(this.outputParameter.toString());
        } else {
            str.append("<unknown>");
        }
        return str.toString();
    }

    public boolean isNullDependent() {
        return this.nullDependent;
    }

    public void setNullDependent(boolean nullSafe) {
        this.nullDependent = nullSafe;
    }

    public int getDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(int deterministic) {
        this.deterministic = deterministic;
    }
}

