/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.sql.lang.BatchedUpdateCommand;
import com.metamatrix.query.sql.lang.BulkInsert;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ProjectIntoNode
extends RelationalNode {
    private static int REQUEST_CREATION = 1;
    private static int RESPONSE_PROCESSING = 2;
    private GroupSymbol intoGroup;
    private List intoElements;
    private String modelName;
    private boolean doBatching = false;
    private boolean doBulkInsert = false;
    private int batchRow = 1;
    private int insertCount = 0;
    private int phase = REQUEST_CREATION;
    private int requestsRegistered = 0;
    private int tupleSourcesProcessed = 0;
    private MetaMatrixComponentException exception;
    private TupleBatch currentBatch;

    public ProjectIntoNode(int nodeID) {
        super(nodeID);
    }

    public void reset() {
        super.reset();
        this.phase = REQUEST_CREATION;
        this.batchRow = 1;
        this.insertCount = 0;
        this.tupleSourcesProcessed = 0;
        this.requestsRegistered = 0;
        this.exception = null;
        this.currentBatch = null;
    }

    public void setIntoGroup(GroupSymbol group) {
        this.intoGroup = group;
    }

    public void setIntoElements(List intoElements) {
        this.intoElements = intoElements;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        while (this.phase == REQUEST_CREATION) {
            List<List> rows;
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.currentBatch == null || !this.currentBatch.getTerminationFlag() && this.batchRow > this.currentBatch.getEndRow()) {
                this.currentBatch = this.getChildren()[0].nextBatch();
                this.batchRow = this.currentBatch.getBeginRow();
                if (this.currentBatch.getRowCount() == 0 && !this.intoGroup.isImplicitTempGroupSymbol()) {
                    continue;
                }
            } else if (this.currentBatch.getTerminationFlag() && this.batchRow > this.currentBatch.getEndRow()) {
                this.phase = RESPONSE_PROCESSING;
                break;
            }
            if (this.tupleSourcesProcessed < this.requestsRegistered) {
                throw BlockedException.INSTANCE;
            }
            int batchSize = this.currentBatch.getRowCount();
            if (this.doBulkInsert) {
                BulkInsert insert = new BulkInsert(this.intoGroup, this.intoElements);
                rows = Arrays.asList(this.currentBatch.getAllTuples());
                insert.setRows(rows);
                this.registerRequest((Command)insert);
            } else if (this.doBatching) {
                int endRow = this.currentBatch.getEndRow();
                rows = new ArrayList<List>(endRow - this.batchRow);
                for (int rowNum = this.batchRow; rowNum <= endRow; ++rowNum) {
                    Insert insert = new Insert(this.intoGroup, this.intoElements, this.convertValuesToConstants(this.currentBatch.getTuple(rowNum), this.intoElements));
                    rows.add((List)((Object)insert));
                }
                this.registerRequest((Command)new BatchedUpdateCommand(rows));
            } else {
                batchSize = 1;
                this.registerRequest(new Insert(this.intoGroup, this.intoElements, this.convertValuesToConstants(this.currentBatch.getTuple(this.batchRow), this.intoElements)));
            }
            this.batchRow += batchSize;
            ++this.requestsRegistered;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.tupleSourcesProcessed < this.requestsRegistered) {
            throw BlockedException.INSTANCE;
        }
        ArrayList<Integer> outputRow = new ArrayList<Integer>(1);
        outputRow.add(new Integer(this.insertCount));
        this.addBatchRow(outputRow);
        this.terminateBatches();
        return this.pullBatch();
    }

    private void registerRequest(Command command) throws MetaMatrixComponentException {
        this.getDataManager().registerRequest(this.getContext().getProcessorID(), command, this.modelName, this.getID());
    }

    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.intoGroup);
    }

    public Object clone() {
        ProjectIntoNode clonedNode = new ProjectIntoNode(super.getID());
        super.copy((RelationalNode)this, (RelationalNode)clonedNode);
        clonedNode.intoGroup = (GroupSymbol)this.intoGroup.clone();
        clonedNode.intoElements = new ArrayList(this.intoElements);
        clonedNode.modelName = this.modelName;
        clonedNode.doBatching = this.doBatching;
        clonedNode.doBulkInsert = this.doBulkInsert;
        return clonedNode;
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Project Into");
        props.put("intoGrp", this.intoGroup.toString());
        ArrayList<String> selectCols = new ArrayList<String>(this.intoElements.size());
        for (int i = 0; i < this.intoElements.size(); ++i) {
            selectCols.add(this.intoElements.get(i).toString());
        }
        props.put("selectCols", selectCols);
        return props;
    }

    private List convertValuesToConstants(List values, List elements) {
        ArrayList<Constant> constants = new ArrayList<Constant>(values.size());
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol es = (ElementSymbol)elements.get(i);
            Class type = es.getType();
            constants.add(new Constant(values.get(i), type));
        }
        return constants;
    }

    protected void setTupleSource(TupleSource tupleSource, int nodeID) {
        try {
            tupleSource.openSource();
            Integer count = (Integer)tupleSource.nextTuple().get(0);
            this.insertCount += count.intValue();
            tupleSource.closeSource();
            ++this.tupleSourcesProcessed;
        }
        catch (BlockedException e) {
            this.exception = new MetaMatrixComponentException((Throwable)e);
        }
        catch (MetaMatrixComponentException e) {
            this.exception = e;
        }
    }

    public void setDoBatching(boolean doBatching) {
        this.doBatching = doBatching;
    }

    public void setDoBulkInsert(boolean doBulkInsert) {
        this.doBulkInsert = doBulkInsert;
    }

    public boolean isTempGroupInsert() {
        return this.intoGroup.isTempGroupSymbol();
    }
}

