/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relate.xml;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.IndexedTupleSource;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relate.xml.DocumentInProgress;
import com.metamatrix.query.processor.relate.xml.ProcessorEnvironment;
import com.metamatrix.query.processor.relate.xml.ProcessorInstruction;
import com.metamatrix.query.processor.relate.xml.Program;
import com.metamatrix.query.processor.relate.xml.XMLPlan;
import com.metamatrix.query.processor.relational.DependentValueSource;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractProcessorEnvironment
implements ProcessorEnvironment {
    private XMLPlan plan;
    private Map resultSetStates = new HashMap();
    private TupleSourceMap tupleSourceMap = new TupleSourceMap();
    private Map dependentValueSources = new HashMap();
    private LinkedList tupleSourceRecursionStack = new LinkedList();
    private LinkedList programStack = new LinkedList();
    private DocumentInProgress documentInProgress;
    private Collection stagingTableGroupsSymbols;
    private Map rowLimits = new HashMap();
    private String xmlFormat;
    private String xmlResultsForm;
    private GroupSymbol documentGroup;

    protected AbstractProcessorEnvironment() {
    }

    ResultSetState getResultSetState(String resultSetName) {
        String resultSetKey = resultSetName.toUpperCase();
        ResultSetState state = (ResultSetState)this.resultSetStates.get(resultSetKey);
        return state;
    }

    public void initialize(XMLPlan plan) {
        this.plan = plan;
    }

    public void reset(Program initialProgram) {
        this.programStack = new LinkedList();
        ProgramState programState = new ProgramState();
        programState.program = initialProgram;
        this.programStack.addFirst(programState);
        this.resetResultSetStates();
        this.tupleSourceMap = new TupleSourceMap();
        this.tupleSourceRecursionStack = new LinkedList();
        this.documentInProgress = null;
    }

    private void resetResultSetStates() {
        Iterator entries = this.resultSetStates.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            ResultSetState state = (ResultSetState)entry.getValue();
            if (state.maskedState == null) continue;
            while (state.maskedState != null) {
                state = state.maskedState;
            }
            entry.setValue(state);
        }
    }

    protected XMLPlan getPlan() {
        return this.plan;
    }

    public void registerResultSet(String resultSetName, Object command, List referencesBoundToResultSet, List replacementExpressions) throws MetaMatrixComponentException {
        String resultSetKey = resultSetName.toUpperCase();
        ResultSetState state = new ResultSetState();
        state.resultSetName = resultSetKey;
        state.resultSetObject = command;
        state.references = referencesBoundToResultSet;
        state.replacementExpressions = replacementExpressions;
        ResultSetState maskedState = (ResultSetState)this.resultSetStates.get(resultSetKey);
        if (maskedState != null) {
            state.maskedState = maskedState;
        }
        this.resultSetStates.put(resultSetKey, state);
    }

    public void deregisterResultSet(String resultSetName) {
        String resultSetKey = resultSetName.toUpperCase();
        ResultSetState state = (ResultSetState)this.resultSetStates.remove(resultSetKey);
        if (state.maskedState != null) {
            this.resultSetStates.put(resultSetKey, state.maskedState);
            List currentRow = this.tupleSourceMap.getCurrentRow(resultSetKey);
            Map elementMap = this.tupleSourceMap.getElementMap(resultSetKey);
            state.maskedState.refreshReferences(currentRow, elementMap);
        }
    }

    public void cacheTupleSources() {
        this.tupleSourceRecursionStack.addFirst(this.tupleSourceMap);
        this.tupleSourceMap = new TupleSourceMap();
        LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"Processor Environment cached results, " + this.tupleSourceRecursionStack.size() + " cached."});
    }

    public void uncacheTupleSources() {
        this.tupleSourceMap = (TupleSourceMap)this.tupleSourceRecursionStack.removeFirst();
        LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"Processor Environment uncached results, " + this.tupleSourceRecursionStack.size() + " cached."});
    }

    public abstract void loadResultSet(String var1) throws MetaMatrixComponentException;

    public Program getCurrentProgram() {
        if (this.programStack.size() > 0) {
            ProgramState programState = (ProgramState)this.programStack.getFirst();
            return programState.program;
        }
        return null;
    }

    public boolean isRecursiveProgramInStack() {
        Iterator stackedPrograms = this.programStack.iterator();
        ProgramState programState = (ProgramState)stackedPrograms.next();
        while (programState.recursionCount == 0 && stackedPrograms.hasNext()) {
            programState = (ProgramState)stackedPrograms.next();
        }
        return programState.recursionCount > 0;
    }

    public void incrementCurrentProgramCounter() {
        ProgramState programState = (ProgramState)this.programStack.getFirst();
        programState.programCounter++;
        while (this.programStack.size() > 1 && programState.programCounter >= programState.program.getProcessorInstructions().size()) {
            this.programStack.removeFirst();
            if (LogManager.isMessageToBeRecorded((String)"XML_PLAN", (int)6)) {
                LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"Processor Environment popped program w/ recursion count " + programState.recursionCount, "; " + this.programStack.size(), " programs left."});
            }
            programState = (ProgramState)this.programStack.getFirst();
        }
    }

    public void pushProgram(Program program) {
        this.pushProgram(program, false);
    }

    public void pushProgram(Program program, boolean isRecursive) {
        ProgramState programState = new ProgramState();
        programState.program = program;
        if (isRecursive) {
            ProgramState previousState = this.getProgramState(program);
            if (previousState != null) {
                programState.recursionCount = previousState.recursionCount + 1;
            } else {
                programState.recursionCount = 1;
            }
            LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"Pushed recursive program w/ recursion count " + programState.recursionCount});
        } else {
            LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"Pushed non-recursive program w/ recursion count " + programState.recursionCount});
        }
        this.programStack.addFirst(programState);
    }

    public ProcessorInstruction getCurrentInstruction() {
        ProgramState programState = (ProgramState)this.programStack.getFirst();
        if (programState != null && programState.program.getProcessorInstructions().isEmpty()) {
            this.incrementCurrentProgramCounter();
            programState = (ProgramState)this.programStack.getFirst();
        }
        if (programState == null) {
            return null;
        }
        return programState.program.getInstructionAt(programState.programCounter);
    }

    public int getProgramRecursionCount(Program program) {
        ProgramState programState = this.getProgramState(program);
        if (programState == null) {
            return 0;
        }
        return programState.recursionCount;
    }

    private ProgramState getProgramState(Program program) {
        ProgramState result = null;
        Iterator stackedPrograms = this.programStack.iterator();
        while (stackedPrograms.hasNext()) {
            ProgramState programState = (ProgramState)stackedPrograms.next();
            Program stackedProgram = programState.program;
            if (stackedProgram != program) continue;
            result = programState;
            break;
        }
        return result;
    }

    public void deliverResults(String resultSetName, TupleSourceID tsID, TupleSource source, IndexedTupleSource its) throws MetaMatrixComponentException {
        source.openSource();
        String resultSetKey = resultSetName.toUpperCase();
        TupleSourceState tss = this.tupleSourceMap.getTupleSourceState(resultSetKey);
        tss.tupleSource = source;
        tss.tupleSourceID = tsID;
        DependentValueSource dvs = (DependentValueSource)this.dependentValueSources.get(resultSetKey);
        if (dvs != null) {
            dvs.setTupleSource(its, tss.tupleSourceID);
        }
    }

    public void setDependentValueSource(String resultSetKey, DependentValueSource dvs) {
        this.dependentValueSources.put(resultSetKey, dvs);
    }

    public List getCurrentRow(String resultSetName) {
        return this.tupleSourceMap.getCurrentRow(resultSetName);
    }

    public boolean iterateCursor(String resultSetName) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        String resultSetKey = resultSetName.toUpperCase();
        this.tupleSourceMap.incrementCurrentRow(resultSetKey);
        List row = this.tupleSourceMap.getCurrentRow(resultSetKey);
        ResultSetState state = (ResultSetState)this.resultSetStates.get(resultSetKey);
        if (row != null) {
            if (state.references != null) {
                boolean useMaskedTupleSource = false;
                Map elementMap = this.getElementMap(resultSetName, useMaskedTupleSource);
                this.tupleSourceMap.setElementMap(resultSetKey, elementMap);
                state.refreshReferences(row, elementMap);
            }
            return true;
        }
        return false;
    }

    public void closeResultSet(String resultSetName) throws MetaMatrixComponentException {
        String resultSetKey = resultSetName.toUpperCase();
        TupleSource source = this.tupleSourceMap.getTupleSource(resultSetKey);
        if (source != null) {
            source.closeSource();
            TupleSourceID tsID = this.tupleSourceMap.getTupleSourceID(resultSetKey);
            if (tsID != null) {
                this.plan.removeTupleSource(resultSetKey, tsID);
            }
            this.tupleSourceMap.removeResultSet(resultSetKey);
        }
    }

    public Map getElementMap(String resultSetName) throws MetaMatrixComponentException {
        return this.getElementMap(resultSetName, true);
    }

    private Map getElementMap(String resultSetName, boolean useMaskedTupleSource) throws MetaMatrixComponentException {
        TupleSource source;
        HashMap elementMap = new HashMap();
        String resultSetKey = resultSetName.toUpperCase();
        TupleSourceMap temp = this.tupleSourceMap;
        if (useMaskedTupleSource && !this.tupleSourceRecursionStack.isEmpty()) {
            temp = (TupleSourceMap)this.tupleSourceRecursionStack.getLast();
        }
        if ((source = temp.getTupleSource(resultSetKey)) == null) {
            throw new MetaMatrixComponentException(QueryExecPlugin.Util.getString("ERR.015.006.0037", (Object)resultSetName));
        }
        List schema = source.getSchema();
        if (schema == null) {
            throw new MetaMatrixComponentException(QueryExecPlugin.Util.getString("ERR.015.006.0038"));
        }
        for (int index = 0; index < schema.size(); ++index) {
            elementMap.put(schema.get(index), new Integer(index));
        }
        return elementMap;
    }

    public boolean resultSetExists(String resultSetName) {
        String resultSetKey = resultSetName.toUpperCase();
        return this.tupleSourceMap.getTupleSource(resultSetKey) != null;
    }

    public DocumentInProgress getDocumentInProgress() {
        return this.documentInProgress;
    }

    public void setDocumentInProgress(DocumentInProgress documentInProgress) {
        this.documentInProgress = documentInProgress;
    }

    public String getXMLFormat() {
        return this.xmlFormat;
    }

    public void setXMLFormat(String xmlFormat) {
        this.xmlFormat = xmlFormat;
    }

    public String getXMLResultsForm() {
        return this.xmlResultsForm;
    }

    public void setXMLResultsForm(String xmlResultsForm) {
        this.xmlResultsForm = xmlResultsForm;
    }

    public boolean isTempGroup(GroupSymbol groupSymbol) {
        return this.stagingTableGroupsSymbols.contains(groupSymbol);
    }

    public TupleSource getTempGroupSource(String tempGroupName) {
        String resultSetKey = tempGroupName.toUpperCase();
        TupleSource result = this.tupleSourceMap.getTupleSource(resultSetKey);
        if (result == null) {
            Iterator i = this.tupleSourceRecursionStack.iterator();
            while (result == null && i.hasNext()) {
                TupleSourceMap temp = (TupleSourceMap)i.next();
                result = temp.getTupleSource(resultSetKey);
            }
        }
        return result;
    }

    protected Collection getStagingTableGroupsSymbols() {
        return this.stagingTableGroupsSymbols;
    }

    public void setStagingTableGroupsSymbols(Collection stagingTableGroupsSymbols) {
        this.stagingTableGroupsSymbols = stagingTableGroupsSymbols;
    }

    private void setRowLimits(Map rowLimits) {
        this.rowLimits = rowLimits;
    }

    public void setRowLimit(String resultSetKey, int rowLimitValue, boolean exceptionOnRowLimit) {
        this.rowLimits.put(resultSetKey, new RowLimit(rowLimitValue, exceptionOnRowLimit));
    }

    public ProcessorDataManager getDataManager() {
        return this.plan.getDataManager();
    }

    public CommandContext getProcessorContext() {
        return this.plan.getContext();
    }

    public Collection getChildPlans() {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator i = this.resultSetStates.values().iterator();
        while (i.hasNext()) {
            ResultSetState state = (ResultSetState)i.next();
            if (!(state.resultSetObject instanceof ProcessorPlan)) continue;
            result.add(state.resultSetObject);
        }
        return result;
    }

    public abstract Object clone();

    protected void copyIntoClone(AbstractProcessorEnvironment clone) {
        clone.setStagingTableGroupsSymbols(this.getStagingTableGroupsSymbols());
        ProgramState initialProgramState = (ProgramState)this.programStack.getLast();
        ProgramState newState = new ProgramState();
        newState.program = initialProgramState.program;
        newState.programCounter = 0;
        newState.recursionCount = 0;
        clone.programStack.addFirst(newState);
        clone.setStagingTableGroupsSymbols(new ArrayList(this.stagingTableGroupsSymbols));
        if (!this.rowLimits.isEmpty()) {
            clone.setRowLimits(new HashMap(this.rowLimits));
        }
        clone.setXMLFormat(this.getXMLFormat());
        clone.setXMLResultsForm(this.getXMLResultsForm());
        Iterator i = this.resultSetStates.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ResultSetState value = (ResultSetState)entry.getValue();
            while (value.maskedState != null) {
                value = value.maskedState;
            }
            clone.resultSetStates.put(entry.getKey(), value.clone());
        }
        clone.dependentValueSources = this.dependentValueSources;
    }

    public GroupSymbol getDocumentGroup() {
        return this.documentGroup;
    }

    public void setDocumentGroup(GroupSymbol documentGroup) {
        this.documentGroup = documentGroup;
    }

    private static class ProgramState {
        private Program program;
        private int programCounter = 0;
        private int recursionCount = 0;
        private static final int NOT_RECURSIVE = 0;

        private ProgramState() {
        }

        public String toString() {
            return this.program.toString() + ", counter " + this.programCounter + ", recursionCount " + (this.recursionCount == 0 ? "not recursive" : "" + this.recursionCount);
        }
    }

    private class TupleSourceMap {
        private Map tupleSources = new HashMap();

        private TupleSourceMap() {
        }

        private TupleSourceState getTupleSourceState(String resultSetKey) {
            TupleSourceState state = (TupleSourceState)this.tupleSources.get(resultSetKey);
            if (state == null) {
                RowLimit rowlimit = (RowLimit)AbstractProcessorEnvironment.this.rowLimits.get(resultSetKey);
                if (rowlimit == null) {
                    rowlimit = RowLimit.NO_ROW_LIMIT;
                }
                state = new TupleSourceState(rowlimit);
                this.tupleSources.put(resultSetKey, state);
            }
            return state;
        }

        TupleSource getTupleSource(String resultSetKey) {
            return this.getTupleSourceState((String)resultSetKey).tupleSource;
        }

        TupleSourceID getTupleSourceID(String resultSetName) {
            return this.getTupleSourceState((String)resultSetName).tupleSourceID;
        }

        List getCurrentRow(String resultSetKey) {
            return this.getTupleSourceState((String)resultSetKey).currentRow;
        }

        void incrementCurrentRow(String resultSetKey) throws MetaMatrixComponentException, MetaMatrixProcessingException {
            TupleSourceState state = (TupleSourceState)this.tupleSources.get(resultSetKey);
            TupleSource source = state.tupleSource;
            if (source == null) {
                throw new ComponentNotFoundException(QueryExecPlugin.Util.getString("AbstractProcessorEnvironment.No_ts_found"));
            }
            if (state.rowLimit != RowLimit.NO_ROW_LIMIT && state.currentRowNumber == state.rowLimit.rowLimitValue) {
                List row;
                if (state.rowLimit.exceptionOnRowLimit && (row = source.nextTuple()) != null) {
                    throw new MetaMatrixProcessingException(QueryExecPlugin.Util.getString("AbstractProcessorEnvironment.row_limit_passed", new Object[]{new Integer(state.rowLimit.rowLimitValue), resultSetKey}));
                }
                state.currentRow = null;
            } else {
                List row;
                state.currentRow = row = source.nextTuple();
                ++state.currentRowNumber;
            }
        }

        Map getElementMap(String resultSetKey) {
            return this.getTupleSourceState((String)resultSetKey).elementMap;
        }

        void setElementMap(String resultSetKey, Map elementMap) {
            this.getTupleSourceState((String)resultSetKey).elementMap = elementMap;
        }

        void removeResultSet(String resultSetKey) {
            this.tupleSources.remove(resultSetKey);
        }

        public String toString() {
            return "TupleSourceMap " + this.tupleSources;
        }
    }

    private class TupleSourceState {
        TupleSource tupleSource;
        TupleSourceID tupleSourceID;
        List currentRow;
        int currentRowNumber;
        final RowLimit rowLimit;
        Map elementMap;

        TupleSourceState(RowLimit rowlimit) {
            this.rowLimit = rowlimit;
        }

        public String toString() {
            return "TupleSourceState " + (this.tupleSource == null ? "not loaded, current row: " : "is loaded, current row: ") + this.currentRow;
        }
    }

    private static class RowLimit {
        static final RowLimit NO_ROW_LIMIT = new RowLimit(-1, false);
        final int rowLimitValue;
        boolean exceptionOnRowLimit;

        RowLimit(int rowLimitValue, boolean exceptionOnRowLimit) {
            this.rowLimitValue = rowLimitValue;
            this.exceptionOnRowLimit = exceptionOnRowLimit;
        }
    }

    static class ResultSetState
    implements Cloneable {
        String resultSetName;
        Object resultSetObject;
        List references;
        List replacementExpressions;
        ResultSetState maskedState;

        ResultSetState() {
        }

        private void refreshReferences(List row, Map elementMap) {
            if (this.references != null) {
                List exprs = this.replacementExpressions;
                for (int i = 0; i < this.references.size(); ++i) {
                    Reference ref = (Reference)this.references.get(i);
                    ref.setData(elementMap, row);
                    Expression expr = (Expression)exprs.get(i);
                    ref.setExpression(expr);
                }
            }
        }

        public Object clone() {
            ResultSetState clone = new ResultSetState();
            clone.resultSetName = this.resultSetName;
            clone.resultSetObject = this.resultSetObject;
            clone.maskedState = null;
            if (this.references != null) {
                clone.references = new ArrayList(this.references);
            }
            if (this.replacementExpressions != null) {
                clone.replacementExpressions = new ArrayList(this.replacementExpressions);
            }
            return clone;
        }

        public String toString() {
            return this.resultSetName + ", resultSetObject " + this.resultSetObject;
        }
    }
}

