/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.command;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.resolver.ProcedureContainerResolver;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.resolver.VariableResolver;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.resolver.util.ResolverVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.GroupContext;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.ProcedureContainer;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InsertResolver
extends ProcedureContainerResolver
implements VariableResolver {
    public void resolveProceduralCommand(Command command, boolean useMetadataCommands, TempMetadataAdapter metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        Insert insert = (Insert)command;
        this.resolveList(insert.getValues(), metadata, insert.getExternalGroupContexts(), null);
        if (insert.getQuery() != null) {
            insert.getQuery().setExternalGroupContexts(insert.getExternalGroupContexts());
            QueryResolver.resolveCommand((Command)insert.getQuery(), (QueryMetadataInterface)metadata);
        }
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(insert.getGroup());
        if (insert.getVariables().isEmpty()) {
            if (insert.getGroup().isResolved()) {
                List variables = ResolverUtil.resolveElementsInGroup((GroupSymbol)insert.getGroup(), (QueryMetadataInterface)metadata);
                Iterator i = variables.iterator();
                while (i.hasNext()) {
                    insert.addVariable((ElementSymbol)((ElementSymbol)i.next()).clone());
                }
            } else {
                for (int i = 0; i < insert.getValues().size(); ++i) {
                    insert.addVariable(new ElementSymbol("expr" + i));
                }
            }
        } else if (insert.getGroup().isResolved()) {
            this.resolveVariables(metadata, insert, groups);
        }
        this.resolveTypes(insert);
        if (!insert.getGroup().isResolved()) {
            if (insert.getQuery() != null) {
                ResolverUtil.resolveImplicitTempGroup((TempMetadataAdapter)metadata, (GroupSymbol)insert.getGroup(), (List)insert.getQuery().getProjectedSymbols());
                ResolverUtil.resolveElementsInGroup((GroupSymbol)insert.getGroup(), (QueryMetadataInterface)metadata);
            } else {
                ResolverUtil.resolveImplicitTempGroup((TempMetadataAdapter)metadata, (GroupSymbol)insert.getGroup(), (List)insert.getVariables());
            }
            this.resolveVariables(metadata, insert, groups);
            this.resolveTypes(insert);
        }
    }

    private void resolveVariables(TempMetadataAdapter metadata, Insert insert, Set groups) throws MetaMatrixComponentException, QueryResolverException {
        try {
            this.resolveList(insert.getVariables(), metadata, null, groups);
        }
        catch (QueryResolverException e) {
            throw new QueryResolverException((Throwable)e, QueryPlugin.Util.getString("ERR.015.012.0054", (Object)insert.getGroup(), (Object)e.getUnresolvedSymbols()));
        }
    }

    private void resolveList(Collection elements, TempMetadataAdapter metadata, GroupContext externalGroups, Set groups) throws MetaMatrixComponentException, QueryResolverException {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Expression expr = (Expression)i.next();
            ResolverVisitor.resolveLanguageObject((LanguageObject)expr, (Collection)groups, (GroupContext)externalGroups, (QueryMetadataInterface)metadata);
        }
    }

    public void resolveTypes(Insert insert) throws QueryResolverException {
        if (insert.getQuery() != null) {
            return;
        }
        if (insert.getValues().size() != insert.getVariables().size()) {
            throw new QueryResolverException("ERR.015.008.0010", QueryPlugin.Util.getString("ERR.015.008.0010", new Object[]{new Integer(insert.getVariables().size()), new Integer(insert.getValues().size())}));
        }
        List values = insert.getValues();
        ArrayList<Expression> newValues = new ArrayList<Expression>(values.size());
        Iterator valueIter = values.iterator();
        Iterator varIter = insert.getVariables().iterator();
        while (valueIter.hasNext()) {
            Expression expression = (Expression)valueIter.next();
            ElementSymbol element = (ElementSymbol)varIter.next();
            if (element.getType() != null && expression.getType() != null) {
                String elementTypeName = DataTypeManager.getDataTypeName((Class)element.getType());
                newValues.add(ResolverUtil.convertExpression((Expression)expression, (String)elementTypeName));
                continue;
            }
            if (element.getType() != null && expression.getType() == null && expression instanceof Reference) {
                Reference ref = (Reference)expression;
                ref.setExpression((Expression)new Constant(null, element.getType()));
                newValues.add(ref);
                continue;
            }
            if (element.getType() == null && expression.getType() != null) {
                element.setType(expression.getType());
                newValues.add(expression);
                continue;
            }
            Assertion.failed((String)"Cannot determine element or expression type");
        }
        insert.setValues(newValues);
    }

    protected String getPlan(QueryMetadataInterface metadata, GroupSymbol group) throws MetaMatrixComponentException, QueryMetadataException {
        return metadata.getInsertPlan(group.getMetadataID());
    }

    protected void resolveGroup(TempMetadataAdapter metadata, ProcedureContainer procCommand) throws MetaMatrixComponentException, QueryResolverException {
        block2: {
            try {
                super.resolveGroup(metadata, procCommand);
            }
            catch (QueryResolverException qre) {
                if (procCommand.getGroup().isImplicitTempGroupSymbol() && metadata.getMetadataStore().getTempGroupID(procCommand.getGroup().getName()) == null) break block2;
                throw qre;
            }
        }
    }

    public Map getVariableValues(Command command, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        Insert insert = (Insert)command;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator varIter = insert.getVariables().iterator();
        Iterator valIter = insert.getValues().iterator();
        while (varIter.hasNext()) {
            ElementSymbol varSymbol = (ElementSymbol)varIter.next();
            String varName = varSymbol.getShortCanonicalName();
            String changingKey = "CHANGING." + varName;
            String inputKey = "INPUT." + varName;
            result.put(changingKey, new Constant((Object)Boolean.TRUE));
            result.put(inputKey, valIter.next());
        }
        List insertElmnts = ResolverUtil.resolveElementsInGroup((GroupSymbol)insert.getGroup(), (QueryMetadataInterface)metadata);
        insertElmnts.removeAll(insert.getVariables());
        Iterator defaultIter = insertElmnts.iterator();
        while (defaultIter.hasNext()) {
            ElementSymbol varSymbol = (ElementSymbol)defaultIter.next();
            Expression value = ResolverUtil.getDefault((ElementSymbol)varSymbol, (QueryMetadataInterface)metadata);
            String varName = varSymbol.getShortCanonicalName();
            String changingKey = "CHANGING." + varName;
            String inputKey = "INPUT." + varName;
            result.put(changingKey, new Constant((Object)Boolean.FALSE));
            result.put(inputKey, value);
        }
        return result;
    }
}

