/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDACrypto;
import com.metamatrix.util.UtilBufferedDataQueue;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.Socket;
import java.sql.SQLException;

public class DRDAByteOrderedDataReader {
    private static String footprint = "$Revision:   3.36.1.0  $";
    public DRDACommunication comm;
    protected UtilTransliterator transliterator;
    private Socket socket;
    private InputStream socketInputStream = null;
    public int processMode = 1;
    public int previousProcessMode = 1;
    public static final int PROCESS_FROM_SOCKET_BUFF = 1;
    public static final int PROCESS_FROM_UNENCRYPT_BUFF = 2;
    public static final int PROCESS_FROM_BYTE_BUFF = 3;
    private int numBytesInSocketBuffer;
    private int socketBufferReadPos;
    private byte[] unencryptBuffer;
    private byte[] tempUnencryptBuffer;
    private int numBytesInUnencryptBuffer;
    private int unencryptBufferReadPos;
    DRDACrypto drdaCrypto;
    private byte[] byteBuffer;
    private int byteBufferReadPos;
    private int numBytesInByteBuffer;
    public int numBytesReadFromCurrentPacket;
    public boolean morePacketsToProcess;
    private byte[] header;
    public int currentPacketLength;
    private int partialHeaderLen;
    private boolean isDSSEncrypted = false;
    public boolean depacketizingExtendedPacket;
    public boolean isFinalExtendedPacket;
    private int currentPacketHeaderLen;
    public boolean interpretAsBigEndian;
    protected byte[] staticByteArray;
    private byte[] socketBuffer;
    private UtilBufferedDataQueue wireContentionBuffer;
    private boolean isClosed = false;
    private int _lenBytes;

    public DRDAByteOrderedDataReader(UtilTransliterator utilTransliterator, DRDACommunication dRDACommunication) {
        this.socket = dRDACommunication.getSocket();
        this.interpretAsBigEndian = true;
        this.staticByteArray = new byte[256];
        this.transliterator = utilTransliterator;
        this.comm = dRDACommunication;
        this.header = new byte[6];
        try {
            this.socketInputStream = this.socket.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DRDAByteOrderedDataReader(UtilPagedTempBuffer utilPagedTempBuffer, int n, UtilTransliterator utilTransliterator, DRDACommunication dRDACommunication) throws UtilException {
        this.socket = dRDACommunication.getSocket();
        this.wireContentionBuffer = new UtilBufferedDataQueue(utilPagedTempBuffer, n);
        this.interpretAsBigEndian = true;
        this.staticByteArray = new byte[256];
        this.transliterator = utilTransliterator;
        this.comm = dRDACommunication;
        this.header = new byte[6];
        this.morePacketsToProcess = n >= 6;
        try {
            this.socketInputStream = this.socket.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.socketBuffer == null) {
            this.socketBuffer = this.comm.getReaderBuffer();
        }
    }

    public void initEncryptionObject(DRDACrypto dRDACrypto) throws SQLException {
        this.drdaCrypto = new DRDACrypto(this.comm);
        this.drdaCrypto.setInitVector(dRDACrypto.initVectorSpec);
        this.drdaCrypto.setSecretKey(dRDACrypto.secretkeyspec);
    }

    public boolean atEndOfReply() throws UtilException {
        return !this.morePacketsToProcess && this.numBytesReadFromCurrentPacket == this.currentPacketLength;
    }

    public void setToReadFromByteArray() {
        this.previousProcessMode = this.processMode;
        this.processMode = 3;
        this.byteBufferReadPos = 0;
    }

    public int cacheRemainingBytes() throws UtilException, SQLException {
        if (this.byteBuffer == null) {
            this.byteBuffer = new byte[Short.MAX_VALUE];
        }
        this.numBytesInByteBuffer = 0;
        this.numBytesInByteBuffer += this.readBytes(this.byteBuffer, 0, this.currentPacketLength - this.numBytesReadFromCurrentPacket);
        this.signalEndOfPacket();
        this.byteBufferReadPos = 0;
        return this.numBytesInByteBuffer;
    }

    public int cacheRemainingBytesInCurrentPacket(boolean bl) throws UtilException, SQLException {
        if (this.byteBuffer == null) {
            this.byteBuffer = new byte[Short.MAX_VALUE];
        }
        if (!bl) {
            this.numBytesInByteBuffer = 0;
        }
        int n = this.readBytes(this.byteBuffer, this.numBytesInByteBuffer, this.currentPacketLength - this.numBytesReadFromCurrentPacket);
        this.numBytesInByteBuffer += n;
        this.byteBufferReadPos = 0;
        if (this.depacketizingExtendedPacket) {
            this.signalStartOfPacket(false);
        }
        return n;
    }

    public void addBytesToCache(int n) throws UtilException, SQLException {
        if (this.byteBuffer == null) {
            this.byteBuffer = new byte[Short.MAX_VALUE];
        }
        this.readBytes(this.byteBuffer, this.numBytesInByteBuffer, n);
        this.numBytesInByteBuffer += n;
    }

    public final String readMutuallyExclusiveFDOCAString(String string) throws UtilException, SQLException {
        String string2 = null;
        short s = this.readInt16();
        if (s != 0) {
            string2 = this.readEncodedString(s, this.comm.MultiByteServerTransliterator);
            this.readAndDiscardBytes(2);
        } else {
            short s2 = this.readInt16();
            string2 = s2 == 0 ? string : this.readEncodedString(s2, this.comm.SingleByteServerTransliterator);
        }
        return string2;
    }

    public final String readMutuallyExclusiveFDOCAString(int n) throws UtilException, SQLException {
        String string = null;
        short s = this.readInt16();
        if (s != 0) {
            string = this.readEncodedString(s, this.comm.MultiByteServerTransliterator);
            this.readAndDiscardBytes(2);
        } else {
            short s2 = this.readInt16();
            string = s2 == 0 ? Integer.toString(n) : this.readEncodedString(s2, this.comm.SingleByteServerTransliterator);
        }
        return string;
    }

    public int readBytes(byte[] byArray, int n, int n2) throws UtilException, SQLException {
        return this.getArrayOfBytes(byArray, n, n2, true);
    }

    public final byte readInt8() throws UtilException, SQLException {
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 1 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 1 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
            ++this.numBytesReadFromCurrentPacket;
            return this.socketBuffer[this.socketBufferReadPos++];
        }
        return this.getByte();
    }

    public final short readUnsignedInt8() throws UtilException, SQLException {
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 1 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 1 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
            ++this.numBytesReadFromCurrentPacket;
            return (short)(this.socketBuffer[this.socketBufferReadPos++] & 0xFF);
        }
        return (short)(this.getByte() & 0xFF);
    }

    public final int readUnsignedInt8asInt() throws UtilException, SQLException {
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 1 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 1 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
            ++this.numBytesReadFromCurrentPacket;
            return this.socketBuffer[this.socketBufferReadPos++] & 0xFF;
        }
        return this.getByte() & 0xFF;
    }

    public final short readInt16() throws UtilException, SQLException {
        if (this.interpretAsBigEndian) {
            if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 2 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 2 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
                int n = this.socketBufferReadPos;
                this.numBytesReadFromCurrentPacket += 2;
                this.socketBufferReadPos += 2;
                return (short)(this.socketBuffer[n] << 8 | this.socketBuffer[n + 1] & 0xFF);
            }
            return (short)(this.getByte() << 8 | this.getByte() & 0xFF);
        }
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 2 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 2 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
            int n = this.socketBufferReadPos;
            this.numBytesReadFromCurrentPacket += 2;
            this.socketBufferReadPos += 2;
            return (short)(this.socketBuffer[n] & 0xFF | this.socketBuffer[n + 1] << 8);
        }
        return (short)(this.getByte() & 0xFF | this.getByte() << 8);
    }

    public final int readUnsignedInt16() throws UtilException, SQLException {
        if (this.interpretAsBigEndian) {
            if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 2 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 2 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
                this.numBytesReadFromCurrentPacket += 2;
                return (this.socketBuffer[this.socketBufferReadPos++] & 0xFF) << 8 | this.socketBuffer[this.socketBufferReadPos++] & 0xFF;
            }
            return (this.getByte() & 0xFF) << 8 | this.getByte() & 0xFF;
        }
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 2 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 2 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
            this.numBytesReadFromCurrentPacket += 2;
            return this.socketBuffer[this.socketBufferReadPos++] & 0xFF | (this.socketBuffer[this.socketBufferReadPos++] & 0xFF) << 8;
        }
        return this.getByte() & 0xFF | (this.getByte() & 0xFF) << 8;
    }

    public final int readInt32() throws UtilException, SQLException {
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 4 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 4 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
            int n = this.socketBufferReadPos;
            this.numBytesReadFromCurrentPacket += 4;
            this.socketBufferReadPos += 4;
            if (this.interpretAsBigEndian) {
                return (this.socketBuffer[n] << 24) + ((this.socketBuffer[n + 1] & 0xFF) << 16) + ((this.socketBuffer[n + 2] & 0xFF) << 8) + (this.socketBuffer[n + 3] & 0xFF);
            }
            return (this.socketBuffer[n] & 0xFF) + ((this.socketBuffer[n + 1] & 0xFF) << 8) + ((this.socketBuffer[n + 2] & 0xFF) << 16) + (this.socketBuffer[n + 3] << 24);
        }
        this.getArrayOfBytes(this.staticByteArray, 0, 4, true);
        int n = this.interpretAsBigEndian ? (this.staticByteArray[0] << 24) + ((this.staticByteArray[1] & 0xFF) << 16) + ((this.staticByteArray[2] & 0xFF) << 8) + (this.staticByteArray[3] & 0xFF) : (this.staticByteArray[0] & 0xFF) + ((this.staticByteArray[1] & 0xFF) << 8) + ((this.staticByteArray[2] & 0xFF) << 16) + (this.staticByteArray[3] << 24);
        return n;
    }

    public final long readUnsignedInt32() throws UtilException, SQLException {
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 4 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 4 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
            this.numBytesReadFromCurrentPacket += 4;
            if (this.interpretAsBigEndian) {
                return (((long)this.socketBuffer[this.socketBufferReadPos++] & 0xFFL) << 24) + (((long)this.socketBuffer[this.socketBufferReadPos++] & 0xFFL) << 16) + (((long)this.socketBuffer[this.socketBufferReadPos++] & 0xFFL) << 8) + ((long)this.socketBuffer[this.socketBufferReadPos++] & 0xFFL);
            }
            return ((long)this.socketBuffer[this.socketBufferReadPos++] & 0xFFL) + (((long)this.socketBuffer[this.socketBufferReadPos++] & 0xFFL) << 8) + (((long)this.socketBuffer[this.socketBufferReadPos++] & 0xFFL) << 16) + (((long)this.socketBuffer[this.socketBufferReadPos++] & 0xFFL) << 24);
        }
        this.getArrayOfBytes(this.staticByteArray, 0, 4, true);
        long l = this.interpretAsBigEndian ? (((long)this.staticByteArray[0] & 0xFFL) << 24) + (((long)this.staticByteArray[1] & 0xFFL) << 16) + (((long)this.staticByteArray[2] & 0xFFL) << 8) + ((long)this.staticByteArray[3] & 0xFFL) : ((long)this.staticByteArray[0] & 0xFFL) + (((long)this.staticByteArray[1] & 0xFFL) << 8) + (((long)this.staticByteArray[2] & 0xFFL) << 16) + (((long)this.staticByteArray[3] & 0xFFL) << 24);
        return l;
    }

    public float readIEEE32BitFloat() throws UtilException, SQLException {
        return Float.intBitsToFloat(this.readInt32());
    }

    public final long readInt64() throws UtilException, SQLException {
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= 8 && this.currentPacketLength - this.numBytesReadFromCurrentPacket > 8 && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
            int n = this.socketBufferReadPos;
            this.numBytesReadFromCurrentPacket += 8;
            this.socketBufferReadPos += 8;
            if (this.interpretAsBigEndian) {
                return ((long)((this.socketBuffer[n] << 24) + ((this.socketBuffer[n + 1] & 0xFF) << 16) + ((this.socketBuffer[n + 2] & 0xFF) << 8) + (this.socketBuffer[n + 3] & 0xFF)) << 32) + ((long)((this.socketBuffer[n + 4] << 24) + ((this.socketBuffer[n + 5] & 0xFF) << 16) + ((this.socketBuffer[n + 6] & 0xFF) << 8) + (this.socketBuffer[n + 7] & 0xFF)) & 0xFFFFFFFFL);
            }
            return ((long)((this.socketBuffer[n] & 0xFF) + ((this.socketBuffer[n + 1] & 0xFF) << 8) + ((this.socketBuffer[n + 2] & 0xFF) << 16) + (this.socketBuffer[n + 3] << 24)) & 0xFFFFFFFFL) + ((long)((this.socketBuffer[n + 4] & 0xFF) + ((this.socketBuffer[n + 5] & 0xFF) << 8) + ((this.socketBuffer[n + 6] & 0xFF) << 16) + (this.socketBuffer[n + 7] << 24)) << 32);
        }
        this.getArrayOfBytes(this.staticByteArray, 0, 8, true);
        if (this.interpretAsBigEndian) {
            return ((long)((this.staticByteArray[0] << 24) + ((this.staticByteArray[1] & 0xFF) << 16) + ((this.staticByteArray[2] & 0xFF) << 8) + (this.staticByteArray[3] & 0xFF)) << 32) + ((long)((this.staticByteArray[4] << 24) + ((this.staticByteArray[5] & 0xFF) << 16) + ((this.staticByteArray[6] & 0xFF) << 8) + (this.staticByteArray[7] & 0xFF)) & 0xFFFFFFFFL);
        }
        return ((long)((this.staticByteArray[0] & 0xFF) + ((this.staticByteArray[1] & 0xFF) << 8) + ((this.staticByteArray[2] & 0xFF) << 16) + (this.staticByteArray[3] << 24)) & 0xFFFFFFFFL) + ((long)((this.staticByteArray[4] & 0xFF) + ((this.staticByteArray[5] & 0xFF) << 8) + ((this.staticByteArray[6] & 0xFF) << 16) + (this.staticByteArray[7] << 24)) << 32);
    }

    public double readIEEE64BitDouble() throws UtilException, SQLException {
        return Double.longBitsToDouble(this.readInt64());
    }

    public String readString(int n) throws UtilException, SQLException {
        byte[] byArray = this.transliterator.getBytesCache();
        byte[] byArray2 = n > byArray.length ? new byte[n] : byArray;
        int n2 = 0;
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= n && this.currentPacketLength - this.numBytesReadFromCurrentPacket > n && this.numBytesReadFromCurrentPacket != 0 && this.processMode == 1) {
            System.arraycopy(this.socketBuffer, this.socketBufferReadPos, byArray2, 0, n);
            this.numBytesReadFromCurrentPacket += n;
            this.socketBufferReadPos += n;
            n2 = n;
        } else {
            n2 = this.getArrayOfBytes(byArray2, 0, n, true);
        }
        return this.transliterator.decode(byArray2, 0, n2);
    }

    public String readEncodedString(int n, UtilTransliterator utilTransliterator) throws UtilException, SQLException {
        if (n == 0) {
            return new String();
        }
        UtilTransliterator utilTransliterator2 = this.transliterator;
        this.transliterator = utilTransliterator;
        String string = this.readString(n);
        this.transliterator = utilTransliterator2;
        return string;
    }

    public InputStream getInputStream(int n) throws UtilException, SQLException {
        this._lenBytes = n;
        return new InputStream(){
            private int readSoFar;
            private int totalLen;
            private boolean atEnd;
            {
                this.totalLen = DRDAByteOrderedDataReader.this._lenBytes;
            }

            public int read() throws IOException {
                if (this.readSoFar < this.totalLen) {
                    try {
                        byte by = DRDAByteOrderedDataReader.this.getByte();
                        ++this.readSoFar;
                        return by & 0xFF;
                    }
                    catch (UtilException utilException) {
                        return -1;
                    }
                    catch (SQLException sQLException) {
                        return -1;
                    }
                }
                if (this.atEnd) {
                    return -1;
                }
                this.atEnd = true;
                return -1;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = this.totalLen - this.readSoFar;
                if (n3 >= n2) {
                    try {
                        DRDAByteOrderedDataReader.this.readBytes(byArray, n, n2);
                        this.readSoFar += n2;
                        return n2;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                    catch (SQLException sQLException) {
                        throw new IOException();
                    }
                }
                if (n3 > 0) {
                    try {
                        DRDAByteOrderedDataReader.this.readBytes(byArray, n, n3);
                        this.readSoFar = this.totalLen;
                        this.atEnd = true;
                        return n3;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                    catch (SQLException sQLException) {
                        throw new IOException();
                    }
                }
                this.atEnd = true;
                return -1;
            }

            public void close() throws IOException {
                int n = this.totalLen - this.readSoFar;
                if (n > 0) {
                    try {
                        DRDAByteOrderedDataReader.this.readAndDiscardBytes(n);
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                    catch (SQLException sQLException) {
                        throw new IOException();
                    }
                }
                this.readSoFar = this.totalLen;
                this.atEnd = true;
            }
        };
    }

    public final InputStream getAsciiStream(int n) throws UtilException, SQLException {
        return this.transliterator.decodeAsAsciiStream(this.getInputStream(n));
    }

    public final Reader getReader(int n) throws UtilException, SQLException {
        return this.transliterator.decodeAsReader(this.getInputStream(n));
    }

    public final void empty() throws UtilException, SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.getNumBytesLeftInCurrentPacket() > 0) {
            this.readAndDiscardBytes(this.getNumBytesLeftInCurrentPacket());
        }
        while (!this.atEndOfReply() || this.depacketizingExtendedPacket) {
            this.signalStartOfPacket(false);
            this.readAndDiscardBytes(this.getNumBytesLeftInCurrentPacket());
            this.signalEndOfPacket();
        }
        if (this.wireContentionBuffer != null) {
            this.wireContentionBuffer.empty();
        }
        this.numBytesInSocketBuffer = 0;
        this.socketBufferReadPos = 0;
        this.numBytesReadFromCurrentPacket = 0;
        this.morePacketsToProcess = false;
        this.currentPacketLength = 0;
        this.isFinalExtendedPacket = false;
        this.processMode = 1;
    }

    public void close() throws SQLException, UtilException {
        this.empty();
        if (this.wireContentionBuffer != null) {
            this.wireContentionBuffer.close();
            this.wireContentionBuffer = null;
        }
        if (this.socketBuffer != null) {
            this.comm.putReaderBuffer(this.socketBuffer);
            this.socketBuffer = null;
        }
        this.isClosed = true;
    }

    public void receive() throws SQLException {
        try {
            if (this.socketBuffer == null) {
                this.socketBuffer = this.comm.getReaderBuffer();
            }
            this.numBytesReadFromCurrentPacket = 0;
            this.morePacketsToProcess = true;
            this.currentPacketLength = 0;
            this.isFinalExtendedPacket = false;
            this.socketBufferReadPos = 0;
            try {
                this.numBytesInSocketBuffer = this.socketInputStream.read(this.socketBuffer, 0, this.comm.socketBufferSize);
                if (this.numBytesInSocketBuffer == -1) {
                    this.morePacketsToProcess = false;
                    throw new UtilException(1002);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new SQLException("SOCKETTIMEOUT");
            }
            catch (IOException iOException) {
                throw new UtilException(1018, iOException.getMessage());
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException), "0800");
        }
    }

    private void cacheNextBlock() throws UtilException, SQLException {
        if (this.wireContentionBuffer != null && this.wireContentionBuffer.numBufferedBytes() > 0) {
            this.numBytesInSocketBuffer = this.wireContentionBuffer.read(this.socketBuffer, 0, this.comm.socketBufferSize);
            this.socketBufferReadPos = 0;
        } else {
            try {
                int n;
                this.numBytesInSocketBuffer = n = this.socketInputStream.read(this.socketBuffer, 0, this.comm.socketBufferSize);
                this.socketBufferReadPos = 0;
                if (n == -1) {
                    throw new UtilException(1002);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new SQLException("SOCKETTIMEOUT");
            }
            catch (IOException iOException) {
                throw new UtilException(1018, iOException.getMessage());
            }
        }
    }

    private void cacheNextBlock(int n, boolean bl) throws UtilException, SQLException {
        if (!bl && this.wireContentionBuffer != null && this.wireContentionBuffer.numBufferedBytes() > 0) {
            this.numBytesInSocketBuffer = this.wireContentionBuffer.read(this.socketBuffer, 0, this.comm.socketBufferSize);
            this.socketBufferReadPos = 0;
        } else {
            if (!this.depacketizingExtendedPacket && !this.morePacketsToProcess && this.numBytesReadFromCurrentPacket == this.currentPacketLength) {
                throw new UtilException(1001);
            }
            try {
                int n2;
                this.numBytesInSocketBuffer = n2 = this.socketInputStream.read(this.socketBuffer, 0, this.comm.socketBufferSize);
                while (this.numBytesInSocketBuffer < n) {
                    n2 = this.socketInputStream.read(this.socketBuffer, this.numBytesInSocketBuffer, this.comm.socketBufferSize - this.numBytesInSocketBuffer);
                    this.numBytesInSocketBuffer += n2;
                }
                this.socketBufferReadPos = 0;
                if (n2 == -1) {
                    throw new UtilException(1002);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new SQLException("SOCKETTIMEOUT");
            }
            catch (IOException iOException) {
                throw new UtilException(1018, iOException.getMessage());
            }
        }
    }

    public final byte getByte() throws UtilException, SQLException {
        switch (this.processMode) {
            case 1: {
                if (this.numBytesReadFromCurrentPacket == 0) {
                    this.signalStartOfPacket(false);
                    if (this.processMode != 1) {
                        return this.getByte();
                    }
                }
                if (this.socketBufferReadPos == this.numBytesInSocketBuffer) {
                    this.cacheNextBlock();
                }
                ++this.numBytesReadFromCurrentPacket;
                if (this.numBytesReadFromCurrentPacket == this.currentPacketLength) {
                    this.signalEndOfPacket();
                }
                return this.socketBuffer[this.socketBufferReadPos++];
            }
            case 3: {
                if (this.byteBufferReadPos == this.numBytesInByteBuffer) {
                    throw new UtilException(1001);
                }
                if (this.byteBufferReadPos + 1 == this.numBytesInByteBuffer) {
                    this.processMode = this.previousProcessMode;
                }
                return this.byteBuffer[this.byteBufferReadPos++];
            }
            case 2: {
                if (this.unencryptBufferReadPos == this.numBytesInUnencryptBuffer) {
                    this.processMode = 1;
                    this.signalEndOfPacket();
                    return this.getByte();
                }
                ++this.numBytesReadFromCurrentPacket;
                return this.unencryptBuffer[this.unencryptBufferReadPos++];
            }
        }
        return 0;
    }

    public int getArrayOfBytes(byte[] byArray, int n, int n2, boolean bl) throws UtilException, SQLException {
        if (n2 <= 0) {
            return 0;
        }
        int n3 = 0;
        switch (this.processMode) {
            case 1: {
                int n4 = n2;
                while (n4 > 0) {
                    if (this.numBytesReadFromCurrentPacket == 0 && bl) {
                        this.signalStartOfPacket(false);
                        if (this.processMode != 1) {
                            return this.getArrayOfBytes(byArray, n, n2, bl);
                        }
                    }
                    if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= (n3 = n4 <= this.currentPacketLength - this.numBytesReadFromCurrentPacket ? n4 : this.currentPacketLength - this.numBytesReadFromCurrentPacket)) {
                        System.arraycopy(this.socketBuffer, this.socketBufferReadPos, byArray, n, n3);
                        this.socketBufferReadPos += n3;
                        this.numBytesReadFromCurrentPacket += n3;
                        n4 -= n3;
                        n += n3;
                    } else {
                        int n5 = this.numBytesInSocketBuffer - this.socketBufferReadPos;
                        System.arraycopy(this.socketBuffer, this.socketBufferReadPos, byArray, n, n5);
                        this.cacheNextBlock(n3 - n5, false);
                        System.arraycopy(this.socketBuffer, this.socketBufferReadPos, byArray, n + n5, n3 - n5);
                        this.socketBufferReadPos += n3 - n5;
                        this.numBytesReadFromCurrentPacket += n3;
                        n4 -= n3;
                        n += n3;
                    }
                    if (this.numBytesReadFromCurrentPacket != this.currentPacketLength || !bl) continue;
                    this.signalEndOfPacket();
                }
                break;
            }
            case 3: {
                if (this.byteBufferReadPos + n2 > this.numBytesInByteBuffer) {
                    throw new UtilException(1001);
                }
                n3 = Math.min(n2, this.numBytesInByteBuffer - this.byteBufferReadPos);
                System.arraycopy(this.byteBuffer, this.byteBufferReadPos, byArray, n, n3);
                this.byteBufferReadPos += n3;
                if (this.byteBufferReadPos != this.numBytesInByteBuffer) break;
                this.processMode = this.previousProcessMode;
                break;
            }
            case 2: {
                if (this.unencryptBufferReadPos == this.numBytesInUnencryptBuffer) {
                    this.processMode = 1;
                    if (bl) {
                        this.signalEndOfPacket();
                    }
                    return this.getArrayOfBytes(byArray, n, n2, bl);
                }
                n3 = Math.min(n2, this.numBytesInUnencryptBuffer - this.unencryptBufferReadPos);
                System.arraycopy(this.unencryptBuffer, this.unencryptBufferReadPos, byArray, n, n3);
                this.unencryptBufferReadPos += n3;
                this.numBytesReadFromCurrentPacket += n3;
                if (n3 < n2) {
                    n3 += this.getArrayOfBytes(byArray, n + n3, n2 - n3, bl);
                }
                return n3;
            }
        }
        return n2;
    }

    public final void discardCurrentPacket() throws UtilException, SQLException {
        if (this.getNumBytesLeftInCurrentPacket() == 0) {
            return;
        }
        this.readAndDiscardBytes(this.getNumBytesLeftInCurrentPacket());
        this.signalEndOfPacket();
        while (this.depacketizingExtendedPacket || this.isFinalExtendedPacket) {
            this.signalStartOfPacket(false);
            this.readAndDiscardBytes(this.getNumBytesLeftInCurrentPacket());
            this.signalEndOfPacket();
        }
    }

    public final void readAndDiscardBytes(int n) throws UtilException, SQLException {
        if (n <= 0) {
            return;
        }
        switch (this.processMode) {
            case 1: {
                if (this.numBytesReadFromCurrentPacket + n <= this.currentPacketLength && this.socketBufferReadPos + n <= this.numBytesInSocketBuffer) {
                    this.socketBufferReadPos += n;
                    this.numBytesReadFromCurrentPacket += n;
                    if (this.numBytesReadFromCurrentPacket != this.currentPacketLength) break;
                    this.signalEndOfPacket();
                    break;
                }
                int n2 = n;
                int n3 = 0;
                while (n2 > 0) {
                    if (this.numBytesReadFromCurrentPacket == 0) {
                        this.signalStartOfPacket(false);
                        if (this.processMode != 1) {
                            this.readAndDiscardBytes(n);
                            return;
                        }
                    }
                    if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= (n3 = n2 <= this.currentPacketLength - this.numBytesReadFromCurrentPacket ? n2 : this.currentPacketLength - this.numBytesReadFromCurrentPacket)) {
                        this.socketBufferReadPos += n3;
                        this.numBytesReadFromCurrentPacket += n3;
                        n2 -= n3;
                    } else {
                        int n4 = this.numBytesInSocketBuffer - this.socketBufferReadPos;
                        this.cacheNextBlock(n3 - n4, false);
                        this.socketBufferReadPos += n3 - n4;
                        this.numBytesReadFromCurrentPacket += n3;
                        n2 -= n3;
                    }
                    if (this.numBytesReadFromCurrentPacket != this.currentPacketLength) continue;
                    this.signalEndOfPacket();
                }
                break;
            }
            case 3: {
                if (this.byteBufferReadPos + n > this.numBytesInByteBuffer) {
                    throw new UtilException(1001);
                }
                this.byteBufferReadPos += n;
                if (this.byteBufferReadPos != this.numBytesInByteBuffer) break;
                this.processMode = this.previousProcessMode;
                break;
            }
            case 2: {
                if (this.unencryptBufferReadPos == this.numBytesInUnencryptBuffer) {
                    this.processMode = 1;
                    this.signalEndOfPacket();
                    this.readAndDiscardBytes(n);
                    break;
                }
                int n5 = Math.min(n, this.numBytesInUnencryptBuffer - this.unencryptBufferReadPos);
                this.unencryptBufferReadPos += n;
                this.numBytesReadFromCurrentPacket += n;
                if (n5 >= n) break;
                this.readAndDiscardBytes(n - n5);
            }
        }
    }

    public final boolean isNextCpEXTDTA() throws UtilException {
        try {
            if (this.getNumBytesLeftInCurrentPacket() >= 4) {
                return this.peekByte(2) == 20 && this.peekByte(3) == 108;
            }
            if (this.getNumBytesLeftInCurrentPacket() == 0 && this.morePacketsToProcess) {
                return this.peekByte(8) == 20 && this.peekByte(9) == 108;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public final byte peekByte(int n) throws UtilException, SQLException {
        switch (this.processMode) {
            case 1: {
                if (this.socketBufferReadPos == this.numBytesInSocketBuffer) {
                    this.cacheNextBlock();
                }
                if (this.socketBufferReadPos + n > this.numBytesInSocketBuffer) {
                    throw new UtilException(1025);
                }
                return this.socketBuffer[this.socketBufferReadPos + n];
            }
            case 3: {
                if (this.byteBufferReadPos + n > this.numBytesInByteBuffer) {
                    throw new UtilException(1025);
                }
                return this.byteBuffer[this.byteBufferReadPos + n];
            }
            case 2: {
                if (this.unencryptBufferReadPos + n > this.numBytesInUnencryptBuffer) {
                    throw new UtilException(1025);
                }
                return this.unencryptBuffer[this.unencryptBufferReadPos + n];
            }
        }
        return 0;
    }

    public int getNextExtendedPacketLength() throws UtilException, SQLException {
        int n = this.socketBufferReadPos + (this.currentPacketLength - this.numBytesReadFromCurrentPacket);
        if (this.processMode == 2) {
            n = this.socketBufferReadPos;
        }
        if (n + 2 <= this.numBytesInSocketBuffer) {
            return (this.socketBuffer[n] & 0x7F) << 8 | this.socketBuffer[n + 1] & 0xFF;
        }
        if (this.wireContentionBuffer == null) {
            this.bufferAllData();
            return this.wireContentionBuffer == null ? 0 : this.wireContentionBuffer.numBufferedBytes();
        }
        return this.wireContentionBuffer.numBufferedBytes();
    }

    protected final void signalStartOfPacket(boolean bl) throws UtilException, SQLException {
        this.currentPacketHeaderLen = !this.depacketizingExtendedPacket ? 6 : 2;
        if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= this.currentPacketHeaderLen) {
            System.arraycopy(this.socketBuffer, this.socketBufferReadPos, this.header, 0, this.currentPacketHeaderLen);
            this.socketBufferReadPos += this.currentPacketHeaderLen;
        } else {
            this.partialHeaderLen = this.numBytesInSocketBuffer - this.socketBufferReadPos;
            System.arraycopy(this.socketBuffer, this.socketBufferReadPos, this.header, 0, this.partialHeaderLen);
            this.cacheNextBlock(this.currentPacketHeaderLen - this.partialHeaderLen, bl);
            System.arraycopy(this.socketBuffer, this.socketBufferReadPos, this.header, this.partialHeaderLen, this.currentPacketHeaderLen - this.partialHeaderLen);
            this.socketBufferReadPos += this.currentPacketHeaderLen - this.partialHeaderLen;
        }
        this.currentPacketLength = (this.header[0] & 0x7F) << 8 | this.header[1] & 0xFF;
        this.depacketizingExtendedPacket = (this.header[0] & 0x80) != 0;
        this.isDSSEncrypted = (this.header[3] & 0xF) == 4;
        this.morePacketsToProcess = (this.header[3] & 0xF0) != 0;
        this.isFinalExtendedPacket = !this.depacketizingExtendedPacket && this.currentPacketHeaderLen == 2;
        this.numBytesReadFromCurrentPacket = this.currentPacketHeaderLen;
        if (this.isDSSEncrypted && !bl) {
            this.unencryptDSSPacket();
        }
    }

    protected final void signalEndOfPacket() throws UtilException {
        this.numBytesReadFromCurrentPacket = 0;
        this.currentPacketLength = 0;
        if (this.isFinalExtendedPacket) {
            this.isFinalExtendedPacket = false;
        }
        if (this.processMode == 2) {
            this.processMode = 1;
        }
    }

    public final int getNumBytesLeftInCurrentPacket() throws UtilException {
        return this.currentPacketLength - this.numBytesReadFromCurrentPacket;
    }

    public final int getNumBytesLeftInSocketBuffer() throws UtilException {
        return this.numBytesInSocketBuffer - this.socketBufferReadPos;
    }

    private final void unencryptDSSPacket() throws UtilException, SQLException {
        if (this.drdaCrypto == null) {
            this.initEncryptionObject(this.comm.drdaCrypto);
        }
        this.numBytesInUnencryptBuffer = 0;
        this.unencryptBufferReadPos = 0;
        int n = 0;
        if (this.unencryptBuffer == null) {
            this.unencryptBuffer = new byte[32780];
            this.tempUnencryptBuffer = new byte[32780];
        }
        if (this.depacketizingExtendedPacket || this.isFinalExtendedPacket) {
            if (this.isFinalExtendedPacket) {
                n = this.getArrayOfBytes(this.tempUnencryptBuffer, 0, this.getNumBytesLeftInCurrentPacket(), false);
                this.numBytesInUnencryptBuffer = this.drdaCrypto.DES_Decrypt_update_final(this.tempUnencryptBuffer, 0, n, this.unencryptBuffer, 0);
            } else {
                n = this.getArrayOfBytes(this.tempUnencryptBuffer, 0, this.getNumBytesLeftInCurrentPacket(), false);
                this.numBytesInUnencryptBuffer = this.drdaCrypto.DES_Decrypt_update(this.tempUnencryptBuffer, 0, n, this.unencryptBuffer, 0);
            }
        } else {
            n = this.getArrayOfBytes(this.tempUnencryptBuffer, 0, this.getNumBytesLeftInCurrentPacket(), false);
            this.numBytesInUnencryptBuffer = this.drdaCrypto.DES_Decrypt(this.tempUnencryptBuffer, 0, n, this.unencryptBuffer, 0);
        }
        this.signalEndOfPacket();
        this.currentPacketLength = this.numBytesInUnencryptBuffer;
        this.unencryptBufferReadPos = 0;
        this.numBytesReadFromCurrentPacket = 0;
        this.processMode = 2;
    }

    public final boolean bufferAllData() throws SQLException, UtilException {
        boolean bl;
        if (!this.morePacketsToProcess && this.currentPacketLength == 0) {
            return true;
        }
        if (this.wireContentionBuffer == null) {
            this.wireContentionBuffer = new UtilBufferedDataQueue(0);
        }
        int n = this.currentPacketLength;
        int n2 = this.numBytesReadFromCurrentPacket;
        boolean bl2 = this.depacketizingExtendedPacket;
        boolean bl3 = this.isFinalExtendedPacket;
        boolean bl4 = this.morePacketsToProcess;
        boolean bl5 = this.isDSSEncrypted;
        int n3 = this.processMode;
        byte[] byArray = new byte[]{this.header[0], this.header[1], this.header[2], this.header[3], this.header[4], this.header[5]};
        int n4 = this.getNumBytesLeftInCurrentPacket();
        boolean bl6 = bl = n4 != 0;
        while (this.morePacketsToProcess || bl || this.depacketizingExtendedPacket) {
            if (!bl) {
                this.signalStartOfPacket(true);
                this.wireContentionBuffer.write(this.header, 0, this.currentPacketHeaderLen);
            } else {
                bl = false;
            }
            n4 = this.getNumBytesLeftInCurrentPacket();
            if (this.processMode != 2) {
                if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= n4) {
                    this.wireContentionBuffer.write(this.socketBuffer, this.socketBufferReadPos, n4);
                    this.socketBufferReadPos += n4;
                    this.numBytesReadFromCurrentPacket += n4;
                } else {
                    int n5 = this.numBytesInSocketBuffer - this.socketBufferReadPos;
                    this.wireContentionBuffer.write(this.socketBuffer, this.socketBufferReadPos, n5);
                    this.cacheNextBlock(n4 - n5, true);
                    this.wireContentionBuffer.write(this.socketBuffer, this.socketBufferReadPos, n4 - n5);
                    this.socketBufferReadPos += n4 - n5;
                    this.numBytesReadFromCurrentPacket += n4;
                }
            }
            this.signalEndOfPacket();
        }
        this.currentPacketLength = n;
        this.numBytesReadFromCurrentPacket = n2;
        this.depacketizingExtendedPacket = bl2;
        this.isFinalExtendedPacket = bl3;
        this.morePacketsToProcess = bl4;
        this.isDSSEncrypted = bl5;
        this.processMode = n3;
        this.header = byArray;
        return true;
    }

    public final int addPacketToBuffer(int n, int n2, int n3, UtilPagedTempBuffer utilPagedTempBuffer) throws SQLException, UtilException {
        if (!this.morePacketsToProcess && this.currentPacketLength == 0) {
            return 0;
        }
        boolean bl = true;
        byte[] byArray = new byte[]{this.header[0], this.header[1], this.header[2], this.header[3], this.header[4], this.header[5]};
        do {
            int n4;
            if (!bl) {
                this.signalStartOfPacket(false);
                byArray[0] = this.header[0];
                byArray[1] = this.header[1];
                if (this.currentPacketHeaderLen == 6) {
                    byArray[2] = this.header[2];
                    byArray[3] = this.header[3];
                    byArray[4] = this.header[4];
                    byArray[5] = this.header[5];
                }
            }
            if (this.isDSSEncrypted) {
                n4 = this.getNumBytesLeftInCurrentPacket() + this.currentPacketHeaderLen;
                if (bl) {
                    n4 += 4;
                }
                if (this.depacketizingExtendedPacket) {
                    n4 = (byte)(0x8000 | n4);
                }
                byArray[0] = (byte)(n4 >>> 8);
                byArray[1] = (byte)n4;
                byArray[3] = (byte)(this.header[3] & 0xF0 | 3);
            }
            n += utilPagedTempBuffer.write((long)n, byArray, 0, this.currentPacketHeaderLen);
            if (bl) {
                utilPagedTempBuffer.write((long)n++, (byte)(n2 >>> 8 & 0xFF));
                utilPagedTempBuffer.write((long)n++, (byte)(n2 >>> 0 & 0xFF));
                utilPagedTempBuffer.write((long)n++, (byte)(n3 >>> 8 & 0xFF));
                utilPagedTempBuffer.write((long)n++, (byte)(n3 >>> 0 & 0xFF));
                bl = false;
            }
            n4 = this.getNumBytesLeftInCurrentPacket();
            if (this.isDSSEncrypted) {
                n += utilPagedTempBuffer.write((long)n, this.unencryptBuffer, this.unencryptBufferReadPos, n4);
                this.unencryptBufferReadPos += n4;
                this.numBytesReadFromCurrentPacket += n4;
            } else if (this.numBytesInSocketBuffer - this.socketBufferReadPos >= n4) {
                n += utilPagedTempBuffer.write((long)n, this.socketBuffer, this.socketBufferReadPos, n4);
                this.socketBufferReadPos += n4;
                this.numBytesReadFromCurrentPacket += n4;
            } else {
                int n5 = this.numBytesInSocketBuffer - this.socketBufferReadPos;
                n += utilPagedTempBuffer.write((long)n, this.socketBuffer, this.socketBufferReadPos, n5);
                this.cacheNextBlock(n4 - n5, true);
                n += utilPagedTempBuffer.write((long)n, this.socketBuffer, this.socketBufferReadPos, n4 - n5);
                this.socketBufferReadPos += n4 - n5;
                this.numBytesReadFromCurrentPacket += n4;
            }
            this.signalEndOfPacket();
        } while (this.depacketizingExtendedPacket);
        return n;
    }
}

