/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPExtensions;
import iaik.x509.ocsp.Request;
import iaik.x509.ocsp.extensions.AcceptableResponses;
import iaik.x509.ocsp.extensions.Nonce;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Enumeration;

public class OCSPRequest {
    static /* synthetic */ Class k;
    static /* synthetic */ Class j;
    private boolean h = true;
    private X509Certificate[] l;
    private byte[] c;
    private AlgorithmID d;
    private OCSPExtensions i;
    private Request[] f;
    private GeneralName e;
    private int a = 1;
    private ASN1 g = new ASN1();

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.h && this.c != null) {
            throw new RuntimeException("Cannot encode this response. First it has to be signed.");
        }
        try {
            outputStream.write(this.getEncoded());
            return;
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.getMessage());
        }
    }

    public void verify(PublicKey publicKey, String string) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray;
        if (this.h) {
            throw new RuntimeException("Cannot verify this request. First it has to be signed.");
        }
        if (this.d == null) {
            throw new NoSuchAlgorithmException("Cannot verify request! No signature algorithm set.");
        }
        Signature signature = this.d.getSignatureInstance(string);
        try {
            byArray = this.g.getFirstObject();
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.toString());
        }
        signature.initVerify(publicKey);
        signature.update(byArray);
        if (!signature.verify(this.c)) {
            throw new SignatureException("Signature verification error!");
        }
    }

    public void verify(PublicKey publicKey) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        this.verify(publicKey, null);
    }

    public X509Certificate verify() throws OCSPException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        X509Certificate[] x509CertificateArray = null;
        if (this.l == null || this.l.length <= 0) {
            throw new OCSPException("Cannot verify request. No certificates included.");
        }
        x509CertificateArray = Util.arrangeCertificateChain(this.l, false);
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            this.verify(x509CertificateArray[0].getPublicKey());
            return x509CertificateArray[0];
        }
        throw new OCSPException("Cannot verify request. Cannot build chain from included certs.");
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        if (this.e != null) {
            stringBuffer.append("requestorName: " + this.e + "\n");
        }
        if (bl) {
            int n2 = 0;
            while (n2 < this.f.length) {
                stringBuffer.append("request " + n2 + ": {\n");
                stringBuffer.append(String.valueOf(this.f[n2].toString(true)) + "}");
                ++n2;
            }
        } else {
            stringBuffer.append("requests: " + this.f.length);
        }
        if (this.i != null) {
            stringBuffer.append("\n");
            if (bl) {
                stringBuffer.append(this.i);
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else {
                stringBuffer.append("Extensions: " + this.i.countExtensions());
            }
        }
        if (this.d != null) {
            stringBuffer.append("\nSignature algorithm: " + this.d);
        }
        if (this.l != null) {
            stringBuffer.append("\ncertificates: " + this.l.length);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.h && this.c != null) {
            throw new RuntimeException("Cannot give an ASN.1 representation of this request. First it has to be resigned.");
        }
        if (this.c == null && this.g.toASN1Object() == null) {
            try {
                this.b();
            }
            catch (OCSPException oCSPException) {
                throw new CodingException(oCSPException.getMessage());
            }
        }
        return this.g.toASN1Object();
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws NoSuchAlgorithmException, InvalidKeyException, OCSPException {
        if (algorithmID == null) {
            throw new OCSPException("Cannot sign request! No signature algorithm specified!");
        }
        this.d = algorithmID;
        Signature signature = this.d.getSignatureInstance(string);
        ASN1Object aSN1Object = this.a();
        signature.initSign(privateKey);
        try {
            signature.update(DerCoder.encode(aSN1Object));
            this.c = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.c);
            SEQUENCE sEQUENCE = new SEQUENCE();
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.d.toASN1Object());
            sEQUENCE2.addComponent(bIT_STRING);
            if (this.l != null && this.l.length > 0) {
                sEQUENCE2.addComponent(new CON_SPEC(0, ASN.createSequenceOf(this.l)));
            }
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(new CON_SPEC(0, sEQUENCE2));
            this.g = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.getMessage());
        }
        catch (SignatureException signatureException) {
            throw new OCSPException(signatureException.getMessage());
        }
        this.h = false;
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, OCSPException {
        this.sign(algorithmID, privateKey, null);
    }

    public void setSignature(AlgorithmID algorithmID, byte[] byArray) throws OCSPException {
        if (algorithmID == null) {
            throw new OCSPException("Cannot sign request! No signature algorithm specified!");
        }
        if (byArray == null || byArray.length == 0) {
            throw new OCSPException("Cannot set empty signature value!");
        }
        this.d = algorithmID;
        this.c = byArray;
        ASN1Object aSN1Object = this.a();
        try {
            BIT_STRING bIT_STRING = new BIT_STRING(this.c);
            SEQUENCE sEQUENCE = new SEQUENCE();
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.d.toASN1Object());
            sEQUENCE2.addComponent(bIT_STRING);
            if (this.l != null && this.l.length > 0) {
                sEQUENCE2.addComponent(new CON_SPEC(0, ASN.createSequenceOf(this.l)));
            }
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(new CON_SPEC(0, sEQUENCE2));
            this.g = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.getMessage());
        }
        this.h = false;
    }

    public void setRequestorName(GeneralName generalName) {
        this.e = generalName;
        this.h = true;
    }

    public void setRequestList(Request[] requestArray) {
        this.f = requestArray;
        this.h = true;
        if (requestArray != null) {
            int n2 = 0;
            while (n2 < requestArray.length) {
                if (requestArray[n2].getReqCert().getType() != 0) {
                    this.a = 2;
                    return;
                }
                ++n2;
            }
        }
    }

    public void setNonce(byte[] byArray) throws X509ExtensionException {
        this.addExtension(new Nonce(byArray));
    }

    public void setCertificates(X509Certificate[] x509CertificateArray) {
        this.l = x509CertificateArray;
        this.h = true;
    }

    public void setAcceptableResponseTypes(ObjectID[] objectIDArray) throws X509ExtensionException {
        this.addExtension(new AcceptableResponses(objectIDArray));
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = false;
        boolean bl2 = bl = this.i == null ? false : this.i.removeExtension(objectID);
        if (bl) {
            this.h = true;
        }
        return bl;
    }

    public void removeAllExtensions() {
        if (this.i != null) {
            this.i.removeAllExtensions();
            this.h = true;
        }
        this.i = null;
    }

    public Enumeration listExtensions() {
        if (this.i == null) {
            return null;
        }
        return this.i.listExtensions();
    }

    private void c() throws X509ExtensionException, CodingException {
        int n2 = 0;
        ASN1Object aSN1Object = this.g.getComponentAt(0);
        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
        if (aSN1Object2.isA(ASN.CON_SPEC) && aSN1Object2.getAsnType().getTag() == 0) {
            BigInteger bigInteger = (BigInteger)((ASN1Object)aSN1Object2.getValue()).getValue();
            this.a = bigInteger.intValue() + 1;
            ++n2;
        }
        if ((aSN1Object2 = aSN1Object.getComponentAt(n2)).isA(ASN.CON_SPEC) && aSN1Object2.getAsnType().getTag() == 1) {
            this.e = new GeneralName((ASN1Object)aSN1Object2.getValue());
            ++n2;
        }
        aSN1Object2 = aSN1Object.getComponentAt(n2);
        this.f = (Request[])ASN.parseSequenceOf(aSN1Object2, j != null ? j : (j = OCSPRequest.a("iaik.x509.ocsp.Request")));
        int n3 = 1 + n2;
        if (n3 < aSN1Object.countComponents()) {
            aSN1Object2 = aSN1Object.getComponentAt(n3);
            this.i = new OCSPExtensions((ASN1Object)aSN1Object2.getValue());
        }
        if (this.g.countComponents() == 2) {
            ASN1Object aSN1Object3 = (ASN1Object)this.g.getComponentAt(1).getValue();
            this.d = new AlgorithmID(aSN1Object3.getComponentAt(0));
            if (this.d == null) {
                throw new CodingException("Request is signed, but signature algorithm is missing!");
            }
            BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object3.getComponentAt(1);
            this.c = (byte[])bIT_STRING.getValue();
            if (this.c == null) {
                throw new CodingException("Request is signed, but signature value is missing!");
            }
            if (aSN1Object3.countComponents() == 3) {
                this.l = (X509Certificate[])ASN.parseSequenceOf((ASN1Object)aSN1Object3.getComponentAt(2).getValue(), k != null ? k : (k = OCSPRequest.a("iaik.x509.X509Certificate")));
            }
            this.h = false;
        }
        this.g.clearASN1Object();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.i == null) {
            return false;
        }
        return this.i.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.i == null) {
            return false;
        }
        return this.i.hasExtensions();
    }

    public int getVersion() {
        return this.a;
    }

    public byte[] getTBSRequest() throws CodingException {
        try {
            if (this.g != null && this.g.toByteArray() != null) {
                return this.g.getFirstObject();
            }
            return DerCoder.encode(this.a());
        }
        catch (OCSPException oCSPException) {
            throw new CodingException(oCSPException.toString());
        }
    }

    public AlgorithmID getSignatureAlgorithm() {
        return this.d;
    }

    public byte[] getSignature() {
        return this.c;
    }

    public GeneralName getRequestorName() {
        return this.e;
    }

    public Request[] getRequestList() {
        return this.f;
    }

    public byte[] getNonce() throws X509ExtensionInitException {
        Nonce nonce = (Nonce)this.getExtension(Nonce.oid);
        if (nonce == null) {
            return null;
        }
        return nonce.getValue();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        if (this.i == null) {
            return null;
        }
        return this.i.getExtension(objectID);
    }

    public byte[] getEncoded() throws CodingException {
        if (this.h && this.c != null) {
            throw new RuntimeException("Cannot encode this request. First it has to be resigned.");
        }
        if (this.c == null && this.g.toByteArray() == null) {
            try {
                this.b();
            }
            catch (OCSPException oCSPException) {
                throw new CodingException(oCSPException.getMessage());
            }
        }
        return this.g.toByteArray();
    }

    public X509Certificate[] getCertifcates() {
        return this.l;
    }

    public ObjectID[] getAccepatableResponseTypes() throws X509ExtensionInitException {
        AcceptableResponses acceptableResponses = (AcceptableResponses)this.getExtension(AcceptableResponses.oid);
        if (acceptableResponses == null) {
            return null;
        }
        return acceptableResponses.getAcceptableResponseTypes();
    }

    public void decode(byte[] byArray) throws CodingException {
        try {
            this.g = new ASN1(byArray);
            this.c();
            return;
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException(x509ExtensionException.getMessage());
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        try {
            this.g = new ASN1(inputStream);
            this.c();
            return;
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new IOException(x509ExtensionException.getMessage());
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.getMessage());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.g = new ASN1(aSN1Object);
        try {
            this.c();
            return;
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    private void b() throws OCSPException {
        try {
            this.a();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.a());
            this.g = new ASN1(sEQUENCE);
            return;
        }
        catch (CodingException codingException) {
            throw new OCSPException(codingException.getMessage());
        }
    }

    private ASN1Object a() throws OCSPException {
        if (this.f == null || this.f.length == 0) {
            throw new OCSPException("No single requests set!");
        }
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (this.a > 1) {
                sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.a - 1)));
            }
            if (this.e != null) {
                sEQUENCE.addComponent(new CON_SPEC(1, this.e.toASN1Object()));
            }
            sEQUENCE.addComponent(ASN.createSequenceOf(this.f));
            if (this.i != null) {
                sEQUENCE.addComponent(new CON_SPEC(2, this.i.toASN1Object()));
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new OCSPException(exception.getMessage());
        }
    }

    public int countRequests() {
        return this.f.length;
    }

    public int countExtensions() {
        if (this.i == null) {
            return 0;
        }
        return this.i.countExtensions();
    }

    public boolean containsSignature() {
        return this.c != null;
    }

    public boolean containsCertificates() {
        return this.l != null && this.l.length > 0;
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.i == null) {
            this.i = new OCSPExtensions();
        }
        this.i.addExtension(v3Extension);
        this.h = true;
    }

    public OCSPRequest(byte[] byArray) throws CodingException {
        this();
        this.decode(byArray);
    }

    public OCSPRequest(InputStream inputStream) throws IOException {
        this();
        this.decode(inputStream);
    }

    public OCSPRequest() {
    }
}

