/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.auth;

import com.metamatrix.sequelink.auth.MGSSContext;
import com.metamatrix.sequelink.auth.MGSSCredential;
import com.metamatrix.sequelink.auth.MGSSException;
import com.metamatrix.sequelink.auth.MGSSProvider;
import com.metamatrix.sequelink.auth.MGSSToken;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.util.Properties;

public class MGSSHandle {
    public static final int MGSS_SECCNTXT_STATE_UNDERCONSTRUCTION = 1;
    public static final int MGSS_SECCNTXT_STATE_OK = 2;
    public static final int MGSS_SECCNTXT_STATE_ERROR = 3;
    private String mechanism;
    private MGSSProvider provider;
    private MGSSContext securityContext;
    private MGSSCredential credentials;
    private int state = 1;
    private Properties attributes;

    MGSSHandle(MGSSProvider mGSSProvider, String string) throws MGSSException {
        this.provider = mGSSProvider;
        this.mechanism = string;
    }

    public MGSSToken establishClientContext(StringBuffer stringBuffer, String string, MGSSToken mGSSToken) throws MGSSException {
        try {
            if (this.credentials == null) {
                this.credentials = this.provider.acquireCredential(stringBuffer, this.mechanism, 1);
                this.securityContext = this.provider.getSecContext(this.mechanism, 1);
                if (this.attributes != null) {
                    this.securityContext.setAttribs(this.attributes);
                }
            }
            MGSSToken mGSSToken2 = null;
            switch (this.state) {
                case 1: {
                    mGSSToken2 = this.securityContext.initSecContext(this.credentials, string, mGSSToken);
                    if (!this.securityContext.isEstablished()) break;
                    this.state = 2;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new MGSSException(8);
                }
            }
            return mGSSToken2;
        }
        catch (MGSSException mGSSException) {
            this.state = 3;
            throw mGSSException;
        }
    }

    public MGSSToken establishServerContext(StringBuffer stringBuffer, String string, MGSSToken mGSSToken) throws MGSSException {
        throw new MGSSException(19);
    }

    public boolean isEstablished() throws MGSSException {
        return this.state == 2;
    }

    public void setAttribs(Properties properties) throws MGSSException {
        this.attributes = properties;
    }

    public Properties getAttribs() throws MGSSException {
        return this.securityContext.getAttribs();
    }

    public void streamToken(SspOutputStream sspOutputStream, MGSSToken mGSSToken) throws IOException, UtilException {
        this.securityContext.streamToken(sspOutputStream, mGSSToken);
    }

    public MGSSToken unstreamToken(SspInputStream sspInputStream) throws IOException, MGSSException, UtilException {
        return this.securityContext.unstreamToken(sspInputStream);
    }

    public String getMechanism() {
        return this.mechanism;
    }
}

