/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import COM.rsa.jsafe.JSAFE_InvalidKeyException;
import COM.rsa.jsafe.JSAFE_PublicKey;
import COM.rsa.jsafe.JSAFE_UnimplementedException;
import com.metamatrix.sequelink.security.Message;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

final class JSafeRSAPublicKey
implements RSAPublicKey {
    private static final String JSAFE_RSA_PUBLICKEY_FORMAT = "RSAPublicKey";
    private static final String JSAFE_RSA_ENC_PUBLICKEY_FORMAT = "RSAPublicKeyBER";
    private static final String JSAFE_RSA_KEY_ALG = "RSA";
    private static final String JSAFE_DEVICE = "Java";
    private JSAFE_PublicKey publicKey;
    private BigInteger modulus;
    private BigInteger publicExponent;

    JSafeRSAPublicKey(RSAPublicKeySpec rSAPublicKeySpec) {
        this.modulus = rSAPublicKeySpec.getModulus();
        this.publicExponent = rSAPublicKeySpec.getPublicExponent();
        try {
            this.publicKey = JSAFE_PublicKey.getInstance((String)JSAFE_RSA_KEY_ALG, (String)JSAFE_DEVICE);
            byte[][] byArrayArray = new byte[][]{this.modulus.toByteArray(), this.publicExponent.toByteArray()};
            this.publicKey.setKeyData(JSAFE_RSA_PUBLICKEY_FORMAT, (byte[][])byArrayArray);
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(Message.Gen.getException(7648, jSAFE_UnimplementedException.toString()));
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(Message.Gen.getException(7648, jSAFE_InvalidKeyException.toString()));
        }
    }

    JSafeRSAPublicKey(X509EncodedKeySpec x509EncodedKeySpec) throws InvalidKeySpecException {
        try {
            ASN1 aSN1 = new ASN1(x509EncodedKeySpec.getEncoded());
            ASN1Object aSN1Object = aSN1.toASN1Object();
            if (!(aSN1Object instanceof SEQUENCE)) {
                throw new InvalidKeySpecException(Message.Gen.getException(7662));
            }
            if (!((aSN1Object = ((SEQUENCE)aSN1Object).getComponentAt(1)) instanceof BIT_STRING)) {
                throw new InvalidKeySpecException(Message.Gen.getException(7662));
            }
            byte[] byArray = (byte[])((BIT_STRING)aSN1Object).getValue();
            aSN1 = new ASN1(byArray);
            if (!((aSN1Object = aSN1.toASN1Object()) instanceof SEQUENCE)) {
                throw new InvalidKeySpecException(Message.Gen.getException(7662));
            }
            ASN1Object aSN1Object2 = ((SEQUENCE)aSN1Object).getComponentAt(0);
            ASN1Object aSN1Object3 = ((SEQUENCE)aSN1Object).getComponentAt(1);
            if (!(aSN1Object2 instanceof INTEGER) || !(aSN1Object3 instanceof INTEGER)) {
                throw new InvalidKeySpecException(Message.Gen.getException(7662));
            }
            this.modulus = (BigInteger)((INTEGER)aSN1Object2).getValue();
            this.publicExponent = (BigInteger)((INTEGER)aSN1Object3).getValue();
            this.publicKey = JSAFE_PublicKey.getInstance((String)JSAFE_RSA_KEY_ALG, (String)JSAFE_DEVICE);
            byte[][] byArrayArray = new byte[][]{this.modulus.toByteArray(), this.publicExponent.toByteArray()};
            this.publicKey.setKeyData(JSAFE_RSA_PUBLICKEY_FORMAT, (byte[][])byArrayArray);
        }
        catch (CodingException codingException) {
            throw new InvalidKeySpecException(Message.Gen.getException(7663, codingException.toString()));
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(Message.Gen.getException(7648, jSAFE_UnimplementedException.toString()));
        }
        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
            throw new RuntimeException(Message.Gen.getException(7648, jSAFE_InvalidKeyException.toString()));
        }
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String getAlgorithm() {
        return JSAFE_RSA_KEY_ALG;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        try {
            byte[][] byArray = this.publicKey.getKeyData(JSAFE_RSA_ENC_PUBLICKEY_FORMAT);
            return byArray[0];
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            throw new RuntimeException(Message.Gen.getException(7648, jSAFE_UnimplementedException.toString()));
        }
    }

    JSAFE_PublicKey getJSafePublicKey() {
        return this.publicKey;
    }
}

