/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import com.metamatrix.sequelink.SLException;
import com.metamatrix.sequelink.security.Message;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;

public class PKCS8 {
    private static final String NL = System.getProperty("line.separator");

    private PKCS8() {
    }

    public static void cryptStream(InputStream inputStream, OutputStream outputStream, String string, boolean bl) throws SLException {
        try {
            if (bl) {
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(inputStream);
                PrivateKey privateKey = encryptedPrivateKeyInfo.decrypt(string);
                outputStream.write(privateKey.getEncoded());
                inputStream.close();
                outputStream.close();
            } else {
                PrivateKey privateKey = PKCS8.inputPrivateKey(inputStream);
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(privateKey);
                encryptedPrivateKeyInfo.encrypt(string, AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC, null);
                outputStream.write(encryptedPrivateKeyInfo.getEncoded());
                inputStream.close();
                outputStream.close();
            }
        }
        catch (Exception exception) {
            throw PKCS8.makeSLException(7645, exception);
        }
        finally {
            string = null;
            System.gc();
        }
    }

    private static SLException makeSLException(int n2, Exception exception) {
        String string = Message.Gen.getException(n2);
        if (exception != null) {
            string = string + NL + exception;
        }
        return new SLException(string, n2);
    }

    private static PrivateKey inputPrivateKey(InputStream inputStream) throws IOException, CodingException, InvalidKeyException {
        ASN1 aSN1 = new ASN1(inputStream);
        ASN1Object aSN1Object = aSN1.toASN1Object();
        return PrivateKeyInfo.getPrivateKey((ASN1Object)aSN1Object);
    }
}

