/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.utils.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;

public final class NumberTheory {
    private static final long c = 58642669L;
    private static final long d = 111546435L;
    private static final BigInteger a;
    private static BigInteger[] b;
    public static final BigInteger TWO;
    public static final BigInteger ONE;
    public static final BigInteger ZERO;

    public static BigInteger nextPrime(BigInteger bigInteger) {
        bigInteger = bigInteger.setBit(0);
        while (!NumberTheory.isProbablePrime(bigInteger)) {
            bigInteger = bigInteger.add(TWO);
        }
        return bigInteger;
    }

    public static boolean millerRabin(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength();
        int n3 = n2 <= 500 ? (n2 <= 100 ? 27 : (n2 <= 150 ? 18 : (n2 <= 200 ? 15 : (n2 <= 250 ? 12 : (n2 <= 300 ? 9 : (n2 <= 350 ? 8 : (n2 <= 400 ? 7 : 6))))))) : (n2 <= 600 ? 5 : (n2 <= 800 ? 4 : (n2 <= 1250 ? 3 : 2)));
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        BigInteger bigInteger3 = BigInteger.valueOf(2L);
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2);
        int n4 = bigInteger4.getLowestSetBit();
        BigInteger bigInteger5 = bigInteger4.shiftRight(n4);
        BigInteger bigInteger6 = bigInteger.subtract(BigInteger.valueOf(4L));
        Random random = new Random();
        int n5 = 1;
        while (n5 <= n3) {
            BigInteger bigInteger7 = new BigInteger(n2 + 4, random);
            BigInteger bigInteger8 = (bigInteger7 = bigInteger7.mod(bigInteger6).add(bigInteger3)).modPow(bigInteger5, bigInteger);
            if (bigInteger8.compareTo(bigInteger2) != 0 && bigInteger8.compareTo(bigInteger4) != 0) {
                int n6 = 1;
                while (n6 <= n4 - 1 && (n6 == 1 || bigInteger8.compareTo(bigInteger4) != 0)) {
                    if ((bigInteger8 = bigInteger8.modPow(bigInteger3, bigInteger)).compareTo(bigInteger2) == 0) {
                        return false;
                    }
                    ++n6;
                }
                if (bigInteger8.compareTo(bigInteger4) != 0) {
                    return false;
                }
            }
            ++n5;
        }
        return true;
    }

    public static boolean isProbablePrime(BigInteger bigInteger) {
        if (bigInteger.compareTo(ONE) <= 0) {
            return false;
        }
        if (NumberTheory.hasSmallFactors(bigInteger)) {
            return false;
        }
        return NumberTheory.millerRabin(bigInteger);
    }

    public static boolean hasSmallFactors(BigInteger bigInteger) {
        if (!bigInteger.testBit(0)) {
            return true;
        }
        if (bigInteger.bitLength() < 59) {
            return false;
        }
        long l2 = bigInteger.mod(a).longValue();
        int n2 = (int)(l2 % 111546435L);
        if (n2 % 3 == 0 || n2 % 5 == 0 || n2 % 7 == 0 || n2 % 11 == 0 || n2 % 13 == 0 || n2 % 17 == 0 || n2 % 19 == 0 || n2 % 23 == 0) {
            return true;
        }
        int n3 = (int)(l2 % 58642669L);
        if (n3 % 29 == 0 || n3 % 31 == 0 || n3 % 37 == 0 || n3 % 41 == 0 || n3 % 43 == 0) {
            return true;
        }
        int n4 = 13;
        while (n4 < b.length) {
            if (bigInteger.mod(b[n4]).signum() == 0) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public static BigInteger getStrongPrime(int n2, Random random) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = ZERO.setBit(511 + 128 * n2);
        BigDecimal bigDecimal = new BigDecimal(Math.sqrt(2.0));
        BigInteger bigInteger3 = new BigDecimal(bigInteger2).multiply(bigDecimal).toBigInteger();
        while ((bigInteger = new BigInteger(512 + 128 * n2, random)).compareTo(bigInteger3) == -1) {
        }
        BigInteger bigInteger4 = NumberTheory.nextPrime(new BigInteger(101, random));
        BigInteger bigInteger5 = NumberTheory.nextPrime(new BigInteger(101, random));
        BigInteger bigInteger6 = bigInteger5.modInverse(bigInteger4).multiply(bigInteger5).subtract(bigInteger4.modInverse(bigInteger5).multiply(bigInteger4));
        BigInteger bigInteger7 = bigInteger4.multiply(bigInteger5);
        BigInteger bigInteger8 = bigInteger.add(bigInteger6.subtract(bigInteger).mod(bigInteger7));
        while (!NumberTheory.isProbablePrime(bigInteger8)) {
            bigInteger8 = bigInteger8.add(bigInteger7);
        }
        return bigInteger8;
    }

    public static int gcd(int n2, int n3) {
        while (n3 != 0) {
            int n4 = n2 % n3;
            n2 = n3;
            n3 = n4;
        }
        return n2;
    }

    public static int[] extGcd(int n2, int n3) {
        if (n3 == 0) {
            int[] nArray = new int[3];
            nArray[0] = n2;
            nArray[1] = 1;
            return nArray;
        }
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        while (n3 > 0) {
            int n8 = n2 / n3;
            int n9 = n2 - n8 * n3;
            int n10 = n4 - n8 * n5;
            int n11 = n6 - n8 * n7;
            n2 = n3;
            n3 = n9;
            n4 = n5;
            n5 = n10;
            n6 = n7;
            n7 = n11;
        }
        return new int[]{n2, n4, n6};
    }

    private NumberTheory() {
    }

    static {
        ZERO = BigInteger.valueOf(0L);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        a = BigInteger.valueOf(6541380665835015L);
        String string = "AAMABQAHAAsADQARABMAFwAdAB8AJQApACsALwA1ADsAPQBDAEcASQBPAFMAWQBhAGUAZwBrAG0AcQB/AIMAiQCLAJUAlwCdAKMApwCtALMAtQC/AMEAxQDHANMA3wDjAOUA6QDvAPEA+wEBAQcBDQEPARUBGQEbASUBMwE3ATkBPQFLAVEBWwFdAWEBZwFvAXUBewF/AYUBjQGRAZkBowGlAa8BsQG3AbsBwQHJAc0BzwHTAd8B5wHrAfMB9wH9AgkCCwIdAiMCLQIzAjkCOwJBAksCUQJXAlkCXwJlAmkCawJ3AoECgwKHAo0CkwKVAqECpQKrArMCvQLFAs8C1w==";
        byte[] byArray = Util.decodeByteArray(string);
        int n2 = byArray.length >> 1;
        b = new BigInteger[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = byArray[n4] & 0xFF;
            n5 = n5 << 8 | byArray[n4 + 1] & 0xFF;
            NumberTheory.b[n3] = BigInteger.valueOf(n5);
            ++n3;
            n4 += 2;
        }
    }
}

