/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.client;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.platform.client.ClientSideLogon;
import com.metamatrix.common.util.NetUtils;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.proxy.SecurityContext;
import com.metamatrix.platform.security.api.Credentials;
import com.metamatrix.platform.security.api.FindResourcesRequest;
import com.metamatrix.platform.security.api.ILogon;
import com.metamatrix.platform.security.api.LogonResult;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;

public class ClientSideLogonImpl
implements ClientSideLogon {
    private static final String QUERY_SERVICE_PROP = "QueryService";
    private Properties connProps;
    private String serviceType;
    private MetaMatrixSessionID sessionID;
    private ILogon remoteProxy;
    private Properties originalConnProps;

    public ClientSideLogonImpl(Properties connProps, ILogon proxy) {
        this.originalConnProps = PropertiesUtils.clone((Properties)connProps);
        this.connProps = connProps;
        this.remoteProxy = proxy;
        this.serviceType = connProps.getProperty("serviceType", QUERY_SERVICE_PROP);
        Object payload = connProps.get("clientToken");
        if (payload != null) {
            this.connProps.put("trustedPayload", payload);
        }
    }

    public LogonResult logon(String productName, FindResourcesRequest findResourcesRequest) throws CommunicationException, ConnectionException {
        String vdbName = this.connProps.getProperty("VirtualDatabaseName");
        String vdbVersion = this.connProps.getProperty("VirtualDatabaseVersion");
        String[] productInfo = new String[4];
        productInfo[0] = vdbName;
        productInfo[1] = vdbVersion;
        try {
            productInfo[2] = NetUtils.getHostAddress();
        }
        catch (UnknownHostException err1) {
            productInfo[2] = "UnknownClientAddress";
        }
        try {
            productInfo[3] = NetUtils.getHostname();
        }
        catch (UnknownHostException err) {
            productInfo[3] = "UnknownClientHost";
        }
        String applicationName = this.connProps.getProperty("ApplicationName", "JDBC API");
        String user = this.connProps.getProperty("user");
        String password = this.connProps.getProperty("password");
        Object objTrustedToken = this.connProps.get("trustedPayload");
        return this.logon(productInfo, applicationName, user, password, objTrustedToken, productName, findResourcesRequest);
    }

    private LogonResult logon(String[] productInfo, String applicationName, String user, String password, Object objTrustedToken, String productName, FindResourcesRequest findResourcesRequest) throws CommunicationException, ConnectionException {
        this.connProps.remove("connectionID");
        Serializable trustedToken = null;
        if (objTrustedToken != null && objTrustedToken instanceof Serializable) {
            trustedToken = (Serializable)objTrustedToken;
        }
        Credentials credential = null;
        if (password != null) {
            credential = new Credentials(password.toCharArray());
        }
        LogonResult logonResult = null;
        try {
            logonResult = this.remoteProxy.logon(user, credential, trustedToken, applicationName, productName, productInfo, findResourcesRequest);
            this.sessionID = logonResult.getSessionID();
        }
        catch (LogonException e) {
            throw new ConnectionException((Throwable)e, e.getMessage());
        }
        catch (ComponentNotFoundException e) {
            throw new CommunicationException((Throwable)e, CommPlatformPlugin.Util.getString("PlatformServerConnectionFactory.Unable_to_find_a_component_used_in_logging_on_to_MetaMatrix"));
        }
        catch (RemoteException e) {
            throw new CommunicationException((Throwable)e, CommPlatformPlugin.Util.getString("PlatformServerConnectionFactory.Error_communicating_with_app_server"));
        }
        String vdbName = this.sessionID.getProductInfo(0);
        if (vdbName != null) {
            this.connProps.setProperty("VirtualDatabaseName", vdbName);
            this.connProps.setProperty("VirtualDatabaseVersion", this.sessionID.getProductInfo(1));
            this.connProps.setProperty("vdbName", vdbName);
            this.connProps.setProperty("vdbVersion", this.sessionID.getProductInfo(1));
            if (this.originalConnProps.getProperty("vdbVersion") == null || this.originalConnProps.getProperty("vdbVersion").length() == 0) {
                this.originalConnProps.setProperty("vdbVersion", this.sessionID.getProductInfo(1));
            }
        }
        this.connProps.setProperty("connectionID", this.sessionID.toString());
        return logonResult;
    }

    public void logoff(MetaMatrixSessionID sessionID) throws ComponentNotFoundException, RemoteException, InvalidSessionException {
        if (this.connProps != null) {
            this.connProps.remove("connectionID");
        }
        this.remoteProxy.logoff(sessionID);
    }

    public MetaMatrixSessionID getSessionId() {
        return this.sessionID;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public SecurityContext getSecurityContext() {
        return new SecurityContext(this.connProps.getProperty("user"), this.sessionID.toString());
    }
}

