/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplClob;
import com.metamatrix.jdbc.slbase.BaseImplClobService;
import com.metamatrix.slutil.UtilDebug;
import java.sql.SQLException;

public class BaseImplClobCached
extends BaseImplClobService {
    private int cacheStartOffset = -1;
    private int cacheEndOffset = -1;
    private byte[] cachedData = null;
    private int bytesPerChar = BaseImplClob.getBytesPerChar(this);

    public BaseImplClobCached(BaseImplClob baseImplClob, BaseExceptions baseExceptions) {
        super(baseImplClob, baseExceptions);
    }

    public int readData(byte[] byArray, int n2, long l2, int n3) throws SQLException {
        this.fetchDataToCache(l2, n3);
        int n4 = new Long(l2).intValue() * this.bytesPerChar;
        int n5 = n3 * this.bytesPerChar;
        System.arraycopy(this.cachedData, n4, byArray, n2, n5);
        return n5;
    }

    protected byte[] getCachedData() {
        return this.cachedData;
    }

    protected void fetchDataToCache(long l2, int n2) throws SQLException {
        UtilDebug.assert("clobOffset must be positive", l2 > 0L);
        UtilDebug.assert("numCharsToRead must be non-negative", n2 >= 0);
        this.createCacheBuffer();
        if (l2 + (long)n2 > (long)(Integer.MAX_VALUE / this.bytesPerChar)) {
            throw this.exceptions.getException(6066);
        }
        int n3 = new Long(l2).intValue();
        int n4 = new Long(l2 + (long)n2).intValue();
        int n5 = n3 * this.bytesPerChar;
        int n6 = n4 * this.bytesPerChar;
        if (this.cacheStartOffset == -1 || this.cacheEndOffset == -1) {
            UtilDebug.assert("Invalid Cache State", this.cacheStartOffset == -1 && this.cacheEndOffset == -1);
            int n7 = n4 - n3;
            if (n7 > 0) {
                this.subImplClob.readData(this.cachedData, n5, n3, n7);
                this.cacheStartOffset = n5;
                this.cacheEndOffset = n6 - 1;
            }
        } else {
            int n8;
            if (n5 < this.cacheStartOffset && (n8 = (this.cacheStartOffset - n5) / this.bytesPerChar) > 0) {
                this.subImplClob.readData(this.cachedData, n5, n3, n8);
                this.cacheStartOffset = n5;
            }
            if (n6 > this.cacheEndOffset) {
                n5 = this.cacheEndOffset + 1;
                n3 = n5 / this.bytesPerChar;
                n8 = (n6 - n5) / this.bytesPerChar;
                if (n8 > 0) {
                    this.subImplClob.readData(this.cachedData, n5, n3, n8);
                    this.cacheEndOffset = n6 - 1;
                }
            }
        }
    }

    private void createCacheBuffer() throws SQLException {
        if (this.cachedData == null) {
            int n2;
            try {
                n2 = new Long(this.getLength()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6066);
            }
            this.cachedData = new byte[(n2 + 1) * this.bytesPerChar];
        }
    }
}

