/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.ctxt.conn;

import com.metamatrix.sequelink.ctxt.Context;
import com.metamatrix.sequelink.ctxt.CtxtAttributes;
import com.metamatrix.sequelink.ctxt.PidList;
import com.metamatrix.sequelink.ctxt.conn.ConnectionContext;
import com.metamatrix.sequelink.describe.IntegerVariableDescriptor;
import com.metamatrix.sequelink.describe.StringVariableDescriptor;
import com.metamatrix.sequelink.describe.VariableDescriptor;
import com.metamatrix.sequelink.ssp.AttribList;
import com.metamatrix.sequelink.ssp.CodecChainedPacket;
import com.metamatrix.sequelink.ssp.CodecDefineDescribe;
import com.metamatrix.sequelink.ssp.CodecGetLobData;
import com.metamatrix.sequelink.ssp.CodecGetLobLength;
import com.metamatrix.sequelink.ssp.CodecGetLobPosition;
import com.metamatrix.sequelink.ssp.CodecGetSettings;
import com.metamatrix.sequelink.ssp.CodecLobTruncate;
import com.metamatrix.sequelink.ssp.CodecLogon;
import com.metamatrix.sequelink.ssp.CodecLogonForXa;
import com.metamatrix.sequelink.ssp.CodecNImmediate;
import com.metamatrix.sequelink.ssp.CodecSavepoint;
import com.metamatrix.sequelink.ssp.CodecSetLobData;
import com.metamatrix.sequelink.ssp.CodecXaRecover;
import com.metamatrix.sequelink.ssp.CodecXaXainfo;
import com.metamatrix.sequelink.ssp.CodecXaXid;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.GetSetting;
import com.metamatrix.sequelink.ssp.IntegerGetSetting;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.SlXid;
import com.metamatrix.sequelink.ssp.SspLob;
import com.metamatrix.sequelink.ssp.StringGetSetting;
import com.metamatrix.sequelink.util.SlXaException;
import com.metamatrix.sequelink.util.UnSyncVector;
import com.metamatrix.slutil.UtilTransliterator;
import java.sql.BatchUpdateException;
import java.sql.SQLException;

class SessionContext
extends Context {
    private static final int kSWSEC_ATTRIB_OFFSET = 3000;
    private static final int kSWSEC_ATTRIB_UID = 3000;
    private static final int kSWSEC_ATTRIB_PWD = 3001;
    private static final int kSWSEC_ATTRIB_DBUID = 3005;
    private static final int kSWSEC_ATTRIB_DBPWD = 3006;
    ConnectionContext conCtxt;
    CtxtAttributes ctxtAttr;
    PidList pidCache;
    VariableDescriptor[] cursorDescriptors;
    VariableDescriptor[] paramDescriptors;
    int describeParam;

    SessionContext(ConnectionContext connectionContext, boolean bl, CtxtAttributes ctxtAttributes, AttribList attribList, DiagnosticList diagnosticList) throws SQLException {
        this.conCtxt = connectionContext;
        this.ctxtAttr = ctxtAttributes;
        this.ssp = connectionContext.getSsp();
        this.chain = this.ssp.getChain();
        this.type = 2;
        this.logon(bl, attribList, diagnosticList);
        this.doInitialProvides(diagnosticList);
        this.defineDescribe(diagnosticList);
    }

    private void logon(boolean bl, AttribList attribList, DiagnosticList diagnosticList) throws SQLException {
        AttribList attribList2 = new AttribList();
        if (attribList.checkPair(77, "DBMSLogon(UID,PWD)")) {
            String string = this.ctxtAttr.getUser();
            String string2 = this.ctxtAttr.getPassword();
            if (string == null || string2 == null) {
                StringBuffer stringBuffer = new StringBuffer();
                if (string == null) {
                    stringBuffer.append("USER");
                    stringBuffer.append(" ");
                }
                if (string2 == null) {
                    stringBuffer.append("PASSWORD");
                }
                throw Message.Gen.getSqlException(7401, stringBuffer.toString());
            }
            attribList2.addStringEncrypted(3000, string);
            attribList2.addStringEncrypted(3001, string2);
        } else if (attribList.checkPair(77, "DBMSLogon(DBUID,DBPWD)")) {
            String string = this.ctxtAttr.getDBUser();
            String string3 = this.ctxtAttr.getDBPassword();
            if (string == null || string3 == null) {
                StringBuffer stringBuffer = new StringBuffer();
                if (string == null) {
                    stringBuffer.append("DBUSER");
                    stringBuffer.append(" ");
                }
                if (string3 == null) {
                    stringBuffer.append("DBPASSWORD");
                }
                throw Message.Gen.getSqlException(7401, stringBuffer.toString());
            }
            attribList2.addStringEncrypted(3005, string);
            attribList2.addStringEncrypted(3006, string3);
        }
        String string = this.ctxtAttr.getDatabaseName();
        if (string != null) {
            attribList2.addString(36, string);
        }
        if (bl && this.ssp.getSspVersion() >= 8) {
            CodecLogonForXa codecLogonForXa = this.ssp.getCodecLogonForXa(attribList2, this);
            this.chain.add(codecLogonForXa);
            this.chain.send(diagnosticList);
            int n2 = codecLogonForXa.getXaRetCode();
            if (n2 != 0) {
                throw Message.Gen.getSqlException(7439, String.valueOf(n2));
            }
        } else {
            CodecLogon codecLogon = this.ssp.getCodecLogon(attribList2, this);
            this.chain.add(codecLogon);
            this.chain.send(diagnosticList);
        }
        this.isActive = true;
    }

    public void deactivate(DiagnosticList diagnosticList) throws SQLException {
        this.chain.flush(diagnosticList);
        this.isActive = false;
        CodecChainedPacket codecChainedPacket = this.ssp.getCodecLogoff(this);
        this.chain.add(codecChainedPacket);
        this.chain.send(diagnosticList);
    }

    private void doInitialProvides(DiagnosticList diagnosticList) throws SQLException {
        GetSetting getSetting;
        int n2;
        int n3;
        int[] nArray = new int[]{11014, 11100, 11101, 11102, 11103, 11104, 11105, 11106, 11107, 11108, 11109, 11110, 11111, 11112, 11113, 11114, 11115, 11116, 11117, 11118, 11119, 11120, 11121, 11122, 11123, 11124, 11125, 11126, 11127, 11131, 11132, 11144, 11145, 11146, 11147, 11148, 11149, 11150, 11151, 11152, 11153, 11154, 11157, 11162, 11163, 11165, 11166, 11167, 11168, 11201, 11205, 11206, 11207, 11226, 11229, 11230, 11231, 11232, 11233, 11234, 11236, 11237, 11238, 11239, 11240, 11241, 11244, 11246, 11249, 11275, 11276, 11026, 11029, 11251};
        int[] nArray2 = new int[]{11129, 11130, 11133, 11156, 11158, 11159, 11160, 11161, 11169, 11228, 11245, 11027};
        int[] nArray3 = new int[]{11216, 11400, 11401, 11402, 11403, 11404, 11405, 11406};
        int[] nArray4 = new int[]{11280, 11278, 11279};
        int[] nArray5 = new int[]{11277};
        int n4 = 0;
        int n5 = nArray.length + nArray2.length;
        if (this.ssp.getServerVersion() >= 0x5030000) {
            n5 += nArray3.length;
        }
        if (this.ssp.getServerVersion() >= 0x5040000) {
            n5 += nArray4.length + nArray5.length;
        }
        GetSetting[] getSettingArray = new GetSetting[n5];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            getSettingArray[n4++] = new IntegerGetSetting(nArray[n3]);
        }
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            getSettingArray[n4++] = new StringGetSetting(nArray2[n3]);
        }
        if (this.ssp.getServerVersion() >= 0x5030000) {
            for (n3 = 0; n3 < nArray3.length; ++n3) {
                getSettingArray[n4++] = new IntegerGetSetting(nArray3[n3]);
            }
        }
        if (this.ssp.getServerVersion() >= 0x5040000) {
            for (n3 = 0; n3 < nArray4.length; ++n3) {
                getSettingArray[n4++] = new IntegerGetSetting(nArray4[n3]);
            }
            for (n3 = 0; n3 < nArray5.length; ++n3) {
                getSettingArray[n4++] = new StringGetSetting(nArray5[n3]);
            }
        }
        CodecGetSettings codecGetSettings = this.ssp.getCodecGetSettings(getSettingArray, this);
        this.chain.add(codecGetSettings);
        this.chain.send(diagnosticList);
        this.pidCache = new PidList(100, this);
        n4 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            getSetting = getSettingArray[n4++];
            this.pidCache.put(new Integer(getSetting.getId()), getSetting.getInfo());
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            getSetting = getSettingArray[n4++];
            this.pidCache.put(new Integer(getSetting.getId()), getSetting.getInfo());
        }
        if (this.ssp.getServerVersion() >= 0x5030000) {
            for (n2 = 0; n2 < nArray3.length; ++n2) {
                getSetting = getSettingArray[n4++];
                this.pidCache.put(new Integer(getSetting.getId()), getSetting.getInfo());
            }
        } else {
            Integer n6 = new Integer(0);
            for (int i2 = 0; i2 < nArray3.length; ++i2) {
                this.pidCache.put(new Integer(nArray3[i2]), n6);
            }
        }
        if (this.ssp.getServerVersion() >= 0x5040000) {
            int n7;
            for (n7 = 0; n7 < nArray4.length; ++n7) {
                GetSetting getSetting2 = getSettingArray[n4++];
                this.pidCache.put(new Integer(getSetting2.getId()), getSetting2.getInfo());
            }
            for (n7 = 0; n7 < nArray5.length; ++n7) {
                GetSetting getSetting3 = getSettingArray[n4++];
                this.pidCache.put(new Integer(getSetting3.getId()), getSetting3.getInfo());
            }
        } else {
            int n8;
            Integer n9 = new Integer(0);
            for (n8 = 0; n8 < nArray4.length; ++n8) {
                this.pidCache.put(new Integer(nArray4[n8]), n9);
            }
            for (n8 = 0; n8 < nArray5.length; ++n8) {
                this.pidCache.put(new Integer(nArray5[n8]), "");
            }
            this.pidCache.put(new Integer(11280), new Integer(1));
        }
    }

    private void defineDescribe(DiagnosticList diagnosticList) throws SQLException {
        VariableDescriptor[] variableDescriptorArray;
        Object object;
        IntegerVariableDescriptor integerVariableDescriptor = new IntegerVariableDescriptor(1);
        IntegerVariableDescriptor integerVariableDescriptor2 = new IntegerVariableDescriptor(2);
        StringVariableDescriptor stringVariableDescriptor = new StringVariableDescriptor(3, this.pidCache.getPidInt(11148, diagnosticList));
        IntegerVariableDescriptor integerVariableDescriptor3 = new IntegerVariableDescriptor(4);
        StringVariableDescriptor stringVariableDescriptor2 = new StringVariableDescriptor(5, this.pidCache.getPidInt(11144, diagnosticList));
        IntegerVariableDescriptor integerVariableDescriptor4 = new IntegerVariableDescriptor(6);
        StringVariableDescriptor stringVariableDescriptor3 = new StringVariableDescriptor(7, this.pidCache.getPidInt(11144, diagnosticList));
        IntegerVariableDescriptor integerVariableDescriptor5 = new IntegerVariableDescriptor(8);
        IntegerVariableDescriptor integerVariableDescriptor6 = new IntegerVariableDescriptor(9);
        StringVariableDescriptor stringVariableDescriptor4 = new StringVariableDescriptor(10, this.pidCache.getPidInt(11146, diagnosticList));
        IntegerVariableDescriptor integerVariableDescriptor7 = new IntegerVariableDescriptor(11);
        StringVariableDescriptor stringVariableDescriptor5 = new StringVariableDescriptor(12, this.pidCache.getPidInt(11149, diagnosticList));
        IntegerVariableDescriptor integerVariableDescriptor8 = new IntegerVariableDescriptor(13);
        StringVariableDescriptor stringVariableDescriptor6 = new StringVariableDescriptor(14, 40);
        IntegerVariableDescriptor integerVariableDescriptor9 = new IntegerVariableDescriptor(15);
        IntegerVariableDescriptor integerVariableDescriptor10 = new IntegerVariableDescriptor(16);
        UtilTransliterator utilTransliterator = this.ssp.getServerVersion() < 0x5040000 ? this.ssp.getDefaultTransliterator() : this.ssp.getAsciiTransliterator();
        StringVariableDescriptor stringVariableDescriptor7 = new StringVariableDescriptor(19, 40, utilTransliterator);
        IntegerVariableDescriptor integerVariableDescriptor11 = new IntegerVariableDescriptor(20);
        if (this.ssp.getServerVersion() >= 0x5030000) {
            object = new VariableDescriptor[]{integerVariableDescriptor, integerVariableDescriptor2, stringVariableDescriptor, integerVariableDescriptor3, stringVariableDescriptor2, integerVariableDescriptor4, stringVariableDescriptor3, integerVariableDescriptor5, integerVariableDescriptor6, stringVariableDescriptor4, integerVariableDescriptor7, stringVariableDescriptor5, integerVariableDescriptor8, stringVariableDescriptor6, integerVariableDescriptor9, integerVariableDescriptor10, stringVariableDescriptor7};
            this.cursorDescriptors = object;
        } else {
            object = new VariableDescriptor[]{integerVariableDescriptor, integerVariableDescriptor2, stringVariableDescriptor, integerVariableDescriptor3, stringVariableDescriptor2, integerVariableDescriptor4, stringVariableDescriptor3, integerVariableDescriptor5, integerVariableDescriptor6, stringVariableDescriptor4, integerVariableDescriptor7, stringVariableDescriptor5, integerVariableDescriptor8, stringVariableDescriptor6, integerVariableDescriptor9, integerVariableDescriptor10};
            this.cursorDescriptors = object;
        }
        object = (Integer)this.pidCache.get(new Integer(11216));
        this.describeParam = (Integer)object;
        if (this.describeParam != 0) {
            variableDescriptorArray = new VariableDescriptor[]{integerVariableDescriptor8, stringVariableDescriptor6, integerVariableDescriptor9, integerVariableDescriptor5, integerVariableDescriptor4, integerVariableDescriptor6, integerVariableDescriptor11, stringVariableDescriptor7};
            this.paramDescriptors = variableDescriptorArray;
            CodecDefineDescribe codecDefineDescribe = this.ssp.getCodecDefineDescribeParam(this.paramDescriptors, this);
            this.chain.add(codecDefineDescribe);
        }
        variableDescriptorArray = this.ssp.getCodecDefineDescribeCursor(this.cursorDescriptors, this);
        this.chain.add((CodecChainedPacket)variableDescriptorArray);
        this.chain.send(diagnosticList);
    }

    void commit(boolean bl, DiagnosticList diagnosticList) throws SQLException {
        CodecChainedPacket codecChainedPacket = this.ssp.getCodecCommit(this);
        this.chain.add(codecChainedPacket);
        if (bl) {
            this.chain.send(diagnosticList);
        }
    }

    void rollback(DiagnosticList diagnosticList) throws SQLException {
        CodecChainedPacket codecChainedPacket = this.ssp.getCodecRollback(this);
        this.chain.add(codecChainedPacket);
        this.chain.send(diagnosticList);
    }

    int[] executeBatch(UnSyncVector unSyncVector, DiagnosticList diagnosticList) throws BatchUpdateException {
        CodecNImmediate codecNImmediate = null;
        if (unSyncVector != null && !unSyncVector.isEmpty()) {
            try {
                codecNImmediate = this.ssp.getCodecNImmediate(unSyncVector, this);
                this.chain.add(codecNImmediate);
                this.chain.send(diagnosticList);
                return codecNImmediate.getUpdateCounts();
            }
            catch (SQLException sQLException) {
                int[] nArray = codecNImmediate != null ? codecNImmediate.getUpdateCounts() : new int[]{};
                BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
                batchUpdateException.setNextException(sQLException.getNextException());
                throw batchUpdateException;
            }
        }
        return new int[0];
    }

    void setSavepoint(String string, DiagnosticList diagnosticList) throws SQLException {
        CodecSavepoint codecSavepoint = this.ssp.getCodecSetSavepoint(this, string);
        this.chain.add(codecSavepoint);
        this.chain.send(diagnosticList);
    }

    void releaseSavepoint(String string, DiagnosticList diagnosticList) throws SQLException {
        CodecSavepoint codecSavepoint = this.ssp.getCodecReleaseSavepoint(this, string);
        this.chain.add(codecSavepoint);
        this.chain.send(diagnosticList);
    }

    void rollbackToSavepoint(String string, DiagnosticList diagnosticList) throws SQLException {
        CodecSavepoint codecSavepoint = this.ssp.getCodecRollbackToSavepoint(this, string);
        this.chain.add(codecSavepoint);
        this.chain.send(diagnosticList);
    }

    void getLobLength(SspLob sspLob, DiagnosticList diagnosticList) throws SQLException {
        CodecGetLobLength codecGetLobLength = this.ssp.getCodecGetLobLength(this, sspLob);
        this.chain.add(codecGetLobLength);
        this.chain.send(diagnosticList);
    }

    int getLobData(SspLob sspLob, byte[] byArray, int n2, long l2, int n3, DiagnosticList diagnosticList) throws SQLException {
        CodecGetLobData codecGetLobData = this.ssp.getCodecGetLobData(this, sspLob, byArray, n2, l2, n3);
        this.chain.add(codecGetLobData);
        this.chain.send(diagnosticList);
        return codecGetLobData.getLengthRead();
    }

    int setLobData(SspLob sspLob, byte[] byArray, int n2, long l2, int n3, DiagnosticList diagnosticList) throws SQLException {
        CodecSetLobData codecSetLobData = this.ssp.getCodecSetLobData(this, sspLob, byArray, n2, l2, n3);
        this.chain.add(codecSetLobData);
        this.chain.send(diagnosticList);
        return codecSetLobData.getLengthWritten();
    }

    public void lobTruncate(SspLob sspLob, long l2, DiagnosticList diagnosticList) throws SQLException {
        CodecLobTruncate codecLobTruncate = this.ssp.getCodecLobTruncate(this, sspLob, l2);
        this.chain.add(codecLobTruncate);
        this.chain.send(diagnosticList);
    }

    long getLobPosition(SspLob sspLob, byte[] byArray, long l2, DiagnosticList diagnosticList) throws SQLException {
        CodecGetLobPosition codecGetLobPosition = this.ssp.getCodecGetLobPosition(this, sspLob, byArray, l2);
        this.chain.add(codecGetLobPosition);
        this.chain.send(diagnosticList);
        return codecGetLobPosition.getPosition();
    }

    public int getServerVersion() {
        return this.ssp.getServerVersion();
    }

    void xa_open(DiagnosticList diagnosticList) throws SQLException {
        if (this.ssp.getSspVersion() >= 8) {
            return;
        }
        CodecXaXainfo codecXaXainfo = this.ssp.getCodecXaOpen(this);
        this.chain.add(codecXaXainfo);
        this.chain.send(diagnosticList);
        int n2 = codecXaXainfo.getXaRetCode();
        if (n2 != 0) {
            throw Message.Gen.getSqlException(7439, String.valueOf(n2));
        }
    }

    void xa_close(DiagnosticList diagnosticList) throws SQLException {
        CodecXaXainfo codecXaXainfo = this.ssp.getCodecXaClose(this);
        this.chain.add(codecXaXainfo);
        this.chain.send(diagnosticList);
        int n2 = codecXaXainfo.getXaRetCode();
        if (n2 != 0) {
            throw Message.Gen.getSqlException(7440, String.valueOf(n2));
        }
    }

    void xa_start(SlXid slXid, int n2) throws SlXaException {
        CodecXaXid codecXaXid;
        try {
            codecXaXid = this.ssp.getCodecXaStart(this, slXid, n2);
            this.chain.add(codecXaXid);
            this.chain.send(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new SlXaException();
        }
        int n3 = codecXaXid.getXaRetCode();
        if (n3 != 0) {
            throw new SlXaException(n3);
        }
    }

    void xa_end(SlXid slXid, int n2) throws SlXaException {
        CodecXaXid codecXaXid;
        try {
            codecXaXid = this.ssp.getCodecXaEnd(this, slXid, n2);
            this.chain.add(codecXaXid);
            this.chain.send(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new SlXaException();
        }
        int n3 = codecXaXid.getXaRetCode();
        if (n3 != 0) {
            throw new SlXaException(n3);
        }
    }

    int xa_prepare(SlXid slXid) throws SlXaException {
        CodecXaXid codecXaXid;
        try {
            codecXaXid = this.ssp.getCodecXaPrepare(this, slXid);
            this.chain.add(codecXaXid);
            this.chain.send(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new SlXaException();
        }
        int n2 = codecXaXid.getXaRetCode();
        if (n2 != 0 && n2 != 3) {
            throw new SlXaException(n2);
        }
        return n2;
    }

    void xa_commit(SlXid slXid, boolean bl) throws SlXaException {
        CodecXaXid codecXaXid;
        int n2;
        try {
            n2 = bl ? 0x40000000 : 0;
            codecXaXid = this.ssp.getCodecXaCommit(this, slXid, n2);
            this.chain.add(codecXaXid);
            this.chain.send(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new SlXaException();
        }
        n2 = codecXaXid.getXaRetCode();
        if (n2 != 0) {
            throw new SlXaException(n2);
        }
    }

    void xa_rollback(SlXid slXid) throws SlXaException {
        CodecXaXid codecXaXid;
        try {
            codecXaXid = this.ssp.getCodecXaRollback(this, slXid);
            this.chain.add(codecXaXid);
            this.chain.send(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new SlXaException();
        }
        int n2 = codecXaXid.getXaRetCode();
        if (n2 != 0) {
            throw new SlXaException(n2);
        }
    }

    void xa_forget(SlXid slXid) throws SlXaException {
        CodecXaXid codecXaXid;
        try {
            codecXaXid = this.ssp.getCodecXaForget(this, slXid);
            this.chain.add(codecXaXid);
            this.chain.send(DiagnosticList.GetADummyList());
        }
        catch (SQLException sQLException) {
            throw new SlXaException();
        }
        int n2 = codecXaXid.getXaRetCode();
        if (n2 != 0) {
            throw new SlXaException(n2);
        }
    }

    SlXid[] xa_recover(int n2) throws SlXaException {
        SlXid[] slXidArray;
        try {
            SlXid[] slXidArray2;
            int n3 = 0x1000000;
            CodecXaRecover codecXaRecover = this.ssp.getCodecXaRecover(this, n3);
            this.chain.add(codecXaRecover);
            this.chain.send(DiagnosticList.GetADummyList());
            int n4 = codecXaRecover.getXaRetCode();
            if (n4 < 0) {
                throw new SlXaException(n4);
            }
            slXidArray = slXidArray2 = codecXaRecover.getXids();
            while (slXidArray2.length == codecXaRecover.getBatchSize()) {
                n3 = 0;
                codecXaRecover = this.ssp.getCodecXaRecover(this, n3);
                this.chain.add(codecXaRecover);
                this.chain.send(DiagnosticList.GetADummyList());
                n4 = codecXaRecover.getXaRetCode();
                if (n4 < 0) {
                    throw new SlXaException(n4);
                }
                slXidArray2 = codecXaRecover.getXids();
                if (slXidArray2.length <= 0) continue;
                SlXid[] slXidArray3 = slXidArray;
                slXidArray = new SlXid[slXidArray3.length + slXidArray2.length];
                System.arraycopy(slXidArray3, 0, slXidArray, 0, slXidArray3.length);
                System.arraycopy(slXidArray2, 0, slXidArray, slXidArray3.length, slXidArray2.length);
            }
        }
        catch (SQLException sQLException) {
            throw new SlXaException();
        }
        return slXidArray;
    }
}

