/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.net.SPDU;

public class SPDUAccept
extends SPDU {
    private static final int kMAX_USERDATA = 512;
    private int fuReq;
    private int protocolOptions;
    private byte[] callingSelector;
    private byte[] calledSelector;
    private int maxSendTduSize;
    private int maxRecvTduSize;
    private int userDataLen;

    SPDUAccept(int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, int n5) throws NetworkException {
        super(2);
        this.validateSelector(byArray);
        this.validateSelector(byArray2);
        this.validateUserDataLen(n5);
        this.fuReq = n;
        this.protocolOptions = n2;
        this.callingSelector = byArray;
        this.calledSelector = byArray2;
        this.maxSendTduSize = n3;
        this.maxRecvTduSize = n4;
        this.userDataLen = n5;
    }

    private void validateUserDataLen(int n) throws NetworkException {
        if (n < 0 || n > 512) {
            throw SPDUAccept.getException(7576);
        }
    }

    public int getFuReq() {
        return this.fuReq;
    }

    public int getProtocolOptions() {
        return this.protocolOptions;
    }

    public byte[] getCalledSelector() {
        return this.calledSelector;
    }

    public byte[] getCallingSelector() {
        return this.callingSelector;
    }

    public int getMaxSendTduSize() {
        return this.maxSendTduSize;
    }

    public int getMaxRecvTduSize() {
        return this.maxRecvTduSize;
    }

    public int getUserDataLen() {
        return this.userDataLen;
    }
}

