/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseBatchUpdateException;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplResultSetAutoGeneratedKeys;
import com.metamatrix.jdbc.base.BaseImplResultSetClientSideEmpty;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.db2.DB2EscapeTranslator;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplResultSet;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAExecuteStatementRequest;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAQueryStatementRequest;
import com.metamatrix.jdbc.db2.drda.DRDAStatementRequest;
import com.metamatrix.util.UtilException;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DB2ImplStatement
extends BaseImplStatement {
    private static String footprint = "$Revision:   3.107.1.7  $";
    public DRDACommunication comm;
    public DB2ImplConnection implConn;
    DRDAStatementRequest request;
    DRDAExecuteStatementRequest executeStmtReq;
    DRDAQueryStatementRequest queryStmtReq;
    DB2ImplResultSet[] resultSetArray;
    int currentResultSetNumber;
    DB2ImplResultSet resultSet;
    int resultType;
    int[] batchUpdateCounts;
    int sp_prepUpdateCount;
    BaseParameterInfo[] savedParamInfos;
    boolean isInitialized;
    boolean wasExecuted;
    String nativeSql;
    int nativeSqlLength;
    int maxSqlLen;
    boolean hasParamInfo;
    boolean isStoredProc;
    public String procedureName;
    public String procedureParamList;
    public boolean haveProcedureInfo;
    String addToCreateTable;
    int sectionNumber;
    String packageName;
    public DRDAPkgNamCsn packageConsistencyToken;
    int resultSetScrollType;
    int resultSetConcurrency;
    public BaseExceptions exceptions;
    private boolean needsToBePrepared;
    private boolean needsNewColumnDescriptions;
    boolean isCursorSelect;
    int previousSQL;
    boolean holdCursorOverCommit;
    BaseParameters baseParams;
    public DRDAByteOrderedDataWriter writer;
    public DRDAByteOrderedDataReader reader;
    private DB2ImplStatement autoGenKeyStmt;
    private boolean executingStoredProc;
    public boolean hasReturnValue;
    public String storedFunctionSQL;
    public boolean settingSpecialRegister;

    public DB2ImplStatement(DB2ImplConnection dB2ImplConnection, int n, int n2, BaseExceptions baseExceptions) throws SQLException {
        this.implConn = dB2ImplConnection;
        this.comm = dB2ImplConnection.comm;
        this.resultSetScrollType = n;
        this.resultSetConcurrency = n2;
        this.resultType = 0;
        this.exceptions = baseExceptions;
        this.needsToBePrepared = true;
        this.needsNewColumnDescriptions = true;
        this.maxSqlLen = this.comm.SQLAMLevel >= 7 ? 0x200000 : 32765;
    }

    public boolean isParameterSetsEmpty() {
        return this.parameterSets == null;
    }

    public void setReader(DRDAByteOrderedDataReader dRDAByteOrderedDataReader) {
        this.reader = dRDAByteOrderedDataReader;
        if (this.queryStmtReq == null) {
            this.queryStmtReq = new DRDAQueryStatementRequest(this.implConn, this.comm, this.reader, this.writer, this.packageConsistencyToken);
        }
        if (this.executeStmtReq == null) {
            this.executeStmtReq = new DRDAExecuteStatementRequest(this.implConn, this.comm, this.reader, this.writer, this, this.packageConsistencyToken);
        }
        this.executeStmtReq.reader = this.reader;
        this.queryStmtReq.reader = this.reader;
    }

    public void setWriter(DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter) {
        this.writer = dRDAByteOrderedDataWriter;
        if (this.queryStmtReq == null) {
            this.queryStmtReq = new DRDAQueryStatementRequest(this.implConn, this.comm, this.reader, this.writer, this.packageConsistencyToken);
        }
        if (this.executeStmtReq == null) {
            this.executeStmtReq = new DRDAExecuteStatementRequest(this.implConn, this.comm, this.reader, this.writer, this, this.packageConsistencyToken);
        }
        this.queryStmtReq.writer = this.writer;
        this.executeStmtReq.writer = this.writer;
    }

    public void setCursorHoldability(boolean bl) {
        this.holdCursorOverCommit = bl;
    }

    public void processCancelResponse() throws SQLException {
        this.executeStmtReq.discardReplyBytes();
    }

    public void setAddToCreateTable(String string) {
        this.addToCreateTable = string;
    }

    public boolean supportsBatchStatements() {
        return this.comm.supportsDRDABatchEmulation;
    }

    public boolean supportsBatchParameters() {
        return this.comm.supportsDRDABatchEmulation;
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        int n;
        BaseColumns baseColumns2 = null;
        String string = "";
        String string2 = "";
        if (this.sql != null) {
            if (this.implConn.resultSetMetaDataOptions == 0) {
                string = this.sql.getSingleTableFromSpecification();
                if (string == null) {
                    string = "";
                }
                if (string != "") {
                    int n2;
                    n = string.indexOf(".");
                    if (n != -1) {
                        string2 = string.substring(0, n);
                        string = string.substring(n + 1, string.length());
                    }
                    if ((n2 = string.indexOf(".")) != -1) {
                        string2 = string.substring(0, n2);
                        string = string.substring(n2 + 1, string.length());
                    }
                }
            }
            if (this.needsNewColumnDescriptions) {
                if (this.request != null) {
                    this.request.columnDescriptions = null;
                }
                if (!this.isInitialized) {
                    this.initializePackageConsistencyToken();
                }
                switch (this.sql.getType()) {
                    case 1: {
                        this.request = this.queryStmtReq;
                        this.request.writePRPSQLSTT(this.nativeSql, true, true);
                        this.request.submitRequest();
                        this.request.processMode = 2;
                        this.request.processReply(this.warnings);
                        this.needsToBePrepared = false;
                        this.needsNewColumnDescriptions = false;
                        this.isCursorSelect = true;
                        break;
                    }
                    case 0: 
                    case 3: {
                        break;
                    }
                    default: {
                        return baseColumns;
                    }
                }
            }
            baseColumns2 = this.isStoredProc && this.resultSet != null && this.databaseMetaDataResultSet == 0 ? (this.resultSet.isCachedResultSet ? this.resultSetArray[this.currentResultSetNumber].getColumnDescriptions() : this.request.columnDescriptions) : (this.databaseMetaDataResultSet == 0 && this.request != null ? this.request.columnDescriptions : baseColumns);
        } else {
            baseColumns2 = baseColumns;
        }
        if (baseColumns2 != null) {
            for (n = 0; n < baseColumns2.count(0); ++n) {
                if (this.implConn.resultSetMetaDataOptions == 0) {
                    baseColumns2.get((int)(n + 1)).tableName = string;
                    baseColumns2.get((int)(n + 1)).schemaName = string2;
                }
                if (this.comm.SQLAMLevel >= 7 || !this.comm.supportsExtendedTypSQLDA) continue;
                baseColumns2.get((int)(n + 1)).isAutoIncrementDeterminedPostDescribe = true;
            }
        }
        return baseColumns2;
    }

    public BaseColumns describeAutoGeneratedKeyColumns() throws SQLException {
        this.autoGenKeyStmt = (DB2ImplStatement)this.implConn.createImplStatement(this.resultSetScrollType, this.resultSetConcurrency);
        BaseSQL baseSQL = null;
        baseSQL = this.comm.serverOS == 3 ? new BaseSQL("select identity_val_local() from SYSIBM.SYSDUMMY1", 0, this.implConn.quotingChar, this.implConn.intoIsOptional, (BaseEscapeTranslator)new DB2EscapeTranslator(this.implConn), this.implConn.exceptions) : (this.comm.serverOS == 8 ? new BaseSQL("select identity_val_local() from QSYS2.SYSPACKAGE WHERE PACKAGE_NAME = 'DDJC330A'", 0, this.implConn.quotingChar, this.implConn.intoIsOptional, (BaseEscapeTranslator)new DB2EscapeTranslator(this.implConn), this.implConn.exceptions) : new BaseSQL("select t.* from table(values(identity_val_local())) as t(key_value)", 0, this.implConn.quotingChar, this.implConn.intoIsOptional, (BaseEscapeTranslator)new DB2EscapeTranslator(this.implConn), this.implConn.exceptions));
        this.autoGenKeyStmt.setSQL(baseSQL);
        this.autoGenKeyStmt.execute();
        int n = this.autoGenKeyStmt.getNextResultType();
        if (this.comm.clearsAutoGenRegisterOnCommit && this.implConn.inAutoCommit) {
            this.implConn.commitTransaction();
            this.executeStmtReq.chainCommit = true;
        }
        if (n == 2) {
            if (this.comm.serverOS == 8 || this.comm.serverOS == 3) {
                BaseColumns baseColumns = this.autoGenKeyStmt.describeColumns(null);
                baseColumns.get((int)1).label = "KEY_VALUE";
                baseColumns.get((int)1).name = "KEY_VALUE";
                return baseColumns;
            }
            return this.autoGenKeyStmt.describeColumns(null);
        }
        return null;
    }

    public BaseImplResultSet getAutoGeneratedKeyResultSet() throws SQLException {
        Object object = null;
        DB2ImplResultSet dB2ImplResultSet = (DB2ImplResultSet)this.autoGenKeyStmt.getNextResultSet();
        if (dB2ImplResultSet.fetchAtPosition(0)) {
            BaseData[][] baseDataArray = new BaseData[1][1];
            baseDataArray[0][0] = dB2ImplResultSet.getData(1, 4);
            object = !baseDataArray[0][0].isNull() ? new BaseImplResultSetAutoGeneratedKeys(baseDataArray) : new BaseImplResultSetClientSideEmpty();
        } else {
            object = new BaseImplResultSetClientSideEmpty();
        }
        this.autoGenKeyStmt.close();
        this.autoGenKeyStmt = null;
        return object;
    }

    public void describeParameters(BaseParameters baseParameters) throws SQLException {
        if (!this.comm.enableDescribeParam) {
            this.hasParamInfo = true;
        } else if (this.sql.getType() == 3 && !this.executingStoredProc) {
            if (!this.haveProcedureInfo) {
                this.getStoredProcedureInformation(baseParameters);
            }
        } else {
            int n;
            if (!this.hasParamInfo) {
                this.savedParamInfos = new BaseParameterInfo[baseParameters.count()];
                for (n = 0; n < baseParameters.count(); ++n) {
                    baseParameters.setParameterInfo(n, new BaseParameterInfo());
                }
                if (!this.isInitialized) {
                    this.initializePackageConsistencyToken();
                }
                if (this.needsToBePrepared) {
                    switch (this.sql.getType()) {
                        case 1: {
                            this.queryStmtReq.setToPrepared();
                            this.queryStmtReq.setParameters(baseParameters);
                            this.request = this.queryStmtReq;
                            this.request.writePRPSQLSTT(this.nativeSql, true, true);
                            this.request.submitRequest();
                            this.request.processMode = 2;
                            this.request.processReply(this.warnings);
                            this.needsToBePrepared = false;
                            this.needsNewColumnDescriptions = false;
                            this.isCursorSelect = true;
                            break;
                        }
                        default: {
                            this.executeStmtReq.setToPrepared();
                            this.executeStmtReq.setParameters(baseParameters);
                            this.request = this.executeStmtReq;
                            this.request.writePRPSQLSTT(this.nativeSql, true, true);
                            this.request.submitRequest();
                            this.request.processMode = 2;
                            this.request.processReply(this.warnings);
                            this.needsToBePrepared = false;
                            this.needsNewColumnDescriptions = false;
                            this.isCursorSelect = false;
                            if (this.sql.getType() != 3) break;
                            this.sp_prepUpdateCount = this.request.getNumRowsAffected();
                        }
                    }
                }
                this.request.setParameters(baseParameters);
                this.request.writeDSCSQLSTT();
                this.request.submitRequest();
                this.request.processMode = 4;
                this.request.processReply(this.warnings);
            }
            for (n = 0; n < baseParameters.count(); ++n) {
                this.savedParamInfos[n] = baseParameters.getParameterInfo(n);
            }
        }
        this.hasParamInfo = true;
    }

    public BaseImplResultSet getNextResultSet() throws SQLException {
        if (this.sql == null) {
            this.resultSet = new DB2ImplResultSet();
        } else if (this.sql.getType() == 3) {
            this.resultSet = this.resultSetArray[this.currentResultSetNumber];
        } else if (this.request.reader.currentPacketLength - this.request.reader.numBytesReadFromCurrentPacket < 4 && this.request.resultSetArray != null) {
            this.resultSetArray = this.request.resultSetArray;
            this.resultSet = this.resultSetArray[this.currentResultSetNumber];
            this.isStoredProc = true;
        } else {
            try {
                this.request.processReply(this.warnings);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -301 && this.comm.enableDescribeParam) {
                    this.request.reExecutingWithParamInfos = true;
                    this.resultType = this.reExecuteWithParamInfos();
                }
                if (this.databaseMetaDataResultSet != 0) {
                    this.request.hasWarnings = false;
                    return new BaseImplResultSetClientSideEmpty();
                }
                throw sQLException;
            }
            this.resultSet = new DB2ImplResultSet(this.request, this.comm);
            this.request.hasWarnings = false;
        }
        return this.resultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNextResultType() throws SQLException {
        if (this.resultType == 1) {
            return 1;
        }
        if (this.sql == null) {
            return 2;
        }
        if (this.sql.getType() == 3) {
            if (this.resultType == 0) {
                this.request.processReply(this.warnings);
                this.resultType = this.request.getResultType();
                if (this.hasReturnValue) {
                    this.baseParams.getOutput(1).setData(4, null);
                    this.baseParams.getOutput(1).setData(4, (Object)new Integer(this.request.getReturnValueForStoredProcedure()));
                    this.baseParams.getOutput((int)1).sqlType = 4;
                }
                if (this.resultType == 1) {
                    this.resultType = 3;
                }
                if (this.request.numResultSets >= 1) {
                    this.resultSetArray = this.request.resultSetArray;
                    return this.resultType;
                } else {
                    try {
                        if (!this.implConn.inAutoCommit) return this.resultType;
                        if (this.request.reader.atEndOfReply()) {
                            this.implConn.commitTransaction();
                            return this.resultType;
                        }
                        this.request.processMode = 2;
                        this.request.processReply(this.warnings);
                        this.implConn.commitTransaction();
                        return this.resultType;
                    }
                    catch (UtilException utilException) {
                        throw this.comm.exceptions.getException((Exception)((Object)utilException));
                    }
                }
            } else {
                if (this.resultType == 3) {
                    this.request.processReply(this.warnings);
                }
                if (this.request.numResultSets - 1 <= this.currentResultSetNumber) {
                    this.resultType = 1;
                    return this.resultType;
                } else {
                    ++this.currentResultSetNumber;
                    this.resultType = 2;
                }
            }
            return this.resultType;
        }
        if (this.resultType == 2) {
            if (this.resultSet == null) {
                this.resultSet = (DB2ImplResultSet)this.getNextResultSet();
                this.resultSet.setWarnings(this.warnings);
                this.resultSet.setImplStatement(this);
            }
            this.resultSet.close();
            this.resultSet = null;
        }
        if (this.isCursorSelect) {
            this.resultType = this.resultType == 0 ? 2 : 1;
            return this.resultType;
        }
        try {
            this.request.processReply(this.warnings);
            if (this.request.getResultType() == 1 && this.resultType == 0) {
                this.request.checkingForAdditionalUpdateCounts = true;
                this.request.resultType = 3;
                return 3;
            }
            this.resultType = this.request.getResultType();
            return this.resultType;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != -301 && sQLException.getErrorCode() != -332 && sQLException.getErrorCode() != -420 || !this.comm.enableDescribeParam) throw sQLException;
            this.request.reExecutingWithParamInfos = true;
            this.resultType = this.reExecuteWithParamInfos();
            return this.resultType;
        }
    }

    public int getNextRowsAffectedCount() throws SQLException {
        if (this.sql.getType() == 3 && this.request.getNumRowsAffected() < this.sp_prepUpdateCount) {
            return this.sp_prepUpdateCount;
        }
        return this.request.getNumRowsAffected();
    }

    public int[] getBatchRowsAffectedCount() throws SQLException {
        if (((DRDAExecuteStatementRequest)this.request).updateCounts == null) {
            return new int[0];
        }
        return ((DRDAExecuteStatementRequest)this.request).updateCounts;
    }

    private boolean preparedForExecute() throws SQLException {
        if (this.sql == null) {
            return false;
        }
        this.closeResultSets();
        if (!this.isInitialized || this.packageConsistencyToken.sectionNumber == 0) {
            if (this.packageConsistencyToken != null) {
                if (this.sql.getType() != this.previousSQL || this.sql.getType() == 1 || this.packageConsistencyToken.sectionNumber == 0) {
                    this.implConn.comm.packageManager.markThisSectionNumber(this.packageConsistencyToken, -1);
                    this.initializePackageConsistencyToken();
                }
            } else {
                this.initializePackageConsistencyToken();
            }
        } else if (!this.implConn.comm.packageManager.isSectionMarkedForPrepare(this.packageConsistencyToken)) {
            this.implConn.comm.packageManager.markThisSectionNumber(this.packageConsistencyToken, 1);
        }
        if (!(this.comm.serverOS != 3 && this.comm.serverOS != 8 || this.needsToBePrepared)) {
            this.needsToBePrepared = this.implConn.comm.packageManager.isSectionMarkedForPrepare(this.packageConsistencyToken);
        }
        if (!this.implConn.stripNewlines.equalsIgnoreCase("false")) {
            this.nativeSql = this.stripNewLines(this.nativeSql);
        }
        if (this.nativeSqlLength > this.maxSqlLen) {
            String[] stringArray = new String[]{Integer.toString(this.nativeSqlLength), Integer.toString(this.maxSqlLen)};
            throw this.comm.exceptions.getException(7093, stringArray);
        }
        return true;
    }

    private BaseParameters fixUpCallParameters(BaseParameters baseParameters) throws SQLException {
        BaseParameters baseParameters2 = null;
        if (this.hasReturnValue) {
            this.nativeSql = this.storedFunctionSQL;
            int n = baseParameters.count() - 1;
            baseParameters2 = new BaseParameters(baseParameters.count() - 1, this.exceptions, (BaseConnection)this.implConn.db2Connection);
            block5: for (int i = 0; i < n; ++i) {
                BaseParameterInfo baseParameterInfo = baseParameters.getParameterInfo(i + 1);
                baseParameters2.setParameterInfo(i, baseParameterInfo);
                switch (baseParameterInfo.mode) {
                    case 4: {
                        baseParameters2.set(i + 1, 2, this.baseParams.get(i + 2, 2));
                        continue block5;
                    }
                    case 1: {
                        baseParameters2.set(i + 1, 1, this.baseParams.get(i + 2, 1));
                        continue block5;
                    }
                    case 2: {
                        baseParameters2.set(i + 1, 4, this.baseParams.get(i + 2, 4));
                    }
                }
            }
        } else {
            baseParameters2 = baseParameters;
        }
        return baseParameters2;
    }

    private final void setupBaseParams(int n) throws SQLException {
        if (this.parameterSets != null && ((BaseParameters)this.parameterSets.elementAt(n)).count() > 0) {
            if (this.baseParams != null && (this.haveProcedureInfo || this.hasParamInfo)) {
                BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(n);
                for (int i = 0; i < baseParameters.count(); ++i) {
                    baseParameters.setParameterInfo(i, this.baseParams.getParameterInfo(i));
                }
                this.baseParams = baseParameters;
            } else {
                this.baseParams = (BaseParameters)this.parameterSets.elementAt(n);
                if (this.comm.serverType == 3 || this.comm.serverType == 11 && this.sql.getType() != 3) {
                    this.describeParameters(this.baseParams);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeBatch() throws SQLException, BatchUpdateException {
        int n;
        if (!this.preparedForExecute()) {
            return;
        }
        int n2 = 0;
        boolean bl = false;
        if (this.parameterSets == null) {
            n2 = this.sql.batchSize();
            bl = false;
        } else {
            n2 = this.parameterSets.size();
            bl = n2 != 1 || ((BaseParameters)this.parameterSets.elementAt(0)).count() != 0;
        }
        this.batchUpdateCounts = new int[n2];
        if (n2 == 0) {
            this.resultType = 1;
            this.request = this.executeStmtReq;
            ((DRDAExecuteStatementRequest)this.request).updateCounts = null;
            return;
        }
        this.isCursorSelect = false;
        this.executeStmtReq.setToPrepared();
        this.request = this.executeStmtReq;
        ((DRDAExecuteStatementRequest)this.request).executingBatch = true;
        ((DRDAExecuteStatementRequest)this.request).lastBatchStatement = false;
        this.request.chainCommit = false;
        if (bl) {
            if (this.sql.getType() == 1) {
                throw new BaseBatchUpdateException(this.exceptions.getException(6090), new int[0]);
            }
            if (this.sql.getType() == 3) {
                ((DRDAExecuteStatementRequest)this.request).executingBatch = false;
                ((DRDAExecuteStatementRequest)this.request).lastBatchStatement = true;
                this.executeStoredProcedureBatch();
                return;
            }
            n = 1;
            if (this.needsToBePrepared) {
                this.request.writePRPSQLSTT(this.nativeSql, false, false);
                ((DRDAExecuteStatementRequest)this.request).processingSQLCAforPrepare = true;
                this.needsToBePrepared = false;
                ++n;
            }
            for (int i = 0; i < n2; ++i) {
                if (i == n2 - 1) {
                    this.request.chainCommit = true;
                    ((DRDAExecuteStatementRequest)this.request).lastBatchStatement = true;
                }
                ((DRDAExecuteStatementRequest)this.request).setParameters((BaseParameters)this.parameterSets.elementAt(i));
                ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(i + n);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (n == n2 - 1) {
                    this.request.chainCommit = true;
                    ((DRDAExecuteStatementRequest)this.request).lastBatchStatement = true;
                }
                this.sql.nextBatchStatement();
                String string = this.sql.getFormatted();
                if (!this.implConn.stripNewlines.equalsIgnoreCase("false")) {
                    string = this.stripNewLines(string);
                }
                if (string.length() > 32765) {
                    String[] stringArray = new String[]{Integer.toString(string.length()), Integer.toString(32765)};
                    throw this.comm.exceptions.getException(7093, stringArray);
                }
                if (this.sql.getType() == 1) {
                    try {
                        this.writer.empty();
                        throw new BaseBatchUpdateException(this.exceptions.getException(6053), new int[0]);
                    }
                    catch (UtilException utilException) {
                        // empty catch block
                    }
                    throw new BaseBatchUpdateException(this.exceptions.getException(6053), new int[0]);
                }
                ((DRDAExecuteStatementRequest)this.request).writeEXCSQLIMM(string, n);
            }
        }
        this.request.submitRequest();
        this.request.processMode = 0;
        ((DRDAExecuteStatementRequest)this.request).updateCounts = this.batchUpdateCounts;
        this.wasExecuted = true;
        try {
            try {
                this.request.processReply(this.warnings);
            }
            catch (SQLException sQLException) {
                block29: {
                    block30: {
                        block28: {
                            if (sQLException.getErrorCode() != -301 || !this.comm.enableDescribeParam || !this.implConn.batchPerformanceWorkaround) break block28;
                            this.request.reExecutingWithParamInfos = true;
                            this.reExecuteBatchWithParamInfos();
                            Object var7_12 = null;
                            if (!this.comm.losesPreparedStateOnCommit) break block29;
                            break block30;
                        }
                        if (((DRDAExecuteStatementRequest)this.request).updateCounts.length <= ((DRDAExecuteStatementRequest)this.request).currentUpdateCount) throw new BaseBatchUpdateException(sQLException, ((DRDAExecuteStatementRequest)this.request).updateCounts);
                        int[] nArray = null;
                        nArray = new int[((DRDAExecuteStatementRequest)this.request).currentUpdateCount];
                        int i = 0;
                        while (true) {
                            if (i >= ((DRDAExecuteStatementRequest)this.request).currentUpdateCount) {
                                ((DRDAExecuteStatementRequest)this.request).updateCounts = nArray;
                                throw new BaseBatchUpdateException(sQLException, ((DRDAExecuteStatementRequest)this.request).updateCounts);
                            }
                            nArray[i] = ((DRDAExecuteStatementRequest)this.request).updateCounts[i];
                            ++i;
                        }
                    }
                    this.needsToBePrepared = this.implConn.inAutoCommit && this.implConn.inLocalTransaction ? true : this.implConn.comm.packageManager.isSectionMarkedForPrepare(this.packageConsistencyToken);
                }
                ((DRDAExecuteStatementRequest)this.request).executingBatch = false;
                ((DRDAExecuteStatementRequest)this.request).lastBatchStatement = true;
                this.resultType = 3;
                this.hasParamInfo = false;
                return;
            }
            Object var7_11 = null;
            if (this.comm.losesPreparedStateOnCommit) {
                this.needsToBePrepared = this.implConn.inAutoCommit && this.implConn.inLocalTransaction ? true : this.implConn.comm.packageManager.isSectionMarkedForPrepare(this.packageConsistencyToken);
            }
            ((DRDAExecuteStatementRequest)this.request).executingBatch = false;
            ((DRDAExecuteStatementRequest)this.request).lastBatchStatement = true;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (this.comm.losesPreparedStateOnCommit) {
                this.needsToBePrepared = this.implConn.inAutoCommit && this.implConn.inLocalTransaction ? true : this.implConn.comm.packageManager.isSectionMarkedForPrepare(this.packageConsistencyToken);
            }
            ((DRDAExecuteStatementRequest)this.request).executingBatch = false;
            ((DRDAExecuteStatementRequest)this.request).lastBatchStatement = true;
            this.resultType = 3;
            this.hasParamInfo = false;
            throw throwable;
        }
        this.resultType = 3;
        this.hasParamInfo = false;
    }

    public void executeStoredProcedureBatch() throws SQLException, BatchUpdateException {
        int n = this.parameterSets.size();
        this.isStoredProc = true;
        this.isCursorSelect = false;
        this.batchUpdateCounts = new int[n];
        for (int i = 0; i < n; ++i) {
            this.setupBaseParams(i);
            if (!this.haveProcedureInfo && this.baseParams != null) {
                this.getStoredProcedureInformation(this.baseParams);
            }
            BaseParameters baseParameters = this.fixUpCallParameters(this.baseParams);
            this.executeStmtReq.setToPrepared();
            this.executeStmtReq.setParameters(baseParameters);
            this.executeStmtReq.isStoredProcedure = true;
            this.executeStmtReq.spName = this.procedureName;
            this.request = this.executeStmtReq;
            if (this.comm.enableRealStoredProcPrepare) {
                if (this.needsToBePrepared) {
                    this.request.writePRPSQLSTT(this.nativeSql, false, false);
                    this.needsToBePrepared = false;
                    ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(2);
                } else {
                    ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(1);
                }
            } else {
                ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(1);
            }
            this.request.processMode = 0;
            this.request.submitRequest();
            this.wasExecuted = true;
            this.needsNewColumnDescriptions = false;
            this.request.processReply(this.warnings);
            this.resultType = this.request.getResultType();
            if (this.hasReturnValue) {
                this.baseParams.getOutput(1).setData(4, null);
                this.baseParams.getOutput(1).setData(4, (Object)new Integer(this.request.getReturnValueForStoredProcedure()));
                this.baseParams.getOutput((int)1).sqlType = 4;
            }
            if (this.resultType == 1) {
                this.resultType = 3;
            } else if (this.resultType == 2 || this.request.numResultSets > 0) {
                throw new BaseBatchUpdateException(this.exceptions.getException(6053), new int[0]);
            }
            this.batchUpdateCounts[i] = -2;
        }
        ((DRDAExecuteStatementRequest)this.request).updateCounts = this.batchUpdateCounts;
    }

    public void execute() throws SQLException {
        if (!this.preparedForExecute()) {
            return;
        }
        this.setupBaseParams(0);
        switch (this.sql.getType()) {
            case 1: {
                this.queryStmtReq.setToPrepared();
                this.queryStmtReq.setParameters(this.baseParams);
                this.request = this.queryStmtReq;
                if (this.needsToBePrepared) {
                    if (this.needsNewColumnDescriptions || this.request.columnDescriptions == null) {
                        this.request.columnDescriptions = null;
                        this.request.writePRPSQLSTT(this.nativeSql, true, false);
                        this.request.processMode = this.databaseMetaDataResultSet != 0 ? 3 : 3;
                    } else {
                        this.request.writePRPSQLSTT(this.nativeSql, false, false);
                    }
                    ((DRDAQueryStatementRequest)this.request).openQuery(this.warnings, false, (short)2);
                } else {
                    ((DRDAQueryStatementRequest)this.request).openQuery(this.warnings, false, (short)1);
                }
                this.request.submitRequest();
                if (this.needsNewColumnDescriptions) {
                    this.request.processReply(this.warnings);
                    this.needsNewColumnDescriptions = false;
                    if (this.request.hasClobColumns) {
                        this.reFetchWithClobSubstitution();
                    }
                } else if (this.request.hasClobColumns && !this.request.reExecutingWithClobSubstitution) {
                    this.reFetchWithClobSubstitution();
                }
                this.request.processMode = 1;
                this.needsToBePrepared = false;
                this.isCursorSelect = true;
                break;
            }
            case 3: {
                this.isStoredProc = true;
                this.isCursorSelect = false;
                this.executingStoredProc = true;
                this.request = this.executeStmtReq;
                BaseParameters baseParameters = this.fixUpCallParameters(this.baseParams);
                if (!this.haveProcedureInfo && this.baseParams != null && baseParameters != null) {
                    if (this.comm.enableRealStoredProcPrepare && this.comm.enableDescribeParam) {
                        this.describeParameters(baseParameters);
                    } else {
                        this.getStoredProcedureInformation(this.baseParams);
                    }
                }
                this.executeStmtReq.setToPrepared();
                this.executeStmtReq.setParameters(baseParameters);
                this.executeStmtReq.isStoredProcedure = true;
                this.executeStmtReq.spName = this.procedureName;
                if (this.comm.enableRealStoredProcPrepare) {
                    if (this.needsToBePrepared) {
                        this.request.writePRPSQLSTT(this.nativeSql, false, false);
                        ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(2);
                    } else {
                        ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(1);
                    }
                } else {
                    ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(1);
                }
                this.request.processMode = 0;
                this.request.submitRequest();
                this.needsToBePrepared = false;
                this.needsNewColumnDescriptions = false;
                this.executingStoredProc = false;
                break;
            }
            case 2: {
                if (this.comm.serverOS == 3 && this.addToCreateTable != null) {
                    this.nativeSql = this.nativeSql + " " + this.addToCreateTable;
                }
            }
            default: {
                this.isCursorSelect = false;
                this.executeStmtReq.setToPrepared();
                this.executeStmtReq.setParameters(this.baseParams);
                this.request = this.executeStmtReq;
                if (this.comm.clearsAutoGenRegisterOnCommit && this.autoGeneratedKeysRequested) {
                    this.request.chainCommit = false;
                }
                if (this.baseParams != null || this.comm.serverType == 6) {
                    if (this.needsToBePrepared) {
                        this.request.writePRPSQLSTT(this.nativeSql, false, false);
                        ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(2);
                    } else {
                        ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(1);
                    }
                    this.request.submitRequest();
                    this.needsToBePrepared = false;
                    this.request.processMode = 0;
                    break;
                }
                if (this.sql.getVerb().equalsIgnoreCase("SET") && this.settingSpecialRegister) {
                    ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSET(this.nativeSql, 0);
                } else {
                    ((DRDAExecuteStatementRequest)this.request).writeEXCSQLIMM(this.nativeSql, 0);
                }
                this.request.submitRequest();
                this.request.processMode = 0;
                this.comm.packageManager.freeThisSectionNumber(this.packageConsistencyToken);
                if (this.packageConsistencyToken != null) {
                    this.packageConsistencyToken.sectionNumber = 0;
                }
                this.isInitialized = false;
            }
        }
        if (this.comm.losesPreparedStateOnCommit) {
            this.needsToBePrepared = this.implConn.inAutoCommit && this.implConn.inLocalTransaction ? true : this.implConn.comm.packageManager.isSectionMarkedForPrepare(this.packageConsistencyToken);
        }
        this.wasExecuted = true;
        this.resultType = 0;
    }

    public void getStoredProcedureInformation(BaseParameters baseParameters) throws SQLException {
        int n;
        this.haveProcedureInfo = true;
        String string = this.implConn.databaseName;
        String string2 = null;
        String string3 = null;
        int n2 = this.procedureName.indexOf(".");
        if (n2 == -1) {
            if (this.comm.serverOS == 8) {
                string2 = this.implConn.collectionId;
                string3 = this.procedureName;
                this.procedureName = this.implConn.collectionId + "." + this.procedureName;
            } else {
                string3 = this.procedureName;
                string2 = this.implConn.currentFunctionPath == null || this.implConn.currentFunctionPath.length() == 0 ? this.implConn.user : "%";
            }
        } else {
            int n3 = this.procedureName.indexOf(".", n2 + 1);
            if (n3 == -1) {
                string2 = this.procedureName.substring(0, n2);
                string3 = this.procedureName.substring(n2 + 1);
            } else {
                string = this.procedureName.substring(0, n2);
                string2 = this.procedureName.substring(n2 + 1, n3);
                string3 = this.procedureName.substring(n3 + 1);
            }
        }
        ResultSet resultSet = this.implConn.db2Connection.getMetaData().getProcedureColumns(string.toUpperCase(), string2.toUpperCase(), string3.toUpperCase(), "%");
        int n4 = baseParameters.count();
        if (this.hasReturnValue) {
            --n4;
            BaseParameterInfo baseParameterInfo = new BaseParameterInfo();
            baseParameterInfo.mode = 4;
            baseParameterInfo.nativeTypeName = "INTEGER";
            baseParameterInfo.precision = 4;
            baseParameterInfo.nullable = 1;
            baseParameterInfo.sqlType = 4;
            baseParameterInfo.typeClassName = "java.sql.Types.INTEGER";
            baseParameters.setParameterInfo(0, baseParameterInfo);
        }
        for (n = 0; n < n4; ++n) {
            String[] stringArray;
            if (!resultSet.next()) {
                if (n == 0) {
                    stringArray = new String[]{this.procedureName};
                    throw this.exceptions.getException(-10013, stringArray, "HY000", -10013);
                }
                throw this.exceptions.getException(7074);
            }
            stringArray = new BaseParameterInfo();
            stringArray.signed = false;
            switch (resultSet.getInt(5)) {
                case 4: {
                    stringArray.mode = 4;
                    break;
                }
                case 1: {
                    stringArray.mode = 1;
                    break;
                }
                case 2: {
                    stringArray.mode = 2;
                    break;
                }
                default: {
                    stringArray.mode = 0;
                }
            }
            stringArray.nativeTypeName = resultSet.getString(7).trim();
            stringArray.precision = resultSet.getInt(8);
            stringArray.scale = resultSet.getInt(10);
            stringArray.nullable = resultSet.getInt(12) == 1 ? 1 : 0;
            if (stringArray.nativeTypeName.equals("BIGINT")) {
                stringArray.sqlType = -5;
                stringArray.typeClassName = "java.sql.Types.BIGINT";
            } else if (stringArray.nativeTypeName.equals("LONG VARCHAR FOR BIT DATA")) {
                stringArray.sqlType = -4;
                stringArray.typeClassName = "java.sql.Types.LONGVARBINARY";
            } else if (stringArray.nativeTypeName.equals("VARCHAR() FOR BIT DATA")) {
                stringArray.sqlType = -3;
                stringArray.typeClassName = "java.sql.Types.VARBINARY";
            } else if (stringArray.nativeTypeName.equals("CHAR() FOR BIT DATA")) {
                stringArray.sqlType = -2;
                stringArray.typeClassName = "java.sql.Types.BINARY";
            } else if (stringArray.nativeTypeName.equals("LONG VARCHAR")) {
                stringArray.sqlType = -1;
                stringArray.typeClassName = "java.sql.Types.LONGVARCHAR";
            } else if (stringArray.nativeTypeName.equals("CHAR") || stringArray.nativeTypeName.equals("CHARACTER")) {
                stringArray.sqlType = 1;
                stringArray.typeClassName = "java.sql.Types.CHAR";
            } else if (stringArray.nativeTypeName.equals("NUMERIC")) {
                stringArray.sqlType = 2;
                stringArray.typeClassName = "java.sql.Types.NUMERIC";
            } else if (stringArray.nativeTypeName.equals("DECIMAL")) {
                stringArray.sqlType = 3;
                stringArray.typeClassName = "java.sql.Types.DECIMAL";
            } else if (stringArray.nativeTypeName.equals("DECFLOAT")) {
                stringArray.sqlType = 3;
                stringArray.typeClassName = "java.sql.Types.DECIMAL";
            } else if (stringArray.nativeTypeName.equals("INTEGER")) {
                stringArray.sqlType = 4;
                stringArray.typeClassName = "java.sql.Types.INTEGER";
            } else if (stringArray.nativeTypeName.equals("SMALLINT")) {
                stringArray.sqlType = 5;
                stringArray.typeClassName = "java.sql.Types.SMALLINT";
            } else if (stringArray.nativeTypeName.equals("FLOAT")) {
                stringArray.sqlType = 6;
                stringArray.typeClassName = "java.sql.Types.FLOAT";
            } else if (stringArray.nativeTypeName.equals("REAL")) {
                stringArray.sqlType = 7;
                stringArray.typeClassName = "java.sql.Types.REAL";
            } else if (stringArray.nativeTypeName.equals("DOUBLE") || stringArray.nativeTypeName.equals("DOUBLE PRECISION")) {
                stringArray.sqlType = 8;
                stringArray.typeClassName = "java.sql.Types.DOUBLE";
                stringArray.nativeTypeName = "DOUBLE";
            } else if (stringArray.nativeTypeName.equals("VARCHAR") || stringArray.nativeTypeName.equals("CHARACTER VARYING")) {
                stringArray.sqlType = 12;
                stringArray.typeClassName = "java.sql.Types.VARCHAR";
                stringArray.nativeTypeName = "VARCHAR";
            } else if (stringArray.nativeTypeName.equals("DATE")) {
                stringArray.sqlType = 91;
                stringArray.typeClassName = "java.sql.Types.DATE";
            } else if (stringArray.nativeTypeName.equals("TIME")) {
                stringArray.sqlType = 92;
                stringArray.typeClassName = "java.sql.Types.TIME";
            } else if (stringArray.nativeTypeName.equals("TIMESTAMP")) {
                stringArray.sqlType = 93;
                stringArray.typeClassName = "java.sql.Types.TIMESTAMP";
            } else if (stringArray.nativeTypeName.equals("GRAPHIC VARYING")) {
                stringArray.sqlType = 12;
                stringArray.typeClassName = "java.sql.Types.VARCHAR";
                stringArray.nativeTypeName = "VARGRAPHIC";
            } else if (stringArray.nativeTypeName.equals("VARGRAPHIC")) {
                stringArray.sqlType = 12;
                stringArray.typeClassName = "java.sql.Types.VARCHAR";
            } else if (stringArray.nativeTypeName.equals("VARGRAPH")) {
                stringArray.sqlType = 12;
                stringArray.typeClassName = "java.sql.Types.VARCHAR";
                stringArray.nativeTypeName = "VARGRAPHIC";
            } else if (stringArray.nativeTypeName.equals("VARG")) {
                stringArray.sqlType = 12;
                stringArray.typeClassName = "java.sql.Types.VARCHAR";
                stringArray.nativeTypeName = "VARGRAPHIC";
            } else if (stringArray.nativeTypeName.equals("GRAPHIC")) {
                stringArray.sqlType = 1;
                stringArray.typeClassName = "java.sql.Types.CHAR";
            } else if (stringArray.nativeTypeName.equals("LONG VARGRAPHIC")) {
                stringArray.sqlType = 12;
                stringArray.typeClassName = "java.sql.Types.LONGVARCHAR";
            } else if (stringArray.nativeTypeName.equals("LONGVARG")) {
                stringArray.sqlType = 12;
                stringArray.typeClassName = "java.sql.Types.LONGVARCHAR";
                stringArray.nativeTypeName = "LONG VARGRAPHIC";
            } else if (stringArray.nativeTypeName.equals("CLOB") || stringArray.nativeTypeName.equals("CHARACTER LARGE OBJECT")) {
                stringArray.sqlType = 2005;
                stringArray.typeClassName = "java.sql.Types.CLOB";
            } else if (stringArray.nativeTypeName.equals("DOUBLE-BYTE CHARACTER LARGE OBJECT")) {
                if (this.executeStmtReq.doubleByteColumns == null) {
                    this.executeStmtReq.doubleByteColumns = new int[n4];
                } else if (n4 > this.executeStmtReq.doubleByteColumns.length) {
                    this.executeStmtReq.doubleByteColumns = new int[n4];
                }
                this.executeStmtReq.doubleByteColumns[n] = 412;
                stringArray.sqlType = 2005;
                stringArray.typeClassName = "java.sql.Types.CLOB";
                stringArray.nativeTypeName = "DBCLOB";
            } else if (stringArray.nativeTypeName.equals("BLOB") || stringArray.nativeTypeName.equals("BINARY LARGE OBJECT")) {
                stringArray.sqlType = 2004;
                stringArray.typeClassName = "java.sql.Types.BLOB";
            } else if (stringArray.nativeTypeName.equalsIgnoreCase("XML")) {
                if (this.implConn.xmlDescribeType == 2005) {
                    stringArray.sqlType = 2005;
                    stringArray.typeClassName = "java.sql.Types.CLOB";
                } else {
                    stringArray.sqlType = 2004;
                    stringArray.typeClassName = "java.sql.Types.BLOB";
                }
            }
            if (this.hasReturnValue) {
                baseParameters.setParameterInfo(n + 1, (BaseParameterInfo)stringArray);
                continue;
            }
            baseParameters.setParameterInfo(n, (BaseParameterInfo)stringArray);
        }
        for (n = 0; n < n4; ++n) {
            int n5 = n + 1;
            if (this.hasReturnValue) {
                ++n5;
            }
            BaseParameterInfo baseParameterInfo = baseParameters.getParameterInfo(n);
            BaseParameter baseParameter = baseParameters.get(n5, 2);
            if (baseParameter != null || (baseParameter = baseParameters.get(n5, 1)) == null || baseParameter.sqlType == -2 || baseParameter.sqlType == -3 || baseParameter.sqlType == -4) continue;
            baseParameter.sqlType = baseParameterInfo.sqlType;
            baseParameter.scale = baseParameterInfo.scale;
        }
        resultSet.close();
    }

    private void initializePackageConsistencyToken() throws SQLException {
        this.isInitialized = true;
        if (this.sql.getType() == 3 && !this.comm.enableRealStoredProcPrepare) {
            this.isStoredProc = true;
            this.packageName = this.comm.packageManager.getPackageName(true);
            this.sectionNumber = this.parameterSets != null ? (this.hasReturnValue && ((BaseParameters)this.parameterSets.elementAt(0)).count() > 1 || !this.hasReturnValue && ((BaseParameters)this.parameterSets.elementAt(0)).count() > 0 ? this.implConn.comm.packageManager.getAvailableSectionNumber(true, true) : this.implConn.comm.packageManager.getAvailableSectionNumber(true, false)) : this.implConn.comm.packageManager.getAvailableSectionNumber(true, false);
        } else {
            this.packageName = this.comm.packageManager.getPackageName(false);
            this.sectionNumber = this.implConn.comm.packageManager.getAvailableSectionNumber(false, false);
        }
        this.queryStmtReq.packageConsistencyToken = this.packageConsistencyToken = new DRDAPkgNamCsn(this.implConn.databaseName, this.implConn.collectionId, this.packageName, this.sectionNumber, null);
        this.executeStmtReq.packageConsistencyToken = this.packageConsistencyToken;
    }

    protected void setSQL(BaseSQL baseSQL) throws SQLException {
        if (this.sql != null) {
            this.previousSQL = this.sql.getType();
        }
        this.sql = baseSQL;
        this.nativeSql = baseSQL.getFormatted();
        this.nativeSqlLength = this.nativeSql.length();
        this.needsToBePrepared = true;
        this.needsNewColumnDescriptions = true;
        this.isInitialized = false;
        this.hasParamInfo = false;
        this.savedParamInfos = null;
        this.wasExecuted = false;
        this.queryStmtReq.processColDesc = true;
    }

    public void cancel() throws SQLException {
        this.implConn.setUpCancelRequest();
        this.implConn.cancelRequest.writeCancelRequest(this.implConn.cancelToken);
        this.implConn.cancelRequest.submitRequest();
        this.implConn.cancelRequest.processReply(this.warnings);
    }

    public void closeResultSets() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        } else if (this.resultSetArray != null) {
            for (int i = 0; i < this.request.numResultSets; ++i) {
                this.resultSetArray[i].close();
            }
            this.resultSetArray = null;
            this.currentResultSetNumber = 0;
        } else if (this.resultType == 2 && this.request.exception == null) {
            this.resultSet = (DB2ImplResultSet)this.getNextResultSet();
            this.resultSet.setWarnings(this.warnings);
            this.resultSet.setImplStatement(this);
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    public void close() throws SQLException {
        this.implConn.implStatements.remove((Object)this);
        try {
            if (this.resultSet != null) {
                if (this.resultSet.request != null && this.resultSet.request.reader != null) {
                    this.resultSet.request.reader.close();
                }
                this.resultSet.close();
                this.resultSet = null;
            } else if (this.resultSetArray != null) {
                for (int i = 0; i < this.request.numResultSets; ++i) {
                    if (this.resultSetArray[i].request != null && this.resultSetArray[i].request.reader != null) {
                        this.resultSetArray[i].request.reader.close();
                    }
                    this.resultSetArray[i].close();
                }
                this.resultSetArray = null;
                this.currentResultSetNumber = 0;
            } else if (this.resultType == 2) {
                this.resultSet = (DB2ImplResultSet)this.getNextResultSet();
                this.resultSet.setWarnings(this.warnings);
                this.resultSet.setImplStatement(this);
                if (this.resultSet.request != null && this.resultSet.request.reader != null) {
                    this.resultSet.request.reader.close();
                }
                this.resultSet.close();
                this.resultSet = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.wasExecuted) {
            if (this.sql != null) {
                if (this.sql.getType() == 3) {
                    this.implConn.commitTransaction();
                } else if (this.sql.getType() == 1 && (!this.implConn.autoCommitResults || this.resultSetArray != null && this.resultSetArray.length > 1)) {
                    this.implConn.commitTransaction();
                }
                if (this.wasExecuted) {
                    this.implConn.comm.packageManager.freeThisSectionNumber(this.packageConsistencyToken);
                } else {
                    this.implConn.comm.packageManager.markThisSectionNumber(this.packageConsistencyToken, 2);
                }
            } else {
                this.implConn.comm.packageManager.freeThisSectionNumber(this.packageConsistencyToken);
            }
        } else {
            this.implConn.comm.packageManager.freeThisSectionNumber(this.packageConsistencyToken);
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.reset();
    }

    public void reset() throws SQLException {
        this.currentResultSetNumber = 0;
        this.haveProcedureInfo = false;
        this.hasParamInfo = false;
        try {
            this.executeStmtReq.discardReplyBytes();
            this.writer.empty();
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
        super.reset();
    }

    private void reFetchWithClobSubstitution() throws SQLException {
        if (!this.implConn.stripNewlines.equalsIgnoreCase("false")) {
            this.sql = new BaseSQL(this.nativeSql, 4, this.implConn.quotingChar, this.implConn.intoIsOptional, (BaseEscapeTranslator)new DB2EscapeTranslator(this.implConn), this.implConn.exceptions);
        }
        CharSequence charSequence = new StringBuffer("SELECT ");
        if (((String)this.sql.getSelectColumnSpecification(0).elementAt(0)).equalsIgnoreCase("*")) {
            BaseSQL baseSQL;
            int n = this.request.columnDescriptions.count(0);
            for (int i = 1; i <= n; ++i) {
                if (this.request.columnDescriptions.get((int)i).type == 2005) {
                    if (this.comm.serverOS != 8) {
                        charSequence.append("CAST ( " + this.request.columnDescriptions.get((int)i).name + " AS LONG VARCHAR )");
                    } else {
                        charSequence.append("VARCHAR (" + this.request.columnDescriptions.get((int)i).name + ")");
                    }
                } else {
                    charSequence.append(this.request.columnDescriptions.get((int)i).name);
                }
                if (i == n) continue;
                charSequence.append(", ");
            }
            StringBuffer stringBuffer = new StringBuffer(this.sql.getFormatted());
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (!stringBuffer.substring(i, i + 6).equalsIgnoreCase(" from ")) continue;
                charSequence.append(stringBuffer.substring(i));
                break;
            }
            this.sql = baseSQL = new BaseSQL(charSequence.toString(), 0, this.implConn.quotingChar, this.implConn.intoIsOptional, (BaseEscapeTranslator)new DB2EscapeTranslator(this.implConn), this.implConn.exceptions);
        } else {
            BaseSQL baseSQL;
            int n;
            int n2 = this.sql.getSelectColumnSpecificationCount();
            for (int i = 0; i < n2; ++i) {
                if (this.request.columnDescriptions.get((int)(i + 1)).type == 2005) {
                    if (this.comm.serverOS != 8) {
                        charSequence.append("CAST ( ");
                        for (n = 0; n < this.sql.getSelectColumnSpecification(i).size(); ++n) {
                            charSequence.append(this.sql.getSelectColumnSpecification(i).elementAt(n));
                        }
                        charSequence.append(" AS LONG VARCHAR )");
                    } else {
                        charSequence.append("VARCHAR (");
                        for (n = 0; n < this.sql.getSelectColumnSpecification(i).size(); ++n) {
                            charSequence.append(this.sql.getSelectColumnSpecification(i).elementAt(n));
                        }
                        charSequence.append(")");
                    }
                } else {
                    for (n = 0; n < this.sql.getSelectColumnSpecification(i).size(); ++n) {
                        charSequence.append(this.sql.getSelectColumnSpecification(i).elementAt(n));
                    }
                }
                if (i == n2 - 1) continue;
                charSequence.append(", ");
            }
            StringBuffer stringBuffer = new StringBuffer(this.sql.getFormatted());
            for (n = 0; n < stringBuffer.length(); ++n) {
                if (!stringBuffer.substring(n, n + 6).equalsIgnoreCase(" from ")) continue;
                charSequence.append(stringBuffer.substring(n));
                break;
            }
            this.sql = baseSQL = new BaseSQL(charSequence.toString(), 0, this.implConn.quotingChar, this.implConn.intoIsOptional, (BaseEscapeTranslator)new DB2EscapeTranslator(this.implConn), this.implConn.exceptions);
        }
        this.request.reExecutingWithClobSubstitution = true;
        charSequence = this.sql.getFormatted();
        if (!this.implConn.stripNewlines.equalsIgnoreCase("false")) {
            charSequence = this.stripNewLines((String)charSequence);
        }
        this.request.writePRPSQLSTT((String)charSequence, false, false);
        ((DRDAQueryStatementRequest)this.request).openQuery(this.warnings, false, (short)2);
        this.request.submitRequest();
        this.request.reExecutingWithClobSubstitution = true;
    }

    private int reExecuteWithParamInfos() throws SQLException {
        this.request.clearExceptions();
        if (this.savedParamInfos != null) {
            for (int i = 0; i < this.baseParams.count(); ++i) {
                this.baseParams.setParameterInfo(i, this.savedParamInfos[i]);
            }
        } else {
            this.describeParameters(this.baseParams);
        }
        this.fixParamsWithMetaData();
        this.execute();
        this.request.processReply(this.warnings);
        return this.request.getResultType();
    }

    private void reExecuteBatchWithParamInfos() throws SQLException {
        int[] nArray = ((DRDAExecuteStatementRequest)this.request).updateCounts;
        int[] nArray2 = new int[nArray.length];
        this.request.clearExceptions();
        ((DRDAExecuteStatementRequest)this.request).executingBatch = false;
        ((DRDAExecuteStatementRequest)this.request).lastBatchStatement = true;
        if (this.comm.losesPreparedStateOnCommit && this.implConn.inAutoCommit && this.implConn.inLocalTransaction) {
            this.needsToBePrepared = true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            if (nArray[i] != -3) {
                nArray2[i] = nArray[i];
                this.hasParamInfo = false;
                continue;
            }
            this.baseParams = (BaseParameters)this.parameterSets.elementAt(i);
            if (!this.hasParamInfo) {
                if (this.savedParamInfos != null) {
                    for (n = 0; n < this.baseParams.count(); ++n) {
                        this.baseParams.setParameterInfo(n, this.savedParamInfos[n]);
                    }
                } else {
                    this.describeParameters(this.baseParams);
                }
            } else {
                for (n = 0; n < this.baseParams.count(); ++n) {
                    this.baseParams.setParameterInfo(n, ((BaseParameters)this.parameterSets.elementAt(i - 1)).getParameterInfo(n));
                }
            }
            this.fixParamsWithMetaData();
            this.request.setToPrepared();
            ((DRDAExecuteStatementRequest)this.request).setParameters(this.baseParams);
            if (this.needsToBePrepared) {
                this.request.writePRPSQLSTT(this.nativeSql, false, false);
                this.needsToBePrepared = false;
                ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(2);
            } else {
                ((DRDAExecuteStatementRequest)this.request).writeEXCSQLSTT(1);
            }
            this.request.submitRequest();
            this.request.processReply(this.warnings);
            this.request.processMode = 0;
            nArray2[i] = this.request.getNumRowsAffected();
            if (!this.comm.losesPreparedStateOnCommit || !this.implConn.inAutoCommit || !this.implConn.inLocalTransaction) continue;
            this.needsToBePrepared = true;
        }
        ((DRDAExecuteStatementRequest)this.request).updateCounts = nArray2;
    }

    private final void fixParamsWithMetaData() throws SQLException {
        for (int i = 0; i < this.baseParams.count(); ++i) {
            BaseParameterInfo baseParameterInfo = this.baseParams.getParameterInfo(i);
            BaseParameter baseParameter = this.baseParams.get(i + 1, 1);
            try {
                if (!baseParameter.isNull) {
                    block1 : switch (baseParameter.getType()) {
                        case 9: {
                            if (baseParameterInfo.precision >= 5) break;
                            if (baseParameter.getBoolean(this.exceptions)) {
                                baseParameter.setString("1");
                                break;
                            }
                            baseParameter.setString("0");
                            break;
                        }
                        case 15: {
                            baseParameter.getASCIIStream(-1, (BaseConnection)this.implConn.db2Connection, this.exceptions).reset();
                            break;
                        }
                        case 14: {
                            baseParameter.getBinaryStream(-1, (BaseConnection)this.implConn.db2Connection, this.exceptions).reset();
                            switch (baseParameterInfo.sqlType) {
                                case -1: 
                                case 1: 
                                case 12: {
                                    byte[] byArray = baseParameter.getBytes(-1, this.exceptions);
                                    baseParameter.setString(this.comm.SingleByteClientTransliterator.decode(byArray, 0, byArray.length));
                                }
                            }
                            break;
                        }
                        case 18: {
                            baseParameter.getCharacterStreamReader(-1, (BaseConnection)this.implConn.db2Connection, this.exceptions).reset();
                            break;
                        }
                        case 16: {
                            baseParameter.getUTF8InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.exceptions).reset();
                            break;
                        }
                        case 17: {
                            baseParameter.getUCS2InputStream(-1, (BaseConnection)this.implConn.db2Connection, this.exceptions).reset();
                            break;
                        }
                        case 2: {
                            switch (baseParameter.sqlType) {
                                case -1: 
                                case 1: 
                                case 12: {
                                    if (this.comm.useMultiByteCPForParams) {
                                        baseParameter.setString(this.comm.MultiByteClientTransliterator.decode(baseParameter.getBytes(-1, this.exceptions), 0, baseParameter.getBytes(-1, this.exceptions).length));
                                        break block1;
                                    }
                                    baseParameter.setString(this.comm.SingleByteClientTransliterator.decode(baseParameter.getBytes(-1, this.exceptions), 0, baseParameter.getBytes(-1, this.exceptions).length));
                                    break block1;
                                }
                                case 2: 
                                case 3: {
                                    baseParameter.setBigDecimal(new BigDecimal(this.comm.drdaUtil.convertDRDADecimalToStringBuffer(baseParameter.getBytes(-1, this.exceptions), baseParameter.scale)));
                                }
                            }
                        }
                    }
                }
                baseParameter.sqlType = baseParameterInfo.sqlType;
                if (baseParameter.sqlType == 93) continue;
                baseParameter.scale = baseParameterInfo.scale;
                continue;
            }
            catch (Exception exception) {
                throw this.comm.exceptions.getException(exception);
            }
        }
    }

    private String stripNewLines(String string) throws SQLException {
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        block19: for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            switch (n2) {
                case 0: {
                    switch (c) {
                        case '-': {
                            n2 = 1;
                            continue block19;
                        }
                        case '\t': {
                            stringBuffer.setCharAt(i, ' ');
                            continue block19;
                        }
                        case '\'': {
                            n2 = 3;
                            continue block19;
                        }
                        case '\n': {
                            stringBuffer.setCharAt(i, ' ');
                            n2 = 0;
                            continue block19;
                        }
                        case '\r': {
                            stringBuffer.setCharAt(i, ' ');
                            n2 = 0;
                            continue block19;
                        }
                    }
                    n2 = 0;
                    continue block19;
                }
                case 1: {
                    switch (c) {
                        case '-': {
                            n2 = 2;
                            continue block19;
                        }
                        case '\t': {
                            stringBuffer.setCharAt(i, ' ');
                            continue block19;
                        }
                        case '\n': {
                            stringBuffer.setCharAt(i, ' ');
                            n2 = 0;
                            continue block19;
                        }
                        case '\r': {
                            stringBuffer.setCharAt(i, ' ');
                            n2 = 0;
                            continue block19;
                        }
                    }
                    n2 = 0;
                    continue block19;
                }
                case 2: {
                    if (c == '\n' || c == '\r') {
                        n2 = 0;
                        continue block19;
                    }
                    n2 = 2;
                    continue block19;
                }
                case 3: {
                    n2 = c == '\'' ? 0 : 3;
                }
            }
        }
        return stringBuffer.toString();
    }

    public String getAlternateWhereClause() throws SQLException {
        if (this.comm.serverOS == 3) {
            return " FETCH FIRST 1 ROW ONLY";
        }
        return null;
    }
}

