/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseCharStreamOnFileChunk;
import com.metamatrix.jdbc.slbase.BaseColumn;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.jdbc.slbase.BaseImplBlob;
import com.metamatrix.jdbc.slbase.BaseImplClob;
import com.metamatrix.jdbc.slbase.BaseImplResultSetService;
import com.metamatrix.jdbc.slbase.BaseInputStreamOnFileChunk;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilPagedTempBuffer;
import com.metamatrix.slutil.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.sql.SQLException;

public final class BaseImplResultSetClientSideInsensitive
extends BaseImplResultSetService {
    boolean tempFilesAreReady = false;
    private File longDataFileHandle;
    private RandomAccessFile longDataFile;
    UtilPagedTempBuffer rowDataBuff;
    UtilPagedTempBuffer rowPositionBuff;
    private int rowsFetchedFromSubResultSet = 0;
    private BaseData[] rowData;
    private boolean endOfResultSetReached = false;
    private int maxLongDataSize;
    byte[] byteArrayForReading;
    static int DEFAULT_BUFF_INCREMENT = 1024;
    int maxMem;

    public BaseImplResultSetClientSideInsensitive(int n2) {
        if (n2 == 0) {
            n2 = 0x200000;
        }
        this.maxMem = n2;
    }

    public BaseImplResultSetClientSideInsensitive() {
        this.maxMem = 2048;
    }

    public void postSetupInitialize() throws SQLException {
        this.tempFilesAreReady = false;
        super.postSetupInitialize();
        this.fetchAtPosition(1);
    }

    void setMaxLongDataFieldCacheSize(int n2) {
        this.maxLongDataSize = n2;
    }

    private void setupTempFiles() throws SQLException {
        try {
            this.rowDataBuff = new UtilPagedTempBuffer(this.maxMem);
            this.rowPositionBuff = new UtilPagedTempBuffer(16);
            this.byteArrayForReading = new byte[DEFAULT_BUFF_INCREMENT];
            this.longDataFileHandle = UtilTempFile.createTempFile("scb_");
            this.longDataFile = new RandomAccessFile(this.longDataFileHandle, "rw");
            this.tempFilesAreReady = true;
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6038);
        }
    }

    public void close() throws SQLException {
        super.close();
        try {
            this.rowDataBuff.truncate();
            this.rowPositionBuff.truncate();
            this.longDataFile.close();
            this.longDataFileHandle.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getScrollType() {
        return 1004;
    }

    public int getColumnAccess() {
        return 2;
    }

    public boolean fetchAtPosition(int n2) throws SQLException {
        boolean bl = this.fetch(n2);
        if (bl) {
            this.fetch(n2 + 1);
        }
        if (bl) {
            bl = n2 > this.rowsFetchedFromSubResultSet ? false : this.getCachedRow(n2 - 1);
        }
        return bl;
    }

    private boolean fetch(int n2) throws SQLException {
        boolean bl = true;
        if (n2 > this.rowsFetchedFromSubResultSet) {
            bl = this.fetchAndCache(n2 - this.rowsFetchedFromSubResultSet, false, 0);
        }
        return bl;
    }

    boolean fetchAndCache(int n2, boolean bl, int n3) throws SQLException {
        boolean bl2 = true;
        for (int i2 = 0; bl2 && i2 < n2; ++i2) {
            if (this.endOfResultSetReached) {
                bl2 = false;
            } else if (!bl) {
                bl2 = this.subImplResultSet.next();
            }
            if (bl2) {
                ++this.rowsFetchedFromSubResultSet;
                this.cacheCurrentRow(n3);
                bl = false;
                n3 = 0;
                continue;
            }
            this.endOfResultSetReached = true;
            this.maxCursorPosition = this.rowsFetchedFromSubResultSet;
        }
        return bl2;
    }

    void cacheCurrentRow(int n2) throws SQLException {
        try {
            if (!this.tempFilesAreReady) {
                this.setupTempFiles();
                this.tempFilesAreReady = true;
            }
            this.rowPositionBuff.writeLong(this.rowDataBuff.getSize());
            for (int i2 = n2; i2 < this.columns.count(0); ++i2) {
                BaseColumn baseColumn = this.columns.get(i2 + 1);
                BaseData baseData = this.subImplResultSet.getData(i2 + 1, baseColumn.baseDataType);
                if (baseData.isNull()) {
                    this.rowDataBuff.writeInt(baseData.getType());
                    this.rowDataBuff.writeInt(-1);
                    continue;
                }
                if (baseData.getType() == 2 || baseData.getType() > 100) {
                    byte[] byArray = baseData.getBytesNoConvert();
                    this.rowDataBuff.writeInt(baseData.getType());
                    this.rowDataBuff.writeInt(byArray.length);
                    this.rowDataBuff.write(this.rowDataBuff.getSize(), byArray);
                    continue;
                }
                if (baseData.getType() == 15 || baseData.getType() == 14) {
                    this.cacheBinaryStream(baseData.getType(), (InputStream)baseData.getObject());
                    continue;
                }
                if (baseData.getType() == 19) {
                    this.cacheBlob((BaseImplBlob)baseData.getObject());
                    continue;
                }
                if (baseData.getType() == 18 || baseData.getType() == 17 || baseData.getType() == 16) {
                    this.cacheCharacterStream(18, (Reader)baseData.getObject());
                    continue;
                }
                if (baseData.getType() == 20) {
                    this.cacheClob((BaseImplClob)baseData.getObject());
                    continue;
                }
                this.rowDataBuff.writeInt(baseData.getType());
                String string = baseData.getString(-1, this.implStatement.implConnection.exceptions);
                int n3 = string.length();
                this.rowDataBuff.writeInt(n3 * 2);
                int n4 = 0;
                while (n4 < n3) {
                    this.rowDataBuff.write(this.rowDataBuff.getSize(), (byte)(string.charAt(n4) >>> 8 & 0xFF));
                    this.rowDataBuff.write(this.rowDataBuff.getSize(), (byte)(string.charAt(n4++) >>> 0 & 0xFF));
                }
            }
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039);
        }
    }

    private void cacheBinaryStream(int n2, InputStream inputStream) throws IOException, UtilException {
        this.rowDataBuff.writeInt(n2);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l2 = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n3 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        byte[] byArray = new byte[n3];
        int n4 = inputStream.read(byArray, 0, n3);
        while (n4 != -1) {
            this.longDataFile.write(byArray, 0, n4);
            l2 += (long)n4;
            if (this.maxLongDataSize != 0) {
                if (n4 >= n3) break;
                n3 = this.maxLongDataSize - (int)l2;
            }
            n4 = inputStream.read(byArray, 0, n3);
        }
        this.rowDataBuff.writeLong(l2);
    }

    private void cacheCharacterStream(int n2, Reader reader) throws IOException, UtilException {
        this.rowDataBuff.writeInt(n2);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        long l2 = 0L;
        this.longDataFile.seek(this.longDataFile.length());
        int n3 = this.maxLongDataSize != 0 ? this.maxLongDataSize : 1024;
        char[] cArray = new char[n3];
        int n4 = reader.read(cArray, 0, n3);
        while (n4 != -1) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.longDataFile.writeChar(cArray[i2]);
            }
            l2 += (long)(n4 * 2);
            if (this.maxLongDataSize != 0) {
                if (n4 >= n3) break;
                n3 = this.maxLongDataSize - (int)(l2 / 2L);
            }
            n4 = reader.read(cArray, 0, n3);
        }
        this.rowDataBuff.writeLong(l2);
    }

    private void cacheBlob(BaseImplBlob baseImplBlob) throws SQLException, IOException, UtilException {
        this.rowDataBuff.writeInt(19);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeBlob(this.longDataFile, baseImplBlob);
    }

    private void cacheClob(BaseImplClob baseImplClob) throws SQLException, IOException, UtilException {
        this.rowDataBuff.writeInt(20);
        this.rowDataBuff.writeLong(this.longDataFile.length());
        this.longDataFile.seek(this.longDataFile.length());
        this.subImplResultSet.writeClob(this.longDataFile, baseImplClob);
    }

    boolean getCachedRow(int n2) throws SQLException {
        boolean bl = false;
        try {
            long l2 = n2 * 8;
            long l3 = this.rowPositionBuff.readLong((int)l2);
            this.intializeRow();
            StringBuffer stringBuffer = new StringBuffer();
            block15: for (int i2 = 0; i2 < this.columns.count(0); ++i2) {
                int n3 = this.rowDataBuff.readInt(l3);
                int n4 = this.rowDataBuff.readInt(l3 += 4L);
                if (n4 == -1) {
                    l3 += 4L;
                    this.rowData[i2].setNull(n3);
                    continue;
                }
                if (n3 == 2) {
                    this.rowData[i2].setBytes(this.rowDataBuff.read(l3 += 4L, n4));
                    l3 += (long)n4;
                    continue;
                }
                if (n3 > 100) {
                    this.rowData[i2].setNativeBytes(this.rowDataBuff.read(l3 += 4L, n4), n3);
                    l3 += (long)n4;
                    continue;
                }
                if (n3 == 15 || n3 == 14) {
                    this.getCachedBinaryStream(n3, l3, this.rowData[i2]);
                    l3 += 16L;
                    continue;
                }
                if (n3 == 18) {
                    this.getCachedCharStream(n3, l3, this.rowData[i2]);
                    l3 += 16L;
                    continue;
                }
                if (n3 == 19) {
                    this.getCachedBlob(this.rowDataBuff.readLong(l3), this.rowData[i2]);
                    l3 += 8L;
                    continue;
                }
                if (n3 == 20) {
                    this.getCachedClob(this.rowDataBuff.readLong(l3), this.rowData[i2]);
                    l3 += 8L;
                    continue;
                }
                l3 += 4L;
                stringBuffer.setLength(0);
                char c2 = '\u0000';
                int n5 = 0;
                while (n5 < n4) {
                    byte by = this.rowDataBuff.read(l3 + (long)n5++);
                    byte by2 = this.rowDataBuff.read(l3 + (long)n5++);
                    c2 = (char)(((by & 0xFF) << 8) + ((by2 & 0xFF) << 0));
                    stringBuffer.append(c2);
                }
                l3 += (long)n4;
                this.rowData[i2].setString(stringBuffer.toString());
                switch (n3) {
                    case 1: {
                        this.rowData[i2].setByte(this.rowData[i2].getByte(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 3: {
                        this.rowData[i2].setShort(this.rowData[i2].getShort(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 4: {
                        this.rowData[i2].setInteger(this.rowData[i2].getInteger(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 5: {
                        this.rowData[i2].setLong(this.rowData[i2].getLong(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 6: {
                        this.rowData[i2].setFloat(this.rowData[i2].getFloat(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 7: {
                        this.rowData[i2].setDouble(this.rowData[i2].getDouble(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 8: 
                    case 21: {
                        this.rowData[i2].setBigDecimal(this.rowData[i2].getBigDecimal(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 9: {
                        this.rowData[i2].setBoolean(this.rowData[i2].getBoolean(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 11: {
                        this.rowData[i2].setDate(this.rowData[i2].getDate(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 12: {
                        this.rowData[i2].setTime(this.rowData[i2].getTime(this.implStatement.implConnection.exceptions));
                        continue block15;
                    }
                    case 13: {
                        this.rowData[i2].setTimestamp(this.rowData[i2].getTimestamp(this.implStatement.implConnection.exceptions));
                    }
                }
            }
            bl = true;
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6040);
        }
        return bl;
    }

    private void getCachedBinaryStream(int n2, long l2, BaseData baseData) throws IOException, UtilException {
        long l3 = this.rowDataBuff.readLong(l2);
        long l4 = this.rowDataBuff.readLong(l2 + 8L);
        BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = new BaseInputStreamOnFileChunk(this.longDataFile, l3, l4);
        baseData.setData(n2, baseInputStreamOnFileChunk);
    }

    private void getCachedCharStream(int n2, long l2, BaseData baseData) throws IOException, UtilException {
        long l3 = this.rowDataBuff.readLong(l2);
        long l4 = this.rowDataBuff.readLong(l2 + 8L);
        BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = new BaseCharStreamOnFileChunk(this.longDataFile, l3, l4);
        baseData.setData(n2, baseCharStreamOnFileChunk);
    }

    private void getCachedBlob(long l2, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l2);
        baseData.setBlob(this.subImplResultSet.readBlob(this.longDataFile));
    }

    private void getCachedClob(long l2, BaseData baseData) throws SQLException, IOException {
        this.longDataFile.seek(l2);
        baseData.setClob(this.subImplResultSet.readClob(this.longDataFile));
    }

    private void intializeRow() {
        if (this.rowData == null) {
            this.rowData = new BaseData[this.columns.count(0)];
            for (int i2 = 0; i2 < this.columns.count(0); ++i2) {
                BaseColumn baseColumn = this.columns.get(i2 + 1);
                this.rowData[i2] = new BaseData();
            }
        }
    }

    public BaseData getData(int n2, int n3) throws SQLException {
        BaseData baseData = this.rowData[n2 - 1];
        Object object = baseData.getObject();
        if (object instanceof BaseInputStreamOnFileChunk) {
            BaseInputStreamOnFileChunk baseInputStreamOnFileChunk = (BaseInputStreamOnFileChunk)object;
            baseData.setData(baseData.getType(), new BaseInputStreamOnFileChunk(baseInputStreamOnFileChunk.file, baseInputStreamOnFileChunk.offset, baseInputStreamOnFileChunk.length));
        } else if (object instanceof BaseCharStreamOnFileChunk) {
            BaseCharStreamOnFileChunk baseCharStreamOnFileChunk = (BaseCharStreamOnFileChunk)object;
            baseData.setData(baseData.getType(), new BaseCharStreamOnFileChunk(baseCharStreamOnFileChunk.file, baseCharStreamOnFileChunk.offset, baseCharStreamOnFileChunk.length));
        }
        return baseData;
    }

    protected boolean setupForNextResultSetInMultipleResult(int n2) throws SQLException {
        boolean bl = this.rowDataBuff == null;
        boolean bl2 = n2 == -1;
        boolean bl3 = false;
        if (n2 == -1) {
            n2 = 0;
        }
        if (bl) {
            this.tempFilesAreReady = false;
            if (!bl2) {
                bl3 = true;
            }
        }
        this.fetchAndCache(Integer.MAX_VALUE, bl3, n2);
        if (bl && !bl2) {
            this.getCachedRow(0);
            this.cursorPosition = 1;
        }
        return true;
    }
}

