/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseCallEscape;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseFunctionEscape;
import com.metamatrix.jdbc.base.BaseTimestampEscape;
import com.metamatrix.util.UtilDebug;
import java.util.Date;

public final class SQLServerEscapeTranslator
extends BaseEscapeTranslator {
    private static String footprint = "$Revision:   3.5.1.0  $";
    BaseConnection conn = null;

    SQLServerEscapeTranslator(BaseConnection baseConnection) {
        this.conn = baseConnection;
    }

    public int getTranslationNeeded(int n) {
        int n2;
        switch (n) {
            case 8212: {
                n2 = 1;
                break;
            }
            case 8193: 
            case 8196: 
            case 8200: 
            case 8209: 
            case 8210: {
                n2 = 2;
                break;
            }
            case 8194: 
            case 8208: {
                n2 = 0;
                break;
            }
            default: {
                UtilDebug.assert("Unknown escape type.", false);
                n2 = 0;
            }
        }
        return n2;
    }

    public String translateCallEscape(BaseCallEscape baseCallEscape) {
        String string = new String("EXEC ");
        if (baseCallEscape.getEscapeType() == 8210) {
            string = string + "? = ";
        }
        string = string + baseCallEscape.getProcedureName() + " " + baseCallEscape.getAllParameters();
        return string;
    }

    public String translateFunctionEscape(BaseFunctionEscape baseFunctionEscape) {
        String string = null;
        switch (baseFunctionEscape.getFunctionType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                break;
            }
            case 12: {
                string = "{fn CONVERT(" + baseFunctionEscape.getParameter(1);
                String string2 = baseFunctionEscape.getParameter(2).toString();
                if (string2.regionMatches(true, 0, "SQL_", 0, 4)) {
                    if (string2.regionMatches(true, 4, "TIME", 0, 4) || string2.regionMatches(true, 4, "DATE", 0, 4) || string2.regionMatches(true, 4, "TIMESTAMP", 0, 9)) {
                        string = string + ", SQL_TYPE_" + string2.substring(4) + ")}";
                        break;
                    }
                    string = string + ", " + string2 + ")}";
                    break;
                }
                if (string2.regionMatches(true, 0, "TIME", 0, 4) || string2.regionMatches(true, 0, "DATE", 0, 4) || string2.regionMatches(true, 0, "TIMESTAMP", 0, 9)) {
                    string = string + ", SQL_TYPE_" + string2 + ")}";
                    break;
                }
                string = string + ", SQL_" + string2 + ")}";
                break;
            }
        }
        return string;
    }

    public String translateTimestampEscape(BaseTimestampEscape baseTimestampEscape) {
        String string = null;
        switch (baseTimestampEscape.getEscapeType()) {
            case 8194: {
                break;
            }
            case 8193: 
            case 8196: {
                Object object;
                string = new String("{ts '");
                if (baseTimestampEscape.getEscapeType() == 8196) {
                    string = string + baseTimestampEscape.getYear() + "-" + baseTimestampEscape.getMonth() + "-" + baseTimestampEscape.getDay();
                } else {
                    switch (this.conn.getDateTimeBehavior()) {
                        case 0: 
                        case 2: {
                            object = new java.sql.Date(System.currentTimeMillis());
                            string = string + String.valueOf(((Date)object).getYear() + 1900) + "-";
                            int n = ((Date)object).getMonth() + 1;
                            if (n < 10) {
                                string = string + "0";
                            }
                            string = string + String.valueOf(n) + "-";
                            int n2 = ((Date)object).getDate();
                            if (n2 < 10) {
                                string = string + "0";
                            }
                            string = string + String.valueOf(n2);
                            break;
                        }
                        case 1: {
                            string = string + "1970-01-01";
                        }
                    }
                }
                string = string + " " + baseTimestampEscape.getHour() + ":" + baseTimestampEscape.getMinutes() + ":" + baseTimestampEscape.getSeconds();
                object = baseTimestampEscape.getSecondsFraction();
                if (object != null) {
                    if (((String)object).length() > 4) {
                        string = string + ((String)object).substring(0, 4);
                        this.warnings.add(7008);
                    } else {
                        string = string + (String)object;
                    }
                }
                string = string + "'}";
            }
        }
        return string;
    }
}

