/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink;

import com.metamatrix.jdbc.sequelink.SequeLinkImplConnection;
import com.metamatrix.jdbc.slbase.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.slbase.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.slbase.BaseResultSetSortDescriptor;
import com.metamatrix.sequelink.ctxt.PidList;
import com.metamatrix.sequelink.jdbc.Utils;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.Message;
import java.sql.SQLException;

public final class SequeLinkImplDatabaseMetaData
extends BaseImplDatabaseMetaData {
    private SequeLinkImplConnection implCon;
    private DiagnosticList dl;
    private PidList pl;
    private int _defaultTransactionIsolation;
    private boolean supportsCatalogs;

    SequeLinkImplDatabaseMetaData(SequeLinkImplConnection sequeLinkImplConnection) throws SQLException {
        this.implCon = sequeLinkImplConnection;
        this.dl = DiagnosticList.GetADummyList();
        this.pl = sequeLinkImplConnection.getPidList();
        this._defaultTransactionIsolation = Utils.NativeToJdbcTxnIsolation(this.getPidInt(11167));
        this.supportsCatalogs = sequeLinkImplConnection.conCtxt.supportsCatalogs(this.dl);
    }

    private int getPidInt(int n2) throws SQLException {
        return this.pl.getPidInt(n2, this.dl);
    }

    private Integer getPidInteger(int n2) throws SQLException {
        return this.pl.getPidInteger(n2, this.dl);
    }

    private String getPidString(int n2) throws SQLException {
        return this.pl.getPidString(n2, this.dl);
    }

    private String commaSeparatedList(int n2, int[] nArray, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if ((n2 & nArray[i2]) == 0) continue;
            stringBuffer.append(stringArray[i2]);
        }
        String string = stringBuffer.toString();
        n3 = string.length();
        if (n3 != 0) {
            string = string.substring(1, n3);
        }
        return string;
    }

    public void initializeNonResultSetMetaData(int n2) throws SQLException {
        switch (n2) {
            case 1: {
                this.allProceduresAreCallable = this.allProceduresAreCallable() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 2: {
                this.allTablesAreSelectable = this.allTablesAreSelectable() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 3: {
                this.isReadOnly = this.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 4: {
                this.nullsAreSortedHigh = this.nullsAreSortedHigh() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 5: {
                this.nullsAreSortedLow = this.nullsAreSortedLow() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 6: {
                this.nullsAreSortedAtStart = this.nullsAreSortedAtStart() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 7: {
                this.nullsAreSortedAtEnd = this.nullsAreSortedAtEnd() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 8: {
                this.databaseProductName = this.getDatabaseProductName();
                break;
            }
            case 9: {
                this.databaseProductVersion = this.getDatabaseProductVersion();
                break;
            }
            case 10: {
                this.usesLocalFiles = this.usesLocalFiles() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 11: {
                this.usesLocalFilePerTable = this.usesLocalFilePerTable() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 12: {
                this.supportsMixedCaseIdentifiers = this.supportsMixedCaseIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 13: {
                this.storesUpperCaseIdentifiers = this.storesUpperCaseIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 14: {
                this.storesLowerCaseIdentifiers = this.storesLowerCaseIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 15: {
                this.storesMixedCaseIdentifiers = this.storesMixedCaseIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 16: {
                this.supportsMixedCaseQuotedIdentifiers = this.supportsMixedCaseQuotedIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 17: {
                this.storesUpperCaseQuotedIdentifiers = this.storesUpperCaseQuotedIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 18: {
                this.storesLowerCaseQuotedIdentifiers = this.storesLowerCaseQuotedIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 19: {
                this.storesMixedCaseQuotedIdentifiers = this.storesMixedCaseQuotedIdentifiers() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 20: {
                this.identifierQuoteString = this.getIdentifierQuoteString();
                break;
            }
            case 21: {
                this.SQLKeywords = this.getSQLKeywords();
                break;
            }
            case 22: {
                this.numericFunctions = this.getNumericFunctions();
                break;
            }
            case 23: {
                this.stringFunctions = this.getStringFunctions();
                break;
            }
            case 24: {
                this.systemFunctions = this.getSystemFunctions();
                break;
            }
            case 25: {
                this.timeDateFunctions = this.getTimeDateFunctions();
                break;
            }
            case 26: {
                this.searchStringEscape = this.getSearchStringEscape();
                break;
            }
            case 27: {
                this.extraNameCharacters = this.getExtraNameCharacters();
                break;
            }
            case 28: {
                this.supportsAlterTableWithAddColumn = this.supportsAlterTableWithAddColumn() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 29: {
                this.supportsAlterTableWithDropColumn = this.supportsAlterTableWithDropColumn() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 30: {
                this.supportsColumnAliasing = this.supportsColumnAliasing() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 31: {
                this.nullPlusNonNullIsNull = this.nullPlusNonNullIsNull() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 32: {
                this.supportsConvert = this.supportsConvert() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 33: {
                this.supportsTableCorrelationNames = this.supportsTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 34: {
                this.supportsDifferentTableCorrelationNames = this.supportsDifferentTableCorrelationNames() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 35: {
                this.supportsExpressionsInOrderBy = this.supportsExpressionsInOrderBy() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 36: {
                this.supportsOrderByUnrelated = this.supportsOrderByUnrelated() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 37: {
                this.supportsGroupBy = this.supportsGroupBy() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 38: {
                this.supportsGroupByUnrelated = this.supportsGroupByUnrelated() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 39: {
                this.supportsGroupByBeyondSelect = this.supportsGroupByBeyondSelect() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 40: {
                this.supportsLikeEscapeClause = this.supportsLikeEscapeClause() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 41: {
                this.supportsMultipleResultSets = this.supportsMultipleResultSets() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 42: {
                this.supportsMultipleTransactions = this.supportsMultipleTransactions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 43: {
                this.supportsNonNullableColumns = this.supportsNonNullableColumns() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 44: {
                this.supportsMinimumSQLGrammar = this.supportsMinimumSQLGrammar() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 45: {
                this.supportsCoreSQLGrammar = this.supportsCoreSQLGrammar() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 46: {
                this.supportsExtendedSQLGrammar = this.supportsExtendedSQLGrammar() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 47: {
                this.supportsANSI92EntryLevelSQL = this.supportsANSI92EntryLevelSQL() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 48: {
                this.supportsANSI92IntermediateSQL = this.supportsANSI92IntermediateSQL() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 49: {
                this.supportsANSI92FullSQL = this.supportsANSI92FullSQL() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 50: {
                this.supportsIntegrityEnhancementFacility = this.supportsIntegrityEnhancementFacility() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 51: {
                this.supportsOuterJoins = this.supportsOuterJoins() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 52: {
                this.supportsFullOuterJoins = this.supportsFullOuterJoins() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 53: {
                this.supportsLimitedOuterJoins = this.supportsLimitedOuterJoins() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 54: {
                this.schemaTerm = this.getSchemaTerm();
                break;
            }
            case 55: {
                this.procedureTerm = this.getProcedureTerm();
                break;
            }
            case 56: {
                this.catalogTerm = this.getCatalogTerm();
                break;
            }
            case 57: {
                this.isCatalogAtStart = this.isCatalogAtStart() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 58: {
                this.catalogSeparator = this.getCatalogSeparator();
                break;
            }
            case 59: {
                this.supportsSchemasInDataManipulation = this.supportsSchemasInDataManipulation() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 60: {
                this.supportsSchemasInProcedureCalls = this.supportsSchemasInProcedureCalls() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 61: {
                this.supportsSchemasInTableDefinitions = this.supportsSchemasInTableDefinitions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 62: {
                this.supportsSchemasInIndexDefinitions = this.supportsSchemasInIndexDefinitions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 63: {
                this.supportsSchemasInPrivilegeDefinitions = this.supportsSchemasInPrivilegeDefinitions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 64: {
                this.supportsCatalogsInDataManipulation = this.supportsCatalogsInDataManipulation() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 65: {
                this.supportsCatalogsInProcedureCalls = this.supportsCatalogsInProcedureCalls() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 66: {
                this.supportsCatalogsInTableDefinitions = this.supportsCatalogsInTableDefinitions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 67: {
                this.supportsCatalogsInIndexDefinitions = this.supportsCatalogsInIndexDefinitions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 68: {
                this.supportsCatalogsInPrivilegeDefinitions = this.supportsCatalogsInPrivilegeDefinitions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 69: {
                this.supportsPositionedDelete = this.supportsPositionedDelete() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 70: {
                this.supportsPositionedUpdate = this.supportsPositionedUpdate() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 71: {
                this.supportsSelectForUpdate = this.supportsSelectForUpdate() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 72: {
                this.supportsStoredProcedures = this.supportsStoredProcedures() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 73: {
                this.supportsSubqueriesInComparisons = this.supportsSubqueriesInComparisons() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 74: {
                this.supportsSubqueriesInExists = this.supportsSubqueriesInExists() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 75: {
                this.supportsSubqueriesInIns = this.supportsSubqueriesInIns() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 76: {
                this.supportsSubqueriesInQuantifieds = this.supportsSubqueriesInQuantifieds() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 77: {
                this.supportsCorrelatedSubqueries = this.supportsCorrelatedSubqueries() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 78: {
                this.supportsUnion = this.supportsUnion() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 79: {
                this.supportsUnionAll = this.supportsUnionAll() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 80: {
                this.supportsOpenCursorsAcrossCommit = this.supportsOpenCursorsAcrossCommit() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 81: {
                this.supportsOpenCursorsAcrossRollback = this.supportsOpenCursorsAcrossRollback() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 82: {
                this.supportsOpenStatementsAcrossCommit = this.supportsOpenStatementsAcrossCommit() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 83: {
                this.supportsOpenStatementsAcrossRollback = this.supportsOpenStatementsAcrossRollback() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 84: {
                this.maxBinaryLiteralLength = this.getMaxBinaryLiteralLength();
                break;
            }
            case 85: {
                this.maxCharLiteralLength = this.getMaxCharLiteralLength();
                break;
            }
            case 86: {
                this.maxColumnNameLength = this.getMaxColumnNameLength();
                break;
            }
            case 87: {
                this.maxColumnsInGroupBy = this.getMaxColumnsInGroupBy();
                break;
            }
            case 88: {
                this.maxColumnsInIndex = this.getMaxColumnsInIndex();
                break;
            }
            case 89: {
                this.maxColumnsInOrderBy = this.getMaxColumnsInOrderBy();
                break;
            }
            case 90: {
                this.maxColumnsInSelect = this.getMaxColumnsInSelect();
                break;
            }
            case 91: {
                this.maxColumnsInTable = this.getMaxColumnsInTable();
                break;
            }
            case 92: {
                this.maxConnections = this.getMaxConnections();
                break;
            }
            case 93: {
                this.maxCursorNameLength = this.getMaxCursorNameLength();
                break;
            }
            case 94: {
                this.maxIndexLength = this.getMaxIndexLength();
                break;
            }
            case 95: {
                this.maxSchemaNameLength = this.getMaxSchemaNameLength();
                break;
            }
            case 96: {
                this.maxProcedureNameLength = this.getMaxProcedureNameLength();
                break;
            }
            case 97: {
                this.maxCatalogNameLength = this.getMaxCatalogNameLength();
                break;
            }
            case 98: {
                this.maxRowSize = this.getMaxRowSize();
                break;
            }
            case 99: {
                this.doesMaxRowSizeIncludeBlobs = this.doesMaxRowSizeIncludeBlobs() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 100: {
                this.maxStatementLength = this.getMaxStatementLength();
                break;
            }
            case 101: {
                this.maxStatements = this.getMaxStatements();
                break;
            }
            case 102: {
                this.maxTableNameLength = this.getMaxTableNameLength();
                break;
            }
            case 103: {
                this.maxTablesInSelect = this.getMaxTablesInSelect();
                break;
            }
            case 104: {
                this.maxUserNameLength = this.getMaxUserNameLength();
                break;
            }
            case 105: {
                this.defaultTransactionIsolation = this.getDefaultTransactionIsolation();
                break;
            }
            case 106: {
                this.supportsTransactions = this.supportsTransactions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 107: {
                this.supportsTransactionIsolationLevelReadCommited = this.supportsTransactionIsolationLevel(2) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 108: {
                this.supportsTransactionIsolationLevelReadUncommited = this.supportsTransactionIsolationLevel(1) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 109: {
                this.supportsTransactionIsolationLevelRepeatableRead = this.supportsTransactionIsolationLevel(4) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 110: {
                this.supportsTransactionIsolationLevelSerializable = this.supportsTransactionIsolationLevel(8) ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 111: {
                this.supportsDataDefinitionAndDataManipulationTransactions = this.supportsDataDefinitionAndDataManipulationTransactions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 112: {
                this.supportsDataManipulationTransactionsOnly = this.supportsDataManipulationTransactionsOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 113: {
                this.dataDefinitionCausesTransactionCommit = this.dataDefinitionCausesTransactionCommit() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 114: {
                this.dataDefinitionIgnoredInTransactions = this.dataDefinitionIgnoredInTransactions() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 115: {
                this.supportsResultSetTypeScrollInsensitive = this.supportsResultSetTypeScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 116: {
                this.supportsResultSetTypeScrollSensitive = this.supportsResultSetTypeScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 117: {
                this.ownUpdatesAreVisibleForwardOnly = this.ownUpdatesAreVisibleForwardOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 118: {
                this.ownUpdatesAreVisibleScrollInsensitive = this.ownUpdatesAreVisibleScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 119: {
                this.ownUpdatesAreVisibleScrollSensitive = this.ownUpdatesAreVisibleScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 120: {
                this.ownDeletesAreVisibleForwardOnly = this.ownDeletesAreVisibleForwardOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 121: {
                this.ownDeletesAreVisibleScrollInsensitive = this.ownDeletesAreVisibleScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 122: {
                this.ownDeletesAreVisibleScrollSensitive = this.ownDeletesAreVisibleScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 123: {
                this.ownInsertsAreVisibleForwardOnly = this.ownInsertsAreVisibleForwardOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 124: {
                this.ownInsertsAreVisibleScrollInsensitive = this.ownInsertsAreVisibleScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 125: {
                this.ownInsertsAreVisibleScrollSensitive = this.ownInsertsAreVisibleScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 126: {
                this.othersUpdatesAreVisibleForwardOnly = this.othersUpdatesAreVisibleForwardOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 127: {
                this.othersUpdatesAreVisibleScrollInsensitive = this.othersUpdatesAreVisibleScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 128: {
                this.othersUpdatesAreVisibleScrollSensitive = this.othersUpdatesAreVisibleScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 129: {
                this.othersDeletesAreVisibleForwardOnly = this.othersDeletesAreVisibleForwardOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 130: {
                this.othersDeletesAreVisibleScrollInsensitive = this.othersDeletesAreVisibleScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 131: {
                this.othersDeletesAreVisibleScrollSensitive = this.othersDeletesAreVisibleScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 132: {
                this.othersInsertsAreVisibleForwardOnly = this.othersInsertsAreVisibleForwardOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 133: {
                this.othersInsertsAreVisibleScrollInsensitive = this.othersInsertsAreVisibleScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 134: {
                this.othersInsertsAreVisibleScrollSensitive = this.othersInsertsAreVisibleScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 135: {
                this.updatesAreDetectedForwardOnly = this.updatesAreDetectedForwardOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 136: {
                this.updatesAreDetectedScrollInsensitive = this.updatesAreDetectedScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 137: {
                this.updatesAreDetectedScrollSensitive = this.updatesAreDetectedScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 138: {
                this.deletesAreDetectedForwardOnly = this.deletesAreDetectedForwardOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 139: {
                this.deletesAreDetectedScrollInsensitive = this.deletesAreDetectedScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 140: {
                this.deletesAreDetectedScrollSensitive = this.deletesAreDetectedScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 141: {
                this.insertsAreDetectedForwardOnly = this.insertsAreDetectedForwardOnly() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 142: {
                this.insertsAreDetectedScrollInsensitive = this.insertsAreDetectedScrollInsensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 143: {
                this.insertsAreDetectedScrollSensitive = this.insertsAreDetectedScrollSensitive() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 144: {
                this.supportsBatchUpdates = this.supportsBatchUpdates() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 145: {
                this.locatorsUpdateCopy = this.locatorsUpdateCopy() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 146: {
                this.supportsSavepoints = this.supportsSavepoints() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 147: {
                this.supportsNamedParameters = this.supportsNamedParameters() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 148: {
                this.supportsMultipleOpenResults = this.supportsMultipleOpenResults() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 149: {
                this.supportsGetGeneratedKeys = this.supportsGetGeneratedKeys() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 151: {
                this.resultSetHoldability = this.resultSetHoldability();
                break;
            }
            case 152: {
                this.databaseMajorVersion = this.databaseMajorVersion();
                break;
            }
            case 153: {
                this.databaseMinorVersion = this.databaseMinorVersion();
                break;
            }
            case 154: {
                this.sqlStateType = this.sqlStateType();
                break;
            }
            default: {
                throw new InternalError("SequeLinkImplDatabaseMetaData.initializeNonResultSetMetaData");
            }
        }
    }

    protected String getResultSetSQL(int n2, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        return null;
    }

    protected boolean stripDoubleQuotesFromValues() {
        return false;
    }

    private boolean allProceduresAreCallable() throws SQLException {
        int n2 = this.getPidInt(11100);
        return n2 == 1;
    }

    private boolean allTablesAreSelectable() throws SQLException {
        int n2 = this.getPidInt(11101);
        return n2 == 1;
    }

    protected String getUserName() throws SQLException {
        return this.getPidString(11169);
    }

    private boolean isReadOnly() throws SQLException {
        int n2 = this.getPidInt(11014);
        return n2 == 1;
    }

    private boolean nullsAreSortedHigh() throws SQLException {
        int n2 = this.getPidInt(11238);
        return n2 == 0;
    }

    private boolean nullsAreSortedLow() throws SQLException {
        int n2 = this.getPidInt(11238);
        return n2 == 1;
    }

    private boolean nullsAreSortedAtStart() throws SQLException {
        int n2 = this.getPidInt(11238);
        return n2 == 2;
    }

    private boolean nullsAreSortedAtEnd() throws SQLException {
        int n2 = this.getPidInt(11238);
        return n2 == 4;
    }

    private String getDatabaseProductName() throws SQLException {
        return this.getPidString(11129);
    }

    private String getDatabaseProductVersion() throws SQLException {
        return this.getPidString(11130);
    }

    private String getDriverName() throws SQLException {
        return "SequeLink";
    }

    private boolean usesLocalFiles() throws SQLException {
        return false;
    }

    private boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    private boolean supportsMixedCaseIdentifiers() throws SQLException {
        int n2 = this.getPidInt(11132);
        return n2 == 3;
    }

    private boolean storesUpperCaseIdentifiers() throws SQLException {
        int n2 = this.getPidInt(11132);
        return n2 == 1;
    }

    private boolean storesLowerCaseIdentifiers() throws SQLException {
        int n2 = this.getPidInt(11132);
        return n2 == 2;
    }

    private boolean storesMixedCaseIdentifiers() throws SQLException {
        int n2 = this.getPidInt(11132);
        return n2 == 4;
    }

    private boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        int n2 = this.getPidInt(11241);
        return n2 == 3;
    }

    private boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        int n2 = this.getPidInt(11241);
        return n2 == 1;
    }

    private boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        int n2 = this.getPidInt(11241);
        return n2 == 2;
    }

    private boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        int n2 = this.getPidInt(11241);
        return n2 == 4;
    }

    private String getIdentifierQuoteString() throws SQLException {
        return this.getPidString(11133);
    }

    private String getSQLKeywords() throws SQLException {
        return this.getPidString(11228);
    }

    private String getNumericFunctions() throws SQLException {
        int n2 = this.getPidInt(11152);
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 262144, 256, 512, 1024, 524288, 2048, 65536, 0x100000, 0x200000, 131072, 0x400000, 4096, 8192, 16384, 32768, 0x800000};
        String[] stringArray = new String[]{",ABS", ",ACOS", ",ASIN", ",ATAN", ",ATAN2", ",CEILING", ",COS", ",COT", ",DEGREES", ",EXP", ",FLOOR", ",LOG", ",LOG10", ",MOD", ",PI", ",POWER", ",RADIANS", ",RAND", ",ROUND", ",SIGN", ",SIN", ",SQRT", ",TAN", ",TRUNCATE"};
        return this.commaSeparatedList(n2, nArray, stringArray);
    }

    private String getStringFunctions() throws SQLException {
        int n2 = this.getPidInt(11162);
        int[] nArray = new int[]{8192, 524288, 16384, 0x100000, 0x200000, 1, 32768, 2, 64, 4, 16, 32, 65536, 8, 0x400000, 0x800000, 128, 256, 512, 1024, 131072, 262144, 2048, 4096};
        String[] stringArray = new String[]{",ASCII", ",BIT_LENGTH", ",CHAR", ",CHAR_LENGTH", ",CHARACTER_LENGTH", ",CONCAT", ",DIFFERENCE", ",INSERT", ",LCASE", ",LEFT", ",LENGTH", ",LOCATE", ",LOCATE_2", ",LTRIM", ",OCTET_LENGTH", ",POSITION", ",REPEAT", ",REPLACE", ",RIGHT", ",RTRIM", ",SOUNDEX", ",SPACE", ",SUBSTRING", ",UCASE"};
        return this.commaSeparatedList(n2, nArray, stringArray);
    }

    private String getSystemFunctions() throws SQLException {
        int n2 = this.getPidInt(11163);
        int[] nArray = new int[]{2, 4, 1};
        String[] stringArray = new String[]{",DBNAME", ",IFNULL", ",USERNAME"};
        return this.commaSeparatedList(n2, nArray, stringArray);
    }

    private String getTimeDateFunctions() throws SQLException {
        int n2 = this.getPidInt(11165);
        int[] nArray = new int[]{2, 131072, 262144, 524288, 512, 32768, 4, 8, 16, 0x100000, 1024, 2048, 32, 65536, 0, 1, 64, 4096, 8192, 16384, 128, 256};
        String[] stringArray = new String[]{",CURDATE", ",CURRENT_DATE", ",CURRENT_TIME", ",CURRENT_TIMESTAMP", ",CURTIME", ",DAYNAME", ",DAYOFMONTH", ",DAYOFWEEK", ",DAYOFYEAR", ",EXTRACT", ",HOUR", ",MINUTE", ",MONTH", ",MONTHNAME", ",NONE", ",NOW", ",QUARTER", ",SECOND", ",TIMESTAMPADD", ",TIMESTAMPDIFF", ",WEEK", ",YEAR"};
        return this.commaSeparatedList(n2, nArray, stringArray);
    }

    private String getSearchStringEscape() throws SQLException {
        return this.getPidString(11161);
    }

    private String getExtraNameCharacters() throws SQLException {
        return this.getPidString(11245);
    }

    private boolean supportsAlterTableWithAddColumn() throws SQLException {
        int n2;
        int n3 = this.getPidInt(11201);
        return (n3 & (n2 = 225)) != 0;
    }

    private boolean supportsAlterTableWithDropColumn() throws SQLException {
        int n2;
        int n3 = this.getPidInt(11201);
        return (n3 & (n2 = 3586)) != 0;
    }

    private boolean supportsColumnAliasing() throws SQLException {
        int n2 = this.getPidInt(11207);
        return n2 == 1;
    }

    private boolean nullPlusNonNullIsNull() throws SQLException {
        int n2 = this.getPidInt(11104);
        return n2 == 0;
    }

    private boolean supportsConvert() throws SQLException {
        int n2 = this.getPidInt(11113);
        return (n2 & 1) != 0;
    }

    public boolean supportsConvert(int n2, int n3) throws SQLException {
        int n4;
        int n5;
        switch (n2) {
            case 1: {
                n5 = 11108;
                break;
            }
            case 12: {
                n5 = 11124;
                break;
            }
            case -1: {
                n5 = 11116;
                break;
            }
            case 2: {
                n5 = 11117;
                break;
            }
            case 3: {
                n5 = 11110;
                break;
            }
            case -7: 
            case 16: {
                n5 = 11107;
                break;
            }
            case -6: {
                n5 = 11122;
                break;
            }
            case 5: {
                n5 = 11119;
                break;
            }
            case 4: {
                n5 = 11114;
                break;
            }
            case -5: {
                n5 = 11105;
                break;
            }
            case 7: {
                n5 = 11118;
                break;
            }
            case 6: {
                n5 = 11112;
                break;
            }
            case 8: {
                n5 = 11111;
                break;
            }
            case -2: {
                n5 = 11106;
                break;
            }
            case -3: {
                n5 = 11123;
                break;
            }
            case -4: {
                n5 = 11115;
                break;
            }
            case 91: {
                n5 = 11109;
                break;
            }
            case 92: {
                n5 = 11120;
                break;
            }
            case 93: {
                n5 = 11121;
                break;
            }
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return false;
            }
            default: {
                throw Message.Gen.getSqlException(7393, "fromType");
            }
        }
        int n6 = this.getPidInt(n5);
        switch (n3) {
            case 1: {
                n4 = 1;
                break;
            }
            case 12: {
                n4 = 256;
                break;
            }
            case -1: {
                n4 = 512;
                break;
            }
            case 2: {
                n4 = 2;
                break;
            }
            case 3: {
                n4 = 4;
                break;
            }
            case -7: 
            case 16: {
                n4 = 4096;
                break;
            }
            case -6: {
                n4 = 8192;
                break;
            }
            case 5: {
                n4 = 16;
                break;
            }
            case 4: {
                n4 = 8;
                break;
            }
            case -5: {
                n4 = 16384;
                break;
            }
            case 7: {
                n4 = 64;
                break;
            }
            case 6: {
                n4 = 32;
                break;
            }
            case 8: {
                n4 = 128;
                break;
            }
            case -2: {
                n4 = 1024;
                break;
            }
            case -3: {
                n4 = 2048;
                break;
            }
            case -4: {
                n4 = 262144;
                break;
            }
            case 91: {
                n4 = 32768;
                break;
            }
            case 92: {
                n4 = 65536;
                break;
            }
            case 93: {
                n4 = 131072;
                break;
            }
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return false;
            }
            default: {
                throw Message.Gen.getSqlException(7393, "toType");
            }
        }
        return (n6 & n4) != 0;
    }

    private boolean supportsTableCorrelationNames() throws SQLException {
        int n2 = this.getPidInt(11125);
        return n2 != 0;
    }

    private boolean supportsDifferentTableCorrelationNames() throws SQLException {
        int n2 = this.getPidInt(11125);
        return n2 == 1;
    }

    private boolean supportsExpressionsInOrderBy() throws SQLException {
        int n2 = this.getPidInt(11131);
        return n2 == 1;
    }

    private boolean supportsOrderByUnrelated() throws SQLException {
        int n2 = this.getPidInt(11240);
        return n2 != 1;
    }

    private boolean supportsGroupBy() throws SQLException {
        int n2 = this.getPidInt(11226);
        return n2 != 0;
    }

    private boolean supportsGroupByUnrelated() throws SQLException {
        int n2 = this.getPidInt(11226);
        return n2 == 3;
    }

    private boolean supportsGroupByBeyondSelect() throws SQLException {
        int n2 = this.getPidInt(11226);
        return n2 == 2;
    }

    private boolean supportsLikeEscapeClause() throws SQLException {
        int n2 = this.getPidInt(11229);
        return n2 == 1;
    }

    private boolean supportsMultipleResultSets() throws SQLException {
        int n2 = this.getPidInt(11150);
        return n2 == 1;
    }

    private boolean supportsMultipleTransactions() throws SQLException {
        int n2 = this.getPidInt(11280);
        return n2 == 1;
    }

    private boolean supportsNonNullableColumns() throws SQLException {
        int n2 = this.getPidInt(11151);
        return n2 == 1;
    }

    private boolean supportsMinimumSQLGrammar() throws SQLException {
        int n2 = this.getPidInt(11153);
        return n2 >= 0;
    }

    private boolean supportsCoreSQLGrammar() throws SQLException {
        int n2 = this.getPidInt(11153);
        return n2 >= 1;
    }

    private boolean supportsExtendedSQLGrammar() throws SQLException {
        int n2 = this.getPidInt(11153);
        return n2 == 2;
    }

    private boolean supportsANSI92EntryLevelSQL() throws SQLException {
        int n2 = this.getPidInt(11257);
        return (n2 & 1) != 0;
    }

    private boolean supportsANSI92IntermediateSQL() throws SQLException {
        int n2 = this.getPidInt(11257);
        return (n2 & 4) != 0;
    }

    private boolean supportsANSI92FullSQL() throws SQLException {
        int n2 = this.getPidInt(11257);
        return (n2 & 8) != 0;
    }

    private boolean supportsIntegrityEnhancementFacility() throws SQLException {
        int n2 = this.getPidInt(11154);
        return n2 == 1;
    }

    private boolean supportsOuterJoins() throws SQLException {
        int n2 = this.getPidInt(11239);
        return n2 != 0;
    }

    private boolean supportsFullOuterJoins() throws SQLException {
        int n2 = this.getPidInt(11239);
        return (n2 & 4) != 0;
    }

    private boolean supportsLimitedOuterJoins() throws SQLException {
        int n2 = this.getPidInt(11239);
        return (n2 & 1) != 0 || (n2 & 2) != 0;
    }

    private String getSchemaTerm() throws SQLException {
        return this.getPidString(11156);
    }

    private String getProcedureTerm() throws SQLException {
        return this.getPidString(11158);
    }

    private String getCatalogTerm() throws SQLException {
        if (!this.supportsCatalogs) {
            return "";
        }
        return this.getPidString(11160);
    }

    private boolean isCatalogAtStart() throws SQLException {
        if (!this.supportsCatalogs) {
            return false;
        }
        int n2 = this.getPidInt(11205);
        return n2 == 1;
    }

    private String getCatalogSeparator() throws SQLException {
        if (!this.supportsCatalogs) {
            return "";
        }
        return this.getPidString(11159);
    }

    private boolean supportsSchemasInDataManipulation() throws SQLException {
        int n2 = this.getPidInt(11244);
        return (n2 & 1) != 0;
    }

    private boolean supportsSchemasInProcedureCalls() throws SQLException {
        int n2 = this.getPidInt(11244);
        return (n2 & 2) != 0;
    }

    private boolean supportsSchemasInTableDefinitions() throws SQLException {
        int n2 = this.getPidInt(11244);
        return (n2 & 4) != 0;
    }

    private boolean supportsSchemasInIndexDefinitions() throws SQLException {
        int n2 = this.getPidInt(11244);
        return (n2 & 8) != 0;
    }

    private boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        int n2 = this.getPidInt(11244);
        return (n2 & 0x10) != 0;
    }

    private boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (!this.supportsCatalogs) {
            return false;
        }
        int n2 = this.getPidInt(11206);
        return (n2 & 1) != 0;
    }

    private boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (!this.supportsCatalogs) {
            return false;
        }
        int n2 = this.getPidInt(11206);
        return (n2 & 2) != 0;
    }

    private boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (!this.supportsCatalogs) {
            return false;
        }
        int n2 = this.getPidInt(11206);
        return (n2 & 4) != 0;
    }

    private boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (!this.supportsCatalogs) {
            return false;
        }
        int n2 = this.getPidInt(11206);
        return (n2 & 8) != 0;
    }

    private boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (!this.supportsCatalogs) {
            return false;
        }
        int n2 = this.getPidInt(11206);
        return (n2 & 0x10) != 0;
    }

    private boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    private boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    private boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    private boolean supportsStoredProcedures() throws SQLException {
        int n2 = this.getPidInt(11157);
        return n2 == 1;
    }

    private boolean supportsSubqueriesInComparisons() throws SQLException {
        int n2 = this.getPidInt(11246);
        return (n2 & 1) != 0;
    }

    private boolean supportsSubqueriesInExists() throws SQLException {
        int n2 = this.getPidInt(11246);
        return (n2 & 2) != 0;
    }

    private boolean supportsSubqueriesInIns() throws SQLException {
        int n2 = this.getPidInt(11246);
        return (n2 & 4) != 0;
    }

    private boolean supportsSubqueriesInQuantifieds() throws SQLException {
        int n2 = this.getPidInt(11246);
        return (n2 & 8) != 0;
    }

    private boolean supportsCorrelatedSubqueries() throws SQLException {
        int n2 = this.getPidInt(11246);
        return (n2 & 0x10) != 0;
    }

    private boolean supportsUnion() throws SQLException {
        int n2 = this.getPidInt(11249);
        return (n2 & 1) != 0;
    }

    private boolean supportsUnionAll() throws SQLException {
        int n2 = this.getPidInt(11249);
        return (n2 & 2) != 0;
    }

    private boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        int n2 = this.getPidInt(11126);
        return n2 == 2;
    }

    private boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        int n2 = this.getPidInt(11127);
        return n2 == 2;
    }

    private boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        int n2 = this.getPidInt(11126);
        return n2 != 0;
    }

    private boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        int n2 = this.getPidInt(11127);
        return n2 != 0;
    }

    private Integer getMaxBinaryLiteralLength() throws SQLException {
        return this.getPidInteger(11278);
    }

    private Integer getMaxCharLiteralLength() throws SQLException {
        return this.getPidInteger(11279);
    }

    private Integer getMaxColumnNameLength() throws SQLException {
        return this.getPidInteger(11144);
    }

    private Integer getMaxColumnsInGroupBy() throws SQLException {
        return this.getPidInteger(11230);
    }

    private Integer getMaxColumnsInIndex() throws SQLException {
        return this.getPidInteger(11231);
    }

    private Integer getMaxColumnsInOrderBy() throws SQLException {
        return this.getPidInteger(11232);
    }

    private Integer getMaxColumnsInSelect() throws SQLException {
        return this.getPidInteger(11233);
    }

    private Integer getMaxColumnsInTable() throws SQLException {
        return this.getPidInteger(11234);
    }

    private Integer getMaxConnections() throws SQLException {
        return new Integer(0);
    }

    private Integer getMaxCursorNameLength() throws SQLException {
        return this.getPidInteger(11145);
    }

    private Integer getMaxIndexLength() throws SQLException {
        return this.getPidInteger(11236);
    }

    private Integer getMaxSchemaNameLength() throws SQLException {
        return this.getPidInteger(11146);
    }

    private Integer getMaxProcedureNameLength() throws SQLException {
        return this.getPidInteger(11147);
    }

    private Integer getMaxCatalogNameLength() throws SQLException {
        return this.getPidInteger(11148);
    }

    private Integer getMaxRowSize() throws SQLException {
        return this.getPidInteger(11275);
    }

    private boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        int n2 = this.getPidInt(11276);
        return n2 == 1;
    }

    private Integer getMaxStatementLength() throws SQLException {
        return new Integer(0);
    }

    private Integer getMaxStatements() throws SQLException {
        return this.getPidInteger(11102);
    }

    private Integer getMaxTableNameLength() throws SQLException {
        return this.getPidInteger(11149);
    }

    private Integer getMaxTablesInSelect() throws SQLException {
        return this.getPidInteger(11237);
    }

    private Integer getMaxUserNameLength() throws SQLException {
        return this.getMaxSchemaNameLength();
    }

    private Integer getDefaultTransactionIsolation() throws SQLException {
        return new Integer(this._defaultTransactionIsolation);
    }

    private boolean supportsTransactions() throws SQLException {
        int n2 = this.getPidInt(11166);
        return n2 != 0;
    }

    private boolean supportsTransactionIsolationLevel(int n2) throws SQLException {
        int n3 = this.getPidInt(11168);
        switch (n2) {
            case 0: {
                return n3 == 0;
            }
            case 1: {
                return (n3 & 1) != 0;
            }
            case 2: {
                return (n3 & 2) != 0;
            }
            case 4: {
                return (n3 & 4) != 0;
            }
            case 8: {
                return (n3 & 8) != 0;
            }
        }
        throw Message.Gen.getSqlException(7393, "level");
    }

    private boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        int n2 = this.getPidInt(11166);
        return n2 == 2;
    }

    private boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        int n2 = this.getPidInt(11166);
        return n2 == 1;
    }

    private boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        int n2 = this.getPidInt(11166);
        return n2 == 3;
    }

    private boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        int n2 = this.getPidInt(11166);
        return n2 == 4;
    }

    private boolean supportsResultSetTypeScrollInsensitive() throws SQLException {
        return true;
    }

    private boolean supportsResultSetTypeScrollSensitive() throws SQLException {
        return false;
    }

    private boolean ownUpdatesAreVisibleForwardOnly() throws SQLException {
        return false;
    }

    private boolean ownUpdatesAreVisibleScrollInsensitive() throws SQLException {
        return false;
    }

    private boolean ownUpdatesAreVisibleScrollSensitive() throws SQLException {
        return false;
    }

    private boolean ownDeletesAreVisibleForwardOnly() throws SQLException {
        return false;
    }

    private boolean ownDeletesAreVisibleScrollInsensitive() throws SQLException {
        return false;
    }

    private boolean ownDeletesAreVisibleScrollSensitive() throws SQLException {
        return false;
    }

    private boolean ownInsertsAreVisibleForwardOnly() throws SQLException {
        return false;
    }

    private boolean ownInsertsAreVisibleScrollInsensitive() throws SQLException {
        return false;
    }

    private boolean ownInsertsAreVisibleScrollSensitive() throws SQLException {
        return false;
    }

    private boolean othersUpdatesAreVisibleForwardOnly() throws SQLException {
        return false;
    }

    private boolean othersUpdatesAreVisibleScrollInsensitive() throws SQLException {
        return false;
    }

    private boolean othersUpdatesAreVisibleScrollSensitive() throws SQLException {
        return false;
    }

    private boolean othersDeletesAreVisibleForwardOnly() throws SQLException {
        return false;
    }

    private boolean othersDeletesAreVisibleScrollInsensitive() throws SQLException {
        return false;
    }

    private boolean othersDeletesAreVisibleScrollSensitive() throws SQLException {
        return false;
    }

    private boolean othersInsertsAreVisibleForwardOnly() throws SQLException {
        return false;
    }

    private boolean othersInsertsAreVisibleScrollInsensitive() throws SQLException {
        return false;
    }

    private boolean othersInsertsAreVisibleScrollSensitive() throws SQLException {
        return false;
    }

    private boolean updatesAreDetectedForwardOnly() throws SQLException {
        return false;
    }

    private boolean updatesAreDetectedScrollInsensitive() throws SQLException {
        return false;
    }

    private boolean updatesAreDetectedScrollSensitive() throws SQLException {
        return false;
    }

    private boolean deletesAreDetectedForwardOnly() throws SQLException {
        return false;
    }

    private boolean deletesAreDetectedScrollInsensitive() throws SQLException {
        return false;
    }

    private boolean deletesAreDetectedScrollSensitive() throws SQLException {
        return false;
    }

    private boolean insertsAreDetectedForwardOnly() throws SQLException {
        return false;
    }

    private boolean insertsAreDetectedScrollInsensitive() throws SQLException {
        return false;
    }

    private boolean insertsAreDetectedScrollSensitive() throws SQLException {
        return false;
    }

    private boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    private boolean locatorsUpdateCopy() throws SQLException {
        if (!this.implCon.supportsLobsNatively()) {
            return true;
        }
        int n2 = this.getPidInt(11405);
        return n2 == 1;
    }

    private boolean supportsSavepoints() throws SQLException {
        int n2 = this.getPidInt(11400);
        return n2 == 1;
    }

    private boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    private boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    private boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    private Integer resultSetHoldability() throws SQLException {
        int n2 = this.getPidInt(11126);
        if (n2 == 2) {
            return new Integer(1);
        }
        return new Integer(2);
    }

    private Integer databaseMajorVersion() throws SQLException {
        return this.getPidInteger(11402);
    }

    private Integer databaseMinorVersion() throws SQLException {
        return this.getPidInteger(11403);
    }

    private Integer sqlStateType() throws SQLException {
        return new Integer(2);
    }
}

