/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.IIOP;
import com.metamatrix.sequelink.net.IIOPFormat;
import com.metamatrix.sequelink.net.IIOPOctetSequence;
import com.metamatrix.sequelink.net.IIOPString;
import com.metamatrix.sequelink.net.NetworkException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class IIOPDecoder {
    DataInputStream dis;
    IIOP iiop;
    IIOPFormat iiopFormat;

    public IIOPDecoder(InputStream inputStream) throws NetworkException {
        this.dis = new DataInputStream(inputStream);
        this.decodeProtocolIdentifier();
        this.decodeProtocolHeader();
    }

    public IIOPDecoder(InputStream inputStream, IIOP iIOP) throws NetworkException {
        this.dis = new DataInputStream(inputStream);
        this.iiop = iIOP;
        this.decodeProtocolMessage();
    }

    public IIOP getIIOP() {
        return this.iiop;
    }

    public IIOPFormat getIIOPFormat() {
        return this.iiopFormat;
    }

    private void decodeProtocolIdentifier() throws NetworkException {
        byte[] byArray = new byte[4];
        try {
            this.dis.readFully(byArray);
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        IIOPFormat.validateProtoId(byArray);
    }

    private void decodeProtocolHeader() throws NetworkException {
        int n;
        byte by;
        byte by2;
        byte by3;
        byte by4;
        try {
            by4 = this.dis.readByte();
            by3 = this.dis.readByte();
            by2 = this.dis.readByte();
            by = this.dis.readByte();
            n = this.dis.readInt();
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        this.iiopFormat = new IIOPFormat(by4, by3, by, by2, n);
        this.iiop = this.iiopFormat.getIIOP();
    }

    private void decodeProtocolMessage() throws NetworkException {
        switch (this.iiop.getMsgType()) {
            case 0: {
                this.decodeRequest();
                break;
            }
            case 1: {
                this.decodeReply();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw IIOP.getException(7524);
            }
        }
    }

    private void decodeRequest() throws NetworkException {
        byte by;
        int n;
        int n2;
        byte by2;
        int n3;
        int n4;
        try {
            n4 = this.dis.readInt();
            n3 = this.dis.readInt();
            by2 = this.dis.readByte();
            byte by3 = this.dis.readByte();
            by3 = this.dis.readByte();
            by3 = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        IIOPOctetSequence iIOPOctetSequence = new IIOPOctetSequence(this.dis, this.iiop.isBigEndian());
        IIOPString iIOPString = new IIOPString(this.dis, this.iiop.isBigEndian());
        try {
            n2 = this.dis.readInt();
            n = this.dis.readInt();
            by = this.dis.readByte();
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        this.iiopFormat = new IIOPFormat(this.iiop, n4, n3, by2, iIOPOctetSequence, iIOPString, n2, n, by);
        this.iiop = this.iiopFormat.getIIOP();
    }

    private void decodeReply() throws NetworkException {
        int n;
        int n2;
        int n3;
        try {
            n3 = this.dis.readInt();
            n2 = this.dis.readInt();
            n = this.dis.readInt();
        }
        catch (IOException iOException) {
            throw IIOP.getException(7531, iOException.getMessage());
        }
        this.iiopFormat = new IIOPFormat(this.iiop, n3, n2, n);
        this.iiop = this.iiopFormat.getIIOP();
        if (this.iiop.getReplyStatus() == 0) {
            byte by;
            int n4;
            try {
                n4 = this.dis.readInt();
            }
            catch (IOException iOException) {
                throw IIOP.getException(7531, iOException.getMessage());
            }
            try {
                by = this.dis.readByte();
            }
            catch (IOException iOException) {
                throw IIOP.getException(7531, iOException.getMessage());
            }
            if (by != 0) {
                throw IIOP.getException(7532);
            }
            this.iiop.setDataLen(n4);
        } else {
            try {
                this.iiop.setDataLen(this.dis.available());
            }
            catch (IOException iOException) {
                throw IIOP.getException(7531, iOException.getMessage());
            }
        }
    }
}

