/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.dqp.ui.config;

import com.metamatrix.core.event.IChangeListener;
import com.metamatrix.core.event.IChangeNotifier;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.dqp.execution.VdbExecutionValidator;
import com.metamatrix.modeler.dqp.internal.execution.WorkspaceProblemsExecutionValidatorImpl;
import com.metamatrix.modeler.dqp.ui.DqpUiConstants;
import com.metamatrix.modeler.internal.dqp.ui.actions.VdbExecutor;
import com.metamatrix.modeler.internal.dqp.ui.config.ConnectorBindingsPanel;
import com.metamatrix.modeler.internal.dqp.ui.views.ConfigurationManagerView;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.vdb.ui.editor.IVdbEditorPage;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.util.WidgetFactory;
import com.metamatrix.vdb.edit.VdbContextEditor;
import com.metamatrix.vdb.edit.VdbEditingContext;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.part.services.NullEditorInput;
import org.eclipse.ui.part.EditorPart;

public class ConnectorBindingsEditorPart
extends EditorPart
implements IChangeListener,
IVdbEditorPage,
DqpUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$dqp$ui$config$ConnectorBindingsEditorPart == null ? (class$com$metamatrix$modeler$internal$dqp$ui$config$ConnectorBindingsEditorPart = ConnectorBindingsEditorPart.class$("com.metamatrix.modeler.internal.dqp.ui.config.ConnectorBindingsEditorPart")) : class$com$metamatrix$modeler$internal$dqp$ui$config$ConnectorBindingsEditorPart));
    private static final String TXN_AUTOWRAP_OPTIMISTIC = "OPTIMISTIC";
    private static final String TXN_AUTOWRAP_PESSIMISTIC = "PESSIMISTIC";
    private static final String TXN_AUTOWRAP_OFF = "OFF";
    private static final String[] TXN_AUTOWRAP_OPTIONS = new String[]{"OPTIMISTIC", "PESSIMISTIC", "OFF"};
    private Button btnExecute;
    private Combo comboTxnAutoWrap;
    private CLabel lblImage;
    private StyledText lblStatus;
    private Composite pnlMain;
    private ConnectorBindingsPanel pnlBindings;
    private IChangeListener changeListener;
    protected boolean dirty;
    private VdbExecutor executor;
    protected File vdbFile;
    protected VdbEditingContext vdbContext;
    protected VdbContextEditor vdbContextEditor;
    private boolean executionPropsChanged;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$dqp$ui$config$ConnectorBindingsEditorPart;
    static /* synthetic */ Class class$com$metamatrix$vdb$internal$edit$InternalVdbEditingContext;

    private static final String getString(String theKey) {
        return DqpUiConstants.UTIL.getStringOrKey(PREFIX + theKey);
    }

    private static final String getString(String id, Object obj) {
        return DqpUiConstants.UTIL.getString(PREFIX + id, obj);
    }

    public void createPartControl(Composite theParent) {
        ScrolledComposite scroller = new ScrolledComposite(theParent, 768);
        scroller.setLayout((Layout)new GridLayout());
        ScrollBar bar = scroller.getHorizontalBar();
        if (bar != null) {
            bar.setIncrement(12);
            bar.setPageIncrement(60);
        }
        if ((bar = scroller.getVerticalBar()) != null) {
            bar.setIncrement(12);
            bar.setPageIncrement(60);
        }
        this.pnlMain = WidgetFactory.createPanel((Composite)scroller, (int)0, (int)1808);
        scroller.setContent((Control)this.pnlMain);
        Display display = this.pnlMain.getDisplay();
        FormToolkit toolkit = null;
        toolkit = new FormToolkit(display);
        toolkit.setBackground(this.pnlMain.getBackground());
        Group group = WidgetFactory.createGroup((Composite)this.pnlMain, (String)ConnectorBindingsEditorPart.getString("statusGroup"), (int)768, (int)1, (int)3);
        this.btnExecute = WidgetFactory.createButton((Composite)group, (String)ConnectorBindingsEditorPart.getString("btnExecute"));
        this.btnExecute.setEnabled(false);
        this.btnExecute.setToolTipText(ConnectorBindingsEditorPart.getString("btnExecute.tip"));
        this.btnExecute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                ConnectorBindingsEditorPart.this.handleExecuteSelected();
            }
        });
        this.lblImage = WidgetFactory.createLabel((Composite)group);
        this.lblStatus = new StyledText((Composite)group, 74);
        this.lblStatus.setText(ConnectorBindingsEditorPart.getString("lblStatus"));
        this.lblStatus.setBackground(UiUtil.getSystemColor((int)22));
        this.lblStatus.setLayoutData((Object)new GridData(768));
        final Hyperlink importLink = toolkit.createHyperlink((Composite)group, ConnectorBindingsEditorPart.getString("openConfigurationManager.linkText"), 64);
        GridData iLinkGD = new GridData();
        iLinkGD.horizontalSpan = 3;
        importLink.setLayoutData((Object)iLinkGD);
        final Color bkgdColor = group.getBackground();
        importLink.setBackground(group.getBackground());
        importLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ConnectorBindingsEditorPart.this.openConfigurationManager();
            }

            public void linkEntered(HyperlinkEvent e) {
                importLink.setBackground(bkgdColor);
                importLink.update();
            }

            public void linkExited(HyperlinkEvent e) {
                importLink.setBackground(bkgdColor);
                importLink.update();
            }
        });
        group = WidgetFactory.createGroup((Composite)this.pnlMain, (String)ConnectorBindingsEditorPart.getString("executionOptionsGroup"), (int)768, (int)1, (int)2);
        StyledText lblCombo = new StyledText((Composite)group, 74);
        lblCombo.setText("Transaction AutoWrap: ");
        lblCombo.setBackground(UiUtil.getSystemColor((int)22));
        this.comboTxnAutoWrap = WidgetFactory.createCombo((Composite)group, (int)8);
        this.comboTxnAutoWrap.setItems(TXN_AUTOWRAP_OPTIONS);
        this.comboTxnAutoWrap.setToolTipText(ConnectorBindingsEditorPart.getString("comboTxnAutoWrap.tip"));
        String txnAutoWrap = null;
        if (this.vdbContext != null) {
            txnAutoWrap = this.vdbContext.getExecutionProperties().getProperty("txnAutoWrap");
        } else if (this.vdbContextEditor != null) {
            txnAutoWrap = this.vdbContextEditor.getExecutionProperties().getProperty("txnAutoWrap");
        }
        if (txnAutoWrap == null) {
            txnAutoWrap = TXN_AUTOWRAP_OPTIMISTIC;
        }
        String[] items = this.comboTxnAutoWrap.getItems();
        for (int i = 0; i < items.length; ++i) {
            String itemStr = items[i];
            if (!itemStr.equalsIgnoreCase(txnAutoWrap)) continue;
            this.comboTxnAutoWrap.select(i);
            break;
        }
        this.comboTxnAutoWrap.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectorBindingsEditorPart.this.handleTxnAutoWrapChanged();
            }
        });
        group = WidgetFactory.createGroup((Composite)this.pnlMain, (String)ConnectorBindingsEditorPart.getString("bindingsGroup"), (int)1808);
        if (this.vdbContext != null && !this.vdbContext.isReadOnly()) {
            StyledText txtInstructions = new StyledText((Composite)group, 74);
            txtInstructions.setText(ConnectorBindingsEditorPart.getString("editInstructionsMsg"));
            txtInstructions.setBackground(UiUtil.getSystemColor((int)22));
            txtInstructions.setLayoutData((Object)new GridData(768));
        } else if (this.vdbContextEditor != null && !this.vdbContextEditor.isReadOnly()) {
            StyledText txtInstructions = new StyledText((Composite)group, 74);
            txtInstructions.setText(ConnectorBindingsEditorPart.getString("editInstructionsMsg"));
            txtInstructions.setBackground(UiUtil.getSystemColor((int)22));
            txtInstructions.setLayoutData((Object)new GridData(768));
        }
        this.pnlBindings = null;
        if (this.vdbContext != null) {
            this.pnlBindings = new ConnectorBindingsPanel((Composite)group, this.vdbFile, this.vdbContext);
        } else if (this.vdbContextEditor != null) {
            this.pnlBindings = new ConnectorBindingsPanel((Composite)group, this.vdbFile, this.vdbContextEditor);
        }
        Point pt = this.pnlMain.computeSize(-1, -1);
        int miny = pt.y + 45;
        scroller.setMinWidth(400);
        scroller.setMinHeight(miny);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        this.pnlBindings.addChangeListener((IChangeListener)this);
        this.dirty = this.isDirty();
        this.updateExecutionStatus();
    }

    public void doSave(IProgressMonitor theMonitor) {
        this.pnlBindings.save();
        this.executionPropsChanged = false;
        this.dirty = this.isDirty();
        this.updateExecutionStatus();
    }

    public void doSaveAs() {
    }

    private VdbExecutor getExecutor() {
        return this.executor;
    }

    public ISelectionListener getSelectionListener() {
        return null;
    }

    protected void handleExecuteSelected() {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                IStatus status;
                IWorkbenchPage page = UiUtil.getWorkbenchPage();
                IEditorPart[] dirtyParts = page.getDirtyEditors();
                if (dirtyParts.length > 0) {
                    for (int i = 0; i < dirtyParts.length; ++i) {
                        if (dirtyParts[i].getTitle().indexOf("Connector Bindings") > -1) {
                            dirtyParts[i].doSave((IProgressMonitor)new NullProgressMonitor());
                            continue;
                        }
                        if (!dirtyParts[i].getEditorInput().getName().equals(ConnectorBindingsEditorPart.this.vdbFile.getName())) continue;
                        dirtyParts[i].doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
                if ((status = ConnectorBindingsEditorPart.this.getExecutor().execute(null, false)).getCode() != 30160037) {
                    ErrorDialog.openError(null, (String)ConnectorBindingsEditorPart.getString("executionProblemDialog.title"), (String)ConnectorBindingsEditorPart.getString("executionProblemDialog.msg"), (IStatus)status);
                }
            }
        });
    }

    private void handleTxnAutoWrapChanged() {
        int selectedIndex = this.comboTxnAutoWrap.getSelectionIndex();
        String txnAutowrapStr = this.comboTxnAutoWrap.getItem(selectedIndex);
        if (txnAutowrapStr.equalsIgnoreCase(TXN_AUTOWRAP_OPTIMISTIC)) {
            MessageDialog.openInformation(null, (String)ConnectorBindingsEditorPart.getString("txnAutoWrapInfoDialog.title"), (String)ConnectorBindingsEditorPart.getString("txnAutoWrapInfoDialog.optimistic.msg"));
        } else if (txnAutowrapStr.equalsIgnoreCase(TXN_AUTOWRAP_PESSIMISTIC)) {
            MessageDialog.openInformation(null, (String)ConnectorBindingsEditorPart.getString("txnAutoWrapInfoDialog.title"), (String)ConnectorBindingsEditorPart.getString("txnAutoWrapInfoDialog.pessimistic.msg"));
        } else if (txnAutowrapStr.equalsIgnoreCase(TXN_AUTOWRAP_OFF)) {
            MessageDialog.openInformation(null, (String)ConnectorBindingsEditorPart.getString("txnAutoWrapInfoDialog.title"), (String)ConnectorBindingsEditorPart.getString("txnAutoWrapInfoDialog.off.msg"));
        }
        if (this.vdbContext != null) {
            this.vdbContext.setExecutionProperty("txnAutoWrap", txnAutowrapStr);
        } else if (this.vdbContextEditor != null) {
            this.vdbContextEditor.setExecutionProperty("txnAutoWrap", txnAutowrapStr);
        }
        this.executionPropsChanged = true;
        this.pnlBindings.setFocus();
        this.stateChanged(null);
    }

    public void init(IEditorSite theSite, IEditorInput theInput) throws PartInitException {
        super.setInput(theInput);
        if (!(theInput instanceof IFileEditorInput && ModelUtilities.isVdbFile((IResource)((IFileEditorInput)theInput).getFile()) && ((IFileEditorInput)theInput).getFile().exists())) {
            throw new PartInitException(ConnectorBindingsEditorPart.getString("errorInvalidInput"));
        }
        this.vdbFile = ((IFileEditorInput)theInput).getFile().getLocation().toFile();
        super.setSite((IWorkbenchPartSite)theSite);
    }

    public boolean isDirty() {
        return this.pnlBindings == null ? false : this.pnlBindings.hasVdbDefnChanges() || this.executionPropsChanged;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void preDispose() {
        this.executor.closeAllConnections();
        if (this.pnlBindings != null && !this.pnlBindings.isDisposed()) {
            this.pnlBindings.removeChangeListener((IChangeListener)this);
        }
        if (this.vdbContext != null) {
            this.vdbContext.removeChangeListener(this.changeListener);
        } else if (this.vdbContextEditor != null) {
            this.vdbContextEditor.removeChangeListener(this.changeListener);
        }
    }

    public void setDisplayName(String theName) {
        this.setPartName(theName);
    }

    public void setFocus() {
        this.pnlBindings.setFocus();
        this.updateExecutionStatus();
    }

    public void setVdbEditingContext(VdbEditingContext theEditingContext) {
        Assertion.isNotNull((Object)theEditingContext);
        Assertion.isInstanceOf((Object)theEditingContext, (Class)(class$com$metamatrix$vdb$internal$edit$InternalVdbEditingContext == null ? (class$com$metamatrix$vdb$internal$edit$InternalVdbEditingContext = ConnectorBindingsEditorPart.class$("com.metamatrix.vdb.internal.edit.InternalVdbEditingContext")) : class$com$metamatrix$vdb$internal$edit$InternalVdbEditingContext), (String)ConnectorBindingsEditorPart.getString("vdbStateError"));
        this.vdbContext = theEditingContext;
        this.vdbContextEditor = null;
        this.changeListener = new IChangeListener(){

            public void stateChanged(IChangeNotifier theSource) {
                ConnectorBindingsEditorPart.this.updateExecutionStatus();
            }
        };
        this.vdbContext.addChangeListener(this.changeListener);
        this.executor = new VdbExecutor(this.vdbContext, this.getValidator());
    }

    public void setVdbEditingContext(VdbContextEditor theEditingContext) {
        Assertion.isNotNull((Object)theEditingContext);
        this.vdbContext = null;
        this.vdbContextEditor = theEditingContext;
        this.changeListener = new IChangeListener(){

            public void stateChanged(IChangeNotifier theSource) {
                ConnectorBindingsEditorPart.this.updateExecutionStatus();
            }
        };
        this.vdbContextEditor.addChangeListener(this.changeListener);
        this.executor = new VdbExecutor(this.vdbContextEditor, this.getValidator());
    }

    public void stateChanged(IChangeNotifier theSource) {
        if (!this.dirty) {
            this.dirty = true;
            if (this.vdbContext != null) {
                this.vdbContext.setModified();
            } else if (this.vdbContextEditor != null) {
                this.vdbContextEditor.setSaveIsRequired();
            }
            this.firePropertyChange(257);
        }
        this.updateExecutionStatus();
    }

    protected void updateExecutionStatus() {
        if (!this.btnExecute.isDisposed()) {
            if (this.vdbContextEditor != null && !this.vdbContextEditor.isOpen()) {
                this.vdbContextEditor.removeChangeListener(this.changeListener);
            } else if (this.vdbContext != null && !this.vdbContext.isOpen()) {
                this.vdbContext.removeChangeListener(this.changeListener);
            }
            final IStatus status = this.executor.canExecute();
            this.btnExecute.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!ConnectorBindingsEditorPart.this.btnExecute.isDisposed()) {
                        ConnectorBindingsEditorPart.this.btnExecute.setEnabled(status.getSeverity() != 4);
                        ConnectorBindingsEditorPart.this.lblImage.setImage(UiUtil.getStatusImage((IStatus)status));
                        ConnectorBindingsEditorPart.this.lblImage.update();
                        String msg = null;
                        msg = status.getCode() == 92 ? ConnectorBindingsEditorPart.getString("noDefFileUserMsg") : (status.isOK() ? ConnectorBindingsEditorPart.getString("okStatusMsg") : status.getMessage());
                        ConnectorBindingsEditorPart.this.lblStatus.setText(msg);
                    }
                }
            });
        }
    }

    public void updateReadOnlyState(boolean theReadOnlyFlag) {
        if (this.pnlBindings != null) {
            this.pnlBindings.setReadonly(theReadOnlyFlag);
        }
    }

    private void openConfigurationManager() {
        IEditorPart part = ConfigurationManagerView.getEditorPart();
        if (part == null) {
            try {
                this.getEditorSite().getPage().openEditor((IEditorInput)new NullEditorInput(), "com.metamatrix.modeler.internal.dqp.ui.views.ConfigurationManagerEditor", true);
            }
            catch (PartInitException err) {
                MessageDialog.openError(null, (String)ConnectorBindingsEditorPart.getString("openConfigurationManager.error.title"), (String)ConnectorBindingsEditorPart.getString("openConfigurationManager.error.msg", "com.metamatrix.modeler.internal.dqp.ui.views.ConfigurationManagerEditor"));
            }
        } else {
            this.getEditorSite().getPage().activate((IWorkbenchPart)part);
        }
    }

    protected VdbExecutionValidator getValidator() {
        return new WorkspaceProblemsExecutionValidatorImpl();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

