/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.slutil;

import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class UtilTransliteratorUsingSunIO
extends UtilTransliterator {
    private String encoding;
    private CharToByteConverter c2b;
    private ByteToCharConverter b2c;
    private int maxBytesPerChar;
    private int maxCharsPerByte;

    public UtilTransliteratorUsingSunIO(String string) throws UtilException {
        try {
            this.encoding = string;
            this.c2b = CharToByteConverter.getConverter((String)string);
            this.b2c = ByteToCharConverter.getConverter((String)string);
            this.maxBytesPerChar = this.c2b.getMaxBytesPerChar();
            this.maxCharsPerByte = this.b2c.getMaxCharsPerByte();
            this.setDefaultCacheSize();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, string);
        }
    }

    public boolean isFixedBytesPerChar() {
        return this.c2b.getMaxBytesPerChar() == 1;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public int getMaxCharsPerByte() {
        return this.maxCharsPerByte;
    }

    public byte[] encode(String string) throws UtilException {
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        try {
            return this.c2b.convertAll(cArray);
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n2 = string.length();
        int n3 = n2 * this.maxBytesPerChar;
        this.setCacheSize(n2);
        try {
            this.c2b.reset();
            this.c2b.setSubstitutionMode(true);
            string.getChars(0, n2, this.charsCache, 0);
            int n4 = this.c2b.convert(this.charsCache, 0, n2, this.bytesCache, 0, n3);
            nArray[0] = n4 += this.c2b.flush(this.bytesCache, this.c2b.nextByteIndex(), n3);
            return this.bytesCache;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public void encode(InputStream inputStream, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = inputStream.read(this.bytesCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.charsCache[i2] = (char)(this.bytesCache[i2] & 0xFF);
                }
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n2, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n2 > 0) {
                int n3 = Math.min(n2, this.streamChunkSize);
                int n4 = reader.read(this.charsCache, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                outputStreamWriter.write(this.charsCache, 0, n4);
                n2 -= n4;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n2, int n3) throws UtilException {
        if (n3 == 0) {
            return EMPTY_STRING;
        }
        int n4 = n3 * this.maxCharsPerByte;
        this.setCacheSize(n4);
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n5 = this.b2c.convert(byArray, n2, n2 + n3, this.charsCache, 0, n4);
            n5 += this.b2c.flush(this.charsCache, n5, n4);
            return new String(this.charsCache, 0, n5);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public int decode(byte[] byArray, int n2, int n3, char[] cArray) throws UtilException {
        if (n3 == 0) {
            return 0;
        }
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n4 = this.b2c.convert(byArray, n2, n2 + n3, cArray, 0, cArray.length);
            n4 += this.b2c.flush(cArray, n4, cArray.length);
            return n4;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public String decode(byte[] byArray, int n2, int n3, int n4) throws UtilException {
        int n5 = n3 * this.maxCharsPerByte;
        int n6 = Math.max(n5, n4);
        this.setCacheSize(n6);
        try {
            this.b2c.reset();
            this.b2c.setSubstitutionMode(true);
            int n7 = this.b2c.convert(byArray, n2, n2 + n3, this.charsCache, 0, n5);
            n7 += this.b2c.flush(this.charsCache, n7, n5);
            for (int i2 = n7; i2 < n4; ++i2) {
                this.charsCache[i2] = 32;
            }
            return new String(this.charsCache, 0, n4);
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw UtilException.createTransliterationFailedException(conversionBufferFullException.getMessage());
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw UtilException.createTransliterationFailedException(unknownCharacterException.getMessage());
        }
        catch (MalformedInputException malformedInputException) {
            throw UtilException.createTransliterationFailedException(malformedInputException.getMessage());
        }
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }
}

