/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net;

import com.metamatrix.sequelink.net.NetCrypto;
import com.metamatrix.sequelink.net.NetOutput;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.util.BufferManager;
import com.metamatrix.sequelink.util.OutputStreamOnByteArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NetOutputStream
extends NetOutput {
    private int preambleSize;
    protected byte[] buf;
    protected int begin;
    protected int end;
    protected int position;

    NetOutputStream(int n) {
        this.preambleSize = n;
        this.begin = n;
        this.buf = BufferManager.GetBuffer();
        this.end = this.buf.length;
        this.position = n;
    }

    public final void write(int n) throws IOException {
        if (this.position >= this.end) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf);
            this.end = this.buf.length;
        }
        this.buf[this.position++] = (byte)n;
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        while (this.position + n2 > this.buf.length) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf);
            this.end = this.buf.length;
        }
        System.arraycopy(byArray, n, this.buf, this.position, n2);
        this.position += n2;
    }

    public final int write(InputStream inputStream, int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        if (this.position == this.end) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf);
            this.end = this.buf.length;
        }
        int n2 = Math.min(this.end - this.position, n);
        n2 = inputStream.read(this.buf, this.position, n2);
        this.position += n2;
        return n2;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) throws IOException {
        if (n < this.begin) {
            throw new IOException();
        }
        if (n > this.end) {
            throw new IOException();
        }
        this.position = n;
    }

    public final int getFreeSpace() {
        return this.end - this.position;
    }

    public int getIncrement() {
        return BufferManager.getIncrement();
    }

    final OutputStream getCurrentHeader() {
        return new OutputStreamOnByteArray(this.buf, 0, this.preambleSize);
    }

    final byte[] getCurrentBuffer() {
        return this.buf;
    }

    final void reset() {
        BufferManager.ReturnBuffer(this.buf);
        this.buf = BufferManager.GetBuffer();
        this.end = this.buf.length;
        this.position = this.preambleSize;
    }

    final int getSize() {
        return this.position - this.begin;
    }

    public void close() {
        if (this.buf != null) {
            BufferManager.ReturnBuffer(this.buf);
        }
        this.buf = null;
    }

    public void encrypt(NetCrypto netCrypto) throws NetworkException {
        int n = this.position - this.begin;
        int n2 = netCrypto.getEncryptionOutputSize(n);
        if (this.buf.length < n2 + this.begin) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf, n2 + this.begin);
        }
        int n3 = netCrypto.encrypt(this.buf, this.begin, n, this.buf, this.begin);
        this.position = n3 + this.begin;
    }
}

