/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.query.processor.BaseProcessorPlan;
import com.metamatrix.query.processor.Describable;
import com.metamatrix.query.processor.DescribableUtil;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationalPlan
extends BaseProcessorPlan
implements ProcessorPlan,
Describable {
    private RelationalNode root;

    public RelationalPlan(RelationalNode node) {
        this.root = node;
    }

    public RelationalNode getRootNode() {
        return this.root;
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.setContext(context);
        this.connectExternal(this.root, context, dataMgr, bufferMgr);
    }

    private void connectExternal(RelationalNode node, CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        node.initialize(context, bufferMgr, dataMgr);
        RelationalNode[] children = node.getChildren();
        for (int i = 0; i < children.length && children[i] != null; ++i) {
            this.connectExternal(children[i], context, dataMgr, bufferMgr);
        }
    }

    public boolean canHandleData(int dataRequestID) {
        return this.canHandleData(this.root, dataRequestID);
    }

    private boolean canHandleData(RelationalNode node, int dataRequestID) {
        RelationalNode childNode;
        if (node.acceptID(dataRequestID)) {
            return true;
        }
        RelationalNode[] children = node.getChildren();
        for (int i = 0; i < children.length && (childNode = children[i]) != null; ++i) {
            if (!this.canHandleData(childNode, dataRequestID)) continue;
            return true;
        }
        return false;
    }

    public boolean connectTupleSource(TupleSource source, int dataRequestID) {
        return this.connectNode(source, this.root, dataRequestID);
    }

    private boolean connectNode(TupleSource source, RelationalNode node, int nodeID) {
        if (node.acceptID(nodeID)) {
            node.setTupleSource(source, nodeID);
            return true;
        }
        RelationalNode[] children = node.getChildren();
        for (int i = 0; i < children.length && children[i] != null; ++i) {
            if (!this.connectNode(source, children[i], nodeID)) continue;
            return true;
        }
        return false;
    }

    public List getOutputElements() {
        return this.root.getTopElements();
    }

    public void setOutputElements(List outputElements) {
        this.root.setTopElements(outputElements);
    }

    public void open() throws MetaMatrixComponentException {
        this.root.open();
    }

    public TupleBatch nextBatch() throws BlockedException, MetaMatrixComponentException, MetaMatrixProcessingException {
        return this.root.nextBatch();
    }

    public void close() throws MetaMatrixComponentException {
        this.root.close();
    }

    public void reset() {
        super.reset();
        this.root.reset();
        LogManager.logTrace((String)"QUERY_PLANNER", (String)"RelationalPlan reset");
    }

    public String toString() {
        return this.root.toString();
    }

    public Object clone() {
        return new RelationalPlan((RelationalNode)this.root.clone());
    }

    public Collection getChildPlans() {
        ArrayList plans = new ArrayList();
        this.findPlans(this.root, plans);
        return plans;
    }

    private void findPlans(RelationalNode node, List plans) {
        List subPlans = node.getChildPlans();
        if (subPlans != null) {
            plans.addAll(subPlans);
        }
        RelationalNode[] children = node.getChildren();
        for (int i = 0; i < children.length && children[i] != null; ++i) {
            this.findPlans(children[i], plans);
        }
    }

    public Map getDescriptionProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("type", "Relational Plan");
        ArrayList<Map> children = new ArrayList<Map>();
        Map childProps = this.getRootNode().getDescriptionProperties();
        children.add(childProps);
        props.put("children", children);
        props.put("outputCols", DescribableUtil.getOutputColumnProperties((List)this.getOutputElements()));
        return props;
    }
}

