/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.message;

import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.core.util.ExternalizeUtil;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.DQPMessage;
import com.metamatrix.dqp.message.MessageProcessor;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.sql.lang.Command;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.List;

public class RequestMessage
extends DQPInboundMessage {
    static final long serialVersionUID = 2258063872049251854L;
    private Command command = null;
    private Command originalCommand = null;
    private int fetchSize;
    private int cursorType;
    private boolean partialResultsFlag;
    private boolean isPreparedStatement;
    private boolean isCallableStatement;
    private boolean isPreparedBatchUpdate;
    private List parameterValues;
    private boolean validationMode;
    private String txnAutoWrapMode;
    private String XMLFormat;
    private String styleSheet;
    private Date submittedTimestamp;
    private Date processingTimestamp;
    private TransactionContext txnContext;
    private boolean useResultSetCache;
    private String cacheCommand;
    private boolean dblQuotedVariableAllowed = false;
    private boolean queryPlanAllowed = true;
    private boolean synchRequest = false;
    private boolean showPlan = false;
    private int rowLimit;
    private transient CapabilitiesFinder cachedFinder;
    protected Object profileID;

    public RequestMessage() {
    }

    public RequestMessage(Command command) {
        this();
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean supportsPartialResults() {
        return this.partialResultsFlag;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setPartialResults(boolean partial) {
        this.partialResultsFlag = partial;
    }

    public boolean isPreparedStatement() {
        return this.isPreparedStatement;
    }

    public boolean isCallableStatement() {
        return this.isCallableStatement;
    }

    public void setPreparedStatement(boolean isPreparedStatement) {
        this.isPreparedStatement = isPreparedStatement;
    }

    public void setCallableStatement(boolean isCallableStatement) {
        this.isCallableStatement = isCallableStatement;
    }

    public List getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(List values) {
        this.parameterValues = values;
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int cursorType) {
        this.cursorType = cursorType;
    }

    public boolean getValidationMode() {
        return this.validationMode;
    }

    public String getXMLFormat() {
        return this.XMLFormat;
    }

    public void setValidationMode(boolean validationMode) {
        this.validationMode = validationMode;
    }

    public void setXMLFormat(String xMLFormat) {
        this.XMLFormat = xMLFormat;
    }

    public String getTxnAutoWrapMode() {
        return this.txnAutoWrapMode;
    }

    public void setTxnAutoWrapMode(String txnAutoWrapMode) {
        this.txnAutoWrapMode = txnAutoWrapMode;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(String styleSheet) {
        this.styleSheet = styleSheet;
    }

    public Date getSubmittedTimestamp() {
        return this.submittedTimestamp;
    }

    public void setSubmittedTimestamp(Date submittedTimestamp) {
        this.submittedTimestamp = submittedTimestamp;
    }

    public void markSubmissionStart() {
        this.setSubmittedTimestamp(new Date());
    }

    public Date getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    public void setProcessingTimestamp(Date processingTimestamp) {
        this.processingTimestamp = processingTimestamp;
    }

    public void markProcessingStart() {
        this.setProcessingTimestamp(new Date());
    }

    public Command getOriginalCommand() {
        return this.originalCommand;
    }

    public void setOriginalCommand(Command originalCommand) {
        this.originalCommand = originalCommand;
    }

    public TransactionContext getTransactionContext() {
        return this.txnContext;
    }

    public void setTransactionContext(TransactionContext context) {
        this.txnContext = context;
    }

    public boolean isTransactional() {
        return this.txnContext != null && this.txnContext.getTransaction() != null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.command = (Command)in.readObject();
        this.originalCommand = (Command)in.readObject();
        this.fetchSize = in.readInt();
        this.cursorType = in.readInt();
        this.partialResultsFlag = in.readBoolean();
        this.isPreparedStatement = in.readBoolean();
        this.isCallableStatement = in.readBoolean();
        this.isPreparedBatchUpdate = in.readBoolean();
        this.parameterValues = ExternalizeUtil.readList((ObjectInput)in);
        this.validationMode = in.readBoolean();
        this.txnAutoWrapMode = (String)in.readObject();
        this.styleSheet = (String)in.readObject();
        this.XMLFormat = (String)in.readObject();
        this.submittedTimestamp = (Date)in.readObject();
        this.processingTimestamp = (Date)in.readObject();
        this.txnContext = (TransactionContext)in.readObject();
        this.useResultSetCache = in.readBoolean();
        this.dblQuotedVariableAllowed = in.readBoolean();
        this.queryPlanAllowed = in.readBoolean();
        this.synchRequest = in.readBoolean();
        this.showPlan = in.readBoolean();
        this.rowLimit = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.command);
        out.writeObject(this.originalCommand);
        out.writeInt(this.fetchSize);
        out.writeInt(this.cursorType);
        out.writeBoolean(this.partialResultsFlag);
        out.writeBoolean(this.isPreparedStatement);
        out.writeBoolean(this.isCallableStatement);
        out.writeBoolean(this.isPreparedBatchUpdate);
        ExternalizeUtil.writeList((ObjectOutput)out, (List)this.parameterValues);
        out.writeBoolean(this.validationMode);
        out.writeObject(this.txnAutoWrapMode);
        out.writeObject(this.styleSheet);
        out.writeObject(this.XMLFormat);
        out.writeObject(this.submittedTimestamp);
        out.writeObject(this.processingTimestamp);
        out.writeObject(this.txnContext);
        out.writeBoolean(this.useResultSetCache);
        out.writeBoolean(this.dblQuotedVariableAllowed);
        out.writeBoolean(this.queryPlanAllowed);
        out.writeBoolean(this.synchRequest);
        out.writeBoolean(this.showPlan);
        out.writeInt(this.rowLimit);
    }

    public void setProfile(boolean profile) {
    }

    public Object getProfileID() {
        if (this.profileID == null) {
            this.profileID = new Integer(((Object)((Object)this)).hashCode());
        }
        return this.profileID;
    }

    public void setProfileID(Object profileID) {
        this.profileID = profileID;
    }

    public boolean useResultSetCache() {
        return this.useResultSetCache && !this.isTransactional();
    }

    public void setUseResultSetCache(boolean useResultSetCacse) {
        this.useResultSetCache = useResultSetCacse;
    }

    public String getCacheCommand() {
        if (this.cacheCommand == null) {
            this.cacheCommand = this.originalCommand.toString();
        }
        return this.cacheCommand;
    }

    public void setCacheCommand(String cacheCommand) {
        this.cacheCommand = cacheCommand;
    }

    public void setDoubleQuotedVariableAllowed(boolean allowed) {
        this.dblQuotedVariableAllowed = allowed;
    }

    public boolean isDoubleQuotedVariableAllowed() {
        return this.dblQuotedVariableAllowed;
    }

    public void setQueryPlanAllowed(boolean allowed) {
        this.queryPlanAllowed = allowed;
    }

    public boolean isQueryPlanAllowed() {
        return this.queryPlanAllowed;
    }

    public void setSynchronousRequest(boolean isSynchronousRequest) {
        this.synchRequest = isSynchronousRequest;
    }

    public boolean isSynchronousRequest() {
        return this.synchRequest;
    }

    public boolean getShowPlan() {
        return this.showPlan;
    }

    public void setShowPlan(boolean showPlan) {
        this.showPlan = showPlan;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public DQPMessage process(MessageProcessor processor) throws Exception {
        return processor.process(this);
    }

    public boolean isPreparedBatchUpdate() {
        return this.isPreparedBatchUpdate;
    }

    public void setPreparedBatchUpdate(boolean isPreparedBatchedUpdate) {
        this.isPreparedBatchUpdate = isPreparedBatchedUpdate;
    }

    public CapabilitiesFinder getCachedFinder() {
        return this.cachedFinder;
    }

    public void setCachedFinder(CapabilitiesFinder cachedFinder) {
        this.cachedFinder = cachedFinder;
    }
}

