/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.packet;

import com.metamatrix.common.comm.platform.socket.packet.AsynchronousPacket;
import com.metamatrix.common.comm.platform.socket.packet.MessagePacketSerializer;
import com.metamatrix.common.comm.platform.socket.packet.Packet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AsynchronousPacketSerializer
extends MessagePacketSerializer {
    private String messageKey;

    public AsynchronousPacketSerializer() {
    }

    public AsynchronousPacketSerializer(int virtualSocketID, String messageKey) {
        super(virtualSocketID);
        this.messageKey = messageKey;
    }

    public Packet createPacket(ObjectInput in) throws IOException {
        return new AsynchronousPacket(this.virtualSocketID, this.messageKey, this.readMessage(in));
    }

    public void writePacketBody(Packet packet, ObjectOutput out) throws IOException {
        out.writeObject(((AsynchronousPacket)packet).message);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.messageKey = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.messageKey);
    }
}

