/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.processing.internal;

import com.metamatrix.modeler.schema.tools.model.schema.Column;
import com.metamatrix.modeler.schema.tools.model.schema.Relationship;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.processing.RelationshipProcessor;
import com.metamatrix.modeler.schema.tools.processing.RelationshipRules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class BaseRelationshipProcessor
implements RelationshipProcessor {
    RelationshipRules rules;
    protected Map tableRelationships = new HashMap();
    protected SchemaModel schemaModel;

    protected void setSechemaModel(SchemaModel model) {
        this.schemaModel = model;
    }

    public void addRelationship(String key, Integer value) {
        this.tableRelationships.put(key, value);
    }

    public void setRelationshipRules(RelationshipRules rules) {
        this.rules = rules;
    }

    protected int calculateCValue(List parents) {
        int C_value = -3;
        Iterator parentIter = parents.iterator();
        while (parentIter.hasNext()) {
            Object o = parentIter.next();
            Relationship tableRelationship = (Relationship)o;
            int maxOccursThisLoop = tableRelationship.getMaxOccurs();
            if (C_value == -3) {
                C_value = maxOccursThisLoop;
                continue;
            }
            if (C_value == maxOccursThisLoop) continue;
            C_value = -2;
            break;
        }
        return C_value;
    }

    protected void removeRecursiveMerges(List elements) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            SchemaObject element = (SchemaObject)iter.next();
            LinkedList fullPath = new LinkedList();
            LinkedList mergedPath = new LinkedList();
            this.removeRecursiveMergesForTable(element, fullPath, mergedPath);
        }
    }

    protected void removeRecursiveMergesForTable(SchemaObject element, LinkedList fullPath, LinkedList mergedPath) {
        fullPath.addLast(element);
        mergedPath.addLast(element);
        Iterator iter = element.getChildren().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            Relationship tableRelationship = (Relationship)o;
            SchemaObject child = tableRelationship.getChild();
            String key = child.getSimpleName() + ':' + child.getNamespace();
            Integer relation = (Integer)this.tableRelationships.get(key);
            int representation = relation;
            LinkedList<SchemaObject> mergedPathParam = mergedPath;
            if (representation == 2 || representation == 3) {
                if (mergedPath.contains(child)) {
                    if (representation == 2) {
                        representation = 0;
                    } else if (representation == 3) {
                        representation = 1;
                    }
                    SchemaObject parent = tableRelationship.getParent();
                    parent.setAllParentRepresentations(representation, this);
                    mergedPathParam = new LinkedList();
                }
            } else {
                mergedPathParam = new LinkedList<SchemaObject>();
                continue;
            }
            if (fullPath.contains(child)) continue;
            this.removeRecursiveMergesForTable(child, fullPath, mergedPathParam);
            mergedPath.removeLast();
            fullPath.removeLast();
        }
    }

    protected void qualifyDuplicateMergedTableNames() {
        ArrayList processedTables = new ArrayList();
        Iterator iter = this.schemaModel.getElements().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            SchemaObject table = (SchemaObject)o;
            this.qualifyDuplicateMergedChildTableNames(table, processedTables);
        }
    }

    protected void qualifyDuplicateMergedChildTableNames(SchemaObject table, List processedTables) {
        if (processedTables.contains(table)) {
            return;
        }
        processedTables.add(table);
        List children = table.getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object oTableRelationship = iter.next();
            Relationship tableRelationship = (Relationship)oTableRelationship;
            this.qualifyDuplicateMergedChildTableNames(tableRelationship.getChild(), processedTables);
        }
        this.checkForDuplicateMergedChildNames(children);
    }

    protected void checkForDuplicateMergedChildNames(List tableRelationships) {
        HashMap<String, SchemaObject> tablesByName = new HashMap<String, SchemaObject>();
        Iterator allTablesIter = tableRelationships.iterator();
        while (allTablesIter.hasNext()) {
            Object o = allTablesIter.next();
            Relationship tableRelationship = (Relationship)o;
            int representation = tableRelationship.getType();
            if (representation != 2 && representation != 3) continue;
            SchemaObject table = tableRelationship.getChild();
            String name = table.getSimpleName();
            Object oExisting = tablesByName.get(name);
            if (oExisting == null) {
                tablesByName.put(name, table);
                continue;
            }
            SchemaObject existing = (SchemaObject)oExisting;
            existing.setMustBeQualified();
            table.setMustBeQualified();
        }
    }

    protected void mergeRelationships() {
        ArrayList processedTables = new ArrayList();
        Iterator iter = this.schemaModel.getElements().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            SchemaObject element = (SchemaObject)o;
            if (!this.schemaModel.isSelectedRootElement(element)) continue;
            this.mergeChildRelationships(element, processedTables);
        }
    }

    protected void mergeChildRelationships(SchemaObject table, List processedTables) {
        if (processedTables.contains(table)) {
            return;
        }
        processedTables.add(table);
        table.setWithinSelectedHierarchy(true);
        Object[] children = table.getChildren().toArray();
        for (int i = 0; i < children.length; ++i) {
            int representation;
            Object relObject = children[i];
            Relationship tableRelationship = (Relationship)relObject;
            SchemaObject child = tableRelationship.getChild();
            this.mergeChildRelationships(child, processedTables);
            String key = child.getSimpleName() + ':' + child.getNamespace();
            if (null == this.tableRelationships.get(key) || (representation = ((Integer)this.tableRelationships.get(key)).intValue()) != 2 && representation != 3) continue;
            this.mergeChild(table, tableRelationship);
            tableRelationship.removeRelationship();
        }
    }

    protected void mergeChild(SchemaObject parent, Relationship tableRelationship) {
        SchemaObject child = tableRelationship.getChild();
        child.setWithinSelectedHierarchy(false);
        Object[] cols = child.getAttributes().toArray();
        for (int i = 0; i < cols.length; ++i) {
            Column col = (Column)cols[i];
            int maxOccurs = tableRelationship.getMaxOccurs();
            for (int iOccurrence = 1; iOccurrence <= maxOccurs; ++iOccurrence) {
                int iOccurenceParam = maxOccurs > 1 ? iOccurrence : -1;
                col.mergeIntoParent(tableRelationship, iOccurenceParam);
            }
        }
        this.pullUpGrandChildRelationships(child.getParents(), child.getChildren());
    }

    protected void pullUpGrandChildRelationships(List parentRelationships, List grandChildren) {
        Object o;
        ArrayList<Relationship> newRelationships = new ArrayList<Relationship>();
        ArrayList<Relationship> foldedRelationships = new ArrayList<Relationship>();
        Iterator iter = grandChildren.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            Relationship grandChild = (Relationship)o;
            Iterator pIter = parentRelationships.iterator();
            while (pIter.hasNext()) {
                Relationship tableRelationship = (Relationship)pIter.next();
                Relationship mergedRelationship = tableRelationship.merge(grandChild);
                newRelationships.add(mergedRelationship);
                foldedRelationships.add(grandChild);
            }
        }
        iter = foldedRelationships.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            Relationship foldedRelationship = (Relationship)o;
            foldedRelationship.removeRelationship();
        }
        iter = newRelationships.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            Relationship newRelationship = (Relationship)o;
            newRelationship.addNewRelationship();
        }
    }

    protected void removeFullyMergedTables() {
        ArrayList<SchemaObject> nonMergedTables = new ArrayList<SchemaObject>();
        Iterator iter = this.schemaModel.getElements().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            SchemaObject table = (SchemaObject)o;
            if (!table.isWithinSelectedHierarchy()) continue;
            nonMergedTables.add(table);
        }
        this.schemaModel.setElements(nonMergedTables);
    }

    protected void qualifyDuplicateNonMergedTableNames() {
        HashMap<String, SchemaObject> tablesByName = new HashMap<String, SchemaObject>();
        Iterator allTablesIter = this.schemaModel.getElements().iterator();
        while (allTablesIter.hasNext()) {
            Object o = allTablesIter.next();
            SchemaObject table = (SchemaObject)o;
            String name = table.getSimpleName();
            Object oExisting = tablesByName.get(name);
            if (oExisting == null) {
                tablesByName.put(name, table);
                continue;
            }
            SchemaObject existing = (SchemaObject)oExisting;
            existing.setMustBeQualified();
            table.setMustBeQualified();
        }
    }
}

