/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.commandshell;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.commandshell.ArgumentConversionException;
import com.metamatrix.core.commandshell.Command;
import com.metamatrix.core.commandshell.CommandTarget;
import com.metamatrix.core.commandshell.NoScriptFileException;
import com.metamatrix.core.commandshell.ScriptReader;
import com.metamatrix.core.commandshell.ScriptResultListener;
import com.metamatrix.core.commandshell.WrongNumberOfArgumentsException;
import com.metamatrix.core.log.FileLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.SystemLogWriter;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.MetaMatrixExceptionUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.log.PlatformLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class CommandShell
implements Cloneable {
    private static final String RUN_METHOD = "run";
    private static final String COMMAND_PROMPT = ">";
    private static final String JAVA_LANG_PREFIX = "java.lang.";
    public static final String DEFAULT_LOG_FILE = ".." + File.separatorChar + "log" + File.separatorChar + "command_shell.log";
    private static final String PROPERTY_LOG_CONSOLE = "metamatrix.log.console";
    private CommandTarget commandTarget;
    private boolean exceptionHandlingOn = false;
    private boolean printStackTraceOnException = true;
    private String defaultFilePath = "";
    private boolean quit = false;
    private Stack readerStack = new Stack();
    private boolean silent = true;
    static /* synthetic */ Class class$java$lang$Object;

    private void setReader(ScriptReader reader) {
        this.readerStack.push(reader);
    }

    private ScriptReader getReader() {
        if (this.readerStack.isEmpty()) {
            return null;
        }
        return (ScriptReader)this.readerStack.peek();
    }

    private void clearReader() {
        this.readerStack.pop();
    }

    public CommandShell(CommandTarget commandTarget) {
        this.commandTarget = commandTarget;
        this.initialize();
    }

    public CommandShell copy(CommandTarget commandTarget) {
        try {
            CommandShell result = (CommandShell)this.clone();
            result.commandTarget = commandTarget;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private void initialize() {
        this.turnOnExceptionHandling();
        this.commandTarget.setShell(this);
    }

    public void setDefaultFilePath(String defaultFilePath) {
        this.defaultFilePath = defaultFilePath;
    }

    public String expandFileName(String localFileName) {
        return this.defaultFilePath + localFileName;
    }

    public void run(String[] args) {
        this.redirectLogging();
        this.writeln(CorePlugin.Util.getString("CommandShell.Started"));
        this.write(this.getCommandPrompt());
        if (args.length == 0) {
            this.enterInteractiveMode();
        } else {
            String[] commandArgs;
            boolean interactive = false;
            if (args[0].equals("-i")) {
                interactive = true;
                commandArgs = new String[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    commandArgs[i - 1] = args[i];
                }
            } else {
                commandArgs = args;
            }
            this.execute(commandArgs);
            if (interactive) {
                this.enterInteractiveMode();
            }
        }
        this.writeln(CorePlugin.Util.getString("CommandShell.Finished"));
    }

    private void redirectLogging() {
        String logConsoleString = System.getProperty(PROPERTY_LOG_CONSOLE);
        String FALSE = Boolean.toString(false);
        boolean redirect = FALSE.equalsIgnoreCase(logConsoleString);
        if (redirect) {
            List listeners = PlatformLog.getInstance().getLogListeners();
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                LogListener ll = (LogListener)it.next();
                if (!(ll instanceof SystemLogWriter)) continue;
                PlatformLog.getInstance().removeListener(ll);
            }
            File file = new File(DEFAULT_LOG_FILE);
            PlatformLog.getInstance().addListener((LogListener)new FileLogWriter(file));
        }
    }

    public void writeln(String text) {
        if (!this.silent) {
            System.out.println(text);
        }
    }

    public void write(String text) {
        if (!this.silent) {
            System.out.print(text);
        }
    }

    private void enterInteractiveMode() {
        try {
            this.setSilent(false);
            this.execute("\n");
            InputStreamReader streamReader = new InputStreamReader(System.in);
            BufferedReader reader = new BufferedReader(streamReader);
            String line = reader.readLine();
            while (!this.quit && line != null && !line.equals(".")) {
                this.execute(line);
                if (this.quit) continue;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    protected String getCommandPrompt() {
        return COMMAND_PROMPT;
    }

    public void quit() {
        this.quit = true;
    }

    public String[] getScriptNames(String fileName) {
        ScriptReader reader = new ScriptReader(new FileUtil(fileName).read());
        return reader.getScriptNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(String fileName, String scriptName, StringBuffer transcript, ScriptResultListener listener) {
        if (transcript == null) {
            transcript = new StringBuffer();
        }
        transcript.append(scriptName);
        transcript.append(" {");
        transcript.append(StringUtil.LINE_SEPARATOR);
        ScriptReader reader = new ScriptReader(new FileUtil(fileName).read());
        this.commandTarget.runningScript(fileName);
        this.setReader(reader);
        reader.gotoScript(scriptName);
        try {
            while (reader.hasMore()) {
                String commandLine = reader.nextCommandLine();
                this.writeln(CorePlugin.Util.getString("CommandShell.Executing", (Object)commandLine));
                transcript.append("\t");
                transcript.append(commandLine);
                String result = this.execute(commandLine);
                result = result == null ? "" : result.trim();
                transcript.append(StringUtil.LINE_SEPARATOR);
                if (!reader.checkResults()) continue;
                transcript.append("\t");
                transcript.append(ScriptReader.RESULT_KEYWORD);
                transcript.append(" [");
                transcript.append(StringUtil.LINE_SEPARATOR);
                transcript.append(result);
                transcript.append(StringUtil.LINE_SEPARATOR);
                transcript.append(StringUtil.LINE_SEPARATOR);
                transcript.append("\t");
                transcript.append("]");
                transcript.append(StringUtil.LINE_SEPARATOR);
                String expectedResults = reader.getExpectedResults().trim();
                if (listener == null) continue;
                listener.scriptResults(fileName, scriptName, expectedResults, result);
            }
            Object var10_9 = null;
            transcript.append("}");
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            transcript.append("}");
            transcript.append(StringUtil.LINE_SEPARATOR);
            transcript.append(StringUtil.LINE_SEPARATOR);
            reader = null;
            this.clearReader();
            throw throwable;
        }
        transcript.append(StringUtil.LINE_SEPARATOR);
        transcript.append(StringUtil.LINE_SEPARATOR);
        reader = null;
        this.clearReader();
    }

    public String getNextCommandLine() throws IOException {
        ScriptReader reader = this.getReader();
        if (reader == null) {
            return new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        return reader.nextCommandLine();
    }

    public Object getTarget() {
        return this.commandTarget;
    }

    public String getHelp() {
        Method[] methods = this.commandTarget.getClass().getMethods();
        StringBuffer result = new StringBuffer();
        Arrays.sort(methods, new /* Unavailable Anonymous Inner Class!! */);
        Set methodsToIgnore = this.commandTarget.getMethodsToIgnore();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getDeclaringClass() == (class$java$lang$Object == null ? CommandShell.class$("java.lang.Object") : class$java$lang$Object) || !this.showHelpFor(methods[i].getName(), methodsToIgnore)) continue;
            result.append(methods[i].getName());
            result.append(" ");
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            String[] parameterNames = this.getParameterNames(methods[i].getName());
            for (int j = 0; j < parameterTypes.length; ++j) {
                String parameterTypeName = parameterTypes[j].getName();
                boolean isArray = false;
                if (parameterTypes[j].isArray()) {
                    isArray = true;
                    parameterTypeName = parameterTypes[j].getComponentType().getName();
                }
                if (parameterTypeName.startsWith(JAVA_LANG_PREFIX)) {
                    parameterTypeName = parameterTypeName.substring(JAVA_LANG_PREFIX.length());
                }
                if (j < parameterNames.length) {
                    result.append("<");
                    result.append(parameterNames[j]);
                    result.append(COMMAND_PROMPT);
                } else {
                    result.append(parameterTypeName);
                    if (isArray) {
                        result.append("[]");
                    }
                }
                result.append(" ");
            }
            result.append(StringUtil.LINE_SEPARATOR);
        }
        return result.toString();
    }

    protected boolean showHelpFor(String methodName, Set methodsToIgnore) {
        return !Command.shouldIgnoreMethod((String)methodName, (Set)methodsToIgnore);
    }

    protected String[] getParameterNames(String methodName) {
        String[] result = this.getParameterNamesDirect(methodName);
        if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    private String[] getParameterNamesDirect(String methodName) {
        if (methodName.equals("delete")) {
            return new String[]{"multilineSqlTerminatedWith;"};
        }
        if (methodName.equals("exec")) {
            return new String[]{"multilineSqlTerminatedWith;"};
        }
        if (methodName.equals("execute")) {
            return new String[]{"query"};
        }
        if (methodName.equals("getColumns")) {
            return new String[]{"schemaPattern", "tableNamePattern", "columnNamePattern"};
        }
        if (methodName.equals("getCrossReference")) {
            return new String[]{"primarySchema:String", "primaryTable:String", "foreignSchema:String", "foreignTable:String"};
        }
        if (methodName.equals("getExportedKeys")) {
            return new String[]{"catalog:String", "schema:String", "table:String"};
        }
        if (methodName.equals("getImportedKeys")) {
            return new String[]{"catalog:String", "schema:String", "table:String"};
        }
        if (methodName.equals("getIndexInfo")) {
            return new String[]{"schema:String", "table:String", "unique:boolean", "approximate:boolean"};
        }
        if (methodName.equals("getModels")) {
            return new String[]{"catalog:String", "schemaPattern:String", "modelPattern:String"};
        }
        if (methodName.equals("getPrimaryKeys")) {
            return new String[]{"schema:String", "table:String"};
        }
        if (methodName.equals("getProcedureColumns")) {
            return new String[]{"schemaPattern:String", "procedureNamePattern:String", "columnNamePattern:String"};
        }
        if (methodName.equals("getProcedures")) {
            return new String[]{"schemaPattern:String", "procedureNamePattern:String"};
        }
        if (methodName.equals("getTables")) {
            return new String[]{"schemaPattern:String", "tableNamePattern:String"};
        }
        if (methodName.equals("getUDTs")) {
            return new String[]{"schemaPattern:String", "typeNamePattern:String"};
        }
        if (methodName.equals("insert")) {
            return new String[]{"multilineSqlTerminatedWith;"};
        }
        if (methodName.equals("loadTest")) {
            return new String[]{"command:String", "threadCounts:int[]"};
        }
        if (methodName.equals("loadTestWithSetup")) {
            return new String[]{"setupCommand:String", "command:String", "threadCounts:int[]"};
        }
        if (methodName.equals("prepareStatement")) {
            return new String[]{"statementName:String", "types:String[]"};
        }
        if (methodName.equals("printResults")) {
            return new String[]{"resultString:StringBuffer", "results:ResultSet"};
        }
        if (methodName.equals("printResultsDirect")) {
            return new String[]{"resultString:StringBuffer", "results:PrintableResults"};
        }
        if (methodName.equals(RUN_METHOD)) {
            return new String[]{"scriptName:String"};
        }
        if (methodName.equals("runRep")) {
            return new String[]{"repCount:int", "scriptName:String"};
        }
        if (methodName.equals("runScript")) {
            return new String[]{"fileName:String", "scriptName:String"};
        }
        if (methodName.equals("runStatement")) {
            return new String[]{"statementName:String", "params:String[]"};
        }
        if (methodName.equals("select")) {
            return new String[]{"multilineSqlTerminatedWith;"};
        }
        if (methodName.equals("setAutoCommit")) {
            return new String[]{"value:boolean"};
        }
        if (methodName.equals("setAutoGetMetadata")) {
            return new String[]{"automaticallyGetMetadata:boolean"};
        }
        if (methodName.equals("setClassLoaderDebug")) {
            return new String[]{"value:boolean"};
        }
        if (methodName.equals("setClassLoadingDriver")) {
            return new String[]{"protocol:String", "driverName:String", "classpath:String"};
        }
        if (methodName.equals("setConnection")) {
            return new String[]{"server:String", "port:String", "vdb:String", "version:String", "user:String", "password:String"};
        }
        if (methodName.equals("setConnectionProperties")) {
            return new String[]{"connectionProperties:Properties"};
        }
        if (methodName.equals("setConnectionUrl")) {
            return new String[]{"url:String"};
        }
        if (methodName.equals("setDriverClass")) {
            return new String[]{"className:String"};
        }
        if (methodName.equals("setFailOnError")) {
            return new String[]{"failOnError:boolean"};
        }
        if (methodName.equals("setIgnoreQueryPlan")) {
            return new String[]{"ignoreQueryPlan:boolean"};
        }
        if (methodName.equals("setJdbcMode")) {
            return new String[]{"jdbcMode:boolean"};
        }
        if (methodName.equals("setLocalConfig")) {
            return new String[]{"vdbName:String", "vdbVersion:String", "localConfigFilePath:String"};
        }
        if (methodName.equals("setPrintStackOnError")) {
            return new String[]{"printStackOnError:boolean"};
        }
        if (methodName.equals("setQueryDisplayInterval")) {
            return new String[]{"n:int"};
        }
        if (methodName.equals("setQueryTimeout")) {
            return new String[]{"timeoutInSeconds:int"};
        }
        if (methodName.equals("setScriptFile")) {
            return new String[]{"scriptFileName:String"};
        }
        if (methodName.equals("setSilent")) {
            return new String[]{"silent:boolean"};
        }
        if (methodName.equals("setUsePreparedStatement")) {
            return new String[]{"usePreparedStatement:boolean"};
        }
        if (methodName.equals("singleLoadTest")) {
            return new String[]{"setupCommand:String", "command:String", "threadCount:int"};
        }
        if (methodName.equals("update")) {
            return new String[]{"multilineSqlTerminatedWith;"};
        }
        return null;
    }

    public void turnOnExceptionHandling() {
        this.exceptionHandlingOn = true;
    }

    public void turnOffExceptionHandling() {
        this.exceptionHandlingOn = false;
    }

    public void setPrintStackTraceOnException(boolean printStackTraceOnException) {
        this.printStackTraceOnException = printStackTraceOnException;
    }

    private String execute(Command command, boolean throwWrongNumberOfArgumentsException, String defaultResult) throws NoSuchMethodException {
        Throwable exception = null;
        command.setDefaultFilePath(this.defaultFilePath);
        Object result = defaultResult;
        try {
            result = command.execute(this.commandTarget.getMethodsToIgnore());
        }
        catch (WrongNumberOfArgumentsException e) {
            if (!throwWrongNumberOfArgumentsException) {
                result = e.getMessage();
            }
        }
        catch (NoScriptFileException e) {
            if (!throwWrongNumberOfArgumentsException) {
                result = e.getMessage();
            }
        }
        catch (ArgumentConversionException e) {
            result = e.getMessage();
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.exceptionHandlingOn) {
                result = MetaMatrixExceptionUtil.getLinkedMessagesVerbose((Throwable)e);
                exception = e;
            }
            if (e instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)e;
                throw runtimeException;
            }
            throw new MetaMatrixRuntimeException(e);
        }
        String stringResult = null;
        if (result != null) {
            if (result != null) {
                if (result instanceof String[]) {
                    String[] arrayResult = (String[])result;
                    StringBuffer sb = new StringBuffer();
                    sb.append("[");
                    for (int i = 0; i < arrayResult.length; ++i) {
                        sb.append(arrayResult[i]);
                        if (i == arrayResult.length - 1) continue;
                        sb.append(",");
                    }
                    sb.append("]");
                    stringResult = sb.toString();
                } else {
                    stringResult = result.toString();
                }
            }
            this.writeln(stringResult);
        }
        if (this.printStackTraceOnException && exception != null) {
            MetaMatrixExceptionUtil.printNestedStackTrace((Throwable)exception, (PrintStream)System.out);
        }
        this.write(this.getCommandPrompt());
        return stringResult;
    }

    public String execute(String commandLine) {
        try {
            return this.executeCommand(new Command(this.getTarget(), commandLine), new Command(this.getTarget(), "run " + commandLine));
        }
        catch (NoSuchMethodException e) {
            return e.getMessage();
        }
    }

    private String executeCommand(Command command, Command alternateCommand) throws NoSuchMethodException {
        try {
            return this.execute(command, false, null);
        }
        catch (NoSuchMethodException e) {
            try {
                return this.execute(alternateCommand, true, e.getMessage());
            }
            catch (NoSuchMethodException e2) {
                throw e;
            }
        }
    }

    private String execute(String[] commandArgs) {
        Command c = new Command(this.getTarget(), commandArgs);
        Command c2 = new Command(this.getTarget(), this.makeStringArray(RUN_METHOD, commandArgs));
        try {
            return this.executeCommand(c, c2);
        }
        catch (NoSuchMethodException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    private String[] makeStringArray(String firstValue, String[] otherValues) {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(otherValues));
        result.add(0, firstValue);
        return result.toArray(new String[0]);
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

