/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.modelgenerator.wsdl.unzipproject.ProjectImporter;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class ModelGeneratorWsdlPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.metamatrix.modeler.modelgenerator.wsdl";
    public static final String BUNDLE_NAME = "com.metamatrix.modeler.modelgenerator.wsdl.i18n";
    public static final PluginUtil Util = new PluginUtilImpl("com.metamatrix.modeler.modelgenerator.wsdl", "com.metamatrix.modeler.modelgenerator.wsdl.i18n", ResourceBundle.getBundle("com.metamatrix.modeler.modelgenerator.wsdl.i18n"));
    private static ModelGeneratorWsdlPlugin INSTANCE = new ModelGeneratorWsdlPlugin();
    public static boolean DEBUG = false;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$modelgenerator$wsdl$ModelGeneratorWsdlPlugin == null ? (class$com$metamatrix$modeler$modelgenerator$wsdl$ModelGeneratorWsdlPlugin = ModelGeneratorWsdlPlugin.class$("com.metamatrix.modeler.modelgenerator.wsdl.ModelGeneratorWsdlPlugin")) : class$com$metamatrix$modeler$modelgenerator$wsdl$ModelGeneratorWsdlPlugin));
    private static boolean m_isDimension = false;
    private static Object m_rootContext = ModelGeneratorWsdlPlugin.initRootContext();
    private static int baseExtensionProjectIndex;
    static /* synthetic */ Class class$com$metamatrix$modeler$modelgenerator$wsdl$ModelGeneratorWsdlPlugin;

    private static Object initRootContext() {
        Object result = null;
        try {
            Class<?> theClass = Class.forName("com.metamatrix.ui.internal.product.ProductCustomizerMgr");
            Method getInstance = theClass.getMethod("getInstance", null);
            Object instance = getInstance.invoke(null, null);
            Method getProductCharacteristics = theClass.getMethod("getProductCharacteristics", null);
            Object productCharacteristics = getProductCharacteristics.invoke(instance, null);
            Class<?> prodCharClass = Class.forName("com.metamatrix.ui.product.IProductCharacteristics");
            Method getRootWorkspaceContext = prodCharClass.getMethod("getRootWorkspaceContext", null);
            result = getRootWorkspaceContext.invoke(productCharacteristics, null);
        }
        catch (ClassNotFoundException cnf) {
        }
        catch (NoSuchMethodException nme) {
        }
        catch (InvocationTargetException ite) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return result;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        if (!m_isDimension) {
            this.ensureExtensionObjects();
        }
    }

    public static ModelGeneratorWsdlPlugin getDefault() {
        return INSTANCE;
    }

    public static boolean isDimension() {
        return m_isDimension;
    }

    public static Object getRootContext() {
        return ModelGeneratorWsdlPlugin.initRootContext();
    }

    private void ensureExtensionObjects() throws Exception {
        Util.log(1, "entering ensureExtensionObjects");
        IWorkspace workspace = ModelerCore.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        ArrayList extensionProjects = this.getKnownModelExtensions();
        IProject[] existingProjects = workspaceRoot.getProjects();
        Util.log(1, "existing projects are: " + existingProjects.toString());
        IProject[] neededProjects = new IProject[extensionProjects.size()];
        block6: for (int iExistingProject = 0; iExistingProject < existingProjects.length; ++iExistingProject) {
            IProject existingProject = existingProjects[iExistingProject];
            String existingProjectName = existingProject.getName();
            for (int iNeededProject = 0; iNeededProject < extensionProjects.size(); ++iNeededProject) {
                ExtensionProjectDesc extensionProjectDesc = (ExtensionProjectDesc)extensionProjects.get(iNeededProject);
                if (existingProjectName == null || !existingProjectName.equals(extensionProjectDesc.projectName)) continue;
                neededProjects[iNeededProject] = existingProject;
                continue block6;
            }
        }
        Util.log(1, "needed projects are: " + neededProjects.toString());
        for (int iNeededProject = 0; iNeededProject < extensionProjects.size(); ++iNeededProject) {
            ExtensionProjectDesc extensionProjectDesc = (ExtensionProjectDesc)extensionProjects.get(iNeededProject);
            IProject project = neededProjects[iNeededProject];
            if (project == null) {
                try {
                    neededProjects[iNeededProject] = project = this.importExistingProject(extensionProjectDesc);
                    Util.log(1, this.getString("importedExtensionProject", new Object[]{extensionProjectDesc.projectName}));
                }
                catch (Exception e) {
                    if (!extensionProjectDesc.required) continue;
                    throw new Exception(this.getString("unableToImportRequiredExtensionProject", new Object[]{extensionProjectDesc.projectName, extensionProjectDesc.pathName}), e);
                }
            } else {
                Util.log(1, this.getString("extensionProjectExists", new Object[]{extensionProjectDesc.projectName}));
            }
            if (project.isOpen()) {
                Util.log(1, this.getString("extensionProjectAlreadyOpen", new Object[]{extensionProjectDesc.projectName}));
            } else {
                try {
                    this.openExistingProject(project);
                    Util.log(1, this.getString("extensionProjectOpened", new Object[]{extensionProjectDesc.projectName}));
                }
                catch (Exception e) {
                    try {
                        project = this.importExistingProject(extensionProjectDesc);
                        this.openExistingProject(project);
                        Util.log(1, this.getString("extensionProjectOpened", new Object[]{extensionProjectDesc.projectName}));
                    }
                    catch (Exception x) {
                        if (extensionProjectDesc.required) {
                            throw new Exception(this.getString("unableToOpenRequiredExtensionProject", new Object[]{extensionProjectDesc.projectName}), x);
                        }
                        Util.log(2, (Throwable)x, this.getString("unableToOpenOptionalExtensionProject", new Object[]{extensionProjectDesc.projectName}));
                        continue;
                    }
                }
            }
            if (iNeededProject != baseExtensionProjectIndex) continue;
            int x = 0;
            x += 10;
        }
        Util.log(1, "exiting ensureExtensionObjects");
    }

    private ArrayList getKnownModelExtensions() {
        ArrayList<ExtensionProjectDesc> extensionProjectDescriptions = new ArrayList<ExtensionProjectDesc>();
        extensionProjectDescriptions.add(new ExtensionProjectDesc("XMLExtensionsProject", "XMLExtensionsProject.zip", true));
        return extensionProjectDescriptions;
    }

    private IProject importExistingProject(ExtensionProjectDesc extensionProjectDesc) throws Exception {
        String fullPath;
        String pathName = extensionProjectDesc.pathName;
        URL bundledurl = pathName == null ? null : ModelGeneratorWsdlPlugin.getDefault().find((IPath)new Path(pathName));
        URL resolvedurl = bundledurl == null ? null : Platform.resolve((URL)bundledurl);
        String path = resolvedurl == null ? null : resolvedurl.getPath();
        File file = path == null ? null : new File(path);
        String string = fullPath = file == null ? null : file.getCanonicalPath();
        if (fullPath == null) {
            throw new Exception(this.getString("unableToFindExtensionProjectZipFile", new Object[]{extensionProjectDesc.pathName, bundledurl, resolvedurl, path, fullPath}));
        }
        ProjectImporter projectImporter = new ProjectImporter();
        IWorkspace workspace = ModelerCore.getWorkspace();
        IProject[] projects = projectImporter.importFromZipFile(workspace, fullPath);
        if (projects == null || projects.length == 0) {
            throw new Exception(this.getString("unableToFindAnyExtensionProjectsInZipFile", new Object[]{extensionProjectDesc.pathName, bundledurl, resolvedurl, path, fullPath}));
        }
        if (projects.length > 1) {
            throw new Exception(this.getString("tooManyExtensionProjectsInZipFile", new Object[]{extensionProjectDesc.pathName, bundledurl, resolvedurl, path, fullPath, new Integer(projects.length)}));
        }
        return projects[0];
    }

    private void openExistingProject(IProject project) throws CoreException {
        project.open(null);
    }

    private String getString(String id) {
        return Util.getString(I18N_PREFIX + id);
    }

    private String getString(String id, Object[] params) {
        return Util.getString(I18N_PREFIX + id, params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (m_rootContext != null && !(m_rootContext instanceof WorkspaceRoot)) {
            m_isDimension = true;
        }
        baseExtensionProjectIndex = 0;
    }

    private static class ExtensionProjectDesc {
        String projectName;
        String pathName;
        boolean required;

        ExtensionProjectDesc(String projectName, String fileName, boolean required) {
            this.projectName = projectName;
            this.pathName = fileName;
            this.required = required;
        }
    }
}

