/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.tempdata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.processor.proc.UpdateCountTupleSource;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.lang.BulkInsert;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Create;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.Drop;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.tempdata.TempTableStore;
import com.metamatrix.query.util.TypeRetrievalUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TempTableStoreImpl
implements TempTableStore {
    private BufferManager buffer;
    private TempMetadataStore tempMetadataStore = new TempMetadataStore();
    private Map groupToTupleSourceID = new HashMap();
    private String sessionID;
    private TempTableStore parentTempTableStore;

    public TempTableStoreImpl(BufferManager buffer, String sessionID, TempTableStore parentTempTableStore) {
        this.buffer = buffer;
        this.sessionID = sessionID;
        this.parentTempTableStore = parentTempTableStore;
    }

    public void addTempTable(Command command, boolean removeExistingTable) throws MetaMatrixComponentException {
        String tempTableName = null;
        List columns = null;
        switch (command.getType()) {
            case 11: {
                tempTableName = ((Create)command).getTable().getName().toUpperCase();
                columns = ((Create)command).getColumns();
                break;
            }
            case 1: {
                Query query = (Query)command;
                if (query.getInto() != null) {
                    tempTableName = query.getInto().getGroup().getName().toUpperCase();
                    columns = query.getSelect().getSymbols();
                    break;
                }
                if (((GroupSymbol)query.getFrom().getGroups().get(0)).isTempGroupSymbol()) {
                    tempTableName = ((GroupSymbol)query.getFrom().getGroups().get(0)).getName().toUpperCase();
                    columns = query.getSelect().getSymbols();
                    break;
                }
                return;
            }
            case 2: {
                Insert insert = (Insert)command;
                GroupSymbol group = insert.getGroup();
                if (group.isTempGroupSymbol()) {
                    tempTableName = group.getName().toUpperCase();
                    columns = insert.getVariables();
                    break;
                }
                return;
            }
            default: {
                return;
            }
        }
        if (this.tempMetadataStore.getTempGroupID(tempTableName) != null) {
            if (removeExistingTable) {
                this.removeTempTableByName(tempTableName);
            } else {
                throw new MetaMatrixComponentException(QueryExecPlugin.Util.getString("TempTableStore.table_exist_error", (Object)tempTableName));
            }
        }
        this.tempMetadataStore.addTempGroup(tempTableName, columns, false, true);
        TupleSourceID tsId = this.buffer.createTupleSource(columns, TypeRetrievalUtil.getTypeNames((List)columns), this.sessionID, 1);
        try {
            this.buffer.setStatus(tsId, 2);
        }
        catch (TupleSourceNotFoundException e) {
            Assertion.failed((String)"Could not find local tuple source for inserting into temp table.");
        }
        this.groupToTupleSourceID.put(tempTableName, tsId);
    }

    public void removeTempTable(Command command) throws MetaMatrixComponentException {
        if (command.getType() == 12) {
            String tempTableName = ((Drop)command).getTable().getName().toUpperCase();
            this.removeTempTableByName(tempTableName);
        } else if (command.getType() == 4) {
            Delete delete = (Delete)command;
            GroupSymbol group = delete.getGroup();
            this.removeTempTableByName(group.getCanonicalName());
        }
    }

    public void removeTempTableByName(String tempTableName) throws MetaMatrixComponentException {
        this.tempMetadataStore.removeTempGroup(tempTableName);
        TupleSourceID tsId = (TupleSourceID)this.groupToTupleSourceID.remove(tempTableName);
        if (tsId != null) {
            try {
                this.buffer.removeTupleSource(tsId);
            }
            catch (TupleSourceNotFoundException tupleSourceNotFoundException) {
                // empty catch block
            }
        }
    }

    public QueryMetadataInterface getMetadata(QueryMetadataInterface metadata) {
        return new TempMetadataAdapter(metadata, this.tempMetadataStore);
    }

    public boolean registerRequest(Command command, QueryProcessor processor, int nodeID) throws MetaMatrixComponentException {
        if (!this.hasTempTable(command)) {
            return false;
        }
        switch (command.getType()) {
            case 2: {
                this.addTuple((Insert)command, processor, nodeID);
                break;
            }
            case 1: {
                Query query = (Query)command;
                GroupSymbol group = (GroupSymbol)query.getFrom().getGroups().get(0);
                this.connectTupleSource(group.getName(), command, processor, nodeID);
                break;
            }
            case 11: {
                this.addTempTable(command, false);
                processor.connectTupleSource((TupleSource)new UpdateCountTupleSource(0), nodeID);
                break;
            }
            case 12: {
                this.removeTempTable(command);
                processor.connectTupleSource((TupleSource)new UpdateCountTupleSource(0), nodeID);
            }
        }
        return true;
    }

    public void removeTempTables() throws MetaMatrixComponentException {
        ArrayList names = new ArrayList(this.groupToTupleSourceID.keySet());
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            this.removeTempTableByName((String)iter.next());
        }
    }

    private void connectTupleSource(String tableName, Command command, QueryProcessor processor, int nodeID) throws MetaMatrixComponentException {
        TupleSourceID tsId = this.getTupleSourceID(tableName, command);
        try {
            processor.connectTupleSource((TupleSource)this.buffer.getTupleSource(tsId), nodeID);
        }
        catch (TupleSourceNotFoundException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    private TupleSourceID getTupleSourceID(String tempTableID, Command command) throws MetaMatrixComponentException {
        TupleSourceID tsID = (TupleSourceID)this.groupToTupleSourceID.get(tempTableID.toUpperCase());
        if (tsID != null) {
            return tsID;
        }
        if (this.parentTempTableStore != null && (tsID = this.parentTempTableStore.getTupleSourceID(tempTableID)) != null) {
            return tsID;
        }
        this.addTempTable(command, true);
        return (TupleSourceID)this.groupToTupleSourceID.get(tempTableID.toUpperCase());
    }

    private void addTuple(Insert insert, QueryProcessor processor, int nodeID) throws MetaMatrixComponentException {
        GroupSymbol group = insert.getGroup();
        TupleSourceID tsId = this.getTupleSourceID(group.getName(), (Command)insert);
        int tuplesAdded = 0;
        try {
            TupleBatch tupleBatch;
            int rowCount = this.buffer.getRowCount(tsId);
            List elements = ResolverUtil.resolveElementsInGroup(group, (QueryMetadataInterface)new TempMetadataAdapter(null, this.tempMetadataStore));
            if (insert instanceof BulkInsert) {
                List tuples = ((BulkInsert)insert).getRows();
                tuplesAdded = tuples.size();
                tupleBatch = new TupleBatch(++rowCount, tuples);
            } else {
                tuplesAdded = 1;
                ArrayList<Object> tuple = new ArrayList<Object>(elements.size());
                Iterator i = elements.iterator();
                while (i.hasNext()) {
                    ElementSymbol symbol = (ElementSymbol)i.next();
                    int index = insert.getVariables().indexOf(symbol);
                    Object value = null;
                    if (index != -1) {
                        Expression expr = (Expression)insert.getValues().get(index);
                        value = ExpressionEvaluator.evaluate((Expression)expr, null, null);
                    }
                    tuple.add(value);
                }
                tupleBatch = new TupleBatch(++rowCount, new List[]{tuple});
            }
            this.buffer.addTupleBatch(tsId, tupleBatch);
        }
        catch (TupleSourceNotFoundException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (ExpressionEvaluationException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (BlockedException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (QueryMetadataException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        catch (QueryResolverException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        processor.connectTupleSource((TupleSource)new UpdateCountTupleSource(tuplesAdded), nodeID);
    }

    public boolean hasTempTable(Command command) {
        switch (command.getType()) {
            case 2: {
                Insert insert = (Insert)command;
                GroupSymbol group = insert.getGroup();
                return group.isTempGroupSymbol();
            }
            case 1: {
                if (!(command instanceof Query)) break;
                Query query = (Query)command;
                GroupSymbol group = (GroupSymbol)query.getFrom().getGroups().get(0);
                return group.isTempGroupSymbol();
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    public Set getAllTempTables() {
        return new HashSet(this.groupToTupleSourceID.keySet());
    }

    public TupleSourceID getTupleSourceID(String tempTableName) {
        return (TupleSourceID)this.groupToTupleSourceID.get(tempTableName.toUpperCase());
    }
}

