/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.modelgenerator.xml.IUiConstants;
import com.metamatrix.modeler.modelgenerator.xml.XmlImporterUiPlugin;
import com.metamatrix.modeler.modelgenerator.xml.model.UserSettings;
import com.metamatrix.modeler.modelgenerator.xml.wizards.LocalMessages;
import com.metamatrix.modeler.modelgenerator.xml.wizards.StateManager;
import com.metamatrix.modeler.modelgenerator.xml.wizards.XsdAsRelationalImportWizard;
import com.metamatrix.ui.internal.util.WidgetFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class IntroductionPanel
extends Composite
implements IUiConstants,
IUiConstants.HelpContexts,
IUiConstants.Images {
    private static PluginUtil util = XmlImporterUiPlugin.getDefault().getPluginUtil();
    private static final String REQUEST_RESPONSE_OPTIONS = util.getString("IntroductionPage.xmlSourceTypes");
    private static final String SOURCE_TYPE_DOCUMENT = util.getString("IntroductionPage.source.document");
    private static final String SOURCE_TYPE_HTTP_NO_PARAMS = util.getString("IntroductionPage.source.httpNoParams");
    private static final String SOURCE_TYPE_HTTP_PARAMS = util.getString("IntroductionPage.source.httpParams");
    private static final String SOURCE_TYPE_HTTP_REQUEST_DOC = util.getString("IntroductionPage.source.httpDocRequest");
    private static final String NO_CATALOG = IntroductionPanel.getLocalString("noCatalog");
    private static final String NAMESPACE_CATALOG = IntroductionPanel.getLocalString("namespaceCatalog");
    private static final String FILENAME_CATALOG = IntroductionPanel.getLocalString("fileNameCatalog");
    private static final String CUSTOM_CATALOG = IntroductionPanel.getLocalString("customCatalog");
    private static final String CATALOG_DESC = IntroductionPanel.getLocalString("catalogDescription");
    private static final String INCLUDE_GROUP = IntroductionPanel.getLocalString("box.title");
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportOptionsPage == null ? (class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportOptionsPage = IntroductionPanel.class$("com.metamatrix.modeler.modelgenerator.xml.wizards.JdbcImportOptionsPage")) : class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportOptionsPage));
    private Button documentRadioButton;
    private Button httpNoParamsRadioButton;
    private Button httpParamsRadioButton;
    private Button httpRequestDocRadioButton;
    private Button noCatalogButton;
    private Button fileNameCatalogButton;
    private Button nameSpaceCatalogButton;
    private Button customCatalogButton;
    private Text customCatalogText;
    private XsdAsRelationalImportWizard wizard;
    private UserSettings userSettings;
    private String m_custName = new String();
    private StateManager manager;
    static /* synthetic */ Class class$com$metamatrix$modeler$modelgenerator$xml$wizards$JdbcImportOptionsPage;

    public IntroductionPanel(Composite parent, XsdAsRelationalImportWizard wizard, StateManager manager) {
        super(parent, 0);
        this.wizard = wizard;
        this.manager = manager;
        this.userSettings = wizard.getUserSettings();
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Group typeGroup = new Group((Composite)this, 0);
        typeGroup.setLayout((Layout)new GridLayout(1, true));
        typeGroup.setLayoutData((Object)new GridData(768));
        typeGroup.setText(REQUEST_RESPONSE_OPTIONS);
        this.documentRadioButton = new Button((Composite)typeGroup, 16);
        this.documentRadioButton.setSelection(0 == this.userSettings.getSourceType());
        this.documentRadioButton.setText(SOURCE_TYPE_DOCUMENT);
        this.httpNoParamsRadioButton = new Button((Composite)typeGroup, 16);
        this.httpNoParamsRadioButton.setSelection(1 == this.userSettings.getSourceType());
        this.httpNoParamsRadioButton.setText(SOURCE_TYPE_HTTP_NO_PARAMS);
        this.httpParamsRadioButton = new Button((Composite)typeGroup, 16);
        this.httpParamsRadioButton.setSelection(2 == this.userSettings.getSourceType());
        this.httpParamsRadioButton.setText(SOURCE_TYPE_HTTP_PARAMS);
        this.httpRequestDocRadioButton = new Button((Composite)typeGroup, 16);
        this.httpRequestDocRadioButton.setSelection(3 == this.userSettings.getSourceType());
        this.httpRequestDocRadioButton.setText(SOURCE_TYPE_HTTP_REQUEST_DOC);
        this.documentRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IntroductionPanel.this.userSettings.setSourceType(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.httpNoParamsRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IntroductionPanel.this.userSettings.setSourceType(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.httpParamsRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IntroductionPanel.this.userSettings.setSourceType(2);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.httpRequestDocRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IntroductionPanel.this.userSettings.setSourceType(3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        int columnCount = 3;
        Group catalogGroup = WidgetFactory.createGroup((Composite)this, (String)INCLUDE_GROUP, (int)256, (int)3);
        catalogGroup.setLayout((Layout)new GridLayout(2, false));
        CLabel catLabel = new CLabel((Composite)catalogGroup, 64);
        catLabel.setText(CATALOG_DESC);
        GridData labelData = new GridData(768);
        labelData.horizontalSpan = 2;
        catLabel.setLayoutData((Object)labelData);
        this.noCatalogButton = WidgetFactory.createRadioButton((Composite)catalogGroup, (String)NO_CATALOG);
        this.noCatalogButton.setSelection(true);
        this.noCatalogButton.addSelectionListener((SelectionListener)new NoCatalogAdapter());
        GridData noCatData = new GridData(768);
        noCatData.horizontalAlignment = 1;
        noCatData.horizontalSpan = 2;
        this.noCatalogButton.setLayoutData((Object)noCatData);
        this.nameSpaceCatalogButton = WidgetFactory.createRadioButton((Composite)catalogGroup, (String)NAMESPACE_CATALOG);
        this.nameSpaceCatalogButton.addSelectionListener((SelectionListener)new NamespaceCatalogAdapter());
        GridData nsCatData = new GridData(768);
        nsCatData.horizontalAlignment = 1;
        nsCatData.horizontalSpan = 2;
        this.nameSpaceCatalogButton.setLayoutData((Object)nsCatData);
        this.fileNameCatalogButton = WidgetFactory.createRadioButton((Composite)catalogGroup, (String)FILENAME_CATALOG);
        this.fileNameCatalogButton.addSelectionListener((SelectionListener)new FileNameCatalogAdapter());
        GridData fnCatData = new GridData(768);
        fnCatData.horizontalAlignment = 1;
        fnCatData.horizontalSpan = 2;
        this.fileNameCatalogButton.setLayoutData((Object)fnCatData);
        this.customCatalogButton = WidgetFactory.createRadioButton((Composite)catalogGroup, (String)CUSTOM_CATALOG);
        this.customCatalogButton.addSelectionListener((SelectionListener)new CustomCatalogAdapter());
        GridData customBtnData = new GridData();
        customBtnData.horizontalAlignment = 1;
        this.customCatalogButton.setLayoutData((Object)customBtnData);
        this.customCatalogText = WidgetFactory.createTextField((Composite)catalogGroup, (int)1, (String)this.m_custName);
        this.customCatalogText.setEnabled(false);
        GridData catTextData = new GridData(768);
        catTextData.widthHint = 50;
        this.customCatalogText.setLayoutData((Object)catTextData);
        this.customCatalogText.addModifyListener((ModifyListener)new CustomTextListener());
    }

    public void setVisible(boolean visible) {
        switch (this.manager.getCatalogType()) {
            case 1: {
                this.noCatalogButton.setSelection(true);
                this.customCatalogText.setEnabled(false);
                break;
            }
            case 2: {
                this.nameSpaceCatalogButton.setSelection(true);
                this.customCatalogText.setEnabled(false);
                break;
            }
            case 3: {
                this.fileNameCatalogButton.setSelection(true);
                this.customCatalogText.setEnabled(true);
                break;
            }
            case 4: {
                this.customCatalogButton.setSelection(true);
                this.customCatalogText.setEnabled(true);
            }
        }
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    private static String getLocalString(String string) {
        String qualifiedName = "IntroductionPage." + string;
        return LocalMessages.getString(qualifiedName);
    }

    private void CatalogButtonSelected(int type) {
        this.manager.setCatalogType(type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CustomTextListener
    implements ModifyListener {
        private CustomTextListener() {
        }

        public void modifyText(ModifyEvent event) {
            IntroductionPanel.this.m_custName = IntroductionPanel.this.customCatalogText.getText();
            IntroductionPanel.this.manager.setCustomCatalogName(IntroductionPanel.this.m_custName);
        }
    }

    private class CustomCatalogAdapter
    extends SelectionAdapter {
        private CustomCatalogAdapter() {
        }

        public void widgetSelected(SelectionEvent event) {
            IntroductionPanel.this.CatalogButtonSelected(4);
            IntroductionPanel.this.customCatalogText.setEnabled(true);
        }
    }

    private class FileNameCatalogAdapter
    extends SelectionAdapter {
        private FileNameCatalogAdapter() {
        }

        public void widgetSelected(SelectionEvent event) {
            IntroductionPanel.this.CatalogButtonSelected(3);
            IntroductionPanel.this.customCatalogText.setEnabled(false);
        }
    }

    private class NamespaceCatalogAdapter
    extends SelectionAdapter {
        private NamespaceCatalogAdapter() {
        }

        public void widgetSelected(SelectionEvent event) {
            IntroductionPanel.this.CatalogButtonSelected(2);
            IntroductionPanel.this.customCatalogText.setEnabled(false);
        }
    }

    private class NoCatalogAdapter
    extends SelectionAdapter {
        private NoCatalogAdapter() {
        }

        public void widgetSelected(SelectionEvent event) {
            IntroductionPanel.this.CatalogButtonSelected(1);
            IntroductionPanel.this.customCatalogText.setEnabled(false);
        }
    }
}

