/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.connector.xml.base.ParameterDescriptor;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IBaseInCriteria;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.LanguageUtil;
import com.metamatrix.data.metadata.runtime.Element;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class CriteriaDesc
extends ParameterDescriptor {
    private ArrayList m_values;
    private int m_currentIndexInValuesList = 0;
    private Boolean m_parentAttribute = null;
    private Boolean m_enumeratedAttribute = null;
    private Boolean m_allowEmptyValue = null;
    private String m_dataAttributeName = null;
    private Properties m_additionalAttributes = null;
    private String m_inputXpath = null;
    private String nativeType = null;
    private boolean m_unlimited = false;
    private boolean m_enumerated = false;
    private boolean m_multiElement = false;
    private boolean m_soapArrayElement = false;
    private boolean m_simpleSoapElement;
    public static final String PARM_REQUIRED_VALUE_COLUMN_PROPERTY_NAME = "RequiredValue";
    public static final String PARM_ALLOWS_EMPTY_VALUES_COLUMN_PROPERTY_NAME = "AllowEmptyInputElement";
    public static final String PARM_HAS_MULTIPLE_VALUES_COLUMN_PROPERTY_NAME = "MultipleValues";
    public static final String PARM_HAS_MULTIPLE_VALUES_COMMA_DELIMITED_NAME = "CommaDelimited";
    public static final String PARM_HAS_MULTIPLE_VALUES_MULTI_ELEMENT_NAME = "MultiElement";
    public static final String PARM_IS_SIMPLE_SOAP_ARRAY_ELEMENT_NAME = "SimpleSoapArrayElement";
    public static final String PARM_IS_COMPLEX_SOAP_ARRAY_ELEMENT_NAME = "ComplexSoapArrayElement";
    public static final String PARM_XPATH_INPUT_COLUMN_PROPERTY_NAME = "XPathForInputParameter";
    public static final String PARM_AS_PARENT_ATTRIBUTE_COLUMN_PROPERTY_NAME = "AttributeOfParent";
    public static final String PARM_AS_NAMED_ATTRIBUTE_COLUMN_PROPERTY_NAME = "DataAttributeName";
    private static boolean disableJoins = false;

    public static CriteriaDesc getCriteriaDescForColumn(Element element, IQuery query) throws ConnectorException {
        CriteriaDesc retVal = null;
        ArrayList values = CriteriaDesc.parseCriteriaToValues(element, query);
        if (values.size() == 0 && CriteriaDesc.testForParam(element)) {
            CriteriaDesc.handleDefaultValue(element, values);
        }
        if (values.size() > 0 || CriteriaDesc.findAllowEmptyValue(element)) {
            retVal = new CriteriaDesc(element, values);
            retVal.setNativeType(element.getNativeType());
        }
        return retVal;
    }

    private static void handleDefaultValue(Element element, ArrayList values) throws ConnectorException {
        Object defaultVal = element.getDefaultValue();
        if (defaultVal != null) {
            values.add(defaultVal);
        } else if (CriteriaDesc.findIsRequired(element)) {
            throw new ConnectorException(Messages.getString("CriteriaDesc.value.not.found.for.param") + element.getMetadataID().getName());
        }
    }

    private static boolean findIsRequired(Element element) throws ConnectorException {
        String value = element.getProperties().getProperty(PARM_REQUIRED_VALUE_COLUMN_PROPERTY_NAME);
        return CriteriaDesc.convertBooleanString(value);
    }

    private static boolean convertBooleanString(String value) {
        Boolean retval = value == null ? Boolean.FALSE : new Boolean(value.equalsIgnoreCase(Boolean.TRUE.toString()));
        return retval;
    }

    private static boolean findAllowEmptyValue(Element element) throws ConnectorException {
        String value = element.getProperties().getProperty(PARM_ALLOWS_EMPTY_VALUES_COLUMN_PROPERTY_NAME);
        return CriteriaDesc.convertBooleanString(value);
    }

    public CriteriaDesc(Element myElement, ArrayList myValues) throws ConnectorException {
        super(myElement);
        this.m_values = myValues;
        String enumerated = PARM_HAS_MULTIPLE_VALUES_COMMA_DELIMITED_NAME;
        String multiElement = PARM_HAS_MULTIPLE_VALUES_MULTI_ELEMENT_NAME;
        String multiplicityStr = this.getElement().getProperties().getProperty(PARM_HAS_MULTIPLE_VALUES_COLUMN_PROPERTY_NAME);
        if (multiplicityStr == null) {
            multiplicityStr = "";
        }
        if (multiplicityStr.equals(PARM_HAS_MULTIPLE_VALUES_COMMA_DELIMITED_NAME)) {
            this.m_unlimited = true;
            this.m_enumerated = true;
        } else if (multiplicityStr.equals(PARM_HAS_MULTIPLE_VALUES_MULTI_ELEMENT_NAME)) {
            this.m_unlimited = true;
            this.m_enumerated = false;
            this.m_multiElement = true;
        } else if (multiplicityStr.equals(PARM_IS_SIMPLE_SOAP_ARRAY_ELEMENT_NAME) || multiplicityStr.equals(PARM_IS_COMPLEX_SOAP_ARRAY_ELEMENT_NAME)) {
            this.m_unlimited = true;
            this.m_enumerated = false;
            this.m_multiElement = true;
            this.m_soapArrayElement = true;
            this.m_simpleSoapElement = multiplicityStr.equals(PARM_IS_SIMPLE_SOAP_ARRAY_ELEMENT_NAME);
        } else {
            this.m_unlimited = false;
            this.m_enumerated = false;
        }
    }

    private CriteriaDesc(CriteriaDesc other) {
        this.setXPath(other.getXPath());
        this.setIsParameter(other.isParameter());
        this.setIsResponseId(other.isResponseId());
        this.setIsLocation(other.isLocation());
        this.setColumnName(new String(other.getColumnName()));
        this.setColumnNumber(other.getColumnNumber());
        this.setElement(other.getElement());
        this.setNativeType(other.getNativeType());
        this.m_parentAttribute = other.m_parentAttribute == null ? null : new Boolean(other.m_parentAttribute);
        this.m_enumeratedAttribute = other.m_enumeratedAttribute == null ? null : new Boolean(other.m_enumeratedAttribute);
        this.m_allowEmptyValue = other.m_allowEmptyValue == null ? null : new Boolean(other.m_allowEmptyValue);
        this.m_dataAttributeName = other.m_dataAttributeName == null ? null : new String(other.m_dataAttributeName);
        this.m_additionalAttributes = other.m_additionalAttributes == null ? null : new Properties(other.m_additionalAttributes);
        this.m_inputXpath = other.m_inputXpath == null ? null : new String(other.m_inputXpath);
        this.m_unlimited = other.m_unlimited;
        this.m_enumerated = other.m_enumerated;
        this.m_multiElement = other.m_multiElement;
        this.m_soapArrayElement = other.m_soapArrayElement;
        this.m_values = new ArrayList();
    }

    public String getInputXpath() throws ConnectorException {
        if (this.m_inputXpath == null) {
            this.findInputXPath();
        }
        return this.m_inputXpath;
    }

    private void findInputXPath() throws ConnectorException {
        this.m_inputXpath = this.getElement().getProperties().getProperty(PARM_XPATH_INPUT_COLUMN_PROPERTY_NAME);
        if (this.m_inputXpath == null || this.m_inputXpath.trim().length() == 0) {
            this.m_inputXpath = this.getColumnName();
        }
    }

    public boolean isUnlimited() {
        return this.m_unlimited;
    }

    public boolean isMultiElement() {
        return this.m_multiElement;
    }

    public boolean isSOAPArrayElement() {
        return this.m_soapArrayElement;
    }

    public boolean isAutoIncrement() throws ConnectorException {
        return this.getElement().isAutoIncremented();
    }

    public boolean isParentAttribute() throws ConnectorException {
        if (this.m_parentAttribute == null) {
            this.findParentAttribute();
        }
        return this.m_parentAttribute;
    }

    private void findParentAttribute() throws ConnectorException {
        String value = this.getElement().getProperties().getProperty(PARM_AS_PARENT_ATTRIBUTE_COLUMN_PROPERTY_NAME);
        this.m_parentAttribute = new Boolean(CriteriaDesc.convertBooleanString(value));
    }

    public boolean isEnumeratedAttribute() throws ConnectorException {
        return this.m_enumerated;
    }

    public boolean allowEmptyValue() throws ConnectorException {
        if (this.m_allowEmptyValue == null) {
            this.findAllowEmptyValue();
        }
        return this.m_allowEmptyValue;
    }

    private void findAllowEmptyValue() throws ConnectorException {
        String value = this.getElement().getProperties().getProperty(PARM_ALLOWS_EMPTY_VALUES_COLUMN_PROPERTY_NAME);
        this.m_allowEmptyValue = new Boolean(CriteriaDesc.convertBooleanString(value));
    }

    public boolean isDataInAttribute() throws ConnectorException {
        String dataAttribute = this.getDataAttributeName();
        return dataAttribute.trim().length() != 0;
    }

    public String getDataAttributeName() throws ConnectorException {
        if (this.m_dataAttributeName == null) {
            this.findDataAttributeName();
        }
        return this.m_dataAttributeName;
    }

    private void findDataAttributeName() throws ConnectorException {
        this.m_dataAttributeName = this.getElement().getProperties().getProperty(PARM_AS_NAMED_ATTRIBUTE_COLUMN_PROPERTY_NAME);
        if (this.m_dataAttributeName == null) {
            this.m_dataAttributeName = "";
        }
    }

    public ArrayList getValues() {
        return this.m_values;
    }

    public int getNumberOfValues() {
        return this.m_values.size();
    }

    public String getCurrentIndexValue() throws ConnectorException {
        int initialBufferSize = 1000;
        if (this.m_values.size() == 0 && this.allowEmptyValue()) {
            return "";
        }
        if (this.isEnumeratedAttribute()) {
            StringBuffer sb = new StringBuffer(1000);
            String startChar = "";
            for (int x = 0; x < this.m_values.size(); ++x) {
                sb.append(startChar);
                sb.append(this.m_values.get(x));
                startChar = ",";
            }
            return sb.toString();
        }
        if (this.m_values.size() > 0) {
            return (String)this.m_values.get(this.m_currentIndexInValuesList);
        }
        return null;
    }

    public boolean incrementIndex() throws ConnectorException {
        if (this.isEnumeratedAttribute()) {
            return false;
        }
        if (this.m_currentIndexInValuesList < this.m_values.size() - 1) {
            ++this.m_currentIndexInValuesList;
            return true;
        }
        return false;
    }

    public void resetIndex() {
        this.m_currentIndexInValuesList = 0;
    }

    private static ArrayList parseCriteriaToValues(Element element, IQuery query) throws ConnectorException {
        String fullName = element.getMetadataID().getFullName().trim().toUpperCase();
        ArrayList parmPair = new ArrayList();
        if (element.getSearchability() == 3 || element.getSearchability() == 1) {
            ICriteria criteria = query.getWhere();
            List criteriaList = LanguageUtil.separateCriteriaByAnd((ICriteria)criteria);
            Iterator criteriaIter = criteriaList.iterator();
            while (criteriaIter.hasNext()) {
                ICriteria criteriaSeg = (ICriteria)criteriaIter.next();
                if (criteriaSeg instanceof ICompareCriteria) {
                    ICompareCriteria compCriteria = (ICompareCriteria)criteriaSeg;
                    if (compCriteria.getOperator() != 0) continue;
                    IExpression lExpr = compCriteria.getLeftExpression();
                    IExpression rExpr = compCriteria.getRightExpression();
                    CriteriaDesc.handleCompareCriteria(lExpr, rExpr, fullName, parmPair);
                    continue;
                }
                if (!(criteriaSeg instanceof IBaseInCriteria)) continue;
                CriteriaDesc.handleInCriteria((IBaseInCriteria)criteriaSeg, fullName, parmPair);
            }
        }
        return parmPair;
    }

    private static void handleInCriteria(IBaseInCriteria baseInCriteria, String fullName, ArrayList parmPair) {
        IExpression expr = baseInCriteria.getLeftExpression();
        if (expr instanceof IElement && CriteriaDesc.nameMatch(expr, fullName)) {
            Iterator vIter = null;
            vIter = ((IInCriteria)baseInCriteria).getRightExpressions().iterator();
            while (vIter.hasNext()) {
                ILiteral val = (ILiteral)vIter.next();
                String constantValue = val.getValue().toString();
                constantValue = CriteriaDesc.stringifyCriteria(constantValue);
                parmPair.add(constantValue);
            }
        }
    }

    private static void handleCompareCriteria(IExpression lExpr, IExpression rExpr, String fullName, ArrayList parmPair) {
        if (disableJoins && lExpr instanceof IElement && rExpr instanceof IElement) {
            return;
        }
        CriteriaDesc.checkElement(lExpr, rExpr, fullName, parmPair);
        CriteriaDesc.checkElement(rExpr, lExpr, fullName, parmPair);
    }

    private static void checkElement(IExpression expression, IExpression literalCandidate, String fullName, ArrayList parmPair) {
        if (expression instanceof IElement && CriteriaDesc.nameMatch(expression, fullName) && literalCandidate instanceof ILiteral) {
            String constantValue = ((ILiteral)literalCandidate).getValue().toString();
            constantValue = CriteriaDesc.stringifyCriteria(constantValue);
            parmPair.add(constantValue);
        }
    }

    public static boolean nameMatch(IExpression expr, String elementName) {
        IElement exprElement = (IElement)expr;
        String symbolName = exprElement.getName().toUpperCase().trim();
        String tempElementName = elementName.toUpperCase();
        int indx = symbolName.lastIndexOf(".");
        symbolName = symbolName.substring(indx + 1);
        indx = elementName.lastIndexOf(".");
        tempElementName = tempElementName.substring(indx + 1);
        return symbolName.equals(tempElementName);
    }

    public static String stringifyCriteria(String startCriteria) {
        int indx2;
        int indx = 0;
        String cStr = new String(startCriteria);
        indx = cStr.indexOf("'");
        if (indx == 0 && (indx2 = cStr.substring(1).indexOf("'")) >= 0) {
            return cStr.substring(1, indx2 + 1);
        }
        indx = cStr.indexOf(34);
        if (indx == 0 && (indx2 = cStr.substring(1).indexOf(34)) > 0) {
            return cStr.substring(1, indx2 + 1);
        }
        return cStr;
    }

    public CriteriaDesc cloneWithoutValues() {
        CriteriaDesc newDesc = new CriteriaDesc(this);
        return newDesc;
    }

    public void setValue(int i, Object object) {
        if (this.m_values.size() <= i) {
            this.m_values.add(i, object);
        } else {
            this.m_values.set(i, object);
        }
    }

    private void setNativeType(String nativeType) {
        this.nativeType = nativeType;
    }

    public String getNativeType() {
        return this.nativeType;
    }

    public boolean isSimpleSoapElement() {
        return this.m_simpleSoapElement;
    }
}

