/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.cache;

import com.metamatrix.connector.xml.cache.CachedObjectRecord;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.cache.Record;
import com.metamatrix.data.api.ConnectorLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ExecutionRecord
implements Record {
    Record parent;
    String executionID;
    Map cacheRecords = new HashMap();

    public ExecutionRecord(Record parent, String executionID, String sourceRequestID, String cacheKey) {
        this.executionID = executionID;
        this.parent = parent;
        this.addCacheRecord(sourceRequestID, cacheKey);
    }

    public void addCacheRecord(String sourceRequestID, String cacheKey) {
        CachedObjectRecord record = (CachedObjectRecord)this.cacheRecords.get(this.executionID);
        if (null != record) {
            throw new RuntimeException("Error - Cannot add a CacheRecord to a RequestPartRecord with an existing key");
        }
        record = new CachedObjectRecord(this, sourceRequestID, cacheKey);
        this.cacheRecords.put(sourceRequestID, record);
    }

    public void deleteCacheItems(ConnectorLogger logger) {
        Collection records = this.cacheRecords.values();
        for (CachedObjectRecord record : records) {
            String cacheKey = record.getCacheKey();
            this.parent.getCache().release(cacheKey, record.getID());
            logger.logTrace("Releasing cache item with key " + cacheKey + " and id " + record.getID());
        }
        this.cacheRecords.clear();
    }

    public String getID() {
        return this.parent.getID() + this.executionID;
    }

    public IDocumentCache getCache() {
        return this.parent.getCache();
    }
}

