/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.processing.internal;

import com.metamatrix.modeler.schema.tools.model.schema.Column;
import com.metamatrix.modeler.schema.tools.model.schema.Relationship;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SchemaModelImpl;
import com.metamatrix.modeler.schema.tools.processing.RelationshipProcessor;
import com.metamatrix.modeler.schema.tools.processing.internal.BaseRelationshipProcessor;
import java.util.List;
import java.util.Map;

public class RequestProcessorImpl
extends BaseRelationshipProcessor
implements RelationshipProcessor {
    public boolean DEBUG_SOUT_REPRESENTATIONS = true;
    private Map tableRelationships;

    public void calculateRelationshipTypes(SchemaModel model) {
        this.setSechemaModel(model);
        List elements = model.getElements();
        for (SchemaObject element : elements) {
            List parents = element.getParents();
            List columns = element.getAttributes();
            int P_value = parents.size();
            int F_value = columns.size();
            boolean canBeRoot = element.isUseAsRoot();
            int C_value = this.calculateCValue(parents);
            int representation = this.rules.calculateRelationship(P_value, C_value, canBeRoot, F_value);
            if (representation != 3 || representation != 2) {
                element.setRepresentAsTable(true);
            }
            element.setAllParentRepresentations(representation, this);
        }
        this.removeRecursiveMerges(elements);
        this.qualifyDuplicateMergedTableNames();
        this.mergeRelationships();
        this.removeFullyMergedTables();
        this.qualifyDuplicateNonMergedTableNames();
        ((SchemaModelImpl)this.schemaModel).setTableRelationships(this.tableRelationships);
    }

    public int C_threshold() {
        return Integer.MAX_VALUE;
    }

    public int P_threshold() {
        return Integer.MAX_VALUE;
    }

    public int F_threshold() {
        return Integer.MAX_VALUE;
    }

    protected void mergeChild(SchemaObject parent, Relationship tableRelationship) {
        SchemaObject child = tableRelationship.getChild();
        child.setWithinSelectedHierarchy(false);
        for (Object o : child.getAttributes()) {
            Column col = (Column)o;
            col.mergeIntoParent(tableRelationship, -1);
        }
        this.pullUpGrandChildRelationships(child.getParents(), child.getChildren());
    }
}

