/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.jms;

import com.metamatrix.connector.xml.AsynchronousDocumentProducer;
import com.metamatrix.connector.xml.SOAPConnectorState;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.DocumentBuilder;
import com.metamatrix.connector.xml.base.DocumentInfo;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.RequestResponseDocumentProducer;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.base.XMLExtractor;
import com.metamatrix.connector.xml.cache.DocumentCache;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.jms.JMSConnection;
import com.metamatrix.connector.xml.jms.JMSExecution;
import com.metamatrix.connector.xml.jms.JMSXMLConnectorState;
import com.metamatrix.connector.xml.jms.Messages;
import com.metamatrix.connector.xml.soap.SOAPDocBuilder;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jdom.Document;

public class JMSRequestExecutor
implements AsynchronousDocumentProducer,
MessageListener {
    private int requestNumber;
    private JMSXMLConnectorState jmsState;
    private List messages;
    private JMSExecution execution;
    private JMSConnection connection;
    private MessageConsumer consumer;
    private MessageProducer producer;
    private XMLExtractor xmlExtractor;
    private String correlationID;
    private String messageSelector;
    private String requestDoc;
    private JMSException onMessageException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSRequestExecutor(JMSXMLConnectorState state, JMSExecution execution) throws ConnectorException {
        this.jmsState = state;
        this.execution = execution;
        this.connection = (JMSConnection)execution.getConnection();
        this.requestNumber = execution.getRequestNumber();
        this.messages = new ArrayList();
        String cacheLocation = this.jmsState.getCacheLocation();
        File cacheFolder = cacheLocation == null || cacheLocation.trim().length() == 0 ? null : new File(cacheLocation);
        this.xmlExtractor = new XMLExtractor(this.jmsState.getMaxInMemoryStringSize(), this.jmsState.isPreprocess(), this.jmsState.isLogRequestResponse(), cacheFolder, this.jmsState.getLogger());
        this.correlationID = this.connection.getQueryId() + "_" + this.requestNumber;
        this.messageSelector = "JMSCorrelationID = '" + this.correlationID + "'";
        try {
            JMSRequestExecutor jMSRequestExecutor = this;
            synchronized (jMSRequestExecutor) {
                Session jmsSession = this.connection.getJMSSession();
                this.consumer = jmsSession.createConsumer(this.connection.getInboundDestination());
                this.consumer.setMessageListener((MessageListener)this);
                ExecutionInfo info = execution.getInfo();
                this.connection.start();
                if (RequestResponseDocumentProducer.checkIfRequestIsNeeded(info)) {
                    Object builder;
                    Properties otherInfo = info.getOtherProperties();
                    String inputParmsXPath = otherInfo.getProperty("XPathRootForInput");
                    String namespacePrefixes = otherInfo.getProperty("NamespacePrefixes");
                    if (this.jmsState instanceof SOAPConnectorState) {
                        builder = new SOAPDocBuilder();
                        this.requestDoc = ((SOAPDocBuilder)builder).createSOAPRequest((SOAPConnectorState)((Object)this.jmsState), info.getParameters(), namespacePrefixes, inputParmsXPath);
                    } else {
                        builder = new DocumentBuilder();
                        Document doc = ((DocumentBuilder)builder).buildDocument(info.getParameters(), inputParmsXPath, namespacePrefixes);
                        this.requestDoc = DocumentBuilder.outputDocToString(doc);
                    }
                    TextMessage outboundMessage = jmsSession.createTextMessage(this.requestDoc);
                    outboundMessage.setJMSCorrelationID(this.correlationID);
                    this.producer = jmsSession.createProducer(this.connection.getOutboundDestination());
                    this.producer.send(this.connection.getOutboundDestination(), (Message)outboundMessage, this.jmsState.getMessageDeliveryMode(), this.jmsState.getMesssagePriority(), (long)this.jmsState.getMessageDuration());
                }
            }
        }
        catch (JMSException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public XMLDocument recreateDocument(Serializable requestObject) throws ConnectorException {
        XMLDocument result = null;
        try {
            Session jmsSession = this.connection.getJMSSession();
            MessageConsumer consumer = jmsSession.createConsumer(this.connection.getInboundDestination(), this.messageSelector);
            TextMessage outboundMessage = jmsSession.createTextMessage(this.requestDoc.toString());
            outboundMessage.setJMSCorrelationID(this.correlationID);
            MessageProducer producer = jmsSession.createProducer(this.connection.getOutboundDestination());
            producer.send(this.connection.getOutboundDestination(), (Message)outboundMessage, this.jmsState.getMessageDeliveryMode(), this.jmsState.getMesssagePriority(), (long)this.jmsState.getMessageDuration());
            TextMessage message = (TextMessage)consumer.receive((long)this.jmsState.getCacheTimeoutMillis());
            ByteArrayInputStream stream = new ByteArrayInputStream(message.getText().getBytes());
            DocumentInfo info = this.xmlExtractor.createDocumentFromStream(stream, "", this.jmsState.getSAXFilterProvider());
            Document domDoc = info.m_domDoc;
            result = new XMLDocument(domDoc, info.m_externalFiles);
        }
        catch (JMSException e) {
            throw new ConnectorException((Throwable)e);
        }
        return result;
    }

    public Serializable getRequestObject(int i) throws ConnectorException {
        return this.requestDoc;
    }

    public int getDocumentCount() throws ConnectorException {
        return 1;
    }

    public String getCacheKey(int i) throws ConnectorException {
        return this.correlationID;
    }

    public Response getXMLResponse(int invocationNumber) throws ConnectorException {
        IDocumentCache cache = this.execution.getCache();
        ExecutionContext exeContext = this.execution.getExeContext();
        String requestID = exeContext.getRequestIdentifier();
        String partID = exeContext.getPartIdentifier();
        String executionID = exeContext.getExecutionCountIdentifier();
        String cacheReference = requestID + partID + executionID + Integer.toString(invocationNumber);
        CriteriaDesc criterion = this.execution.getInfo().getResponseIDCriterion();
        if (null != criterion) {
            String responseid = (String)criterion.getValues().get(0);
            this.connection.getConnector().createCacheObjectRecord(requestID, partID, executionID, Integer.toString(invocationNumber), responseid);
            return new Response(responseid, this, cache, this.jmsState.isErrorOnRecreateDoc(), cacheReference);
        }
        int documentCount = this.getDocumentCount();
        String[] cacheKeys = new String[documentCount];
        XMLDocument[] docs = new XMLDocument[documentCount];
        for (int i = 0; i < documentCount; ++i) {
            String cacheKey = this.getCacheKey(i);
            XMLDocument doc = DocumentCache.cacheLookup(cache, cacheKey, null);
            if (doc == null) {
                String documentDistinguishingId = "";
                if (documentCount > 1) {
                    documentDistinguishingId = new Integer(i).toString();
                }
                TextMessage message = (TextMessage)this.messages.get(i);
                try {
                    String messageText = message.getText();
                    if (messageText.length() == 0) {
                        throw new ConnectorException("Message " + message.getJMSMessageID() + "with CorrelataionID " + message.getJMSCorrelationID() + " was empty");
                    }
                    ByteArrayInputStream stream = new ByteArrayInputStream(messageText.getBytes());
                    DocumentInfo info = this.xmlExtractor.createDocumentFromStream(stream, documentDistinguishingId, this.jmsState.getSAXFilterProvider());
                    Document domDoc = info.m_domDoc;
                    doc = new XMLDocument(domDoc, info.m_externalFiles);
                    cache.addToCache(cacheKey, doc, info.m_memoryCacheSize, cacheReference);
                    this.execution.getConnection().getConnector().createCacheObjectRecord(requestID, partID, executionID, Integer.toString(invocationNumber), cacheKey);
                }
                catch (JMSException e) {
                    String exMessage = Messages.getString("JMSRequestExecutor.exception.getting.message.text");
                    throw new ConnectorException((Throwable)e, exMessage);
                }
            }
            docs[i] = doc;
            cacheKeys[i] = cacheKey;
        }
        this.connection.getConnector().createCacheObjectRecord(requestID, partID, executionID, Integer.toString(invocationNumber), cacheKeys[0]);
        return new Response(docs, cacheKeys, this, cache, this.jmsState.isErrorOnRecreateDoc(), cacheReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResponse() throws ConnectorException {
        JMSRequestExecutor jMSRequestExecutor = this;
        synchronized (jMSRequestExecutor) {
            if (this.onMessageException != null) {
                throw new ConnectorException((Throwable)this.onMessageException, Messages.getString("JMSRequestExecutor.exception.onMessage"));
            }
            boolean result = true;
            if (null != this.producer) {
                result = !this.messages.isEmpty();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        JMSRequestExecutor jMSRequestExecutor = this;
        synchronized (jMSRequestExecutor) {
            ConnectorLogger logger = this.connection.getConnector().getLogger();
            try {
                logger.logTrace(message.getJMSMessageID());
                logger.logTrace(message.getJMSCorrelationID());
                logger.logTrace(message.getJMSType());
                this.messages.add(message);
            }
            catch (JMSException e) {
                this.onMessageException = e;
            }
        }
    }
}

