/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTempBuffer;

public class UtilByteArrayDataProvider
implements UtilDataProvider {
    static String footprint = "$Revision:   3.7.2.0  $";
    byte[] byteArray;
    int readPosition;
    int length;
    UtilDataProvider provider;
    UtilTempBuffer tempBuffer;

    public UtilByteArrayDataProvider(byte[] byArray, int n) {
        this.byteArray = byArray;
        this.readPosition = 0;
        this.length = n;
        this.provider = null;
    }

    public UtilByteArrayDataProvider(byte[] byArray) {
        this(byArray, byArray.length);
    }

    public UtilByteArrayDataProvider(UtilDataProvider utilDataProvider, UtilPagedTempBuffer utilPagedTempBuffer, int n) {
        this(null, 0);
        this.provider = utilDataProvider;
        this.readPosition = 0;
        this.length = n;
        this.tempBuffer = utilPagedTempBuffer;
    }

    public UtilByteArrayDataProvider(UtilDataProvider utilDataProvider) {
        this(null, 0);
        this.provider = utilDataProvider;
        this.readPosition = 0;
        this.length = 0;
        this.tempBuffer = new UtilPagedTempBuffer();
    }

    public boolean atEndOfReply() {
        return this.readPosition == this.length;
    }

    public long getNumBytesLeftInCurrentReply() {
        return this.length - this.readPosition;
    }

    public long getReadPosition() {
        return this.readPosition;
    }

    public byte getByte() throws UtilException {
        if (this.readPosition == this.length) {
            throw new UtilException(1001);
        }
        byte by = this.provider == null ? this.byteArray[this.readPosition] : this.tempBuffer.read(this.readPosition);
        ++this.readPosition;
        return by;
    }

    public int getArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (this.readPosition == this.length) {
            throw new UtilException(1001);
        }
        int n3 = Math.min(n2, this.length - this.readPosition);
        if (this.provider == null) {
            System.arraycopy(this.byteArray, this.readPosition, byArray, n, n3);
        } else {
            n3 = this.tempBuffer.read(this.readPosition, byArray, n, n3);
        }
        this.readPosition += n3;
        return n3;
    }

    public void empty() throws UtilException {
        this.readPosition = this.length;
        this.tempBuffer.truncate();
    }

    public void backup(int n) {
        this.readPosition -= n;
        if (this.readPosition < 0) {
            this.readPosition = 0;
        }
    }

    public void resetByteArray(int n) throws UtilException {
        if (this.provider != null) {
            throw new UtilException(1022);
        }
        this.readPosition = 0;
        this.length = n;
    }

    public void receive() throws UtilException {
        if (this.provider == null) {
            return;
        }
        this.readPosition = 0;
        this.tempBuffer.truncate();
        this.provider.receive();
        this.length = this.tempBuffer.write(this.provider);
    }

    public void fill() throws UtilException {
        if (this.provider == null) {
            return;
        }
        this.readPosition = 0;
        this.tempBuffer.truncate();
        this.length = this.tempBuffer.write(this.provider);
    }

    public boolean moreUnbufferedDataToReturn() {
        return false;
    }

    public void reset() {
        this.length = 0;
        this.readPosition = 0;
    }
}

