/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.proc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.QueryComponentException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.execution.multisource.PlanModifier;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.optimizer.QueryOptimizer;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.proc.CommandInstruction;
import com.metamatrix.query.processor.proc.ExecDynamicSqlInstruction;
import com.metamatrix.query.processor.proc.ExecSqlInstruction;
import com.metamatrix.query.processor.proc.ProcedureEnvironment;
import com.metamatrix.query.processor.program.Program;
import com.metamatrix.query.processor.program.ProgramEnvironment;
import com.metamatrix.query.processor.program.ProgramInstruction;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.resolver.util.ResolveVirtualGroupCriteriaVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.rewriter.VariableSubstitutionVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.DynamicCommand;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.util.VariableContext;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExecDynamicSqlInstruction
extends CommandInstruction {
    private static PopCallInstruction POP_CALL_INSTRUCTION = new PopCallInstruction(null);
    private DynamicCommand dynamicCommand;
    IDGenerator idGenerator;
    CapabilitiesFinder capFinder;
    private QueryMetadataInterface metadata;
    CreateUpdateProcedureCommand parentProcCommand;
    private Program dynamicProgram;

    public ExecDynamicSqlInstruction(CreateUpdateProcedureCommand parentProcCommand, DynamicCommand command, List references, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capFinder) {
        this.parentProcCommand = parentProcCommand;
        this.dynamicCommand = command;
        this.metadata = metadata;
        this.capFinder = capFinder;
        this.idGenerator = idGenerator;
        this.setReferences(references);
    }

    public void process(ProgramEnvironment env) throws BlockedException, MetaMatrixComponentException {
        LogManager.logTrace((String)"QUERY_PLANNER", (String)"Processing ExecDynamicSqlInstruction as part of processing the update procedure");
        ProcedureEnvironment procEnv = (ProcedureEnvironment)env;
        VariableContext localContext = procEnv.getCurrentVariableContext();
        this.setReferenceValues(localContext);
        QueryParser parser = new QueryParser();
        try {
            Object value = ExpressionEvaluator.evaluate(this.dynamicCommand.getSql(), Collections.EMPTY_MAP, Collections.EMPTY_LIST, (LookupEvaluator)procEnv.getDataManager(), procEnv.getContext());
            if (value == null) {
                throw new MetaMatrixComponentException(QueryExecPlugin.Util.getString("ExecDynamicSqlInstruction.0"));
            }
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Executing dynamic sql ", value});
            Command command = parser.parseCommand(value.toString());
            command.setExternalGroupContexts(this.dynamicCommand.getExternalGroupContexts());
            command.setTemporaryMetadata(this.dynamicCommand.getTemporaryMetadata());
            command.setVariableValues(new HashMap(this.dynamicCommand.getVariableValues()));
            this.updateContextWithUsingValues(procEnv, localContext);
            Map tempMetadata = command.getTemporaryMetadata();
            TempMetadataStore metadataStore = new TempMetadataStore(tempMetadata);
            if (this.dynamicCommand.getUsing() != null && !this.dynamicCommand.getUsing().isEmpty()) {
                metadataStore.addTempGroup("USING", new LinkedList(this.dynamicCommand.getUsing().keySet()));
                GroupSymbol using = new GroupSymbol("USING");
                using.setMetadataID(metadataStore.getTempGroupID("USING"));
                command.addExternalGroupToContext(using);
            }
            if (this.parentProcCommand.isUpdateProcedure()) {
                ResolveVirtualGroupCriteriaVisitor.resolveCriteria((LanguageObject)command, (GroupSymbol)this.parentProcCommand.getVirtualGroup(), (QueryMetadataInterface)this.metadata);
            }
            QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata);
            this.validateDynamicCommand(procEnv, command);
            Map nameValueMap = this.createVariableValuesMap(localContext);
            command.getVariableValues().putAll(nameValueMap);
            VariableSubstitutionVisitor.substituteVariables((LanguageObject)command, command.getVariableValues(), command.getType());
            QueryRewriter.rewrite(command, this.parentProcCommand, this.metadata, procEnv.getContext());
            if (this.dynamicCommand.getAsColumns() != null && !this.dynamicCommand.getAsColumns().isEmpty()) {
                command = this.wrapCommand(command);
            }
            ProcessorPlan commandPlan = QueryOptimizer.optimizePlan(command, this.metadata, this.idGenerator, this.capFinder, AnalysisRecord.createNonRecordingRecord(), procEnv.getContext());
            PlanModifier multiSourcePlanModifier = (PlanModifier)procEnv.getContext().getMultiSourcePlanModifier();
            if (multiSourcePlanModifier != null) {
                multiSourcePlanModifier.modifyPlan(commandPlan, this.metadata);
            }
            List references = ReferenceCollectorVisitor.getReferences((LanguageObject)command);
            ExecSqlInstruction inst = new ExecSqlInstruction(commandPlan, references, this.dynamicCommand.getIntoGroup());
            this.dynamicProgram = new Program();
            this.dynamicProgram.addInstruction((ProgramInstruction)inst);
            this.dynamicProgram.addInstruction((ProgramInstruction)POP_CALL_INSTRUCTION);
            if (this.dynamicCommand.getIntoGroup() != null) {
                String groupName = this.dynamicCommand.getIntoGroup().getCanonicalName();
                if (!procEnv.getTempTableStore().getAllTempTables().contains(groupName)) {
                    procEnv.getTempContext().add(groupName);
                }
            }
            procEnv.push(this.dynamicProgram);
        }
        catch (QueryComponentException e) {
            Object[] params = new Object[]{this.dynamicCommand, this.dynamicCommand.getSql(), e.getMessage()};
            throw new MetaMatrixComponentException((Throwable)e, QueryExecPlugin.Util.getString("ExecDynamicSqlInstruction.couldnt_execute", params));
        }
        catch (ExpressionEvaluationException e) {
            Object[] params = new Object[]{this.dynamicCommand, this.dynamicCommand.getSql(), e.getMessage()};
            throw new MetaMatrixComponentException((Throwable)e, QueryExecPlugin.Util.getString("ExecDynamicSqlInstruction.couldnt_execute", params));
        }
    }

    private void updateContextWithUsingValues(ProcedureEnvironment procEnv, VariableContext localContext) throws ExpressionEvaluationException, MetaMatrixComponentException {
        if (this.dynamicCommand.getUsing() != null && !this.dynamicCommand.getUsing().isEmpty()) {
            Iterator i = this.dynamicCommand.getUsing().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object assignment = ExpressionEvaluator.evaluate((Expression)entry.getValue(), Collections.EMPTY_MAP, Collections.EMPTY_LIST, (LookupEvaluator)procEnv.getDataManager(), procEnv.getContext());
                LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{this, " The using variable ", entry.getKey(), " has value :", assignment});
                localContext.setValue((ElementSymbol)entry.getKey(), assignment);
            }
        }
    }

    private Query wrapCommand(Command command) throws QueryResolverException, MetaMatrixComponentException {
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
        int i = 0;
        String subquery_group_name = "X";
        GroupSymbol groupSymbol = new GroupSymbol(subquery_group_name);
        while (groups.contains(groupSymbol)) {
            subquery_group_name = "X" + i;
            ++i;
            groupSymbol = new GroupSymbol(subquery_group_name);
        }
        Select select = new Select();
        Map shortNameMap = this.createShortNameMap(command.getProjectedSymbols());
        Iterator columns = this.dynamicCommand.getAsColumns().iterator();
        while (columns.hasNext()) {
            String expectedName;
            Class projectedSymbolType = null;
            ElementSymbol expectedSymbol = (ElementSymbol)columns.next();
            String actualName = expectedName = expectedSymbol.getShortCanonicalName();
            boolean shouldAlias = false;
            if (this.dynamicCommand.getAsColumns().size() == 1) {
                SingleElementSymbol projectedSymbol = (SingleElementSymbol)command.getProjectedSymbols().get(0);
                actualName = projectedSymbol.getShortCanonicalName();
                projectedSymbolType = projectedSymbol.getType();
                shouldAlias = !actualName.equals(expectedName);
            } else {
                projectedSymbolType = (Class)shortNameMap.get(expectedName);
            }
            ElementSymbol wrappedSymbol = new ElementSymbol(groupSymbol.getCanonicalName() + "." + actualName);
            Expression result = ResolverUtil.convertExpression((Expression)wrappedSymbol, DataTypeManager.getDataTypeName((Class)projectedSymbolType), DataTypeManager.getDataTypeName((Class)expectedSymbol.getType()));
            if (!(result instanceof SingleElementSymbol)) {
                wrappedSymbol = new ExpressionSymbol(expectedName, result);
                shouldAlias = true;
            }
            if (shouldAlias) {
                wrappedSymbol = new AliasSymbol(expectedName, (SingleElementSymbol)wrappedSymbol);
            }
            select.addSymbol((SelectSymbol)wrappedSymbol);
        }
        Query query = new Query();
        query.setSelect(select);
        From from = new From();
        GroupSymbol inlineGroup = new GroupSymbol(subquery_group_name);
        from.addClause((FromClause)new UnaryFromClause(inlineGroup));
        TempMetadataStore store = new TempMetadataStore();
        TempMetadataAdapter tma = new TempMetadataAdapter(this.metadata, store);
        store.addTempGroup(inlineGroup.getName(), command.getProjectedSymbols());
        inlineGroup.setMetadataID(store.getTempGroupID(inlineGroup.getName()));
        query.setFrom(from);
        QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)tma);
        query.setOption(command.getOption());
        from.getClauses().clear();
        SubqueryFromClause sqfc = new SubqueryFromClause(inlineGroup.getName());
        sqfc.setCommand(command);
        sqfc.getGroupSymbol().setMetadataID(inlineGroup.getMetadataID());
        from.addClause((FromClause)sqfc);
        query.getTemporaryMetadata().putAll(store.getData());
        if (this.dynamicCommand.getIntoGroup() != null) {
            query.setInto(new Into(this.dynamicCommand.getIntoGroup()));
        }
        return query;
    }

    private Map createVariableValuesMap(VariableContext localContext) {
        HashMap variableMap = new HashMap();
        localContext.getFlattenedContextMap(variableMap);
        HashMap<String, Constant> nameValueMap = new HashMap<String, Constant>(variableMap.size());
        Iterator entries = variableMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            nameValueMap.put(((ElementSymbol)entry.getKey()).getCanonicalName(), new Constant(entry.getValue()));
        }
        nameValueMap.putAll(this.dynamicCommand.getVariableValues());
        return nameValueMap;
    }

    private void validateDynamicCommand(ProcedureEnvironment procEnv, Command command) throws MetaMatrixComponentException, QueryComponentException {
        CommandContext context;
        List dynamicExpectedColumns = this.dynamicCommand.getAsColumns();
        List sourceProjectedSymbolList = command.getProjectedSymbols();
        if (dynamicExpectedColumns != null && !dynamicExpectedColumns.isEmpty()) {
            if (dynamicExpectedColumns.size() != sourceProjectedSymbolList.size()) {
                throw new QueryComponentException(QueryExecPlugin.Util.getString("ExecDynamicSqlInstruction.4"));
            }
            Iterator dynamicIter = dynamicExpectedColumns.iterator();
            Map sourceMap = this.createShortNameMap(sourceProjectedSymbolList);
            while (dynamicIter.hasNext()) {
                String sourceTypeName;
                Class dynamicType;
                String dynamicTypeName;
                SingleElementSymbol dynamicSymbol = (SingleElementSymbol)dynamicIter.next();
                Object sourceSymbolDatatype = null;
                if (dynamicExpectedColumns.size() > 1) {
                    sourceSymbolDatatype = sourceMap.get(dynamicSymbol.getShortCanonicalName());
                    if (sourceSymbolDatatype == null) {
                        Object[] params = new Object[]{dynamicSymbol.getShortCanonicalName()};
                        throw new QueryComponentException(QueryExecPlugin.Util.getString("ExecDynamicSqlInstruction.5", params));
                    }
                } else {
                    sourceSymbolDatatype = sourceMap.values().iterator().next();
                }
                if ((dynamicTypeName = DataTypeManager.getDataTypeName((Class)(dynamicType = dynamicSymbol.getType()))).equals(sourceTypeName = DataTypeManager.getDataTypeName((Class)sourceSymbolDatatype)) || DataTypeManager.isImplicitConversion((String)sourceTypeName, (String)dynamicTypeName)) continue;
                Object[] params = new Object[]{sourceTypeName, dynamicSymbol.getShortCanonicalName(), dynamicTypeName};
                throw new QueryComponentException(QueryExecPlugin.Util.getString("ExecDynamicSqlInstruction.6", params));
            }
        }
        if (procEnv.getContext().isOptimisticTransaction()) {
            int origModelCount = this.dynamicCommand.getUpdatingModelCount();
            int newModelCount = command.updatingModelCount(this.metadata);
            if ((origModelCount == 0 || origModelCount == 1) && newModelCount > origModelCount) {
                Object[] params = new Object[]{new Integer(newModelCount), new Integer(origModelCount)};
                throw new QueryComponentException(QueryExecPlugin.Util.getString("ExecDynamicSqlInstruction.1", params));
            }
        }
        if ((context = procEnv.getContext()).pushCall(this.parentProcCommand.getVirtualGroup().getCanonicalName())) {
            Object[] params = new Object[]{this.parentProcCommand.getVirtualGroup().getCanonicalName()};
            throw new QueryComponentException(QueryExecPlugin.Util.getString("ExecDynamicSqlInstruction.3", params));
        }
    }

    private Map createShortNameMap(List sourceProjectedSymbolList) {
        Iterator sourceIter = sourceProjectedSymbolList.iterator();
        HashMap<String, Class> sourceMap = new HashMap<String, Class>();
        while (sourceIter.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)sourceIter.next();
            sourceMap.put(symbol.getShortCanonicalName(), symbol.getType());
        }
        return sourceMap;
    }

    public Object clone() {
        List copyReferences = this.cloneReferences();
        ExecDynamicSqlInstruction clone = new ExecDynamicSqlInstruction(this.parentProcCommand, this.dynamicCommand, copyReferences, this.metadata, this.idGenerator, this.capFinder);
        return clone;
    }

    public String toString() {
        return "ExecDynamicSqlInstruction";
    }

    public Map getDescriptionProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", "SQL");
        props.put("sql", "EXECSQL_INSTRUCTION");
        if (this.dynamicCommand.getIntoGroup() != null) {
            props.put("group", this.dynamicCommand.getIntoGroup().toString());
        }
        return props;
    }

    public Collection getChildPlans() {
        if (this.dynamicProgram != null) {
            return this.dynamicProgram.getChildPlans();
        }
        return Collections.EMPTY_LIST;
    }
}

