/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.model.schema.impl;

import com.metamatrix.modeler.schema.tools.model.jdbc.Column;
import com.metamatrix.modeler.schema.tools.model.jdbc.internal.ColumnImpl;
import com.metamatrix.modeler.schema.tools.model.schema.Column;
import com.metamatrix.modeler.schema.tools.model.schema.Relationship;
import com.metamatrix.modeler.schema.tools.model.schema.impl.BaseColumn;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SchemaModelImpl;
import com.metamatrix.modeler.schema.tools.model.schema.impl.TextColumn;

public class MergedColumn
extends BaseColumn {
    private Column childCol;
    private Relationship tableRelationship;
    private int iOccurence;

    public MergedColumn(Column childCol, Relationship tableRelationship, int iOccurence) {
        super(false, childCol.getType());
        this.childCol = childCol;
        this.tableRelationship = tableRelationship;
        this.iOccurence = iOccurence;
    }

    public String getXpath() {
        StringBuffer retval = new StringBuffer();
        String tableXpath = this.tableRelationship.getChildRelativeXpath();
        retval.append(tableXpath);
        if (this.iOccurence >= 0) {
            retval.append("[" + this.iOccurence + "]");
        }
        String childXpath = this.childCol.getXpath();
        retval.append("/");
        retval.append(childXpath);
        return retval.toString();
    }

    public String getSimpleName() {
        StringBuffer retval = new StringBuffer();
        String tableSimpleName = this.tableRelationship.getChild().getSimpleName();
        retval.append(tableSimpleName);
        if (this.iOccurence >= 0) {
            retval.append(this.iOccurence);
        }
        String childSimpleName = this.childCol.getSimpleName();
        String sep = SchemaModelImpl.getSeparator();
        retval.append(sep);
        retval.append(childSimpleName);
        if (this.childCol instanceof TextColumn) {
            int index = retval.lastIndexOf("text");
            return retval.substring(0, index - 1);
        }
        return retval.toString();
    }

    public Column copy() {
        return new MergedColumn(this.childCol, this.tableRelationship, this.iOccurence);
    }

    public void printDebug() {
        StringBuffer buff = new StringBuffer("\t \t");
        buff.append("MergedColumn: ");
        buff.append("SimpleName = " + this.getSimpleName());
        buff.append(" ");
        buff.append("XPath = " + this.getXpath());
        buff.append(" ");
        buff.append("Occurance = " + this.iOccurence);
        buff.append(" ");
        buff.append("TableRelationship = " + this.tableRelationship);
        buff.append(" ");
        System.out.println(buff.toString());
    }

    public com.metamatrix.modeler.schema.tools.model.jdbc.Column getColumnImplementation() {
        ColumnImpl newColumn = new ColumnImpl();
        newColumn.setDataAttributeName(this.getSimpleName());
        newColumn.setDataType(((BaseColumn)this.childCol).getDataType());
        newColumn.setIsAttributeOfParent(false);
        newColumn.setIsInputParameter(false);
        newColumn.setName(this.getSimpleName());
        newColumn.setOutputXPath(this.getXpath());
        newColumn.setRole(Column.Role.DATA);
        return newColumn;
    }
}

