/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseColumnsImplResultSet;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplResultSetClientSideEmpty;
import com.metamatrix.jdbc.base.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.base.BaseStatement;
import com.metamatrix.jdbc.base.BaseTableTypes;
import com.metamatrix.jdbc.base.BaseTypeInfos;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public abstract class BaseImplDatabaseMetaData {
    private static String footprint = "$Revision:   3.11.1.1  $";
    public static final int NONE = 0;
    public static final int TABLES = 1;
    public static final int COLUMNS = 2;
    public static final int TYPEINFO = 3;
    public static final int TABLETYPES = 4;
    public static final int PROCEDURES = 5;
    public static final int PROCEDURECOLUMNS = 6;
    public static final int BESTROWIDENTIFIER = 7;
    public static final int CATALOGS = 8;
    public static final int COLUMNPRIVILEGES = 9;
    public static final int CROSSREFERENCE = 10;
    public static final int EXPORTEDKEYS = 11;
    public static final int IMPORTEDKEYS = 12;
    public static final int INDEXINFO = 13;
    public static final int PRIMARYKEYS = 14;
    public static final int SCHEMAS = 15;
    public static final int TABLEPRIVILEGES = 16;
    public static final int UDTS = 17;
    public static final int VERSIONCOLUMNS = 18;
    public static final int SUPERTYPES = 19;
    public static final int SUPERTABLES = 20;
    public static final int ATTRIBUTES = 21;
    public static final int CLIENTINFO = 22;
    protected static final int CO_NONE = 0;
    protected static final int CO_POPULATE_REMARKS_COLUMNS = 1;
    protected static final int CO_SYNONYM_SUPPORT = 2;
    protected static final int CO_USE_GETCOLUMNS_EMULATION = 4;
    public static final int CO_DEFAULT_VALUE = 2;
    protected int catalogOptions = 2;
    private BaseConnection connection;
    protected BaseExceptions exceptions;
    public Boolean allProceduresAreCallable;
    public Boolean allTablesAreSelectable;
    public Boolean isReadOnly;
    public Boolean nullsAreSortedHigh;
    public Boolean nullsAreSortedLow;
    public Boolean nullsAreSortedAtStart;
    public Boolean nullsAreSortedAtEnd;
    public String databaseProductName;
    public String databaseProductVersion;
    public Boolean usesLocalFiles;
    public Boolean usesLocalFilePerTable;
    public Boolean supportsMixedCaseIdentifiers;
    public Boolean storesUpperCaseIdentifiers;
    public Boolean storesLowerCaseIdentifiers;
    public Boolean storesMixedCaseIdentifiers;
    public Boolean supportsMixedCaseQuotedIdentifiers;
    public Boolean storesUpperCaseQuotedIdentifiers;
    public Boolean storesLowerCaseQuotedIdentifiers;
    public Boolean storesMixedCaseQuotedIdentifiers;
    public String identifierQuoteString;
    public String SQLKeywords;
    public String numericFunctions;
    public String stringFunctions;
    public String systemFunctions;
    public String timeDateFunctions;
    public String searchStringEscape;
    public String extraNameCharacters;
    public Boolean supportsAlterTableWithAddColumn;
    public Boolean supportsAlterTableWithDropColumn;
    public Boolean supportsColumnAliasing;
    public Boolean nullPlusNonNullIsNull;
    public Boolean supportsConvert;
    public Boolean supportsTableCorrelationNames;
    public Boolean supportsDifferentTableCorrelationNames;
    public Boolean supportsExpressionsInOrderBy;
    public Boolean supportsOrderByUnrelated;
    public Boolean supportsGroupBy;
    public Boolean supportsGroupByUnrelated;
    public Boolean supportsGroupByBeyondSelect;
    public Boolean supportsLikeEscapeClause;
    public Boolean supportsMultipleResultSets;
    public Boolean supportsMultipleTransactions;
    public Boolean supportsNonNullableColumns;
    public Boolean supportsMinimumSQLGrammar;
    public Boolean supportsCoreSQLGrammar;
    public Boolean supportsExtendedSQLGrammar;
    public Boolean supportsANSI92EntryLevelSQL;
    public Boolean supportsANSI92IntermediateSQL;
    public Boolean supportsANSI92FullSQL;
    public Boolean supportsIntegrityEnhancementFacility;
    public Boolean supportsOuterJoins;
    public Boolean supportsFullOuterJoins;
    public Boolean supportsLimitedOuterJoins;
    public String schemaTerm;
    public String procedureTerm;
    public String catalogTerm;
    public Boolean isCatalogAtStart;
    public String catalogSeparator;
    public Boolean supportsSchemasInDataManipulation;
    public Boolean supportsSchemasInProcedureCalls;
    public Boolean supportsSchemasInTableDefinitions;
    public Boolean supportsSchemasInIndexDefinitions;
    public Boolean supportsSchemasInPrivilegeDefinitions;
    public Boolean supportsCatalogsInDataManipulation;
    public Boolean supportsCatalogsInProcedureCalls;
    public Boolean supportsCatalogsInTableDefinitions;
    public Boolean supportsCatalogsInIndexDefinitions;
    public Boolean supportsCatalogsInPrivilegeDefinitions;
    public Boolean supportsPositionedDelete;
    public Boolean supportsPositionedUpdate;
    public Boolean supportsSelectForUpdate;
    public Boolean supportsStoredProcedures;
    public Boolean supportsSubqueriesInComparisons;
    public Boolean supportsSubqueriesInExists;
    public Boolean supportsSubqueriesInIns;
    public Boolean supportsSubqueriesInQuantifieds;
    public Boolean supportsCorrelatedSubqueries;
    public Boolean supportsUnion;
    public Boolean supportsUnionAll;
    public Boolean supportsOpenCursorsAcrossCommit;
    public Boolean supportsOpenCursorsAcrossRollback;
    public Boolean supportsOpenStatementsAcrossCommit;
    public Boolean supportsOpenStatementsAcrossRollback;
    public Integer maxBinaryLiteralLength;
    public Integer maxCharLiteralLength;
    public Integer maxColumnNameLength;
    public Integer maxColumnsInGroupBy;
    public Integer maxColumnsInIndex;
    public Integer maxColumnsInOrderBy;
    public Integer maxColumnsInSelect;
    public Integer maxColumnsInTable;
    public Integer maxConnections;
    public Integer maxCursorNameLength;
    public Integer maxIndexLength;
    public Integer maxSchemaNameLength;
    public Integer maxProcedureNameLength;
    public Integer maxCatalogNameLength;
    public Integer maxRowSize;
    public Boolean doesMaxRowSizeIncludeBlobs;
    public Integer maxStatementLength;
    public Integer maxStatements;
    public Integer maxTableNameLength;
    public Integer maxTablesInSelect;
    public Integer maxUserNameLength;
    public Integer defaultTransactionIsolation;
    public Boolean supportsTransactions;
    public Boolean supportsTransactionIsolationLevel;
    public Boolean supportsTransactionIsolationLevelNone;
    public Boolean supportsTransactionIsolationLevelReadCommited;
    public Boolean supportsTransactionIsolationLevelReadUncommited;
    public Boolean supportsTransactionIsolationLevelRepeatableRead;
    public Boolean supportsTransactionIsolationLevelSerializable;
    public Boolean supportsDataDefinitionAndDataManipulationTransactions;
    public Boolean supportsDataManipulationTransactionsOnly;
    public Boolean dataDefinitionCausesTransactionCommit;
    public Boolean dataDefinitionIgnoredInTransactions;
    public Boolean supportsResultSetTypeScrollInsensitive;
    public Boolean supportsResultSetTypeScrollSensitive;
    public Boolean ownUpdatesAreVisibleForwardOnly;
    public Boolean ownUpdatesAreVisibleScrollInsensitive;
    public Boolean ownUpdatesAreVisibleScrollSensitive;
    public Boolean ownDeletesAreVisibleForwardOnly;
    public Boolean ownDeletesAreVisibleScrollInsensitive;
    public Boolean ownDeletesAreVisibleScrollSensitive;
    public Boolean ownInsertsAreVisibleForwardOnly;
    public Boolean ownInsertsAreVisibleScrollInsensitive;
    public Boolean ownInsertsAreVisibleScrollSensitive;
    public Boolean othersUpdatesAreVisibleForwardOnly;
    public Boolean othersUpdatesAreVisibleScrollInsensitive;
    public Boolean othersUpdatesAreVisibleScrollSensitive;
    public Boolean othersDeletesAreVisibleForwardOnly;
    public Boolean othersDeletesAreVisibleScrollInsensitive;
    public Boolean othersDeletesAreVisibleScrollSensitive;
    public Boolean othersInsertsAreVisibleForwardOnly;
    public Boolean othersInsertsAreVisibleScrollInsensitive;
    public Boolean othersInsertsAreVisibleScrollSensitive;
    public Boolean updatesAreDetectedForwardOnly;
    public Boolean updatesAreDetectedScrollInsensitive;
    public Boolean updatesAreDetectedScrollSensitive;
    public Boolean deletesAreDetectedForwardOnly;
    public Boolean deletesAreDetectedScrollInsensitive;
    public Boolean deletesAreDetectedScrollSensitive;
    public Boolean insertsAreDetectedForwardOnly;
    public Boolean insertsAreDetectedScrollInsensitive;
    public Boolean insertsAreDetectedScrollSensitive;
    public Boolean supportsBatchUpdates;
    public Boolean locatorsUpdateCopy;
    public Boolean supportsSavepoints;
    public Boolean supportsNamedParameters;
    public Boolean supportsMultipleOpenResults;
    public Boolean supportsGetGeneratedKeys;
    public Boolean supportsResultSetHoldability;
    public Integer resultSetHoldability;
    public Integer databaseMajorVersion;
    public Integer databaseMinorVersion;
    public Integer sqlStateType;
    public Integer maxClientAppName;
    public Integer maxClientHostName;
    public Integer maxClientUser;
    public Integer maxClientAcctInfo;
    public final int ALLPROCEDURESARECALLABLE = 1;
    public final int ALLTABLESARESELECTABLE = 2;
    public final int ISREADONLY = 3;
    public final int NULLSARESORTEDHIGH = 4;
    public final int NULLSARESORTEDLOW = 5;
    public final int NULLSARESORTEDATSTART = 6;
    public final int NULLSARESORTEDATEND = 7;
    public final int DATABASEPRODUCTNAME = 8;
    public final int DATABASEPRODUCTVERSION = 9;
    public final int USESLOCALFILES = 10;
    public final int USESLOCALFILEPERTABLE = 11;
    public final int SUPPORTSMIXEDCASEIDENTIFIERS = 12;
    public final int STORESUPPERCASEIDENTIFIERS = 13;
    public final int STORESLOWERCASEIDENTIFIERS = 14;
    public final int STORESMIXEDCASEIDENTIFIERS = 15;
    public final int SUPPORTSMIXEDCASEQUOTEDIDENTIFIERS = 16;
    public final int STORESUPPERCASEQUOTEDIDENTIFIERS = 17;
    public final int STORESLOWERCASEQUOTEDIDENTIFIERS = 18;
    public final int STORESMIXEDCASEQUOTEDIDENTIFIERS = 19;
    public final int IDENTIFIERQUOTESTRING = 20;
    public final int SQLKEYWORDS = 21;
    public final int NUMERICFUNCTIONS = 22;
    public final int STRINGFUNCTIONS = 23;
    public final int SYSTEMFUNCTIONS = 24;
    public final int TIMEDATEFUNCTIONS = 25;
    public final int SEARCHSTRINGESCAPE = 26;
    public final int EXTRANAMECHARACTERS = 27;
    public final int SUPPORTSALTERTABLEWITHADDCOLUMN = 28;
    public final int SUPPORTSALTERTABLEWITHDROPCOLUMN = 29;
    public final int SUPPORTSCOLUMNALIASING = 30;
    public final int NULLPLUSNONNULLISNULL = 31;
    public final int SUPPORTSCONVERT = 32;
    public final int SUPPORTSTABLECORRELATIONNAMES = 33;
    public final int SUPPORTSDIFFERENTTABLECORRELATIONNAMES = 34;
    public final int SUPPORTSEXPRESSIONSINORDERBY = 35;
    public final int SUPPORTSORDERBYUNRELATED = 36;
    public final int SUPPORTSGROUPBY = 37;
    public final int SUPPORTSGROUPBYUNRELATED = 38;
    public final int SUPPORTSGROUPBYBEYONDSELECT = 39;
    public final int SUPPORTSLIKEESCAPECLAUSE = 40;
    public final int SUPPORTSMULTIPLERESULTSETS = 41;
    public final int SUPPORTSMULTIPLETRANSACTIONS = 42;
    public final int SUPPORTSNONNULLABLECOLUMNS = 43;
    public final int SUPPORTSMINIMUMSQLGRAMMAR = 44;
    public final int SUPPORTSCORESQLGRAMMAR = 45;
    public final int SUPPORTSEXTENDEDSQLGRAMMAR = 46;
    public final int SUPPORTSANSI92ENTRYLEVELSQL = 47;
    public final int SUPPORTSANSI92INTERMEDIATESQL = 48;
    public final int SUPPORTSANSI92FULLSQL = 49;
    public final int SUPPORTSINTEGRITYENHANCEMENTFACILITY = 50;
    public final int SUPPORTSOUTERJOINS = 51;
    public final int SUPPORTSFULLOUTERJOINS = 52;
    public final int SUPPORTSLIMITEDOUTERJOINS = 53;
    public final int SCHEMATERM = 54;
    public final int PROCEDURETERM = 55;
    public final int CATALOGTERM = 56;
    public final int ISCATALOGATSTART = 57;
    public final int CATALOGSEPARATOR = 58;
    public final int SUPPORTSSCHEMASINDATAMANIPULATION = 59;
    public final int SUPPORTSSCHEMASINPROCEDURECALLS = 60;
    public final int SUPPORTSSCHEMASINTABLEDEFINITIONS = 61;
    public final int SUPPORTSSCHEMASININDEXDEFINITIONS = 62;
    public final int SUPPORTSSCHEMASINPRIVILEGEDEFINITIONS = 63;
    public final int SUPPORTSCATALOGSINDATAMANIPULATION = 64;
    public final int SUPPORTSCATALOGSINPROCEDURECALLS = 65;
    public final int SUPPORTSCATALOGSINTABLEDEFINITIONS = 66;
    public final int SUPPORTSCATALOGSININDEXDEFINITIONS = 67;
    public final int SUPPORTSCATALOGSINPRIVILEGEDEFINITIONS = 68;
    public final int SUPPORTSPOSITIONEDDELETE = 69;
    public final int SUPPORTSPOSITIONEDUPDATE = 70;
    public final int SUPPORTSSELECTFORUPDATE = 71;
    public final int SUPPORTSSTOREDPROCEDURES = 72;
    public final int SUPPORTSSUBQUERIESINCOMPARISONS = 73;
    public final int SUPPORTSSUBQUERIESINEXISTS = 74;
    public final int SUPPORTSSUBQUERIESININS = 75;
    public final int SUPPORTSSUBQUERIESINQUANTIFIEDS = 76;
    public final int SUPPORTSCORRELATEDSUBQUERIES = 77;
    public final int SUPPORTSUNION = 78;
    public final int SUPPORTSUNIONALL = 79;
    public final int SUPPORTSOPENCURSORSACROSSCOMMIT = 80;
    public final int SUPPORTSOPENCURSORSACROSSROLLBACK = 81;
    public final int SUPPORTSOPENSTATEMENTSACROSSCOMMIT = 82;
    public final int SUPPORTSOPENSTATEMENTSACROSSROLLBACK = 83;
    public final int MAXBINARYLITERALLENGTH = 84;
    public final int MAXCHARLITERALLENGTH = 85;
    public final int MAXCOLUMNNAMELENGTH = 86;
    public final int MAXCOLUMNSINGROUPBY = 87;
    public final int MAXCOLUMNSININDEX = 88;
    public final int MAXCOLUMNSINORDERBY = 89;
    public final int MAXCOLUMNSINSELECT = 90;
    public final int MAXCOLUMNSINTABLE = 91;
    public final int MAXCONNECTIONS = 92;
    public final int MAXCURSORNAMELENGTH = 93;
    public final int MAXINDEXLENGTH = 94;
    public final int MAXSCHEMANAMELENGTH = 95;
    public final int MAXPROCEDURENAMELENGTH = 96;
    public final int MAXCATALOGNAMELENGTH = 97;
    public final int MAXROWSIZE = 98;
    public final int DOESMAXROWSIZEINCLUDEBLOBS = 99;
    public final int MAXSTATEMENTLENGTH = 100;
    public final int MAXSTATEMENTS = 101;
    public final int MAXTABLENAMELENGTH = 102;
    public final int MAXTABLESINSELECT = 103;
    public final int MAXUSERNAMELENGTH = 104;
    public final int DEFAULTTRANSACTIONISOLATION = 105;
    public final int SUPPORTSTRANSACTIONS = 106;
    public final int SUPPORTSTRANSACTIONISOLATIONLEVEL = 10700;
    public final int SUPPORTSTRANSACTIONISOLATIONLEVELREADCOMMITED = 107;
    public final int SUPPORTSTRANSACTIONISOLATIONLEVELNONE = 154;
    public final int SUPPORTSTRANSACTIONISOLATIONLEVELREADUNCOMMITED = 108;
    public final int SUPPORTSTRANSACTIONISOLATIONLEVELREPEATABLEREAD = 109;
    public final int SUPPORTSTRANSACTIONISOLATIONLEVELSERIALIZABLE = 110;
    public final int SUPPORTSDATADEFINITIONANDDATAMANIPULATIONTRANSACTIONS = 111;
    public final int SUPPORTSDATAMANIPULATIONTRANSACTIONSONLY = 112;
    public final int DATADEFINITIONCAUSESTRANSACTIONCOMMIT = 113;
    public final int DATADEFINITIONIGNOREDINTRANSACTIONS = 114;
    public final int SUPPORTSRESULTSETTYPESCROLLINSENSITIVE = 115;
    public final int SUPPORTSRESULTSETTYPESCROLLSENSITIVE = 116;
    public final int OWNUPDATESAREVISIBLEFORWARDONLY = 117;
    public final int OWNUPDATESAREVISIBLESCROLLINSENSITIVE = 118;
    public final int OWNUPDATESAREVISIBLESCROLLSENSITIVE = 119;
    public final int OWNDELETESAREVISIBLEFORWARDONLY = 120;
    public final int OWNDELETESAREVISIBLESCROLLINSENSITIVE = 121;
    public final int OWNDELETESAREVISIBLESCROLLSENSITIVE = 122;
    public final int OWNINSERTSAREVISIBLEFORWARDONLY = 123;
    public final int OWNINSERTSAREVISIBLESCROLLINSENSITIVE = 124;
    public final int OWNINSERTSAREVISIBLESCROLLSENSITIVE = 125;
    public final int OTHERSUPDATESAREVISIBLEFORWARDONLY = 126;
    public final int OTHERSUPDATESAREVISIBLESCROLLINSENSITIVE = 127;
    public final int OTHERSUPDATESAREVISIBLESCROLLSENSITIVE = 128;
    public final int OTHERSDELETESAREVISIBLEFORWARDONLY = 129;
    public final int OTHERSDELETESAREVISIBLESCROLLINSENSITIVE = 130;
    public final int OTHERSDELETESAREVISIBLESCROLLSENSITIVE = 131;
    public final int OTHERSINSERTSAREVISIBLEFORWARDONLY = 132;
    public final int OTHERSINSERTSAREVISIBLESCROLLINSENSITIVE = 133;
    public final int OTHERSINSERTSAREVISIBLESCROLLSENSITIVE = 134;
    public final int UPDATESAREDETECTEDFORWARDONLY = 135;
    public final int UPDATESAREDETECTEDSCROLLINSENSITIVE = 136;
    public final int UPDATESAREDETECTEDSCROLLSENSITIVE = 137;
    public final int DELETESAREDETECTEDFORWARDONLY = 138;
    public final int DELETESAREDETECTEDSCROLLINSENSITIVE = 139;
    public final int DELETESAREDETECTEDSCROLLSENSITIVE = 140;
    public final int INSERTSAREDETECTEDFORWARDONLY = 141;
    public final int INSERTSAREDETECTEDSCROLLINSENSITIVE = 142;
    public final int INSERTSAREDETECTEDSCROLLSENSITIVE = 143;
    public final int SUPPORTSBATCHUPDATES = 144;
    public final int LOCATORSUPDATECOPY = 145;
    public final int SUPPORTSSAVEPOINTS = 146;
    public final int SUPPORTSNAMEDPARAMETERS = 147;
    public final int SUPPORTSMULTIPLEOPENRESULTS = 148;
    public final int SUPPORTSGETGENERATEDKEYS = 149;
    public final int SUPPORTSRESULTSETHOLDABILITY = 150;
    public final int RESULTSETHOLDABILITY = 151;
    public final int DATABASEMAJORVERSION = 152;
    public final int DATABASEMINORVERSION = 153;
    public final int SQLSTATETYPE = 154;
    public final int MAXCLIENTAPPNAME = 155;
    public final int MAXCLIENTHOSTNAME = 156;
    public final int MAXCLIENTUSER = 157;
    public final int MAXCLIENTACCTINFO = 158;
    static final int NO_CATALOG = 0;
    static final int CATALOG_AT_START = 1;
    static final int CATALOG_AT_END = 2;

    protected BaseImplConnection getImplConnection() throws SQLException {
        return this.connection.implConnection;
    }

    public void setup(BaseConnection baseConnection) throws SQLException {
        String string;
        this.connection = baseConnection;
        this.exceptions = baseConnection.exceptions;
        try {
            string = this.connection.getConnectProperties().get("CatalogIncludesSynonyms");
            if (string != null && string.compareToIgnoreCase("false") == 0) {
                this.catalogOptions = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = this.connection.getConnectProperties().get("CatalogOptions");
            if (string != null) {
                this.catalogOptions = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeNonResultSetMetaData(int n) throws SQLException {
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    protected String getResultSetSQL(int n, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) throws SQLException {
        return null;
    }

    protected BaseTypeInfos getTypeInfo() throws SQLException {
        return null;
    }

    private int find(StringBuffer stringBuffer, char c, int n) {
        if (n >= stringBuffer.length()) {
            return -1;
        }
        boolean bl = false;
        while (!bl) {
            if (stringBuffer.charAt(n) == c) {
                return n;
            }
            if (++n < stringBuffer.length()) continue;
            bl = true;
        }
        return -1;
    }

    private String processRestrictionForColumnsEmulation(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = this.find(stringBuffer, '%', 0);
        while (n != -1) {
            if (n == 0) {
                return null;
            }
            if (stringBuffer.charAt(n - 1) != '\\') {
                return null;
            }
            stringBuffer.deleteCharAt(n - 1);
            if (n < stringBuffer.length()) {
                n = this.find(stringBuffer, '%', n);
                continue;
            }
            n = -1;
        }
        n = this.find(stringBuffer, '_', 0);
        while (n != -1) {
            if (n == 0) {
                return null;
            }
            if (stringBuffer.charAt(n - 1) != '\\') {
                return null;
            }
            stringBuffer.deleteCharAt(n - 1);
            if (n < stringBuffer.length()) {
                n = this.find(stringBuffer, '_', n);
                continue;
            }
            n = -1;
        }
        return stringBuffer.toString();
    }

    protected BaseImplResultSet getImplResultSet(int n, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) throws SQLException {
        String string;
        if (n != 2) {
            return null;
        }
        if ((this.catalogOptions & 1) != 0) {
            return null;
        }
        if ((this.catalogOptions & 4) == 0) {
            return null;
        }
        String string2 = this.connection.getCatalog();
        String string3 = (String)baseResultSetFilterDescriptor.getRestriction(1);
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        } else if (string3.compareTo(string2) != 0) {
            return new BaseImplResultSetClientSideEmpty();
        }
        int n2 = string3.length() == 0 ? 0 : (this.isCatalogAtStart != false ? 1 : 2);
        String string4 = (String)baseResultSetFilterDescriptor.getRestriction(2);
        if (this.schemaTerm.length() > 0) {
            if (string4 == null) {
                return null;
            }
            if (string4.length() == 0) {
                return new BaseImplResultSetClientSideEmpty();
            }
            if ((string4 = this.processRestrictionForColumnsEmulation(string4)) == null) {
                return null;
            }
        } else if (string4 != null && string4.length() != 0) {
            return new BaseImplResultSetClientSideEmpty();
        }
        if ((string = (String)baseResultSetFilterDescriptor.getRestriction(3)) == null) {
            return null;
        }
        if (string.length() == 0) {
            return new BaseImplResultSetClientSideEmpty();
        }
        if ((string = this.processRestrictionForColumnsEmulation(string)) == null) {
            return null;
        }
        String string5 = (String)baseResultSetFilterDescriptor.getRestriction(4);
        if (string5 != null && !string5.trim().equalsIgnoreCase("%")) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT * FROM ");
        if (n2 == 1) {
            stringBuffer.append(this.identifierQuoteString + string3 + this.identifierQuoteString + this.catalogSeparator);
        }
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append(this.identifierQuoteString + string4 + this.identifierQuoteString + ".");
        }
        stringBuffer.append(this.identifierQuoteString + string + this.identifierQuoteString);
        if (n2 == 2) {
            stringBuffer.append(this.catalogSeparator + this.identifierQuoteString + string3 + this.identifierQuoteString);
        }
        stringBuffer.append(" WHERE 0=1");
        BaseStatement baseStatement = new BaseStatement(this.connection, 1003, 1007);
        ResultSetMetaData resultSetMetaData = null;
        try {
            String string6 = stringBuffer.toString();
            ResultSet resultSet = baseStatement.executeQuery(string6);
            resultSetMetaData = resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            return new BaseImplResultSetClientSideEmpty();
        }
        if (resultSetMetaData == null) {
            return new BaseImplResultSetClientSideEmpty();
        }
        baseResultSetFilterDescriptor.removeAllRestrictions();
        baseResultSetSortDescriptor.setSatisfied();
        return new BaseColumnsImplResultSet(resultSetMetaData, string3, string4, string);
    }

    protected BaseTableTypes getTableTypes() {
        return null;
    }

    protected boolean stripDoubleQuotesFromValues() {
        return true;
    }

    protected String getUserName() throws SQLException {
        return this.connection.connectProps.get("user");
    }

    protected String getClientInfoPropertiesDescription(String string) throws SQLException {
        return "Stored local to driver";
    }
}

