/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.xml.aspects.sql;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.transformation.MappingClassColumn;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelEntity;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.xml.aspects.sql.AbstractXmlDocumentEntitySqlAspect;
import com.metamatrix.modeler.xml.ModelerXmlPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class XmlElementSqlAspect
extends AbstractXmlDocumentEntitySqlAspect
implements SqlColumnAspect {
    static final boolean SELECTABLE = true;
    static final boolean UPDATABLE = false;
    static final boolean AUTO_INCREMENT = false;
    static final boolean CASE_SENSITIVE = false;
    static final boolean SIGNED = false;
    static final boolean CURRENCY = false;
    static final boolean FIXED_LENGTH = false;
    static final boolean TRANSFORMATION_INPUT_PARAMETER = false;
    static final int SEARCH_TYPE = 0;
    static final Object DEFAULT_VALUE = null;
    static final Object MIN_VALUE = null;
    static final Object MAX_VALUE = null;
    static final int LENGTH = 0;
    static final int SCALE = 0;
    static final int NULL_TYPE = 1;
    static final String FORMAT = null;
    static final int PRECISION = 0;
    static final int CHAR_OCTET_LENGTH = 0;
    static final int POSITION = 0;
    static final int RADIX = 0;
    static final int NULL_VALUES = 0;
    static final int DISTINCT_VALUES = 0;
    Map elementMap = null;
    private Set elementFullNames = null;

    public XmlElementSqlAspect(MetamodelEntity entity) {
        super(entity);
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'G';
    }

    public String getName(EObject eObject) {
        ArgCheck.isInstanceOf(XmlElement.class, (Object)eObject);
        Path path = new Path(this.getShortName(eObject));
        EObject parent = eObject.eContainer();
        SqlAspect parentAspect = AspectManager.getSqlAspect((EObject)parent);
        while (parentAspect != null && !(parent instanceof XmlDocument)) {
            if (parentAspect instanceof SqlColumnAspect) {
                String name = null;
                name = parentAspect instanceof AbstractXmlDocumentEntitySqlAspect ? ((AbstractXmlDocumentEntitySqlAspect)parentAspect).getShortName(parent) : parentAspect.getName(parent);
                path = new Path("").append(name).append((IPath)path);
            } else if (parentAspect instanceof SqlTableAspect) break;
            parent = parent.eContainer();
            parentAspect = AspectManager.getSqlAspect((EObject)parent);
        }
        return path.toString().replace('/', '.');
    }

    protected String getShortName(EObject eObject) {
        ArgCheck.isInstanceOf(XmlElement.class, (Object)eObject);
        return ((XmlElement)eObject).getName();
    }

    protected String getParentFullName(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent != null) {
            SqlAspect parentAspect = AspectManager.getSqlAspect((EObject)parent);
            while (parentAspect != null) {
                if (parentAspect instanceof SqlTableAspect) {
                    return parentAspect.getFullName(parent);
                }
                if ((parent = parent.eContainer()) != null) {
                    parentAspect = AspectManager.getSqlAspect((EObject)parent);
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public int getCharOctetLength(EObject eObject) {
        return 0;
    }

    public EObject getDatatype(EObject eObject) {
        Object lookupObj;
        ArgCheck.isInstanceOf(XmlElement.class, (Object)eObject);
        XmlElement xmlElement = (XmlElement)eObject;
        if (this.elementMap == null) {
            this.populateMappingInfo((EObject)xmlElement);
        }
        if ((lookupObj = this.elementMap.get(xmlElement)) == null && this.elementFullNames.contains(this.getFullName((EObject)xmlElement))) {
            this.populateMappingInfo((EObject)xmlElement);
            lookupObj = this.elementMap.get(xmlElement);
        }
        Container cntr = ModelerCore.getContainer((EObject)eObject);
        if (lookupObj != null) {
            Assertion.isInstanceOf(lookupObj, MappingClassColumn.class, null);
            MappingClassColumn mappingColumn = (MappingClassColumn)lookupObj;
            EObject type = mappingColumn.getType();
            return this.resolveWhenProxy(type, (ResourceSet)cntr);
        }
        try {
            XSDTypeDefinition type;
            XSDComponent xsdComp = xmlElement.getXsdComponent();
            if (xsdComp instanceof XSDElementDeclaration && (type = ((XSDElementDeclaration)xsdComp).getTypeDefinition()) != null) {
                return this.resolveWhenProxy((EObject)type, (ResourceSet)cntr);
            }
            return ModelerCore.getDatatypeManager((EObject)eObject).getBuiltInDatatype("string");
        }
        catch (Throwable e) {
            return null;
        }
    }

    private EObject resolveWhenProxy(EObject e, ResourceSet resolveContext) {
        EObject resolvedEObject = e;
        if (e != null && e.eIsProxy() && (resolvedEObject = EcoreUtil.resolve((EObject)e, (ResourceSet)resolveContext)).eIsProxy()) {
            String msg = ModelerXmlPlugin.Util.getString("XmlElementSqlAspect.Unable_to_resolve_proxy_with_uri", (Object)((InternalEObject)e).eProxyURI());
            ModelerXmlPlugin.Util.log(4, msg);
        }
        return resolvedEObject;
    }

    public String getNativeType(EObject eObject) {
        return null;
    }

    public String getDatatypeName(EObject eObject) {
        EObject datatype = this.getDatatype(eObject);
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
        String dtName = dtMgr.getName(datatype);
        return dtName == null ? "string" : dtName;
    }

    public String getDatatypeObjectID(EObject eObject) {
        EObject datatype = this.getDatatype(eObject);
        try {
            if (datatype == null) {
                datatype = ModelerCore.getWorkspaceDatatypeManager().getBuiltInDatatype("string");
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
        String uuid = dtMgr.getUuidString(datatype);
        return uuid == null ? "" : uuid;
    }

    public Object getDefaultValue(EObject eObject) {
        return DEFAULT_VALUE;
    }

    public String getFormat(EObject eObject) {
        return FORMAT;
    }

    public int getLength(EObject eObject) {
        return 0;
    }

    public Object getMaxValue(EObject eObject) {
        return MAX_VALUE;
    }

    public Object getMinValue(EObject eObject) {
        return MIN_VALUE;
    }

    public int getNullType(EObject eObject) {
        return 1;
    }

    public int getPosition(EObject eObject) {
        return 0;
    }

    public int getPrecision(EObject eObject) {
        return 0;
    }

    public int getRadix(EObject eObject) {
        return 0;
    }

    public int getDistinctValues(EObject eObject) {
        return 0;
    }

    public int getNullValues(EObject eObject) {
        return 0;
    }

    public String getRuntimeType(EObject eObject) {
        String runtimeType = null;
        EObject datatype = this.getDatatype(eObject);
        if (datatype != null) {
            runtimeType = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true).getRuntimeTypeName(datatype);
        }
        if (runtimeType == null) {
            runtimeType = "string";
        }
        return runtimeType;
    }

    public int getScale(EObject eObject) {
        return 0;
    }

    public int getSearchType(EObject eObject) {
        return 0;
    }

    public boolean isAutoIncrementable(EObject eObject) {
        return false;
    }

    public boolean isCaseSensitive(EObject eObject) {
        return false;
    }

    public boolean isCurrency(EObject eObject) {
        return false;
    }

    public boolean isFixedLength(EObject eObject) {
        return false;
    }

    public boolean isSelectable(EObject eObject) {
        return true;
    }

    public boolean isSigned(EObject eObject) {
        return false;
    }

    public boolean isTranformationInputParameter(EObject eObject) {
        EmfResource emfResource;
        ModelContents contents;
        ArgCheck.isInstanceOf(XmlElement.class, (Object)eObject);
        XmlElement element = (XmlElement)eObject;
        if (element instanceof XmlRoot) {
            return false;
        }
        XmlDocument doc = this.getDocParent(element);
        XmlElement parent = this.getElementParent(element);
        if (doc == null || parent == null) {
            return false;
        }
        Resource eResource = element.eResource();
        if (eResource instanceof EmfResource && (contents = (emfResource = (EmfResource)eResource).getModelContents()) != null) {
            for (TreeMappingRoot tmr : contents.getTransformations((EObject)doc)) {
                if (!tmr.getOutputs().contains((Object)parent)) continue;
                for (Mapping mapping : tmr.getNested()) {
                    if (!mapping.getOutputs().contains((Object)element)) continue;
                    if (mapping.getInputs().size() == 0) {
                        return false;
                    }
                    for (MappingClassColumn column : mapping.getInputs()) {
                        SqlAspect aspect = AspectManager.getSqlAspect((EObject)column);
                        if (!(aspect instanceof SqlColumnAspect)) {
                            return false;
                        }
                        if (((SqlColumnAspect)aspect).isTranformationInputParameter((EObject)column)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private XmlDocument getDocParent(XmlElement child) {
        if (child == null) {
            return null;
        }
        for (EObject parent = child.eContainer(); parent != null; parent = parent.eContainer()) {
            if (!(parent instanceof XmlDocument)) continue;
            return (XmlDocument)parent;
        }
        return null;
    }

    private XmlElement getElementParent(XmlElement child) {
        if (child == null) {
            return null;
        }
        for (EObject parent = child.eContainer(); parent != null; parent = parent.eContainer()) {
            if (!(parent instanceof XmlElement)) continue;
            return (XmlElement)parent;
        }
        return null;
    }

    public boolean isUpdatable(EObject eObject) {
        return false;
    }

    public boolean canSetDatatype() {
        return false;
    }

    public void setDatatype(EObject eObject, EObject datatype) {
        throw new UnsupportedOperationException(ModelerXmlPlugin.Util.getString("XmlElementSqlAspect.Datatype_cannot_be_set_on_an_XMLElement_1"));
    }

    public boolean canSetLength() {
        return false;
    }

    public void setLength(EObject eObject, int length) {
        throw new UnsupportedOperationException(ModelerXmlPlugin.Util.getString("XmlElementSqlAspect.Length_cannot_be_set_on_an_XMLElement_2"));
    }

    public boolean canSetNullType() {
        return false;
    }

    public void setNullType(EObject eObject, int nullType) {
        throw new UnsupportedOperationException(ModelerXmlPlugin.Util.getString("XmlElementSqlAspect.NullType_cannot_be_set_on_an_XMLElement_3"));
    }

    Map getMappingInfo(EObject xmlEntity) {
        if (this.elementMap != null) {
            return this.elementMap;
        }
        this.populateMappingInfo(xmlEntity);
        return this.elementMap;
    }

    private void populateMappingInfo(EObject xmlEntity) {
        Resource resource = xmlEntity.eResource();
        ModelContents mdlContents = new ModelContents(resource);
        XmlDocument document = this.getXmlDocument(xmlEntity);
        this.elementMap = new HashMap();
        this.elementFullNames = new HashSet();
        for (MappingRoot mappingRoot : mdlContents.getTransformations((EObject)document)) {
            if (mappingRoot == null || !(mappingRoot instanceof TreeMappingRoot)) continue;
            for (Mapping nestedMapping : mappingRoot.getNested()) {
                EList inputs = nestedMapping.getInputs();
                EList outputs = nestedMapping.getOutputs();
                if (outputs.isEmpty() || inputs.isEmpty()) continue;
                Object output = outputs.iterator().next();
                Object input = inputs.iterator().next();
                this.elementMap.put(output, input);
                if (!(output instanceof XmlElement)) continue;
                this.elementFullNames.add(this.getFullName((EObject)output));
            }
        }
    }

    private XmlDocument getXmlDocument(EObject xmlElement) {
        EObject document = null;
        for (EObject container = xmlElement.eContainer(); container != null; container = container.eContainer()) {
            document = container;
        }
        Assertion.isInstanceOf((Object)document, XmlDocument.class, null);
        return (XmlDocument)document;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public boolean isDatatypeFeature(EObject eObject, EStructuralFeature eFeature) {
        return false;
    }
}

