/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilJDKVersionChecker;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class UtilTempFile {
    private static String footprint = "$Revision:   3.3.1.0  $";

    public static File createTempFile(String string) throws IOException {
        File file = null;
        try {
            file = UtilJDKVersionChecker.isJava2() ? UtilTempFile.createTempFileJava2(string) : UtilTempFile.createTempFilePreJava2(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
        return file;
    }

    private static File createTempFileJava2(String string) throws IOException {
        final String string2 = string;
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return File.createTempFile(string2, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private static File createTempFilePreJava2(String string) throws IOException {
        File file = null;
        int n = 0;
        while ((file = new File(string + Integer.toString(n++))).exists()) {
        }
        return file;
    }
}

