/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.plantree;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class NodeEditor {
    private NodeEditor() {
    }

    public static final void attachFirst(PlanNode parent, PlanNode child) {
        Assertion.isNotNull((Object)parent);
        if (child != null) {
            parent.addFirstChild(child);
            child.setParent(parent);
        }
    }

    public static final void attachLast(PlanNode parent, PlanNode child) {
        Assertion.isNotNull((Object)parent);
        if (child != null) {
            parent.addLastChild(child);
            child.setParent(parent);
        }
    }

    public static final PlanNode cutFirst(PlanNode node) {
        Assertion.isNotNull((Object)node);
        if (node.getChildCount() == 0) {
            return null;
        }
        PlanNode temp = node.getFirstChild();
        Assertion.isNotNull((Object)temp);
        node.removeChild(temp);
        temp.setParent(null);
        return temp;
    }

    public static final PlanNode cutLast(PlanNode node) {
        Assertion.isNotNull((Object)node);
        if (node.getChildCount() == 0) {
            return null;
        }
        PlanNode temp = node.getLastChild();
        Assertion.isNotNull((Object)temp);
        node.removeChild(temp);
        temp.setParent(null);
        return temp;
    }

    public static final void insertNode(PlanNode parent, PlanNode child, PlanNode insert) {
        Assertion.isNotNull((Object)parent);
        Assertion.isNotNull((Object)child);
        Assertion.isNotNull((Object)insert);
        List children = parent.getChildren();
        int index = children.indexOf(child);
        Assertion.isNonNegative((int)index);
        children.set(index, insert);
        insert.setParent(parent);
        child.setParent(insert);
        insert.addLastChild(child);
    }

    public static final void removeChildNode(PlanNode parent, PlanNode child) {
        Assertion.isNotNull((Object)parent);
        Assertion.isNotNull((Object)child);
        LinkedList newChildren = new LinkedList(parent.getChildren());
        List orphans = child.getChildren();
        ListIterator<PlanNode> childIter = newChildren.listIterator();
        while (childIter.hasNext()) {
            PlanNode possibleChild = (PlanNode)childIter.next();
            if (possibleChild != child) continue;
            childIter.remove();
            for (PlanNode orphan : orphans) {
                childIter.add(orphan);
            }
        }
        for (PlanNode removeNode : new LinkedList(parent.getChildren())) {
            parent.removeChild(removeNode);
        }
        parent.addChildren(newChildren);
        for (PlanNode newChild : newChildren) {
            newChild.setParent(parent);
        }
        Iterator removeIter = new LinkedList(child.getChildren()).iterator();
        while (removeIter.hasNext()) {
            child.removeChild((PlanNode)removeIter.next());
        }
    }

    public static final PlanNode findNodePreOrder(PlanNode root, int type) {
        return NodeEditor.findNodePreOrder(root, type, 2);
    }

    public static final PlanNode findNodePreOrder(PlanNode root, int type, int stopTypes) {
        if (root.getType() == type) {
            return root;
        }
        if (stopTypes % root.getType() == 0) {
            return null;
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            for (PlanNode child : children) {
                PlanNode found = NodeEditor.findNodePreOrder(child, type, stopTypes);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static final List findAllNodes(PlanNode root, int type) {
        Assertion.isNotNull((Object)root);
        LinkedList nodes = new LinkedList();
        NodeEditor.findAllNodesHelper(root, type, nodes, 2);
        return nodes;
    }

    public static final List findAllNodes(PlanNode root, int type, int stopType) {
        Assertion.isNotNull((Object)root);
        LinkedList nodes = new LinkedList();
        NodeEditor.findAllNodesHelper(root, type, nodes, stopType);
        return nodes;
    }

    private static final void findAllNodesHelper(PlanNode node, int type, List foundNodes, int stopType) {
        if (node.getType() == type) {
            foundNodes.add(node);
        }
        if (node.getChildCount() > 0 && (stopType == 2 || stopType % node.getType() != 0)) {
            List children = node.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                NodeEditor.findAllNodesHelper((PlanNode)iter.next(), type, foundNodes, stopType);
            }
        }
    }

    public static final void replaceNode(PlanNode originalNode, PlanNode replacementNode) {
        Assertion.isNotNull((Object)originalNode);
        Assertion.isNotNull((Object)replacementNode);
        PlanNode parent = originalNode.getParent();
        LinkedList children = new LinkedList(parent.getChildren());
        for (PlanNode child : children) {
            parent.removeChild(child);
        }
        for (PlanNode child : children) {
            if (child == originalNode) {
                parent.addLastChild(replacementNode);
                continue;
            }
            parent.addLastChild(child);
        }
        Iterator orphanIter = originalNode.getChildren().iterator();
        while (orphanIter.hasNext()) {
            NodeEditor.attachLast(replacementNode, (PlanNode)orphanIter.next());
        }
    }

    public static final void replaceNode(PlanNode originalNode, List replacementNodes) {
        Assertion.isNotNull((Object)originalNode);
        Assertion.isNotNull((Object)replacementNodes);
        Assertion.isPositive((int)replacementNodes.size());
        PlanNode parent = originalNode.getParent();
        LinkedList children = new LinkedList(originalNode.getChildren());
        while (originalNode.getChildren().size() > 0) {
            NodeEditor.cutLast(originalNode);
        }
        NodeEditor.removeChildNode(parent, originalNode);
        PlanNode top = parent;
        for (PlanNode bottom : replacementNodes) {
            NodeEditor.attachLast(top, bottom);
            top = bottom;
        }
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            NodeEditor.attachLast(top, (PlanNode)childIter.next());
        }
    }

    public static final PlanNode getSibling(PlanNode node) {
        Assertion.isNotNull((Object)node);
        PlanNode parentNode = node.getParent();
        Assertion.isNotNull((Object)parentNode);
        if (parentNode.getChildCount() >= 3) {
            Assertion.assertTrue((parentNode.getChildCount() < 3 ? 1 : 0) != 0, (String)QueryExecPlugin.Util.getString("ERR.015.004.0057"));
        }
        if (parentNode.getChildCount() == 1) {
            return null;
        }
        PlanNode siblingNode = parentNode.getLastChild();
        if (siblingNode == node) {
            siblingNode = parentNode.getFirstChild();
        }
        return siblingNode;
    }
}

