/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.internal.core.xml.XPathHelper;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionForm;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.resolver.util.ResolverVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.trans.XPathException;

public class ResolverVisitorUtil {
    static void resolveBetweenCriteria(BetweenCriteria criteria) throws QueryResolverException, MetaMatrixComponentException {
        Expression exp = criteria.getExpression();
        Expression lower = criteria.getLowerExpression();
        Expression upper = criteria.getUpperExpression();
        ResolverUtil.setTypeIfReference(exp, lower.getType() == null ? upper.getType() : lower.getType());
        ResolverUtil.setTypeIfReference(lower, exp.getType());
        ResolverUtil.setTypeIfReference(upper, exp.getType());
        String expTypeName = DataTypeManager.getDataTypeName((Class)exp.getType());
        String lowerTypeName = DataTypeManager.getDataTypeName((Class)lower.getType());
        String upperTypeName = DataTypeManager.getDataTypeName((Class)upper.getType());
        if (exp.getType().equals(lower.getType()) && exp.getType().equals(upper.getType())) {
            return;
        }
        String commonType = ResolverUtil.getCommonType(new String[]{expTypeName, lowerTypeName, upperTypeName});
        if (commonType == null) {
            throw new QueryResolverException("ERR.015.008.0027", QueryPlugin.Util.getString("ERR.015.008.0027", (Object)expTypeName, (Object)lowerTypeName, (Object)criteria));
        }
        criteria.setExpression(ResolverUtil.convertExpression(exp, expTypeName, commonType));
        criteria.setLowerExpression(ResolverUtil.convertExpression(lower, lowerTypeName, commonType));
        criteria.setUpperExpression(ResolverUtil.convertExpression(upper, upperTypeName, commonType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void resolveCompareCriteria(CompareCriteria ccrit) throws QueryResolverException, MetaMatrixComponentException {
        Expression leftExpression = ccrit.getLeftExpression();
        Expression rightExpression = ccrit.getRightExpression();
        boolean leftIsAggregate = leftExpression instanceof AggregateSymbol;
        boolean rightIsAggregate = rightExpression instanceof AggregateSymbol;
        ResolverUtil.setTypeIfReference(leftExpression, rightExpression.getType());
        ResolverUtil.setTypeIfReference(rightExpression, leftExpression.getType());
        if (leftExpression.getType().equals(rightExpression.getType())) return;
        boolean converted = false;
        String leftTypeName = DataTypeManager.getDataTypeName((Class)leftExpression.getType());
        String rightTypeName = DataTypeManager.getDataTypeName((Class)rightExpression.getType());
        if (rightExpression instanceof Constant) {
            try {
                ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName));
                return;
            }
            catch (QueryResolverException qre) {
                // empty catch block
            }
        }
        if (!converted && leftExpression instanceof Constant) {
            try {
                ccrit.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, rightTypeName));
                return;
            }
            catch (QueryResolverException qre) {
                // empty catch block
            }
        }
        if (!converted) {
            if (!leftIsAggregate && ResolverUtil.canImplicitlyConvert(leftTypeName, rightTypeName)) {
                ccrit.setLeftExpression(ResolverUtil.convertExpression(leftExpression, leftTypeName, rightTypeName));
                return;
            }
            if (!converted && !rightIsAggregate && ResolverUtil.canImplicitlyConvert(rightTypeName, leftTypeName)) {
                ccrit.setRightExpression(ResolverUtil.convertExpression(rightExpression, rightTypeName, leftTypeName));
                return;
            }
        }
        if (converted) return;
        if (rightIsAggregate) {
            if (leftIsAggregate) {
                throw new QueryResolverException("ERR.015.008.0064", QueryPlugin.Util.getString("ERR.015.008.0064"));
            }
            AggregateSymbol aggRight = (AggregateSymbol)rightExpression;
            String aggFunc = aggRight.getAggregateFunction();
            if (!aggFunc.equals("MIN")) {
                if (!aggFunc.equals("MAX")) throw new QueryResolverException("ERR.015.008.0028", QueryPlugin.Util.getString("ERR.015.008.0028"));
            }
            if (!ResolverUtil.canImplicitlyConvert(rightTypeName, leftTypeName)) throw new QueryResolverException("ERR.015.008.0028", QueryPlugin.Util.getString("ERR.015.008.0028"));
            aggRight.setExpression(ResolverUtil.convertExpression(aggRight.getExpression(), rightTypeName, leftTypeName));
            return;
        } else {
            if (!leftIsAggregate) throw new QueryResolverException("ERR.015.008.0027", QueryPlugin.Util.getString("ERR.015.008.0027", new Object[]{leftTypeName, rightTypeName, ccrit}));
            AggregateSymbol aggLeft = (AggregateSymbol)leftExpression;
            String aggFunc = aggLeft.getAggregateFunction();
            if (!aggFunc.equals("MIN")) {
                if (!aggFunc.equals("MAX")) throw new QueryResolverException("ERR.015.008.0028", QueryPlugin.Util.getString("ERR.015.008.0028"));
            }
            if (!ResolverUtil.canImplicitlyConvert(leftTypeName, rightTypeName)) throw new QueryResolverException("ERR.015.008.0028", QueryPlugin.Util.getString("ERR.015.008.0028"));
            aggLeft.setExpression(ResolverUtil.convertExpression(aggLeft.getExpression(), leftTypeName, rightTypeName));
        }
    }

    static void resolveMatchCriteria(MatchCriteria mcrit) throws QueryResolverException, MetaMatrixComponentException {
        ResolverUtil.setTypeIfReference(mcrit.getLeftExpression(), mcrit.getRightExpression().getType());
        mcrit.setLeftExpression(ResolverVisitorUtil.resolveMatchCriteriaExpression(mcrit, mcrit.getLeftExpression()));
        ResolverUtil.setTypeIfReference(mcrit.getRightExpression(), mcrit.getLeftExpression().getType());
        mcrit.setRightExpression(ResolverVisitorUtil.resolveMatchCriteriaExpression(mcrit, mcrit.getRightExpression()));
    }

    static Expression resolveMatchCriteriaExpression(MatchCriteria mcrit, Expression expr) throws QueryResolverException {
        String type = DataTypeManager.getDataTypeName((Class)expr.getType());
        Expression result = expr;
        if (type != null && !type.equals("string") && !type.equals("clob")) {
            if (!(expr instanceof AggregateSymbol) && ResolverUtil.canImplicitlyConvert(type, "string")) {
                result = ResolverUtil.convertExpression(expr, type, "string");
            } else if (!(expr instanceof AggregateSymbol) && ResolverUtil.canImplicitlyConvert(type, "clob")) {
                result = ResolverUtil.convertExpression(expr, type, "clob");
            } else {
                throw new QueryResolverException("ERR.015.008.0029", QueryPlugin.Util.getString("ERR.015.008.0029", (Object)mcrit));
            }
        }
        return result;
    }

    static void resolveSetCriteria(SetCriteria scrit) throws QueryResolverException, MetaMatrixComponentException {
        Class exprType = scrit.getExpression().getType();
        if (exprType == null) {
            throw new QueryResolverException("ERR.015.008.0030", QueryPlugin.Util.getString("ERR.015.008.0030", (Object)scrit.getExpression()));
        }
        String exprTypeName = DataTypeManager.getDataTypeName((Class)exprType);
        boolean changed = false;
        ArrayList<Expression> newVals = new ArrayList<Expression>();
        boolean convertLeft = false;
        Class setType = null;
        for (Expression value : scrit.getValues()) {
            ResolverUtil.setTypeIfReference(value, exprType);
            if (!value.getType().equals(exprType)) {
                if (value instanceof AggregateSymbol) {
                    throw new QueryResolverException("ERR.015.008.0031", QueryPlugin.Util.getString("ERR.015.008.0031", (Object)scrit));
                }
                String valTypeName = DataTypeManager.getDataTypeName((Class)value.getType());
                if (ResolverUtil.canImplicitlyConvert(valTypeName, exprTypeName)) {
                    newVals.add(ResolverUtil.convertExpression(value, valTypeName, exprTypeName));
                    changed = true;
                    continue;
                }
                convertLeft = true;
                setType = value.getType();
                break;
            }
            newVals.add(value);
        }
        if (convertLeft) {
            String setTypeName = DataTypeManager.getDataTypeName(setType);
            if (ResolverUtil.canImplicitlyConvert(exprTypeName, setTypeName)) {
                for (Expression value : scrit.getValues()) {
                    if (value.getType() == null) {
                        throw new QueryResolverException("ERR.015.008.0030", QueryPlugin.Util.getString("ERR.015.008.0030", (Object)value));
                    }
                    if (value.getType().equals(setType)) continue;
                    throw new QueryResolverException("ERR.015.008.0031", QueryPlugin.Util.getString("ERR.015.008.0031", (Object)scrit));
                }
                scrit.setExpression(ResolverUtil.convertExpression(scrit.getExpression(), exprTypeName, setTypeName));
            } else {
                throw new QueryResolverException("ERR.015.008.0031", QueryPlugin.Util.getString("ERR.015.008.0031", (Object)scrit));
            }
        }
        if (changed) {
            scrit.setValues(newVals);
        }
    }

    static Expression resolveSubqueryPredicateCriteria(Expression expression, SubqueryContainer crit) throws QueryResolverException, MetaMatrixComponentException {
        Class exprType = expression.getType();
        if (exprType == null) {
            throw new QueryResolverException("ERR.015.008.0030", QueryPlugin.Util.getString("ERR.015.008.0030", (Object)expression));
        }
        String exprTypeName = DataTypeManager.getDataTypeName((Class)exprType);
        List projectedSymbols = crit.getCommand().getProjectedSymbols();
        if (projectedSymbols.size() != 1) {
            throw new QueryResolverException("ERR.015.008.0032", QueryPlugin.Util.getString("ERR.015.008.0032", (Object)crit.getCommand()));
        }
        Class subqueryType = ((Expression)projectedSymbols.iterator().next()).getType();
        String subqueryTypeName = DataTypeManager.getDataTypeName((Class)subqueryType);
        Expression result = null;
        try {
            result = ResolverUtil.convertExpression(expression, exprTypeName, subqueryTypeName);
        }
        catch (QueryResolverException qre) {
            throw new QueryResolverException((Throwable)qre, "ERR.015.008.0033", QueryPlugin.Util.getString("ERR.015.008.0033", (Object)crit));
        }
        return result;
    }

    static void resolveIsNullCriteria(IsNullCriteria crit) throws QueryResolverException, MetaMatrixComponentException {
        ResolverUtil.setTypeIfReference(crit.getExpression(), DataTypeManager.DefaultDataClasses.OBJECT);
    }

    static void resolveCaseExpression(CaseExpression obj) throws QueryResolverException {
        String whenTypeName;
        if (obj.getType() != null) {
            return;
        }
        int whenCount = obj.getWhenCount();
        Expression expr = obj.getExpression();
        Class whenType = null;
        Class thenType = null;
        for (int i = 0; i < whenCount; ++i) {
            if (whenType == null) {
                whenType = obj.getWhenExpression(i).getType();
            }
            if (thenType != null) continue;
            thenType = obj.getThenExpression(i).getType();
        }
        Expression elseExpr = obj.getElseExpression();
        if (elseExpr != null && thenType == null) {
            thenType = elseExpr.getType();
        }
        ArrayList<String> whenTypeNames = new ArrayList<String>(whenCount + 1);
        ArrayList<String> thenTypeNames = new ArrayList<String>(whenCount + 1);
        ResolverUtil.setTypeIfReference(expr, whenType);
        whenTypeNames.add(DataTypeManager.getDataTypeName((Class)expr.getType()));
        Expression when = null;
        Expression then = null;
        for (int i = 0; i < whenCount; ++i) {
            when = obj.getWhenExpression(i);
            then = obj.getThenExpression(i);
            ResolverUtil.setTypeIfReference(when, expr.getType());
            ResolverUtil.setTypeIfReference(then, thenType);
            if (!whenTypeNames.contains(DataTypeManager.getDataTypeName((Class)when.getType()))) {
                whenTypeNames.add(DataTypeManager.getDataTypeName((Class)when.getType()));
            }
            if (thenTypeNames.contains(DataTypeManager.getDataTypeName((Class)then.getType()))) continue;
            thenTypeNames.add(DataTypeManager.getDataTypeName((Class)then.getType()));
        }
        if (elseExpr != null) {
            ResolverUtil.setTypeIfReference(elseExpr, thenType);
            if (!thenTypeNames.contains(DataTypeManager.getDataTypeName((Class)elseExpr.getType()))) {
                thenTypeNames.add(DataTypeManager.getDataTypeName((Class)elseExpr.getType()));
            }
        }
        if ((whenTypeName = ResolverUtil.getCommonType(whenTypeNames.toArray(new String[whenTypeNames.size()]))) == null) {
            throw new QueryResolverException("ERR.015.008.0068", QueryPlugin.Util.getString("ERR.015.008.0068", (Object)"WHEN", (Object)obj));
        }
        String thenTypeName = ResolverUtil.getCommonType(thenTypeNames.toArray(new String[thenTypeNames.size()]));
        if (thenTypeName == null) {
            throw new QueryResolverException("ERR.015.008.0068", QueryPlugin.Util.getString("ERR.015.008.0068", (Object)"THEN/ELSE", (Object)obj));
        }
        obj.setExpression(ResolverUtil.convertExpression(obj.getExpression(), whenTypeName));
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(ResolverUtil.convertExpression(obj.getWhenExpression(i), whenTypeName));
            thens.add(ResolverUtil.convertExpression(obj.getThenExpression(i), thenTypeName));
        }
        obj.setWhen(whens, thens);
        if (elseExpr != null) {
            obj.setElseExpression(ResolverUtil.convertExpression(elseExpr, thenTypeName));
        }
        obj.setType(DataTypeManager.getDataTypeClass((String)thenTypeName));
    }

    static void resolveSearchedCaseExpression(SearchedCaseExpression obj) throws QueryResolverException {
        String thenTypeName;
        if (obj.getType() != null) {
            return;
        }
        int whenCount = obj.getWhenCount();
        Class thenType = null;
        for (int i = 0; i < whenCount; ++i) {
            if (thenType != null) continue;
            thenType = obj.getThenExpression(i).getType();
        }
        Expression elseExpr = obj.getElseExpression();
        if (elseExpr != null && thenType == null) {
            thenType = elseExpr.getType();
        }
        ArrayList<String> thenTypeNames = new ArrayList<String>(whenCount + 1);
        Expression then = null;
        for (int i = 0; i < whenCount; ++i) {
            then = obj.getThenExpression(i);
            ResolverUtil.setTypeIfReference(then, thenType);
            if (thenTypeNames.contains(DataTypeManager.getDataTypeName((Class)then.getType()))) continue;
            thenTypeNames.add(DataTypeManager.getDataTypeName((Class)then.getType()));
        }
        if (elseExpr != null) {
            ResolverUtil.setTypeIfReference(elseExpr, thenType);
            if (!thenTypeNames.contains(DataTypeManager.getDataTypeName((Class)elseExpr.getType()))) {
                thenTypeNames.add(DataTypeManager.getDataTypeName((Class)elseExpr.getType()));
            }
        }
        if ((thenTypeName = ResolverUtil.getCommonType(thenTypeNames.toArray(new String[thenTypeNames.size()]))) == null) {
            throw new QueryResolverException("ERR.015.008.0068", QueryPlugin.Util.getString("ERR.015.008.0068", (Object)"THEN/ELSE", (Object)obj));
        }
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(ResolverUtil.convertExpression(obj.getThenExpression(i), thenTypeName));
        }
        obj.setWhen(obj.getWhen(), thens);
        if (elseExpr != null) {
            obj.setElseExpression(ResolverUtil.convertExpression(elseExpr, thenTypeName));
        }
        obj.setType(DataTypeManager.getDataTypeClass((String)thenTypeName));
    }

    public static void resolveFunction(Function function, QueryMetadataInterface metadata) throws QueryResolverException, MetaMatrixComponentException {
        Constant xpathConst;
        FunctionDescriptor fd;
        if (function.getFunctionDescriptor() != null) {
            return;
        }
        boolean hasArgWithoutType = false;
        Expression[] args = function.getArgs();
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i].getType();
            if (types[i] != null) continue;
            if (!(args[i] instanceof Reference)) {
                throw new QueryResolverException("ERR.015.008.0035", QueryPlugin.Util.getString("ERR.015.008.0035", new Object[]{args[i], function}));
            }
            hasArgWithoutType = true;
        }
        FunctionLibrary library = FunctionLibraryManager.getFunctionLibrary();
        if (FunctionLibrary.isConvert((Function)function) && hasArgWithoutType) {
            Constant constant = (Constant)function.getArg(1);
            Class type = DataTypeManager.getDataTypeClass((String)((String)constant.getValue()));
            ResolverUtil.setTypeIfReference(function.getArg(0), type);
            types[0] = type;
            hasArgWithoutType = false;
        }
        if ((fd = ResolverVisitorUtil.findWithImplicitConversions(library, function, args, types, hasArgWithoutType)) == null) {
            FunctionForm form = library.findFunctionForm(function.getName(), args.length);
            if (form == null) {
                throw new QueryResolverException("ERR.015.008.0039", QueryPlugin.Util.getString("ERR.015.008.0039", (Object)function));
            }
            if (hasArgWithoutType) {
                throw new QueryResolverException("ERR.015.008.0036", QueryPlugin.Util.getString("ERR.015.008.0036", (Object)function));
            }
            throw new QueryResolverException("ERR.015.008.0040", QueryPlugin.Util.getString("ERR.015.008.0040", (Object)function));
        }
        if (fd.getName().equalsIgnoreCase("convert") || fd.getName().equalsIgnoreCase("cast")) {
            String dataType = (String)((Constant)args[1]).getValue();
            Class dataTypeClass = DataTypeManager.getDataTypeClass((String)dataType);
            fd = library.findTypedConversionFunction(args[0].getType(), dataTypeClass);
            Class srcTypeClass = args[0].getType();
            if (srcTypeClass != null && dataTypeClass != null && !srcTypeClass.equals(dataTypeClass) && DataTypeManager.getTransform((Class)srcTypeClass, (Class)dataTypeClass) == null) {
                throw new QueryResolverException("ERR.015.008.0037", QueryPlugin.Util.getString("ERR.015.008.0037", new Object[]{DataTypeManager.getDataTypeName((Class)srcTypeClass), dataType}));
            }
        } else if (fd.getName().equalsIgnoreCase("lookup")) {
            ResolvedLookup lookup = ResolverVisitorUtil.resolveLookup(function, metadata);
            fd = library.copyFunctionChangeReturnType(fd, lookup.getReturnElement().getType());
        } else if (fd.getName().equalsIgnoreCase("xpathvalue") && args[1] != null && args[1] instanceof Constant && (xpathConst = (Constant)args[1]).getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            String value = (String)xpathConst.getValue();
            if (value == null) {
                throw new QueryResolverException(QueryPlugin.Util.getString("QueryResolver.invalid_xpath", (Object)QueryPlugin.Util.getString("ResolveFunctionsVisitor.xpath_cant_be_null")));
            }
            try {
                XPathHelper.validateXpath((String)value);
            }
            catch (XPathException e) {
                throw new QueryResolverException(QueryPlugin.Util.getString("QueryResolver.invalid_xpath", (Object)e.getMessage()));
            }
        }
        function.setFunctionDescriptor(fd);
        function.setType(fd.getReturnType());
    }

    public static ResolvedLookup resolveLookup(Function lookup, QueryMetadataInterface metadata) throws QueryResolverException, MetaMatrixComponentException {
        Expression[] args = lookup.getArgs();
        ResolvedLookup result = new ResolvedLookup();
        if (args[0] instanceof Constant && args[1] instanceof Constant && args[2] instanceof Constant) {
            GroupSymbol groupSym = new GroupSymbol((String)((Constant)args[0]).getValue());
            try {
                groupSym.setMetadataID(metadata.getGroupID((String)((Constant)args[0]).getValue()));
                if (metadata.isVirtualGroup(groupSym.getMetadataID())) {
                    throw new QueryResolverException("ERR.015.008.0065", QueryPlugin.Util.getString("ERR.015.008.0065", ((Constant)args[0]).getValue()));
                }
            }
            catch (QueryMetadataException e) {
                throw new QueryResolverException("ERR.015.008.0062", QueryPlugin.Util.getString("ERR.015.008.0062", ((Constant)args[0]).getValue()));
            }
            result.setGroup(groupSym);
            List<GroupSymbol> groups = Arrays.asList(groupSym);
            String returnElementName = (String)((Constant)args[0]).getValue() + "." + (String)((Constant)args[1]).getValue();
            ElementSymbol returnElement = new ElementSymbol(returnElementName);
            try {
                ResolverVisitor.resolveLanguageObject((LanguageObject)returnElement, groups, (QueryMetadataInterface)metadata);
            }
            catch (QueryResolverException e) {
                throw new QueryResolverException("ERR.015.008.0062", QueryPlugin.Util.getString("ERR.015.008.0062", (Object)returnElementName));
            }
            result.setReturnElement(returnElement);
            String keyElementName = (String)((Constant)args[0]).getValue() + "." + (String)((Constant)args[2]).getValue();
            ElementSymbol keyElement = new ElementSymbol(keyElementName);
            try {
                ResolverVisitor.resolveLanguageObject((LanguageObject)keyElement, groups, (QueryMetadataInterface)metadata);
            }
            catch (QueryResolverException e) {
                throw new QueryResolverException("ERR.015.008.0062", QueryPlugin.Util.getString("ERR.015.008.0062", (Object)keyElementName));
            }
            result.setKeyElement(keyElement);
            return result;
        }
        throw new QueryResolverException("ERR.015.008.0063", QueryPlugin.Util.getString("ERR.015.008.0063"));
    }

    static FunctionDescriptor findWithImplicitConversions(FunctionLibrary library, Function function, Expression[] args, Class[] types, boolean hasArgWithoutType) throws QueryResolverException {
        FunctionDescriptor[] conversions = library.determineNecessaryConversions(function.getName(), types, hasArgWithoutType);
        if (conversions == null) {
            return null;
        }
        Class[] newSignature = new Class[conversions.length];
        for (int i = 0; i < conversions.length; ++i) {
            Class newType = types[i];
            if (conversions[i] != null) {
                newType = conversions[i].getReturnType();
                ResolverUtil.setTypeIfReference(args[i], newType);
                if (types[i] != null) {
                    function.insertConversion(i, conversions[i]);
                }
            }
            newSignature[i] = newType;
        }
        return library.findFunction(function.getName(), newSignature);
    }

    public static class ResolvedLookup {
        private GroupSymbol group;
        private ElementSymbol keyElement;
        private ElementSymbol returnElement;

        void setGroup(GroupSymbol group) {
            this.group = group;
        }

        public GroupSymbol getGroup() {
            return this.group;
        }

        void setKeyElement(ElementSymbol keyElement) {
            this.keyElement = keyElement;
        }

        public ElementSymbol getKeyElement() {
            return this.keyElement;
        }

        void setReturnElement(ElementSymbol returnElement) {
            this.returnElement = returnElement;
        }

        public ElementSymbol getReturnElement() {
            return this.returnElement;
        }
    }
}

