/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSecurityContextCreator;
import com.metamatrix.util.UtilType4SecurityContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Random;
import java.util.TimeZone;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TTIANODataPacket
extends TTIDataPacket {
    private static String footprint = "$Revision:   3.7.1.0  $";
    BaseExceptions exceptions;
    public String servicePrincipalName = null;
    public byte[] clientSecurityToken;
    public byte[] serverSecurityToken;
    private byte[] adbeef = new byte[]{-83, -66, -17};
    private byte[] anoData = new byte[]{9, 9, 9, 9, 9, 9, 9, 9};
    private byte[] ai = new byte[]{0, 4, 0, 1, 0, 2, 0, 3};
    public int packetType = 0;
    public static final int PACKET_TYPE_ANO1 = 0;
    public static final int PACKET_TYPE_ANO2 = 1;
    public static final int PACKET_TYPE_ANO3 = 2;
    public static final int PACKET_TYPE_ANO4 = 3;
    private boolean useKerberosAuthentication = false;
    public int kerberosStep = 0;
    private Random rand = null;
    private int KERB_BUFF_SIZE = 2048;
    private byte[] kerberosRequestBuff = null;
    private byte[] ANO1 = new byte[]{-83, -66, -17, 0, -98, 10, 16, 2, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 16, 2, 0, 0, 8, 0, 1, 0, 0};
    private byte[] ANO1B = new byte[]{0, 18, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 4, 0, 4, 0, 1, 0, 1, 0, 2, 0, 1, 0, 5, 0, 0, 0, 0, 0, 4, 0, 5, 10, 16, 2, 0, 0, 2, 0, 3, -32, -31, 0, 2, 0, 6, -4, -1, 0, 1, 0, 2, 1, 0, 3, 0, 0, 78, 84, 83, 0, 2, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 16, 2, 0, 0, 12, 0, 1, 0, 17, 6, 16, 12, 15, 10, 11, 8, 2, 1, 3, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 16, 2, 0, 0, 3, 0, 1, 0, 3, 1};
    private byte[] ANO2 = new byte[]{-83, -66, -17, 0, 77, 9, 32, 1, 0, 0, 1, 0, 0, 1, 0, 5, 0, 0, 0, 0, 0, 4, 0, 5, 2, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 0, 20, 0, 1, 2, 0, 0, 0, 5, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 1, 0, 0, 0, 0};
    public byte[] ANO3Triplet = null;
    public byte[] ANO3Triplet2 = new byte[]{-111, 56, 56};
    public byte[] ANO3Triplet3 = new byte[]{-108, 59, 59};
    private byte[] ANO3 = new byte[]{-83, -66, -17, 0, -121, 10, 16, 2, 0, 0, 1, 0, 0, 1, 0, 7, 0, 0, 0, 0, 0, 4, 0, 5, 2, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 0, 20, 0, 1, 2, 0, 0, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 1, 0, 0, 0, 0, 0, 4, 0, 1, 46, 0, 0, 0, 0, 46, 0, 1};
    public byte[] ANO4Triplet = null;
    public byte[] ANO4Triplet2 = new byte[]{-59, -92, -92};
    public byte[] ANO4Triplet3 = new byte[]{-57, -90, -90};
    public byte[] ANO4Triplet4 = new byte[]{-53, -86, -86};
    private byte[] ANO4 = new byte[]{-83, -66, -17, 0, -69, 10, 16, 2, 0, 0, 1, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 4, 0, 1, -102, 0, 0, 0, 0, -102, 0, 1};
    private byte[] Oracle10GPacketData = new byte[]{-83, -66, -17, 0, -114, 8, 16, 80, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 8, 16, 80, 0, 0, 8, 0, 1, 9, 9, 9, 9, 9, 9, 9, 9, 0, 18, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 4, 0, 4, 0, 1, 0, 2, 0, 3, 0, 1, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 8, 16, 80, 0, 0, 2, 0, 3, -32, -31, 0, 2, 0, 6, -4, -1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 8, 16, 80, 0, 0, 9, 0, 1, 0, 1, 2, 3, 6, 8, 10, 11, 12, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 8, 16, 80, 0, 0, 2, 0, 1, 0, 1};

    public TTIANODataPacket(BaseExceptions baseExceptions) {
        this.TTCCode = 222;
        this.exceptions = baseExceptions;
        this.useKerberosAuthentication = false;
    }

    public void useKerberosAuthentication() {
        this.useKerberosAuthentication = true;
        this.kerberosRequestBuff = new byte[this.KERB_BUFF_SIZE * 2];
        this.rand = new Random();
    }

    int readLength(byte[] byArray, int n, int n2, int[] nArray) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = byArray[n] & 0xFF;
        if (n3 <= 127) {
            nArray[0] = n3;
            return 1;
        }
        if (n3 == 129) {
            if (n2 < 2) {
                return 0;
            }
            nArray[0] = byArray[n + 1] & 0xFF;
            return 2;
        }
        if (n3 == 130) {
            if (n2 < 3) {
                return 0;
            }
            nArray[0] = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
            return 3;
        }
        return 0;
    }

    int readCodeAndLength(byte[] byArray, int n, int n2, int[] nArray) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.readLength(byArray, n + 1, n2 - 1, nArray);
        if (n3 > 0) {
            ++n3;
        }
        return n3;
    }

    int readCodeAndLengthBytes(byte[] byArray, int n, int n2) {
        int[] nArray = new int[1];
        int n3 = this.readCodeAndLength(byArray, n, n2, nArray);
        if (n3 <= 0) {
            return 0;
        }
        if ((n2 -= n3) < nArray[0]) {
            return 0;
        }
        return n3 + nArray[0];
    }

    int readLengthBytes(byte[] byArray, int n, int n2) {
        int[] nArray = new int[1];
        int n3 = this.readLength(byArray, n, n2, nArray);
        if (n3 <= 0) {
            return 0;
        }
        if ((n2 -= n3) < nArray[0]) {
            return 0;
        }
        return n3 + nArray[0];
    }

    public byte[] MD5(byte[] byArray, int n, int n2) throws SQLException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray, n, n2);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.exceptions.getException(7046, stringArray);
        }
    }

    public byte[] DESencrypt(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) throws SQLException {
        Cipher cipher;
        Cipher cipher2;
        try {
            cipher2 = Cipher.getInstance("DES/CBC/NoPadding");
            cipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.exceptions.getException(7047, stringArray);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "DES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
        try {
            cipher2.init(1, (Key)secretKeySpec, ivParameterSpec);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.exceptions.getException(7047, stringArray);
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, n, byArray4, 0, n2);
        byte[] byArray5 = null;
        try {
            byArray5 = cipher2.doFinal(byArray4);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.exceptions.getException(7047, stringArray);
        }
        return byArray5;
    }

    int putGSSCodeLength(byte[] byArray, int n, int n2, byte by) {
        n += this.KERB_BUFF_SIZE - n2;
        if (n2 <= 255) {
            byArray[--n] = (byte)n2;
            if (n2 > 127) {
                byArray[--n] = -127;
                n2 += 3;
            } else {
                n2 += 2;
            }
        } else {
            byArray[--n] = (byte)n2;
            byArray[--n] = (byte)(n2 >> 8);
            byArray[--n] = -126;
            n2 += 4;
        }
        byArray[--n] = by;
        return n2;
    }

    int putGSSCodeLength(byte[] byArray, int n, int n2, byte by, byte[] byArray2, int n3) {
        int n4 = n2 + n3;
        System.arraycopy(byArray2, 0, byArray, n + this.KERB_BUFF_SIZE - n4, n3);
        return this.putGSSCodeLength(byArray, n, n4, by);
    }

    void convert2(byte[] byArray, int n, int n2) {
        if (n2 >= 100) {
            byArray[1] = 42;
            byArray[n] = 42;
            return;
        }
        if (n2 >= 10) {
            byArray[n] = (byte)(n2 / 10 + 48);
            byArray[n + 1] = (byte)(n2 % 10 + 48);
            return;
        }
        byArray[n] = 48;
        byArray[n + 1] = (byte)(n2 + 48);
    }

    void convert4(byte[] byArray, int n, int n2) {
        if (n2 >= 10000) {
            byArray[3] = 42;
            byArray[2] = 42;
            byArray[1] = 42;
            byArray[n] = 42;
            return;
        }
        if (n2 >= 1000) {
            byArray[n + 3] = (byte)(n2 % 10 + 48);
            byArray[n + 2] = (byte)((n2 /= 10) % 10 + 48);
            byArray[n + 1] = (byte)((n2 /= 10) % 10 + 48);
            byArray[n] = (byte)(n2 / 10 + 48);
            return;
        }
        if (n2 >= 100) {
            byArray[n] = 48;
            byArray[n + 3] = (byte)(n2 % 10 + 48);
            byArray[n + 2] = (byte)((n2 /= 10) % 10 + 48);
            byArray[n + 1] = (byte)(n2 / 10 + 48);
            return;
        }
        if (n2 >= 10) {
            byArray[n] = 48;
            byArray[n + 1] = 48;
            byArray[n + 3] = (byte)(n2 % 10 + 48);
            byArray[n + 2] = (byte)(n2 / 10 + 48);
            return;
        }
        byArray[n] = 48;
        byArray[n + 1] = 48;
        byArray[n + 2] = 48;
        byArray[n + 3] = (byte)n2;
    }

    int writeTime(long l, byte[] byArray, int n, int n2) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(l);
        this.convert4(byArray, n + n2, calendar.get(1));
        this.convert2(byArray, n + (n2 += 4), calendar.get(2) + 1);
        this.convert2(byArray, n + (n2 += 2), calendar.get(5));
        n2 += 2;
        int n3 = calendar.get(10);
        if (calendar.get(9) == 1) {
            n3 += 12;
        }
        this.convert2(byArray, n + n2, n3);
        this.convert2(byArray, n + (n2 += 2), calendar.get(12));
        this.convert2(byArray, n + (n2 += 2), calendar.get(13));
        byArray[n + (n2 += 2)] = 90;
        return ++n2;
    }

    int putTime(byte[] byArray, int n, byte by, long l) {
        int n2 = this.writeTime(l, byArray, n + this.KERB_BUFF_SIZE - 15, 0);
        n2 = this.putGSSCodeLength(byArray, n, n2, (byte)24);
        return this.putGSSCodeLength(byArray, n, n2, by);
    }

    private void memSet(byte[] byArray, int n, byte by, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[n + i] = by;
        }
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException, SQLException {
        if (this.useKerberosAuthentication) {
            switch (this.kerberosStep) {
                case 1: {
                    byte[] byArray = new byte[]{-83, -66, -17, 0, -92, 10, 32, 1, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 8, 0, 1, 0, 0};
                    oracleDataConsumer.writeBytes(byArray, 0, byArray.length);
                    byte[] byArray2 = new byte[6];
                    this.rand.nextBytes(byArray2);
                    oracleDataConsumer.writeBytes(byArray2, 0, byArray2.length);
                    byte[] byArray3 = new byte[]{0, 18, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 4, 0, 4, 0, 1, 0, 1, 0, 2, 0, 1, 0, 5, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 2, 0, 3, -32, -31, 0, 2, 0, 6, -4, -1, 0, 1, 0, 2, 1, 0, 9, 0, 0, 75, 69, 82, 66, 69, 82, 79, 83, 53, 0, 2, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 12, 0, 1, 0, 17, 6, 16, 12, 15, 10, 11, 8, 2, 1, 3, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 3, 0, 1, 0, 3, 1};
                    oracleDataConsumer.writeBytes(byArray3, 0, byArray3.length);
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[]{-83, -66, -17, 0, 50, 10, 32, 1, 0, 0, 1, 0, 0, 1, 0, 4, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 1, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 2, 0, 1, 0, 2, 0};
                    oracleDataConsumer.writeBytes(byArray, 0, byArray.length);
                    break;
                }
                case 3: {
                    int n;
                    UtilType4SecurityContext utilType4SecurityContext = UtilSecurityContextCreator.createType4SecurityContext((String)this.servicePrincipalName);
                    byte[] byArray = utilType4SecurityContext.getSecurityToken(null);
                    if (byArray == null) {
                        String[] stringArray = new String[]{"encoded ticket"};
                        throw this.exceptions.getException(7045, stringArray);
                    }
                    byte[] byArray4 = utilType4SecurityContext.getSessionKeyForSecurityToken();
                    if (byArray4 == null) {
                        String[] stringArray = new String[]{"session key for encoded ticket"};
                        throw this.exceptions.getException(7045, stringArray);
                    }
                    String string = utilType4SecurityContext.getUsername();
                    if (string == null) {
                        String[] stringArray = new String[]{"username"};
                        throw this.exceptions.getException(7045, stringArray);
                    }
                    String string2 = utilType4SecurityContext.getRealm();
                    if (string2 == null) {
                        String[] stringArray = new String[]{"realm"};
                        throw this.exceptions.getException(7045, stringArray);
                    }
                    utilType4SecurityContext.cleanup();
                    int n2 = 0;
                    int n3 = byArray.length;
                    int[] nArray = new int[1];
                    int n4 = this.readCodeAndLength(byArray, 0, n3, nArray);
                    if (n4 == 0) {
                        String[] stringArray = new String[]{"1"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    if ((n4 = this.readCodeAndLengthBytes(byArray, n2 += n4, n3 -= n4)) == 0) {
                        String[] stringArray = new String[]{"2"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    if ((n4 = this.readLengthBytes(byArray, n2 += n4, n3 -= n4)) == 0) {
                        String[] stringArray = new String[]{"3"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    if ((n4 = this.readCodeAndLength(byArray, n2 += n4, n3 -= n4, nArray)) == 0) {
                        String[] stringArray = new String[]{"4"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    if ((n4 = this.readCodeAndLength(byArray, n2 += n4, n3 -= n4, nArray)) == 0) {
                        String[] stringArray = new String[]{"5"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    if ((n4 = this.readCodeAndLengthBytes(byArray, n2 += n4, n3 -= n4)) == 0) {
                        String[] stringArray = new String[]{"6"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    if ((n4 = this.readCodeAndLengthBytes(byArray, n2 += n4, n3 -= n4)) == 0) {
                        String[] stringArray = new String[]{"7"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    if ((n4 = this.readCodeAndLengthBytes(byArray, n2 += n4, n3 -= n4)) == 0) {
                        String[] stringArray = new String[]{"8"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    if ((n4 = this.readCodeAndLength(byArray, n2 += n4, n3 -= n4, nArray)) == 0) {
                        String[] stringArray = new String[]{"9"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    if ((n4 = this.readCodeAndLength(byArray, n2 += n4, n3 -= n4, nArray)) == 0) {
                        String[] stringArray = new String[]{"10"};
                        throw this.exceptions.getException(7044, stringArray);
                    }
                    byte[] byArray5 = new byte[nArray[0] + n4];
                    System.arraycopy(byArray, n2, byArray5, 0, nArray[0] + n4);
                    byArray = byArray5;
                    long l = System.currentTimeMillis();
                    int n5 = this.putTime(this.kerberosRequestBuff, this.KERB_BUFF_SIZE, (byte)-91, l);
                    byte[] byArray6 = new byte[]{2, 3, 0, 0, 0};
                    int n6 = n5;
                    n5 += this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)-92, byArray6, byArray6.length);
                    this.kerberosRequestBuff[this.KERB_BUFF_SIZE * 2 - n6 - 1] = (byte)(this.rand.nextInt() >> 4);
                    this.kerberosRequestBuff[this.KERB_BUFF_SIZE * 2 - n6 - 2] = (byte)(this.rand.nextInt() >> 4);
                    this.kerberosRequestBuff[this.KERB_BUFF_SIZE * 2 - n6 - 3] = (byte)(this.rand.nextInt() >> 4);
                    byte[] byArray7 = new byte[]{4, 4, -105, 23, 107, -31};
                    n6 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)-95, byArray7, byArray7.length);
                    byte[] byArray8 = new byte[]{2, 1, 1};
                    int n7 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5 - n6, 0, (byte)-96, byArray8, byArray8.length);
                    n6 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, n6 + n7, (byte)48);
                    n5 += this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, n6, (byte)-93);
                    byte[] byArray9 = string.getBytes();
                    n6 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)27, byArray9, byArray9.length);
                    n6 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, n6, (byte)48);
                    n6 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, n6, (byte)-95);
                    n7 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5 - n6, 0, (byte)-96, byArray8, byArray8.length);
                    n6 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, n6 + n7, (byte)48);
                    n5 += this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, n6, (byte)-94);
                    byte[] byArray10 = string2.getBytes();
                    n6 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)27, byArray10, byArray10.length);
                    n5 += this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, n6, (byte)-95);
                    byte[] byArray11 = new byte[]{2, 1, 5};
                    n5 += this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)-96, byArray11, byArray11.length);
                    n5 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE, n5, (byte)48);
                    n5 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE, n5, (byte)98);
                    for (n = 0; n < 8; ++n) {
                        this.kerberosRequestBuff[n] = (byte)(this.rand.nextInt() >> 4);
                    }
                    this.memSet(this.kerberosRequestBuff, 8, (byte)0, 16);
                    n = 24;
                    System.arraycopy(this.kerberosRequestBuff, this.KERB_BUFF_SIZE * 2 - n5, this.kerberosRequestBuff, n, n5);
                    n6 = (n += n5) & 7;
                    if (n6 != 0) {
                        n7 = 8 - n6;
                        this.memSet(this.kerberosRequestBuff, n, (byte)0, n7);
                        n += n7;
                    }
                    byte[] byArray12 = this.MD5(this.kerberosRequestBuff, 0, n);
                    System.arraycopy(byArray12, 0, this.kerberosRequestBuff, 8, byArray12.length);
                    byte[] byArray13 = this.DESencrypt(this.kerberosRequestBuff, 0, n, new byte[8], byArray4);
                    System.arraycopy(byArray13, 0, this.kerberosRequestBuff, this.KERB_BUFF_SIZE * 2 - n, byArray13.length);
                    n5 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE, n, (byte)4);
                    n5 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE, n5, (byte)-94);
                    byte[] byArray14 = new byte[]{2, 1, 3};
                    n7 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)-96, byArray14, byArray14.length);
                    n5 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE, n5 + n7, (byte)48);
                    n5 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE, n5, (byte)-92);
                    n5 += this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)-93, byArray, byArray.length);
                    byte[] byArray15 = new byte[]{3, 5, 0, 0, 0, 0, 0};
                    n5 += this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)-94, byArray15, byArray15.length);
                    byte[] byArray16 = new byte[]{2, 1, 14};
                    n5 += this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)-95, byArray16, byArray16.length);
                    n5 += this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE - n5, 0, (byte)-96, byArray11, byArray11.length);
                    n5 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE, n5, (byte)48);
                    n6 = n5 = this.putGSSCodeLength(this.kerberosRequestBuff, this.KERB_BUFF_SIZE, n5, (byte)110);
                    byte[] byArray17 = new byte[]{0, 1};
                    System.arraycopy(byArray17, 0, this.kerberosRequestBuff, this.KERB_BUFF_SIZE * 2 - byArray17.length - n5, byArray17.length);
                    byte[] byArray18 = new byte[]{-83, -66, -17};
                    oracleDataConsumer.writeBytes(byArray18, 0, byArray18.length);
                    byte[] byArray19 = new byte[]{10, 32, 1, 0, 0, 1, 0, 0, 1, 0, 4, 0, 0, 0, 0, 0, 2, 0, 3, 0, 2, 0, 4, 0, 4, 0, 0, 0, 4, 0, 4, 0, 1};
                    oracleDataConsumer.writeBigEndianInt16(byArray18.length + 1 + 2 + 4 + byArray19.length + 2 + (n5 += byArray17.length));
                    oracleDataConsumer.writeBytes(byArray19, 0, byArray19.length);
                    String string3 = null;
                    try {
                        string3 = InetAddress.getLocalHost().toString();
                    }
                    catch (UnknownHostException unknownHostException) {
                        String[] stringArray = new String[]{"host IP address"};
                        throw this.exceptions.getException(7045, stringArray);
                    }
                    int n8 = string3.indexOf(47);
                    n8 = n8 == -1 ? 0 : ++n8;
                    n2 = string3.indexOf(46, n8);
                    if (n2 != -1) {
                        oracleDataConsumer.writeByte((byte)Integer.parseInt(string3.substring(n8, n2)));
                        n8 = n2 + 1;
                    }
                    if ((n2 = string3.indexOf(46, n8)) != -1) {
                        oracleDataConsumer.writeByte((byte)Integer.parseInt(string3.substring(n8, n2)));
                        n8 = n2 + 1;
                    }
                    if ((n2 = string3.indexOf(46, n8)) != -1) {
                        oracleDataConsumer.writeByte((byte)Integer.parseInt(string3.substring(n8, n2)));
                        n8 = n2 + 1;
                    }
                    oracleDataConsumer.writeByte((byte)Integer.parseInt(string3.substring(n8)));
                    oracleDataConsumer.writeBigEndianInt16(n6);
                    oracleDataConsumer.writeBytes(this.kerberosRequestBuff, this.KERB_BUFF_SIZE * 2 - n5, n5);
                    break;
                }
                case 4: {
                    byte[] byArray = new byte[]{-83, -66, -17, 0, 26, 9, 32, 7, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, -1};
                    oracleDataConsumer.writeBytes(byArray, 0, byArray.length);
                }
            }
        } else {
            switch (this.packetType) {
                case 0: {
                    oracleDataConsumer.writeBytes(this.ANO1, 0, this.ANO1.length);
                    byte[] byArray = String.valueOf(System.currentTimeMillis()).getBytes();
                    oracleDataConsumer.writeBytes(byArray, byArray.length - 7, 6);
                    oracleDataConsumer.writeBytes(this.ANO1B, 0, this.ANO1B.length);
                    break;
                }
                case 1: {
                    oracleDataConsumer.writeBytes(this.ANO2, 0, this.ANO2.length);
                    break;
                }
                case 2: {
                    if (this.ANO3Triplet != null) {
                        this.ANO3[4] = this.ANO3Triplet[0];
                        this.ANO3[80] = this.ANO3Triplet[1];
                        this.ANO3[85] = this.ANO3Triplet[2];
                    }
                    oracleDataConsumer.writeBytes(this.ANO3, 0, this.ANO3.length);
                    oracleDataConsumer.writeBytes(this.clientSecurityToken, 0, this.clientSecurityToken.length);
                    break;
                }
                case 3: {
                    if (this.ANO4Triplet != null) {
                        this.ANO4[4] = this.ANO4Triplet[0];
                        this.ANO4[24] = this.ANO4Triplet[1];
                        this.ANO4[29] = this.ANO4Triplet[2];
                    }
                    oracleDataConsumer.writeBytes(this.ANO4, 0, this.ANO4.length);
                    oracleDataConsumer.writeBytes(this.clientSecurityToken, 0, this.clientSecurityToken.length);
                }
            }
        }
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        if (this.useKerberosAuthentication) {
            switch (this.kerberosStep) {
                case 1: {
                    oracleDataProvider.skipBytes(80);
                    byte by = oracleDataProvider.readByte();
                    oracleDataProvider.skipBytes(2);
                    String string = oracleDataProvider.readString(by);
                    if (!string.equalsIgnoreCase("KERBEROS5")) {
                        throw this.exceptions.getException(7050);
                    }
                    oracleDataProvider.skipBytes(66);
                    break;
                }
                case 2: {
                    oracleDataProvider.skipBytes(21);
                    byte by = oracleDataProvider.readByte();
                    oracleDataProvider.skipBytes(2);
                    String string = oracleDataProvider.readString(by);
                    oracleDataProvider.skipBytes(1);
                    byte by2 = oracleDataProvider.readByte();
                    oracleDataProvider.skipBytes(2);
                    String string2 = oracleDataProvider.readString(by2);
                    this.servicePrincipalName = string + "/" + string2;
                    this.packetType = 2;
                    break;
                }
                case 3: {
                    boolean bl;
                    oracleDataProvider.skipBytes(11);
                    boolean bl2 = bl = oracleDataProvider.readByte() != 0;
                    if (!bl) break;
                    oracleDataProvider.skipBytes(6);
                    short s = oracleDataProvider.readInt16BIG();
                    String[] stringArray = new String[]{String.valueOf(s)};
                    throw this.exceptions.getException(7048, stringArray);
                }
            }
        } else {
            switch (this.packetType) {
                case 0: {
                    oracleDataProvider.skipBytes(83);
                    String string = oracleDataProvider.readString(3);
                    if (!string.equalsIgnoreCase("NTS")) {
                        throw this.exceptions.getException(7038);
                    }
                    oracleDataProvider.skipBytes(38);
                    byte by = oracleDataProvider.readByte();
                    this.packetType = 2;
                    break;
                }
                case 1: {
                    oracleDataProvider.skipBytes(48);
                    this.servicePrincipalName = oracleDataProvider.readString(oracleDataProvider.m_numBytesInPacketBuffer - oracleDataProvider.m_numBytesProcessed);
                    this.packetType = 2;
                    break;
                }
                case 2: {
                    if (oracleDataProvider.m_numBytesInPacketBuffer < 33) {
                        throw this.exceptions.getException(7036);
                    }
                    oracleDataProvider.skipBytes(32);
                    this.serverSecurityToken = new byte[oracleDataProvider.m_numBytesInPacketBuffer - oracleDataProvider.m_numBytesProcessed];
                    oracleDataProvider.readBytes(this.serverSecurityToken, 0, oracleDataProvider.m_numBytesInPacketBuffer - oracleDataProvider.m_numBytesProcessed);
                    this.packetType = 3;
                    break;
                }
            }
        }
    }
}

